/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.micup.impl;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.FP;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.base.bean.RecommendEnterData;
import com.yy.hiyo.channel.base.hiido.FollowStatisHelper;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.model.bean.RoomData;
import com.yy.hiyo.channel.module.follow.FollowHandler;
import com.yy.hiyo.channel.plugins.micup.MicUpStatisHelper;
import com.yy.hiyo.channel.plugins.micup.R;
import com.yy.hiyo.channel.plugins.micup.base.BaseComponent;
import com.yy.hiyo.channel.plugins.micup.bean.AudioInfo;
import com.yy.hiyo.channel.plugins.micup.bean.LeadSingDataInfo;
import com.yy.hiyo.channel.plugins.micup.bean.MicupDataContext;
import com.yy.hiyo.channel.plugins.micup.bean.PlayerInfo;
import com.yy.hiyo.channel.plugins.micup.bean.RoundInfo;
import com.yy.hiyo.channel.plugins.micup.bean.SongInfo;
import com.yy.hiyo.channel.plugins.micup.common.ChannelMicUpMsgDef;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicUpPanelManager;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicupDataChangeNotify;
import com.yy.hiyo.channel.plugins.micup.interfaces.IMicupHost;
import com.yy.hiyo.channel.plugins.micup.panel.MicUpPanelView;
import com.yy.hiyo.channel.plugins.micup.panel.MicUpUICallback;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import com.yy.hiyo.mvp.base.callback.WeakCallback;
import com.yy.hiyo.relation.base.follow.FollowerUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class MicUpPanelManager
extends BaseComponent
implements IMicUpPanelManager,
MicUpUICallback {
    private MicUpPanelView mMicUpPanelView;
    private int mCurrentRound;
    private FollowHandler mFollowHandler;
    private int mClickGetRound = -1;
    private long mSongIdentifyStartTime;
    private IMicupDataChangeNotify mDataChangeNotify = new IMicupDataChangeNotify(){

        @Override
        public void onNextRoundNotify(int round) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTMicUpPanel", (String)"next round notify current round: %s,server round: %s", (Object[])new Object[]{MicUpPanelManager.this.mCurrentRound, round});
            }
            if (MicUpPanelManager.this.mCurrentRound != round) {
                Bundle data = new Bundle();
                data.putInt("curr_song_no", round);
                RoundInfo currentRoundInfo = MicUpPanelManager.this.getDataContext().getCurrentRoundInfo();
                int totalRound = currentRoundInfo != null ? currentRoundInfo.getTotalRound() : 10;
                data.putInt("total_song", totalRound);
                MicUpPanelManager.this.showFlyScreen(3, data);
            }
            MicUpPanelManager.this.mCurrentRound = round;
        }

        @Override
        public void onUserGetTheChanceNotify(long uid, int round, String avatar, String nick) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTMicUpPanel", (String)"data change notify uid: %s , round: %s", (Object[])new Object[]{uid, round});
            }
            if (AccountUtil.getUid() == uid) {
                Bundle data = new Bundle();
                data.putString("avatar", avatar);
                data.putString("nick", nick);
                MicUpPanelManager.this.showFlyScreen(0, data);
            } else if (uid != -1L) {
                Bundle data = new Bundle();
                data.putString("avatar", avatar);
                data.putString("nick", nick);
                MicUpPanelManager.this.showFlyScreen(1, data);
            } else {
                MicUpPanelManager.this.showFlyScreen(2, null);
            }
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTMicUpPanel", (String)"onUserGetTheChanceNotify, mClickGetRound = %d", (Object[])new Object[]{MicUpPanelManager.this.mClickGetRound});
            }
            if (MicUpPanelManager.this.mClickGetRound == round) {
                if (AccountUtil.getUid() == uid) {
                    MicUpStatisHelper.reportGetBtnClick(MicUpPanelManager.this.getCurrRoomId(), 1, MicUpPanelManager.this.getCurrMusicId());
                } else {
                    MicUpStatisHelper.reportGetBtnClick(MicUpPanelManager.this.getCurrRoomId(), 2, MicUpPanelManager.this.getCurrMusicId());
                }
            }
        }

        @Override
        public void onSongIdentifyResultNotify(RoundInfo roundInfo) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTMicUpPanel", (String)"data change notify identify result: %s", (Object[])new Object[]{roundInfo});
            }
            int songIdentifyState = roundInfo.getSongIdentifyState();
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTMicUpPanel", (String)"song identify state: %s", (Object[])new Object[]{songIdentifyState});
            }
            switch (songIdentifyState) {
                case 2: {
                    MicUpPanelManager.this.showSingSuccessPanel(MicUpPanelManager.this.getDataContext().isSinger());
                    break;
                }
                case 3: {
                    boolean isSinger = MicUpPanelManager.this.getDataContext().isSinger();
                    if (isSinger) {
                        PlayerInfo playerInfo = roundInfo.getPlayerInfo();
                        if (playerInfo != null && playerInfo.getLife() == 0) {
                            MicUpPanelManager.this.showOutPanel();
                            break;
                        }
                        MicUpPanelManager.this.showSingFailPanel(true);
                        break;
                    }
                    MicUpPanelManager.this.showSingFailPanel(false);
                    break;
                }
                case 4: {
                    ToastUtils.showToast((Context)MicUpPanelManager.this.getContext(), (int)R.string.short_tips_mic_up_identify_error);
                    break;
                }
            }
            long endTime = System.currentTimeMillis();
            MicUpStatisHelper.reportDistiPgShow(MicUpPanelManager.this.getCurrRoomId(), MicUpPanelManager.this.getCurrMusicId(), MicUpPanelManager.this.mSongIdentifyStartTime, endTime, MicUpPanelManager.this.getStatisRoleType());
        }

        @Override
        public void onWaitForDetermineNotify(int round, int term) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTMicUpPanel", (String)"onWaitForDetermineNotify round: %s", (Object[])new Object[]{round});
            }
            MicUpPanelManager.this.showRecognizingPanel(MicUpPanelManager.this.getDataContext().isSinger());
        }

        @Override
        public void onUpdateRoundInfoNotify(List<PlayerInfo> playerInfos, int errorCode, String errMsg) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTMicUpPanel", (String)"data change notify update round: %s , errorCode: %s , errorMsg: %s", (Object[])new Object[]{playerInfos, errorCode, errMsg});
            }
        }
    };

    public MicUpPanelManager(RoomData roomDataContainer, MicupDataContext dataContext) {
        super(roomDataContainer, dataContext);
    }

    @Override
    public void onCreate(IMicupHost host, IMvpContext context) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTMicUpPanel", (String)"onCreate", (Object[])new Object[0]);
        }
        super.onCreate(host, context);
        host.registerDataNotify(this.mDataChangeNotify);
        this.mFollowHandler = new FollowHandler();
        this.mFollowHandler.setDialogLinkManager(this.getDialogLinkManager());
    }

    @Override
    public void showPanel(YYFrameLayout container) {
        this.mMicUpPanelView = new MicUpPanelView(container.getContext(), this);
        container.removeAllViews();
        container.addView((View)this.mMicUpPanelView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        RoundInfo currentRoundInfo = this.getDataContext().getCurrentRoundInfo();
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTMicUpPanel", (String)"show panel round info: %s", (Object[])new Object[]{currentRoundInfo});
        }
        if (currentRoundInfo != null) {
            int roundState = currentRoundInfo.getRoundState();
            if (roundState == 0) {
                return;
            }
            this.mCurrentRound = currentRoundInfo.getRound();
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTMicUpPanel", (String)"show panel round state: %s , current round: %s", (Object[])new Object[]{roundState, this.mCurrentRound});
            }
            if (roundState == 1) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTMicUpPanel", (String)"data service notify round state: %s,current round: %s", (Object[])new Object[]{roundState, this.mCurrentRound});
                }
                if (this.mCurrentRound == 1) {
                    this.showCountDownPanel();
                    HashMap<String, Object> map = new HashMap<String, Object>(1);
                    map.put("audio", "micUp321go");
                    this.host.onHandleEvent(1, map);
                } else {
                    Bundle data = new Bundle();
                    data.putInt("curr_song_no", this.mCurrentRound);
                    int totalRound = currentRoundInfo.getTotalRound() == 0 ? 10 : currentRoundInfo.getTotalRound();
                    data.putInt("total_song", totalRound);
                    this.showFlyScreen(3, data);
                }
            } else if (roundState == 2) {
                boolean audience = this.getDataContext().isAudience(AccountUtil.getUid());
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTMicUpPanel", (String)"show panel wai for get chance user is in audience: %s", (Object[])new Object[]{audience});
                }
                this.showLeadSingPanel(audience);
            } else if (roundState == 3) {
                this.showSingPanel(this.getDataContext().isSinger());
            } else if (roundState == 4) {
                this.showRecognizingPanel(this.getDataContext().isSinger());
            }
        }
    }

    @Override
    public void showCountDownPanel() {
        if (this.mMicUpPanelView != null) {
            this.mMicUpPanelView.showCountDownPanel(() -> {
                boolean audience = this.getDataContext().isAudience(AccountUtil.getUid());
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTMicUpPanel", (String)"showCountDownPanel user is audience: %s", (Object[])new Object[]{audience});
                }
                this.showLeadSingPanel(audience);
            });
        }
        MicUpStatisHelper.reportGameTimeShow(this.getCurrRoomId());
    }

    @Override
    public void showLeadSingPanel(boolean audience) {
        if (this.mMicUpPanelView != null) {
            if (audience) {
                int totalRound = this.getDataContext().getSongInfoList().size();
                this.mMicUpPanelView.showAudienceLeadSingPanel(this.getDataContext().getCurrentRoundInfo().getSongInfo(), this.getDataContext().getCurrentRoundInfo().getRound(), totalRound == 0 ? 10 : totalRound);
            } else {
                LeadSingDataInfo info = new LeadSingDataInfo();
                info.currentSongInfo = this.getDataContext().getCurrentRoundInfo().getSongInfo();
                info.leftLifeValue = this.getDataContext().getPlayer(AccountUtil.getUid()).getLife();
                info.currentRound = this.getDataContext().getCurrentRoundInfo().getRound();
                int totalRound = this.getDataContext().getSongInfoList().size();
                info.totalSong = totalRound == 0 ? 10 : totalRound;
                this.mMicUpPanelView.showLeadSingPanel(info);
            }
            if (this.host != null && this.host.getAudioManager() != null) {
                this.host.getAudioManager().playSong(this.getDataContext().getCurrentRoundInfo().getSongInfo(), null);
            }
        }
        String roomId = this.getRoomDataContainer() != null ? this.getRoomDataContainer().getRoomId() : "";
        RoomTrack.INSTANCE.reportGameRulePanelShow(roomId);
    }

    @Override
    public void showSingPanel(boolean isSinger) {
        if (this.mMicUpPanelView != null) {
            if (isSinger) {
                SongInfo currentSongInfo = this.getDataContext().getCurrentRoundInfo().getSongInfo();
                PlayerInfo playerInfo = this.getDataContext().getPlayer(AccountUtil.getUid());
                List<String> preLyrics = Collections.emptyList();
                List<String> postLyrics = Collections.emptyList();
                if (currentSongInfo != null) {
                    preLyrics = currentSongInfo.preLyric;
                    postLyrics = currentSongInfo.postLyric;
                }
                int leftLife = 0;
                if (playerInfo != null) {
                    leftLife = playerInfo.getLife();
                }
                this.mMicUpPanelView.showSingPanel(preLyrics, postLyrics, leftLife);
            } else {
                String singerAvatar = "";
                RoundInfo roundInfo = this.getDataContext().getCurrentRoundInfo();
                PlayerInfo playerInfo = roundInfo.getPlayerInfo();
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTMicUpPanel", (String)"showSingPanel round info:%s", (Object[])new Object[]{roundInfo});
                }
                if (playerInfo != null) {
                    singerAvatar = playerInfo.getAvatar();
                }
                this.mMicUpPanelView.showAudienceSingPanel(singerAvatar, this.getDataContext().getSingerUid());
            }
        }
        String roomId = this.getRoomDataContainer() != null ? this.getRoomDataContainer().getRoomId() : "";
        RoomTrack.INSTANCE.reportGameRulePanelShow(roomId);
    }

    @Override
    public void showFlyScreen(int status, Bundle data) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTMicUpPanel", (String)"showFlyScreen status: %s", (Object[])new Object[]{status});
        }
        String roomId = this.getCurrRoomId();
        String musicId = this.getCurrMusicId();
        if (this.mMicUpPanelView != null) {
            if (this.host != null && this.host.getAudioManager() != null) {
                this.host.getAudioManager().stopPlaySong(this.getDataContext().getCurrentRoundInfo().getSongInfo());
            }
            if (status == 0) {
                String avatar = data == null ? "" : data.getString("avatar", "");
                String nick = data == null ? "" : data.getString("nick", "");
                this.mMicUpPanelView.showMyTurnPanel(avatar, nick);
                MicUpStatisHelper.reportSelfGetShow(roomId, musicId);
            } else if (status == 1) {
                String avatar = data == null ? "" : data.getString("avatar", "");
                String nick = data == null ? "" : data.getString("nick", "");
                this.mMicUpPanelView.showOtherTurnPanel(avatar, nick);
                MicUpStatisHelper.reportOtherGetShow(roomId, musicId);
            } else if (status == 2) {
                this.mMicUpPanelView.showAllFailedPanel();
                HashMap<String, Object> map = new HashMap<String, Object>(1);
                map.put("audio", "micUpAllCanNotSing");
                this.host.onHandleEvent(1, map);
                MicUpStatisHelper.reportNoGetShow(roomId, musicId);
            } else if (status == 3) {
                int curr = data == null ? 0 : data.getInt("curr_song_no");
                int total = data == null ? 10 : data.getInt("total_song");
                this.mMicUpPanelView.showNextSongPanel(curr, total);
                MicUpStatisHelper.reportNextSongShow(roomId);
            }
        }
    }

    @Override
    public void showRecognizingPanel(boolean isSinger) {
        if (this.mMicUpPanelView != null) {
            if (isSinger) {
                this.mMicUpPanelView.showRecognizingPanel();
            } else {
                String singerAvatar = "";
                PlayerInfo playerInfo = this.getDataContext().getCurrentRoundInfo().getPlayerInfo();
                if (playerInfo != null) {
                    singerAvatar = playerInfo.getAvatar();
                }
                this.mMicUpPanelView.showAudienceDeterminePanel(this.getDataContext().getSingerUid(), 1, singerAvatar);
            }
        }
        this.mSongIdentifyStartTime = System.currentTimeMillis();
    }

    @Override
    public void showSingSuccessPanel(boolean isSinger) {
        if (this.mMicUpPanelView != null) {
            String singerAvatar = "";
            int leftLife = 0;
            RoundInfo roundInfo = this.getDataContext().getCurrentRoundInfo();
            PlayerInfo playerInfo = roundInfo.getPlayerInfo();
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTMicUpPanel", (String)"showSingSuccessPanel. round:%d, playerInfo:%s", (Object[])new Object[]{roundInfo.getRound(), playerInfo});
            }
            if (playerInfo != null) {
                singerAvatar = playerInfo.getAvatar();
                leftLife = playerInfo.getLife();
            }
            if (isSinger) {
                this.mMicUpPanelView.showDeterminePanel(2, singerAvatar, leftLife);
            } else {
                this.mMicUpPanelView.showAudienceDeterminePanel(this.getDataContext().getSingerUid(), 2, singerAvatar);
            }
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put("audio", "micUpSingSuccess");
            this.host.onHandleEvent(1, map);
        }
        MicUpStatisHelper.reportSingSuccessShow(this.getCurrRoomId(), this.getCurrMusicId(), this.getStatisRoleType());
    }

    @Override
    public void showSingFailPanel(boolean isSinger) {
        if (this.mMicUpPanelView != null) {
            String singerAvatar = "";
            int leftLife = 0;
            RoundInfo roundInfo = this.getDataContext().getCurrentRoundInfo();
            PlayerInfo playerInfo = roundInfo.getPlayerInfo();
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTMicUpPanel", (String)"showSingFailPanel. round:%d, playerInfo:%s", (Object[])new Object[]{roundInfo.getRound(), playerInfo});
            }
            if (playerInfo != null) {
                singerAvatar = playerInfo.getAvatar();
                leftLife = playerInfo.getLife();
            }
            if (isSinger) {
                this.mMicUpPanelView.showDeterminePanel(3, singerAvatar, leftLife);
            } else {
                this.mMicUpPanelView.showAudienceDeterminePanel(this.getDataContext().getSingerUid(), 3, singerAvatar);
            }
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put("audio", "micUpSingFail");
            this.host.onHandleEvent(1, map);
        }
        MicUpStatisHelper.reportSingFailedShow(this.getCurrRoomId(), this.getCurrMusicId(), this.getStatisRoleType());
    }

    @Override
    public void showOutPanel() {
        if (this.mMicUpPanelView != null) {
            String singerAvatar = "";
            PlayerInfo playerInfo = this.getDataContext().getCurrentRoundInfo().getPlayerInfo();
            if (playerInfo != null) {
                singerAvatar = playerInfo.getAvatar();
            }
            this.mMicUpPanelView.showDeterminePanel(4, singerAvatar, 0);
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put("audio", "micUpDieOut");
            this.host.onHandleEvent(1, map);
        }
        MicUpStatisHelper.reportOutShow(this.getCurrRoomId());
    }

    @Override
    public void onDestroy(int reasonCode) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTMicUpPanel", (String)"onDestroy reasonCode: %s", (Object[])new Object[]{reasonCode});
        }
        super.onDestroy(reasonCode);
        this.host.unRegisterDataNotify(this.mDataChangeNotify);
        if (this.mMicUpPanelView != null) {
            this.mMicUpPanelView.removeAllViews();
            this.mMicUpPanelView = null;
        }
    }

    @Override
    public void onGetClick() {
        if (this.host == null || this.host.getDataFetcher() == null) {
            return;
        }
        this.host.getDataFetcher().tryGetTheChance(this.mCurrentRound, this.getDataContext().getTerm(), (Callback<Boolean>)WeakCallback.of((IDestroyable)this.getMvpContext(), success -> {
            if (!success.booleanValue() && this.mMicUpPanelView != null) {
                this.mMicUpPanelView.enableClickGet();
            }
            if (!success.booleanValue()) {
                return;
            }
            if (this.host.getAudioManager() != null) {
                this.host.getAudioManager().stopPlaySong(this.getDataContext().getCurrentRoundInfo().getSongInfo());
            }
        }));
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("audio", "micUpClickGet");
        this.host.onHandleEvent(1, map);
        this.mClickGetRound = this.mCurrentRound;
    }

    @Override
    public void onShowMyTurnEnd() {
        this.showSingPanel(this.getDataContext().isSinger());
        if (this.host != null && this.host.getAudioManager() != null) {
            this.host.getAudioManager().startSelfSinging(this.getDataContext().getCurrentRoundInfo().getSongInfo());
        }
    }

    @Override
    public void onShowOtherTurnEnd() {
        this.showSingPanel(this.getDataContext().isSinger());
    }

    @Override
    public void onShowAllFailedEnd() {
    }

    @Override
    public void onShowNextEnd() {
        this.showLeadSingPanel(this.getDataContext().isAudience(AccountUtil.getUid()));
    }

    @Override
    public void onSubmitAudioClick() {
        if (this.host == null) {
            return;
        }
        SongInfo songInfo = this.getDataContext().getCurrentRoundInfo().getSongInfo();
        if (this.host.getAudioManager() != null && this.host.getDataFetcher() != null) {
            this.host.getAudioManager().stopSelfSinging(songInfo);
            AudioInfo selfAudioInfo = this.host.getAudioManager().getSelfAudioInfo(songInfo);
            if (selfAudioInfo != null) {
                this.host.getDataFetcher().identifyAudio(selfAudioInfo.cacheAccAudio, selfAudioInfo.cacheAccAudio.length, "audio", selfAudioInfo.followAudioInfo.songId, this.getDataContext().getTerm());
            }
        }
        MicUpStatisHelper.reportSingSubmitBtnClick(this.getCurrRoomId(), this.getCurrMusicId());
    }

    @Override
    public void onFollowClick(long uid) {
        int enterType = 5;
        if (this.mFollowHandler != null) {
            this.mFollowHandler.handleClick(uid, FollowerUtils.INSTANCE.enterType2ePath(enterType + ""));
        }
        String roomId = this.getRoomDataContainer() != null ? this.getRoomDataContainer().getRoomId() : "";
        LinkedHashMap<String, String> ext = new LinkedHashMap<String, String>();
        if (this.getRoomDataContainer() != null && this.getRoomDataContainer().getEnterParam() != null) {
            RecommendEnterData recommendEnterData = (RecommendEnterData)this.getRoomDataContainer().getEnterParam().getExtra("from_recommend_info", null);
            if (recommendEnterData != null) {
                ext.put("token", recommendEnterData.getToken());
            } else if (this.getRoomDataContainer().getEnterParam().matchedUid == uid && !FP.empty((CharSequence)this.getRoomDataContainer().getEnterParam().postId)) {
                if (!FP.empty((CharSequence)this.getRoomDataContainer().getEnterParam().postToken)) {
                    ext.put("token", this.getRoomDataContainer().getEnterParam().postToken);
                }
                if (!FP.empty((CharSequence)this.getRoomDataContainer().getEnterParam().postId)) {
                    ext.put("post_id", this.getRoomDataContainer().getEnterParam().postId);
                }
                if (!FP.empty((CharSequence)this.getRoomDataContainer().getEnterParam().postPageSource)) {
                    ext.put("post_pg_source", this.getRoomDataContainer().getEnterParam().postPageSource);
                }
                ext.put("send_post_uid", "" + uid);
            }
        }
        FollowStatisHelper.reportFollowClickWithExt((long)uid, (String)roomId, (int)enterType, ext);
    }

    @Override
    public void onSendGiftClick(long targetUid) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTMicUpPanel", (String)"click send gift to uid: %s", (Object[])new Object[]{targetUid});
        }
        if (this.host != null) {
            HashMap<String, Object> param = new HashMap<String, Object>(1);
            param.put("uid", targetUid);
            this.host.onHandleEvent(0, param);
        }
    }

    @Override
    public void onGameRuleClick() {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTMicUpPanel", (String)"click game rule.", (Object[])new Object[0]);
        }
        MsgDispatcher.getInstance().sendMessage(ChannelMicUpMsgDef.MSG_SHOW_NEW_USER_GUIDE);
        String roomId = this.getRoomDataContainer() != null ? this.getRoomDataContainer().getRoomId() : "";
        RoomTrack.INSTANCE.reportGameRuleBtnClick(roomId);
    }

    @Override
    public int getState() {
        return this.getDataContext().getState();
    }

    private String getCurrRoomId() {
        return this.getRoomDataContainer() != null ? this.getRoomDataContainer().getRoomId() : "0";
    }

    private String getCurrMusicId() {
        SongInfo songInfo = this.getDataContext().getCurrentRoundInfo().getSongInfo();
        return songInfo != null ? songInfo.songId : "0";
    }

    private int getStatisRoleType() {
        int roleType = this.getRoomDataContainer().isPlayManager(AccountUtil.getUid()) ? 1 : (this.getRoomDataContainer().getSeatData().isInSeat(AccountUtil.getUid()) ? (this.getDataContext().isSinger() ? 2 : 3) : 4);
        return roleType;
    }
}

