;(function() {
	if (window.WebViewJavascriptBridge) {
        console.log("bridge exists,return.")
        return
    }
	var messagingIframe
	var sendMessageQueue = []
	var receiveMessageQueue = []
	var messageHandlers = {}
	
	var MESSAGE_SEPARATOR = '__WVJB_MESSAGE_SEPERATOR__'
	var CUSTOM_PROTOCOL_SCHEME = 'wvjbscheme'
	var QUEUE_HAS_MESSAGE = '__WVJB_QUEUE_MESSAGE__'
	
	var responseCallbacks = {}
	var uniqueId = 1
	
	function _createQueueReadyIframe(doc) {
		messagingIframe = doc.createElement('iframe')
		messagingIframe.style.display = 'none'
		doc.documentElement.appendChild(messagingIframe)
	}

	function init(messageHandler) {
		if (WebViewJavascriptBridge._messageHandler) { throw new Error('WebViewJavascriptBridge.init called twice') }
		WebViewJavascriptBridge._messageHandler = messageHandler
		var receivedMessages = receiveMessageQueue
		receiveMessageQueue = null
		for (var i=0; i<receivedMessages.length; i++) {
			_dispatchMessageFromObjC(receivedMessages[i])
		}
	}

	function send(data, responseCallback) {
		_doSend({ data:data }, responseCallback)
	}

	function registerHandler(handlerName, handler) {
		messageHandlers[handlerName] = handler
	}
	
	function callHandler(handlerName, data, responseCallback) {
		_doSend({ handlerName:handlerName, data:data }, responseCallback)
	}

	function clientHasHandler(handlerName)
	{
	    return window.wvJSBridgeObject.hasHandler(handlerName);
	}

	function jsHasHandler(handlerName){
	    console.log("handlerName = " + handlerName + ", messageHandlers[handlerName] = " + messageHandlers[handlerName]);
	    return messageHandlers[handlerName];
	}
	
	function _doSend(message, responseCallback) {
		try{
            if (responseCallback) {
                var callbackId = 'cb_'+(uniqueId++)+'_'+new Date().getTime()
                responseCallbacks[callbackId] = responseCallback
                message['callbackId'] = callbackId
            }
            sendMessageQueue.push(JSON.stringify(message))
            messagingIframe.src = CUSTOM_PROTOCOL_SCHEME + '://' + QUEUE_HAS_MESSAGE
        }catch(exception){
            console.log("_doSend "+exception)
        }
	}

	function _fetchQueue() {
		var messageQueueString = sendMessageQueue.join(MESSAGE_SEPARATOR)
		sendMessageQueue = []
		window.wvJSBridgeObject.javaScriptMessageBridge(messageQueueString);
		return messageQueueString
	}

	function _dispatchMessageFromObjC(messageJSON) {
		setTimeout(function _timeoutDispatchMessageFromObjC() {
			var message = JSON.parse(messageJSON)
			var messageHandler
			if (message.responseId) {
				var responseCallback = responseCallbacks[message.responseId]
//console.log("qinboxuwakao,_dispatchMessageFromObjC, responseCallback = " + responseCallback + ", responseData=" +message.responseData)
				if (!responseCallback) { return; }
				responseCallback(message.responseData)
				delete responseCallbacks[message.responseId]
			} else {
				var responseCallback
				if (message.callbackId) {
					var callbackResponseId = message.callbackId
					responseCallback = function(responseData) {
						_doSend({ responseId:callbackResponseId, responseData:responseData })
					}
				}
				
				var handler = WebViewJavascriptBridge._messageHandler
				if (message.handlerName) {
					handler = messageHandlers[message.handlerName]
				}
				
				try {
					handler(message.data, responseCallback)
				} catch(exception) {
					if (typeof console != 'undefined') {
						console.log("WebViewJavascriptBridge: WARNING: javascript handler threw.", message, exception)
					}
				}
			}
		})
	}
	
	function _handleMessageFromObjC(messageJSON) {
		if (receiveMessageQueue) {
			receiveMessageQueue.push(messageJSON)
		} else {
			_dispatchMessageFromObjC(messageJSON)
		}
	}

	window.WebViewJavascriptBridge = {
		init: init,
		send: send,
		registerHandler: registerHandler,
		callHandler: callHandler,
		clientHasHandler:clientHasHandler,
		jsHasHandler:jsHasHandler,
		_fetchQueue: _fetchQueue,
		_handleMessageFromObjC: _handleMessageFromObjC
	}

	var doc = document
	_createQueueReadyIframe(doc)
	var readyEvent = doc.createEvent('Events')
	readyEvent.initEvent('WebViewJavascriptBridgeReady')
	readyEvent.bridge = WebViewJavascriptBridge
	doc.dispatchEvent(readyEvent)
	console.log("WebViewJavascriptBridgeReady event end, window.wvJSBridgeObject == "+ window.wvJSBridgeObject);
})();

var dispatchMsgToJs = function(msg){
    setTimeout(function(){
        try{
                console.log("msg = " + msg  + ",window.WebViewJavascriptBridge = " + window.WebViewJavascriptBridge );
                var message = JSON.parse(msg)
                if(message.hasOwnProperty('handlerName') && !window.WebViewJavascriptBridge.jsHasHandler(message.handlerName)){
                    window.wvJSBridgeObject.onJsHandlerNotFound(message.callbackId, message.handlerName)
                    return
                }
                console.log("msg2 = " + msg  + ",window.WebViewJavascriptBridge = " + window.WebViewJavascriptBridge );
                window.WebViewJavascriptBridge._handleMessageFromObjC(msg)
            }catch (exception){
                console.log(exception)
            }
    }, 100);

}
