/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv;

import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.framework.core.ui.PanelLayer;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.cbase.context.ChannelPageContext;
import com.yy.hiyo.channel.cbase.model.bean.RoomData;
import com.yy.hiyo.channel.cbase.module.ktv.KTVCommonCallback;
import com.yy.hiyo.channel.cbase.module.ktv.base.KTVBasePresent;
import com.yy.hiyo.channel.plugins.ktv.IUICallback;
import com.yy.hiyo.channel.plugins.ktv.KTVOperateProvider;
import com.yy.hiyo.channel.plugins.ktv.KtvSvgaReportBean;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVHandler;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVLifecycle;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVManager;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVBaseContext;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVLifecycle;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.IKTVMusicLibraryOperator;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.KTVLibraryContract;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.KTVLibraryPresenter;
import com.yy.hiyo.channel.plugins.ktv.list.songlist.IKTVSongListOperator;
import com.yy.hiyo.channel.plugins.ktv.list.songlist.KTVSongListContract;
import com.yy.hiyo.channel.plugins.ktv.list.songlist.KTVSongListPresenter;
import com.yy.hiyo.channel.plugins.ktv.model.KTVRoomManager;
import com.yy.hiyo.channel.plugins.ktv.panel.IKTVPanelListener;
import com.yy.hiyo.channel.plugins.ktv.panel.IKTVPanelOperater;
import com.yy.hiyo.channel.plugins.ktv.panel.ISvgaAnimListener;
import com.yy.hiyo.channel.plugins.ktv.panel.KTVPanelContract;
import com.yy.hiyo.channel.plugins.ktv.panel.KTVPanelPresenter;
import com.yy.hiyo.channel.plugins.ktv.room.IRoomOperater;
import com.yy.hiyo.channel.plugins.ktv.room.RoomCommonOperater;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public class KTVRoomPageController
implements IKTVHandler {
    private IKTVManager iKtvManager = new KTVRoomManager();
    private KTVOperateProvider mKTVOperateProvider;
    private KTVPanelContract.Presenter mKTVPanelPresent;
    private KTVLibraryContract.Presenter mLibraryPresenter;
    private KTVSongListContract.Presenter mSelectedSongPresenter;
    private IRoomOperater iRoomOperater;
    private ChannelPageContext<AbsPage> mRoomContext;
    private Set<IKTVLifecycle> mLifecycleSet = new HashSet<IKTVLifecycle>();
    private Set<KTVBasePresent> mKTVBasePresentSet = new HashSet<KTVBasePresent>();
    private Queue<KtvSvgaReportBean> mGiftQueue = new LinkedList<KtvSvgaReportBean>();
    private boolean isAnimSvga = false;
    private KtvSvgaReportBean lastSvgaBean;
    private IKTVLifecycle iKtvLifecycleInner = new KTVLifecycle(){

        @Override
        public void onCreate(KTVBaseContext context) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVBase", (String)"onCreate", (Object[])new Object[0]);
            }
            for (IKTVLifecycle iktvLifecycle : KTVRoomPageController.this.mLifecycleSet) {
                iktvLifecycle.onCreate(context);
            }
            super.onCreate(context);
        }

        @Override
        public void onQuited(KTVBaseContext context) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVBase", (String)"onQuited", (Object[])new Object[0]);
            }
            super.onQuited(context);
            for (IKTVLifecycle iktvLifecycle : KTVRoomPageController.this.mLifecycleSet) {
                iktvLifecycle.onQuited(context);
            }
        }

        @Override
        public void onViewCreate(KTVBaseContext context) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVBase", (String)"onViewCreate", (Object[])new Object[0]);
            }
            super.onViewCreate(context);
            for (KTVBasePresent ktvBasePresent : KTVRoomPageController.this.mKTVBasePresentSet) {
                ktvBasePresent.onKTVCreate();
            }
            for (IKTVLifecycle iktvLifecycle : KTVRoomPageController.this.mLifecycleSet) {
                iktvLifecycle.onViewCreate(context);
            }
        }

        @Override
        public void onVideoModeChange(boolean isVideoMode) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVBase", (String)("onVideoModeChange isVideoMode = " + isVideoMode), (Object[])new Object[0]);
            }
            for (IKTVLifecycle iktvLifecycle : KTVRoomPageController.this.mLifecycleSet) {
                iktvLifecycle.onVideoModeChange(isVideoMode);
            }
        }

        @Override
        public void onViewDestory(KTVBaseContext context) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVBase", (String)"onViewDestory", (Object[])new Object[0]);
            }
            super.onViewDestory(context);
            for (KTVBasePresent ktvBasePresent : KTVRoomPageController.this.mKTVBasePresentSet) {
                ktvBasePresent.onKTVDestroy();
            }
            for (IKTVLifecycle iktvLifecycle : KTVRoomPageController.this.mLifecycleSet) {
                iktvLifecycle.onViewDestory(context);
            }
            KTVRoomPageController.this.mKTVBasePresentSet.clear();
        }

        @Override
        public void onDestroy(KTVBaseContext context) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVBase", (String)"onDestroy", (Object[])new Object[0]);
            }
            for (IKTVLifecycle iktvLifecycle : KTVRoomPageController.this.mLifecycleSet) {
                iktvLifecycle.onDestroy(context);
            }
            super.onDestroy(context);
        }
    };
    private IKTVPanelListener iktvPanelListener = new IKTVPanelListener(){

        @Override
        public void onVideoModeChange(boolean isVideoMode) {
            if (KTVRoomPageController.this.iKtvLifecycleInner != null) {
                KTVRoomPageController.this.iKtvLifecycleInner.onVideoModeChange(isVideoMode);
            }
        }

        @Override
        public void onQuited() {
            if (KTVRoomPageController.this.iKtvLifecycleInner != null) {
                KTVRoomPageController.this.iKtvLifecycleInner.onQuited(KTVRoomPageController.this.iKtvManager.getContext());
            }
            KTVRoomPageController.this.closeKTV();
        }
    };
    private ISvgaAnimListener mISvgaAnimListener = new ISvgaAnimListener(){

        @Override
        public void onSvgaAnimStart() {
            KTVRoomPageController.this.isAnimSvga = true;
            if (KTVRoomPageController.this.lastSvgaBean != null) {
                ChannelTrack.INSTANCE.onKtvSvgaShow(Integer.valueOf(KTVRoomPageController.this.lastSvgaBean.getPropsId()), Long.valueOf(KTVRoomPageController.this.lastSvgaBean.getUid()));
            }
        }

        @Override
        public void onSvgaAnimFinish() {
            KTVRoomPageController.this.isAnimSvga = false;
            if (!KTVRoomPageController.this.mGiftQueue.isEmpty()) {
                KTVRoomPageController.this.lastSvgaBean = (KtvSvgaReportBean)KTVRoomPageController.this.mGiftQueue.poll();
                if (KTVRoomPageController.this.lastSvgaBean != null && !TextUtils.isEmpty((CharSequence)KTVRoomPageController.this.lastSvgaBean.getSvgaUrl())) {
                    KTVRoomPageController.this.realStartSvga(KTVRoomPageController.this.lastSvgaBean.getSvgaUrl());
                }
            }
        }
    };

    KTVRoomPageController(ChannelPageContext<AbsPage> roomContext, IKTVLifecycle ktvLifecycle) {
        this.mRoomContext = roomContext;
        this.mKTVOperateProvider = new KTVOperateProvider();
        this.mLifecycleSet.add(ktvLifecycle);
    }

    void startKTV(YYFrameLayout viewContainer, PanelLayer listContainer) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVBase", (String)"\u6253\u5f00ktv", (Object[])new Object[0]);
        }
        KTVBaseContext context = new KTVBaseContext();
        context.setRoomContext(this.mRoomContext);
        this.initKTVRoomManager(context);
        this.initKTVPanelModel(viewContainer, listContainer);
        this.initKTVLibraryModel(listContainer);
        this.initKTVSelectedSongModel(listContainer);
        this.initRoomOpearter();
        if (this.iKtvLifecycleInner != null) {
            this.iKtvLifecycleInner.onViewCreate(context);
        }
        this.mKTVPanelPresent.openPanel();
    }

    void closeKTV() {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVBase", (String)"\u5173\u95edktv", (Object[])new Object[0]);
        }
        if (this.mKTVPanelPresent != null) {
            ((IKTVPanelOperater)this.mKTVPanelPresent.getContract()).closePanel();
        }
        if (this.iKtvManager != null && this.iKtvManager.getContext() != null) {
            this.iKtvLifecycleInner.onViewDestory(this.iKtvManager.getContext());
            if (this.iKtvManager.getContext().getRoomData() != null) {
                this.iKtvManager.onDestroy();
                this.iKtvManager = new KTVRoomManager();
            }
        }
    }

    private void initKTVRoomManager(KTVBaseContext context) {
        if (null == context || null == context.getRoomData()) {
            return;
        }
        if (null == this.iKtvManager) {
            this.iKtvManager = new KTVRoomManager();
        }
        if (null == this.iKtvManager.getContext()) {
            this.iKtvManager.onCreate(context);
        }
    }

    private void initKTVPanelModel(YYFrameLayout viewContainer, PanelLayer panelLayer) {
        this.mKTVPanelPresent = new KTVPanelPresenter(viewContainer, this, panelLayer);
        this.mKTVOperateProvider.setKTVPanelOperater((IKTVPanelOperater)this.mKTVPanelPresent.getContract());
        if (this.mKTVPanelPresent.getContract() != null) {
            ((IKTVPanelOperater)this.mKTVPanelPresent.getContract()).registerKTVPanelListener(this.iktvPanelListener);
        }
        this.mKTVBasePresentSet.add(this.mKTVPanelPresent);
    }

    private void initKTVLibraryModel(PanelLayer listContainer) {
        this.mLibraryPresenter = new KTVLibraryPresenter(listContainer, this);
        this.mKTVOperateProvider.setIKTVMusicLibraryOperator((IKTVMusicLibraryOperator)this.mLibraryPresenter.getContract());
        this.mKTVBasePresentSet.add(this.mLibraryPresenter);
    }

    private void initKTVSelectedSongModel(PanelLayer listContainer) {
        this.mSelectedSongPresenter = new KTVSongListPresenter(listContainer, this);
        this.mKTVOperateProvider.setIKTVSongListOperator((IKTVSongListOperator)this.mSelectedSongPresenter.getContract());
        this.mKTVBasePresentSet.add(this.mSelectedSongPresenter);
    }

    private void initRoomOpearter() {
        this.iRoomOperater = new RoomCommonOperater();
        this.mKTVOperateProvider.setRoomOperater(this.iRoomOperater);
    }

    public void setCommRoomCallback(IRoomOperater.IExtRoomOperater iExtRoomOperater) {
        if (this.iRoomOperater != null) {
            this.iRoomOperater.setExtRoomOperater(iExtRoomOperater);
        }
    }

    public KTVPanelContract.Presenter getKTVPanelPresenter() {
        return this.mKTVPanelPresent;
    }

    @Override
    public IKTVManager getKTVManager() {
        return this.iKtvManager;
    }

    @Override
    @NonNull
    public KTVOperateProvider getKTVOperateProvider() {
        return this.mKTVOperateProvider;
    }

    @Override
    public RoomData getmRoomDataContainer() {
        return this.mRoomContext.getRoomData();
    }

    @Override
    public void showMutePanel(long singerUid) {
    }

    @Override
    public int getPluginMode() {
        return 11;
    }

    public boolean addSongFromChat(String songId, KTVCommonCallback callback) {
        if (this.mLibraryPresenter == null) {
            return false;
        }
        return this.mLibraryPresenter.addSongFromChat(songId, callback);
    }

    void onRoomViewDestory() {
        if (null != this.getKTVManager()) {
            this.iKtvLifecycleInner.onViewDestory(this.getKTVManager().getContext());
        }
    }

    public void startGiftSvga(String url, int propsId, long uid) {
        this.addSvgaQueue(url, propsId, uid);
    }

    private void realStartSvga(String url) {
        if (this.mKTVPanelPresent != null) {
            this.mKTVPanelPresent.startGiftSvga(url, this.mISvgaAnimListener);
        }
    }

    private void addSvgaQueue(String url, int propsId, long uid) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (this.mGiftQueue.isEmpty() && !this.isAnimSvga) {
            this.realStartSvga(url);
            ChannelTrack.INSTANCE.onKtvSvgaShow(Integer.valueOf(propsId), Long.valueOf(uid));
        } else {
            this.mGiftQueue.offer(new KtvSvgaReportBean(uid, url, propsId));
        }
    }

    public void setUICallback(IUICallback callback) {
        if (null != this.mKTVPanelPresent) {
            this.mKTVPanelPresent.setUICallback(callback);
        }
    }

    public void onPageDetach() {
        this.isAnimSvga = false;
        this.mGiftQueue.clear();
    }

    @Override
    public List<View> getScrollViews() {
        if (this.mKTVPanelPresent != null) {
            return this.mKTVPanelPresent.getScrollViews();
        }
        return Collections.EMPTY_LIST;
    }
}

