/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.videoktv;

import android.content.Context;
import android.widget.FrameLayout;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.ui.PanelLayer;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.channelhiido.RadioUtils;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.model.bean.RoomInfo;
import com.yy.hiyo.channel.cbase.module.ktv.KTVCommonCallback;
import com.yy.hiyo.channel.cbase.module.ktv.base.IKtvCallback;
import com.yy.hiyo.channel.cbase.module.ktv.base.KtvConfigBean;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVMusicInfo;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomData;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomOperateInfo;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import com.yy.hiyo.channel.cbase.module.ktv.room.IKTVNotifyHandler;
import com.yy.hiyo.channel.cbase.tools.IRevenueToolsModulePresenter;
import com.yy.hiyo.channel.component.profile.profilecard.base.ProfileCardPresenter;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVHandler;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVCommonPresenter;
import com.yy.hiyo.channel.plugins.ktv.common.callback.IKTVPanelUICallback;
import com.yy.hiyo.channel.plugins.ktv.common.callback.IKTVQueryCallback;
import com.yy.hiyo.channel.plugins.ktv.model.downloader.IKTVdownloadCallback;
import com.yy.hiyo.channel.plugins.ktv.model.player.IKTVPlayerCallback;
import com.yy.hiyo.channel.plugins.ktv.panel.IKTVPanelListener;
import com.yy.hiyo.channel.plugins.ktv.panel.IKTVPanelOperater;
import com.yy.hiyo.channel.plugins.ktv.panel.ISvgaAnimListener;
import com.yy.hiyo.channel.plugins.ktv.panel.VideoKTVPanelContract;
import com.yy.hiyo.channel.plugins.ktv.panel.utils.KTVDataReportHelper;
import com.yy.hiyo.channel.plugins.ktv.utils.KTVEventReportUtil;
import com.yy.hiyo.channel.plugins.ktv.videoktv.VideoKTVLyricViewModel;
import com.yy.hiyo.channel.plugins.ktv.videoktv.VideoKTVPanelManager;
import com.yy.hiyo.mvp.base.SimpleLifeCycleOwner;
import com.yy.hiyo.user.base.profilecard.OpenProfileFrom;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.param.ShowGiftPanelParam;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;

public class VideoKTVPanelPresenter
extends KTVCommonPresenter
implements VideoKTVPanelContract.Presenter,
IKTVPanelUICallback,
IKTVPlayerCallback {
    private static final long READY_TIME_LIMIT = 3900L;
    private FrameLayout mContainer;
    private PanelLayer mPanelLayer;
    private VideoKTVPanelManager mPanelManager;
    private boolean mIsOwnerOrMaster;
    private boolean mIsOwner;
    private String mCurrentNeedPlaySongId = "";
    private long mCurrentSongStartTime = 0L;
    private String mLastReportSongId = "";
    private boolean mCameraOpen = false;
    private boolean mSkipMusicAnim = false;
    private long mCurrentSingerUid = 0L;
    private IKtvCallback ktvCallback;
    private SimpleLifeCycleOwner lifeCycleOwner = new SimpleLifeCycleOwner("VideoKTVPanelPresenter");
    private VideoKTVLyricViewModel lyricViewModel;
    private IKTVNotifyHandler<KTVRoomOperateInfo> mTerminateSongNotify = this::handleTerminateSongNotify;
    IKTVdownloadCallback iktVdownloadCallback = new IKTVdownloadCallback(){

        @Override
        public void onSuccess(KTVMusicInfo songInfo, String type, String filePath) {
            int currentSongInfoStatus;
            if (songInfo == null) {
                return;
            }
            KTVRoomData currentKTVRoomData = VideoKTVPanelPresenter.this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData();
            if (currentKTVRoomData == null) {
                return;
            }
            KTVRoomSongInfo currentSongInfo = currentKTVRoomData.getCurrentSongInfo();
            if (currentSongInfo == null) {
                return;
            }
            if (VideoKTVPanelPresenter.this.mCurrentNeedPlaySongId.equals(songInfo.getSongId()) && type.equals("Instrumental") && currentSongInfo.getUid() == AccountUtil.getUid()) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVPanel", (String)"download music success,start play uid: %s", (Object[])new Object[]{currentSongInfo.getUid()});
                }
                if (VideoKTVPanelPresenter.this.getHandler().getKTVManager().getKTVDownloader().checkInstrumentalVaild(songInfo) == 2) {
                    long minimumTime = 3900L - (System.currentTimeMillis() - VideoKTVPanelPresenter.this.mCurrentSongStartTime);
                    VideoKTVPanelPresenter.this.getHandler().getKTVManager().getKTVPlayer().play(VideoKTVPanelPresenter.this.mCurrentNeedPlaySongId, VideoKTVPanelPresenter.this, minimumTime);
                } else {
                    VideoKTVPanelPresenter.this.onPlayFailed(songInfo.getSongId());
                }
            }
            if (StringUtils.isNotEmpty((String)currentSongInfo.getResourceId()) && currentSongInfo.getResourceId().equals(songInfo.getSongId()) && type.equals("lyric") && ((currentSongInfoStatus = currentSongInfo.getStatus()) == 1 || currentSongInfoStatus == 2) && VideoKTVPanelPresenter.this.mPanelManager != null) {
                FeatureLog.i((String)"FTKTVPanel", (String)"download mOriginSinger lyric success,start load lyric uid: %s", (Object[])new Object[]{currentSongInfo.getUid()});
                VideoKTVPanelPresenter.this.mPanelManager.loadPanelLyric(filePath);
            }
        }

        @Override
        public void onStarted(KTVMusicInfo songInfo, String type) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVPanel", (String)"start download music and lyric resource id: %s", (Object[])new Object[]{songInfo == null ? "unKnown" : songInfo.getSongId()});
            }
        }

        @Override
        public void onError(KTVMusicInfo songInfo, String type, String errorMessage) {
            FeatureLog.e((String)"FTKTVPanel", (String)"download song id: %s,download %s error: %s", (Object[])new Object[]{songInfo == null ? "unKnown" : songInfo.getSongId(), type, errorMessage});
            if ("Instrumental".equals(type)) {
                if (songInfo == null) {
                    return;
                }
                KTVRoomData currentKTVRoomData = VideoKTVPanelPresenter.this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData();
                if (currentKTVRoomData == null) {
                    return;
                }
                KTVRoomSongInfo currentSongInfo = currentKTVRoomData.getCurrentSongInfo();
                if (currentSongInfo == null) {
                    return;
                }
                if (VideoKTVPanelPresenter.this.mCurrentNeedPlaySongId.equals(songInfo.getSongId()) && currentSongInfo.getUid() == AccountUtil.getUid()) {
                    FeatureLog.e((String)"FTKTVPanel", (String)"my song download failed,terminate song", (Object[])new Object[0]);
                    VideoKTVPanelPresenter.this.getHandler().getKTVManager().getKTVRoomServices().terminateSong(VideoKTVPanelPresenter.this.mCurrentNeedPlaySongId, 1, null);
                }
            }
        }

        @Override
        public void onProgress(KTVMusicInfo songInfo, String type, long total, long current) {
            if (songInfo == null) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"KTVProgress", (String)"songInfo null", (Object[])new Object[0]);
                }
                return;
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"KTVProgress", (String)"currentSongId:%s, songId:%s, type:%s", (Object[])new Object[]{VideoKTVPanelPresenter.this.mCurrentNeedPlaySongId, songInfo.getSongId(), type});
            }
            if (VideoKTVPanelPresenter.this.mCurrentNeedPlaySongId.equals(songInfo.getSongId()) && "Instrumental".equals(type) && VideoKTVPanelPresenter.this.mPanelManager != null) {
                VideoKTVPanelPresenter.this.mPanelManager.showLoading(total, current);
            }
        }
    };
    private KvoBinder mBinder = new KvoBinder((Object)this);
    private IKTVPanelListener iktvPanelListener;

    public void onPlayFailed(String playFailSongId) {
        String songId;
        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_can_not_play_song), (int)0);
        if (this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData() != null && this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo() != null && (songId = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().getResourceId()).equals(playFailSongId)) {
            this.getHandler().getKTVManager().getKTVRoomServices().terminateSong(songId, 1, null);
        }
    }

    public VideoKTVPanelPresenter(final FrameLayout container, PanelLayer panelLayer, IKTVHandler handler) {
        super(handler);
        this.mContainer = container;
        this.mPanelLayer = panelLayer;
        this.getHandler().getKTVManager().getKTVPlayer().registerKTVPanelUICallback(this);
        this.registerDownloader();
        this.getHandler().getKTVManager().getKTVRoomServices().registerTerminateSongNotify(this.mTerminateSongNotify);
        this.lifeCycleOwner.onEvent(Lifecycle.Event.ON_RESUME);
        this.lyricViewModel = new VideoKTVLyricViewModel(this.getHandler());
        this.lyricViewModel.hasLyricPermission(this.getOwnerUid()).observe((LifecycleOwner)this.lifeCycleOwner, (Observer)new Observer<Boolean>(){

            public void onChanged(Boolean it) {
                VideoKTVPanelPresenter.this.updateContainerVisible(VideoKTVPanelPresenter.this.getCurrentSongInfo(), it, container);
            }
        });
    }

    private void updateContainerVisible(KTVRoomSongInfo info, Boolean hasLyricPermission2, FrameLayout container) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"VideoKTVPanelPresenter", (String)"updateContainerVisible hasLyricPermission %s", (Object[])new Object[]{hasLyricPermission2});
        }
        if (Boolean.TRUE.equals(hasLyricPermission2)) {
            if (this.isSinger() || this.isRoomOwner() || this.isMeShowing()) {
                container.setVisibility(0);
            } else {
                boolean visible;
                boolean bl = visible = info != null && StringUtils.isNotEmpty((String)info.getSongId()) || this.isMultiVideo();
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"VideoKTVPanelPresenter", (String)"updateContainerVisible hasLyricPermission %s, visible %b", (Object[])new Object[]{hasLyricPermission2, visible});
                }
                container.setVisibility(visible ? 0 : 8);
            }
        } else {
            container.setVisibility(8);
        }
    }

    private void handleTerminateSongNotify(KTVRoomOperateInfo operateInfo) {
        if (0 == operateInfo.getOperateFlag() && null != this.mPanelManager) {
            this.mPanelManager.showEndingPanel(this.isSinger(), operateInfo.getKTVRoomSongInfo());
        }
    }

    public void setKtvCallback(IKtvCallback ktvCallback) {
        this.ktvCallback = ktvCallback;
    }

    public void start() {
    }

    private void registerDownloader() {
        this.getHandler().getKTVManager().getKTVDownloader().registerKTVDonwloadListener(this.iktVdownloadCallback);
    }

    @Override
    public void openPanel() {
        this.mIsOwner = this.getHandler().getmRoomDataContainer().getRoomInfo().isRoomOwner(AccountUtil.getUid());
        this.mIsOwnerOrMaster = this.getHandler().getmRoomDataContainer().getRoomInfo().isOwnerOrMaster(AccountUtil.getUid());
        this.mPanelManager = new VideoKTVPanelManager(this.mContainer, this.mPanelLayer);
        this.mPanelManager.setPresenter(this);
        this.mPanelManager.showPanel(-1);
        this.getHandler().getKTVManager().getKTVRoomServices().fetchKTVRoomOrderedSongList(null);
        this.mBinder.singleBindSourceTo((KvoSource)this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData());
        this.mBinder.singleBindSourceTo((KvoSource)this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo());
        RadioUtils.INSTANCE.reportSingTableShow(this.isSinging());
    }

    @Override
    public void playSong() {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVPanel", (String)"clicked sing and play song", (Object[])new Object[0]);
        }
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVPanel", (String)"network unavailable", (Object[])new Object[0]);
            }
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
            return;
        }
        KTVRoomData currentKTVRoomData = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData();
        if (currentKTVRoomData == null) {
            FeatureLog.e((String)"FTKTVPlayer", (String)"play song currentKTVRoomData is null.", (Object[])new Object[0]);
            return;
        }
        KTVRoomSongInfo currentSongInfo = currentKTVRoomData.getCurrentSongInfo();
        if (currentSongInfo == null) {
            FeatureLog.e((String)"FTKTVPlayer", (String)"play song currentSongInfo is null.", (Object[])new Object[0]);
            return;
        }
        String resourceId = currentSongInfo.getResourceId();
        if (StringUtils.isEmpty((String)resourceId)) {
            FeatureLog.e((String)"FTKTVPlayer", (String)"play song resourceId is null.", (Object[])new Object[0]);
            return;
        }
        this.mCurrentSingerUid = currentSongInfo.getUid();
        this.mCurrentNeedPlaySongId = resourceId;
        this.mCurrentSongStartTime = System.currentTimeMillis();
        this.mPanelManager.showGetReadyPanel(this.isSinger(), currentKTVRoomData.hasSkipSongPolicy(), true, currentSongInfo);
        this.reportHidoEvent(1);
        this.getHandler().getKTVManager().getKTVPlayer().play(resourceId, this, 3900L);
    }

    @Override
    public void openSongList() {
        if (this.getHandler().getKTVOperateProvider().getIKTVSongListOperator() != null) {
            this.getHandler().getKTVOperateProvider().getIKTVSongListOperator().showSongListPanel();
        }
    }

    @Override
    public void openSongLib() {
        if (this.getHandler().getKTVOperateProvider().getIKTVMusicLibraryOperator() != null) {
            this.getHandler().getKTVOperateProvider().getIKTVMusicLibraryOperator().setMode(1);
            this.getHandler().getKTVOperateProvider().getIKTVMusicLibraryOperator().showMusicLibrary();
        }
    }

    @Override
    public void skipSong() {
        KTVRoomData currentKTVRoomData;
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVPanel", (String)"click skip song", (Object[])new Object[0]);
        }
        if ((currentKTVRoomData = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData()) == null) {
            return;
        }
        KTVRoomSongInfo currentSongInfo = currentKTVRoomData.getCurrentSongInfo();
        String currentSongId = currentSongInfo.getSongId();
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVPlayer", (String)"skipSong song id: %s", (Object[])new Object[]{currentSongId});
        }
        if (StringUtils.isNotEmpty((String)currentSongId)) {
            this.getHandler().getKTVManager().getKTVRoomServices().terminateSong(currentSongId, 1, null);
        }
    }

    @Override
    public void closePanel() {
        if (this.isMultiVideo()) {
            this.showCloseKtvDialog();
        } else {
            this.realClosePanel();
        }
    }

    private void realClosePanel() {
        if (this.iktvPanelListener != null) {
            this.iktvPanelListener.onQuited();
        }
        this.closePanelInner();
        this.getHandler().nextSong();
    }

    private void showCloseKtvDialog() {
        OkCancelDialog dialog2 = new OkCancelDialog.Builder().message((CharSequence)ResourceUtils.getString((int)R.string.content_multivideo_close_ktv_dialog)).setCancelLabel((CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_no)).okLabel((CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_yes)).listener(new OkCancelDialogListener(){

            public void onCancel() {
            }

            public void onOk() {
                VideoKTVPanelPresenter.this.realClosePanel();
            }
        }).cancelable(true).outSideCancelable(true).build();
        this.getHandler().getKTVManager().getContext().getRoomContext().getDialogLinkManager().showDialog((BaseDialog)dialog2);
    }

    public void closePanelInner() {
        if (this.mPanelManager != null) {
            this.mPanelManager.closePanel();
        }
    }

    @Override
    public void onKTVDestroy() {
        super.onKTVDestroy();
        this.mBinder.clearAllKvoConnections();
        this.destoryRes();
        if (this.mPanelManager != null) {
            this.mPanelManager.destroy();
        }
        if (this.mContainer != null) {
            this.mContainer.removeAllViews();
        }
        this.lifeCycleOwner.onEvent(Lifecycle.Event.ON_DESTROY);
    }

    void destoryRes() {
        this.getHandler().getKTVManager().getKTVDownloader().unRegisterKTVDonwloadListener(this.iktVdownloadCallback);
        this.getHandler().getKTVManager().getKTVPlayer().registerKTVPanelUICallback(null);
        this.getHandler().getKTVManager().getKTVRoomServices().unRegisterTerminateSongNotify(this.mTerminateSongNotify);
    }

    @Override
    public void pauseSingSong() {
        KTVRoomData currentKTVRoomData;
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVPanel", (String)"clicked pause song", (Object[])new Object[0]);
        }
        if (this.isSinger()) {
            this.getHandler().getKTVManager().getKTVPlayer().pause();
            RadioUtils.INSTANCE.reportSingPause();
        }
        if (this.mPanelManager != null) {
            this.mPanelManager.onIsPauseState(true);
        }
        if ((currentKTVRoomData = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData()) == null) {
            return;
        }
        KTVRoomSongInfo currentSongInfo = currentKTVRoomData.getCurrentSongInfo();
        if (currentSongInfo == null) {
            return;
        }
        String songId = currentSongInfo.getSongId();
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVPanel", (String)"clicked pause song id: %s", (Object[])new Object[]{songId});
        }
        if (StringUtils.isNotEmpty((String)songId)) {
            this.getHandler().getKTVManager().getKTVRoomServices().pauseSong(songId, null);
        }
    }

    @Override
    public void resumeSingSong() {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVPanel", (String)"clicked resume song", (Object[])new Object[0]);
        }
        if (this.isSinger()) {
            this.getHandler().getKTVManager().getKTVPlayer().resume();
            RadioUtils.INSTANCE.reportSingContinue();
        }
        this.mPanelManager.onIsPauseState(false);
        KTVRoomData currentKTVRoomData = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData();
        if (currentKTVRoomData == null) {
            return;
        }
        KTVRoomSongInfo currentSongInfo = currentKTVRoomData.getCurrentSongInfo();
        if (currentSongInfo == null) {
            return;
        }
        String songId = currentSongInfo.getSongId();
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVPanel", (String)"clicked resume song id: %s", (Object[])new Object[]{songId});
        }
        if (StringUtils.isNotEmpty((String)songId)) {
            this.getHandler().getKTVManager().getKTVRoomServices().startSong(songId, null);
        }
    }

    @Override
    public boolean isPause() {
        return this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().getStatus() == 2;
    }

    @Override
    public boolean isSinging() {
        return this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().getStatus() == 1;
    }

    @Override
    public boolean isSinger() {
        return this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().isSinger();
    }

    @Override
    public boolean isRoomOwner() {
        return this.mIsOwner;
    }

    @Override
    public boolean isMeShowing() {
        if (this.getHandler().getKTVManager().getContext().getRoomContext().getChannel().getDataService().getCacheDetail() != null && this.getHandler().getKTVManager().getContext().getRoomContext().getChannel().getDataService().getCacheDetail().baseInfo.isLoopMicRoom()) {
            return this.isMeAnchor();
        }
        RoomInfo roomInfo = this.getHandler().getmRoomDataContainer().getRoomInfo();
        if (roomInfo.isGroupParty() && 0L != roomInfo.getShowUid()) {
            return AccountUtil.getUid() == roomInfo.getShowUid();
        }
        return this.isRoomOwner();
    }

    @Override
    public boolean isOwnerOrMaster() {
        return this.mIsOwnerOrMaster;
    }

    @Override
    public boolean isInSeat() {
        return this.getHandler().getKTVManager().getContext().getRoomContext().getChannel().getSeatService().isInSeat(AccountUtil.getUid());
    }

    private boolean isMeAnchor() {
        return this.getHandler().getKTVManager().getContext().getRoomContext().getChannel().getRoleService().isMeAnchor();
    }

    @Override
    public void onPrepare(KTVRoomSongInfo songInfo) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVPanel", (String)"onPrepare", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((String)songInfo.getSongId())) {
            if (this.mPanelManager != null) {
                KTVRoomData currentKTVRoomData = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData();
                this.mPanelManager.showNoSongPanel(this.isInSeat(), currentKTVRoomData.hasCloseKTVPolicy());
            }
        } else {
            if (this.mPanelManager != null) {
                KTVRoomData currentKTVRoomData = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData();
                this.mPanelManager.showGetReadyPanel(this.isSinger(), currentKTVRoomData.hasSkipSongPolicy(), false, songInfo);
            }
            this.getHandler().setSingerUid(songInfo.getUid());
            this.getHandler().nextSong();
        }
    }

    @Override
    public void onStart(final KTVRoomSongInfo songInfo) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVPanel", (String)"onStart", (Object[])new Object[0]);
        }
        this.getHandler().setSingerUid(songInfo.getUid());
        Boolean permission = (Boolean)this.lyricViewModel.hasLyricPermission(this.getOwnerUid()).getValue();
        this.updateContainerVisible(songInfo, permission, this.mContainer);
        String resourceId = songInfo.getResourceId();
        if (StringUtils.isNotEmpty((String)resourceId)) {
            this.getHandler().getKTVManager().getKTVMusicListProvider().getMusicInfo(resourceId, new IKTVQueryCallback<KTVMusicInfo>(){

                @Override
                public void onSuccess(KTVMusicInfo data, boolean isCache) {
                    if (VideoKTVPanelPresenter.this.getHandler().getKTVManager() != null) {
                        String lyricFilePath = VideoKTVPanelPresenter.this.getHandler().getKTVManager().getKTVDownloader().getLocalLyricFilePath(data);
                        if (FeatureLog.isLogLevelBlowInfo()) {
                            FeatureLog.i((String)"FTKTVPanel", (String)"onStart load lyric path: %s", (Object[])new Object[]{lyricFilePath});
                        }
                        if (VideoKTVPanelPresenter.this.mPanelManager != null) {
                            if (StringUtils.isNotEmpty((String)lyricFilePath)) {
                                VideoKTVPanelPresenter.this.mPanelManager.loadPanelLyric(lyricFilePath);
                            }
                            VideoKTVPanelPresenter.this.mPanelManager.showSingingPanel(VideoKTVPanelPresenter.this.isSinger(), !VideoKTVPanelPresenter.this.mCameraOpen, songInfo);
                        }
                    }
                }

                @Override
                public void onFail(String errorMessage) {
                    FeatureLog.e((String)"FTKTVPanel", (String)"load lyric failed: %s", (Object[])new Object[]{errorMessage});
                }
            });
        }
    }

    @Override
    public void onPause(KTVRoomSongInfo songInfo) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVPanel", (String)"onPause", (Object[])new Object[0]);
        }
        this.getHandler().getKTVManager().getKTVPlayer().pause();
        if (this.mPanelManager != null) {
            this.mPanelManager.onIsPauseState(true);
            this.mPanelManager.showSingingPanel(this.isSinger(), false, songInfo);
        }
    }

    @Override
    public void onResume(final KTVRoomSongInfo songInfo) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVPanel", (String)"onResume", (Object[])new Object[0]);
        }
        this.getHandler().getKTVManager().getKTVPlayer().resume();
        if (this.mPanelManager != null) {
            this.mPanelManager.onIsPauseState(false);
            if (this.mPanelManager.hasLoadLyricFile()) {
                this.mPanelManager.showSingingPanel(this.isSinger(), false, songInfo);
            } else {
                String resourceId = songInfo.getResourceId();
                if (StringUtils.isNotEmpty((String)resourceId)) {
                    this.getHandler().getKTVManager().getKTVMusicListProvider().queryMusic(resourceId, new KTVCommonCallback<KTVMusicInfo>(){

                        public void onSuccess(KTVMusicInfo data) {
                            String lyricFilePath = VideoKTVPanelPresenter.this.getHandler().getKTVManager().getKTVDownloader().getLocalLyricFilePath(data);
                            if (StringUtils.isNotEmpty((String)lyricFilePath) && VideoKTVPanelPresenter.this.mPanelManager != null) {
                                VideoKTVPanelPresenter.this.mPanelManager.loadPanelLyric(lyricFilePath);
                            }
                            if (VideoKTVPanelPresenter.this.mPanelManager != null) {
                                VideoKTVPanelPresenter.this.mPanelManager.showSingingPanel(VideoKTVPanelPresenter.this.isSinger(), false, songInfo);
                            }
                        }

                        public void onFail(int code, String errorMessage) {
                            FeatureLog.e((String)"FTKTVPlayer", (String)"load lyric failed: %s", (Object[])new Object[]{errorMessage});
                        }
                    });
                }
            }
        }
    }

    @Override
    public void onClear(KTVRoomSongInfo songInfo) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVPanel", (String)"onClear", (Object[])new Object[0]);
        }
        KTVRoomData currentKTVRoomData = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData();
        if (StringUtils.isEmpty((String)songInfo.getSongId())) {
            if (this.mPanelManager != null) {
                this.mPanelManager.showNoSongPanel(this.isInSeat(), currentKTVRoomData.hasCloseKTVPolicy());
            }
        } else if (this.mPanelManager != null) {
            this.mPanelManager.showGetReadyPanel(this.isSinger(), currentKTVRoomData.hasSkipSongPolicy(), false, songInfo);
        }
        this.updateContainerVisible(songInfo, this.hasLyricPermission(), this.mContainer);
    }

    @Override
    public void onLoading(KTVRoomSongInfo songInfo) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVPanel", (String)"onLoading", (Object[])new Object[0]);
        }
        if (this.mPanelManager != null) {
            KTVRoomData currentKTVRoomData = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData();
            this.mPanelManager.showLoadingPanel(currentKTVRoomData.hasCloseKTVPolicy());
        }
        if (songInfo != null) {
            this.getHandler().setSingerUid(songInfo.getUid());
        }
    }

    @Override
    public String getRoomId() {
        return this.getHandler().getmRoomDataContainer().getRoomId();
    }

    public KTVPanelOperater getContract() {
        return new KTVPanelOperater();
    }

    @Override
    public void onAudioPlaySpectrumData(byte[] data) {
    }

    @Override
    public void onLyricsTime(int time, int totalDuration) {
        if (this.mPanelManager != null) {
            this.mPanelManager.updateLyricTime(time, totalDuration);
        }
    }

    @KvoMethodAnnotation(sourceClass=KTVRoomSongInfo.class, name="songId")
    public void onCurrSongIdChanged(KvoEventIntent event) {
        KTVRoomSongInfo currentSongInfo;
        String oldSongId = (String)event.oldValue();
        String newSongId = (String)event.newValue();
        KTVRoomData currentKTVRoomData = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData();
        KTVRoomSongInfo kTVRoomSongInfo = currentSongInfo = currentKTVRoomData == null ? null : currentKTVRoomData.getCurrentSongInfo();
        if (FP.empty((CharSequence)oldSongId) && !FP.empty((CharSequence)newSongId)) {
            if (currentSongInfo != null && currentSongInfo.getUid() == AccountUtil.getUid()) {
                this.playSong();
            }
        } else if ((FP.empty((CharSequence)oldSongId) || !FP.empty((CharSequence)newSongId)) && currentSongInfo != null && currentSongInfo.getUid() == AccountUtil.getUid()) {
            this.playSong();
        }
        if (null != this.mPanelManager) {
            this.mPanelManager.currentSongInfoChanged(currentSongInfo);
        }
    }

    @KvoMethodAnnotation(sourceClass=KTVRoomSongInfo.class, name="status")
    public void onSongStatusChanged(KvoEventIntent event) {
        if (event == null || event.oldValue() == null || event.newValue() == null) {
            return;
        }
        int oldValue = (Integer)event.oldValue();
        int newValue = (Integer)event.newValue();
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVPanel", (String)"old value: %s,new value: %s", (Object[])new Object[]{oldValue, newValue});
        }
        if (newValue == -2) {
            this.mCurrentNeedPlaySongId = "";
            this.mCurrentSongStartTime = 0L;
            this.onLoading((KTVRoomSongInfo)event.source());
        } else if (newValue == -1) {
            this.onClear((KTVRoomSongInfo)event.source());
        } else if (newValue == 0) {
            this.onPrepare((KTVRoomSongInfo)event.source());
        } else if ((oldValue == -2 || oldValue == -1 || oldValue == 0 || oldValue == 3) && newValue == 1) {
            this.onStart((KTVRoomSongInfo)event.source());
        } else if ((oldValue == 2 || oldValue == 1) && newValue == 1) {
            this.onResume((KTVRoomSongInfo)event.source());
        } else if (newValue == 2) {
            this.onPause((KTVRoomSongInfo)event.source());
        }
        if (null != this.mPanelManager) {
            this.mPanelManager.currentSongStatusChanged(newValue);
        }
    }

    @KvoMethodAnnotation(sourceClass=KTVRoomData.class, name="mPolicy", thread=1)
    public void onPolicyChanged(KvoEventIntent event) {
        this.checkSelectSongPolicy(KTVRoomData.getSelectSongPolicy((int)((Integer)event.oldValue())), KTVRoomData.getSelectSongPolicy((int)((Integer)event.newValue())));
    }

    private void checkSelectSongPolicy(int oldPolicy, int newPolicy) {
        if (newPolicy == 1) {
            if (this.mPanelManager != null) {
                this.mPanelManager.setSelectSongPolicy(this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().getStatus(), false);
            }
        } else if (newPolicy == 2 && this.mPanelManager != null) {
            this.mPanelManager.setSelectSongPolicy(this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().getStatus(), true);
        }
    }

    @Override
    public void onPlaySuccess() {
        KTVDataReportHelper.playSongReport(this.mCurrentNeedPlaySongId, 2);
    }

    @Override
    public void onPlayFail() {
        FeatureLog.e((String)"FTKTVPanel", (String)"play song resource id: %s failed.", (Object[])new Object[]{this.mCurrentNeedPlaySongId});
        KTVDataReportHelper.playSongReport(this.mCurrentNeedPlaySongId, 1);
        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_can_not_play_song), (int)0);
    }

    @Override
    public void onPlayEnd() {
        RadioUtils.INSTANCE.reportChangeSongClick("5");
    }

    @Override
    public void onPrePlay() {
        KTVDataReportHelper.playSongReport(this.mCurrentNeedPlaySongId, 0);
    }

    @Override
    public void showGiftPanel(long uid) {
        IChannelPageContext<AbsPage> roomPageContext;
        if (null != this.getHandler().getKTVManager() && null != this.getHandler().getKTVManager().getContext() && null != (roomPageContext = this.getHandler().getKTVManager().getContext().getRoomContext())) {
            if (uid == 0L) {
                ((IRevenueToolsModulePresenter)roomPageContext.getPresenter(IRevenueToolsModulePresenter.class)).getGiftPresenter().showGiftPanel(5);
            } else {
                ShowGiftPanelParam param = new ShowGiftPanelParam(5);
                param.setSelectedUid(Collections.singletonList(uid));
                ((IRevenueToolsModulePresenter)roomPageContext.getPresenter(IRevenueToolsModulePresenter.class)).openGiftPanel(param);
            }
        }
    }

    @Override
    public VideoKTVPanelContract.View getView() {
        return this.mPanelManager;
    }

    @Override
    public void openVideoScheme(boolean openCamera) {
    }

    @Override
    public void startGiftSvga(String url, ISvgaAnimListener listener) {
        if (this.mPanelManager != null) {
            this.mPanelManager.startGiftSvga(url, listener);
        }
    }

    @Override
    public KTVRoomSongInfo getCurrentSongInfo() {
        KTVRoomData currentKTVRoomData = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData();
        if (currentKTVRoomData == null) {
            return null;
        }
        return currentKTVRoomData.getCurrentSongInfo();
    }

    @Override
    public boolean isMultiVideo() {
        return this.getHandler().getPluginMode() == 15;
    }

    @Override
    public void showMutePanel() {
        this.getHandler().showMutePanel(this.mCurrentSingerUid);
    }

    @Override
    public void updateSwipeEnable(boolean enable) {
        if (this.ktvCallback != null) {
            this.ktvCallback.updateSwipeEnable(enable);
        }
    }

    @Override
    public void showSingerProfile(long uid) {
        IChannelPageContext<AbsPage> roomPageContext;
        if (null != this.getHandler().getKTVManager() && null != this.getHandler().getKTVManager().getContext() && (roomPageContext = this.getHandler().getKTVManager().getContext().getRoomContext()) != null) {
            ((ProfileCardPresenter)roomPageContext.getPresenter(ProfileCardPresenter.class)).showProfileCard(uid, OpenProfileFrom.FROM_OTHER);
            if (roomPageContext.getChannel() != null && roomPageContext.getChannel().getRoleService() != null) {
                String role = roomPageContext.getChannel().getRoleService().getRoleCache(AccountUtil.getUid()) + "";
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "ktv_profile_click").put("room_id", this.getRoomId()).put("user_role", role));
            }
        }
    }

    @Override
    @Nullable
    public GiftItemInfo getGiftInfo() {
        return this.getHandler().getKTVManager().getKTVRoomServices().getGiftInfo();
    }

    public void reportHidoEvent(int flag) {
        String ktvMode = KTVEventReportUtil.MODE_VIDEO;
        if (!this.mCameraOpen) {
            ktvMode = KTVEventReportUtil.MODE_VOICE;
        }
        if (flag == 1) {
            RadioUtils.INSTANCE.reportMusicTouch(this.mCurrentNeedPlaySongId, ktvMode);
        } else if (flag == 2 && !this.mLastReportSongId.equals(this.mCurrentNeedPlaySongId)) {
            KTVEventReportUtil.reportKTVModelChange(this.mCurrentNeedPlaySongId, ktvMode);
            this.mLastReportSongId = this.mCurrentNeedPlaySongId;
        }
    }

    public void changeMode(boolean isVideoMode) {
        if (this.mPanelManager != null) {
            this.mPanelManager.changeMode(isVideoMode);
        }
    }

    public void updateConfig(KtvConfigBean config) {
        if (config == null) {
            return;
        }
        if (this.mPanelManager != null) {
            this.mPanelManager.updateConfig(config);
        }
    }

    private Boolean hasLyricPermission() {
        long owner = this.getHandler().getmRoomDataContainer().getRoomInfo().getOwner();
        return (Boolean)this.lyricViewModel.hasLyricPermission(owner).getValue();
    }

    private long getOwnerUid() {
        return this.getHandler().getmRoomDataContainer().getRoomInfo().getOwnerId();
    }

    private KTVRoomData getKtvData() {
        return this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData();
    }

    public class KTVPanelOperater
    implements IKTVPanelOperater {
        @Override
        public void registerKTVPanelListener(IKTVPanelListener ktvPanelListener) {
            if (ktvPanelListener != null) {
                VideoKTVPanelPresenter.this.iktvPanelListener = ktvPanelListener;
            }
        }

        @Override
        public void unRegisterKTVPanelListener(IKTVPanelListener ktvPanelListener) {
            if (ktvPanelListener == VideoKTVPanelPresenter.this.iktvPanelListener) {
                VideoKTVPanelPresenter.this.iktvPanelListener = null;
            }
        }

        @Override
        public void closePanel() {
            VideoKTVPanelPresenter.this.closePanelInner();
        }
    }
}

