/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.model.room;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.KtvGiftConfig;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoFieldAnnotation;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.base.service.ISeatUpdateListener;
import com.yy.hiyo.channel.cbase.module.ktv.KTVCommonCallback;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVAudioPosition;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomData;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomOperateInfo;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomOrderedListInfo;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import com.yy.hiyo.channel.cbase.module.ktv.room.IKTVNotifyHandler;
import com.yy.hiyo.channel.cbase.module.ktv.room.IKTVRoomService;
import com.yy.hiyo.channel.plugins.ktv.apiservice.KTVProtoService;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVManager;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVBaseContext;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVBaseModel;
import com.yy.hiyo.channel.plugins.ktv.common.callback.IKTVProtoCallback;
import com.yy.hiyo.channel.plugins.ktv.utils.KTVEventReportUtil;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.voice.base.bean.CompressorParam;
import com.yy.hiyo.voice.base.bean.LimterParam;
import com.yy.hiyo.voice.base.bean.ReverbExParameter;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.wallet.base.GiftChannel;
import com.yy.hiyo.wallet.base.IGiftService;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import net.ihago.ktv.api.biz.AddSongNotify;
import net.ihago.ktv.api.biz.BizPush;
import net.ihago.ktv.api.biz.DelSongNotify;
import net.ihago.ktv.api.biz.GetRoomKaraokeInfoRsp;
import net.ihago.ktv.api.biz.KaraokeAddSongRsp;
import net.ihago.ktv.api.biz.KaraokeDelSongRsp;
import net.ihago.ktv.api.biz.KaraokePauseSongRsp;
import net.ihago.ktv.api.biz.KaraokeSongInfo;
import net.ihago.ktv.api.biz.KaraokeSongSetTopRsp;
import net.ihago.ktv.api.biz.KaraokeStartSingRsp;
import net.ihago.ktv.api.biz.KaraokeTerminateSongRsp;
import net.ihago.ktv.api.biz.PauseSongNotify;
import net.ihago.ktv.api.biz.ReportAudioPositionRsp;
import net.ihago.ktv.api.biz.SongSetTopNotify;
import net.ihago.ktv.api.biz.StartSingNotify;
import net.ihago.ktv.api.biz.TerminateSongNotify;

public class KTVRoomServices
extends KTVBaseModel
implements IKTVRoomService,
ISeatUpdateListener,
IRoleService.IMemberOrMasterChangeListener {
    public static final int TOTAL_LIST_COUNT_LIMIT = 50;
    public static final int MY_LIST_COUNT_LIMIT = 25;
    public static final String kvo_mKTVRoomSongInfoList = "mKTVRoomSongInfoList";
    @KvoFieldAnnotation(name="mKTVRoomSongInfoList")
    private List<KTVRoomSongInfo> mKTVRoomSongInfoList = new ArrayList<KTVRoomSongInfo>();
    private KTVRoomData mKTVRoomData = new KTVRoomData();
    private Set<String> mMyResouceIds = new CopyOnWriteArraySet<String>();
    private CopyOnWriteArrayList<KTVRoomSongInfo> mMySongList = new CopyOnWriteArrayList();
    private int mCurrentVersion;
    private final CopyOnWriteArraySet<IKTVNotifyHandler<KTVRoomSongInfo>> mAddSongNotifySet = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<IKTVNotifyHandler<List<KTVRoomOperateInfo>>> mDelSongNotifySet = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<IKTVNotifyHandler<KTVRoomOperateInfo>> mTerminateSongNotifySet = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<IKTVNotifyHandler<KTVRoomOperateInfo>> mSetTopSongNotifySet = new CopyOnWriteArraySet();
    private String mRoomId = "";
    private boolean hasRetryedTerminateSong = false;
    private boolean hasHeadset = false;
    private final KvoBinder mBinder = new KvoBinder((Object)this);
    private IProtoNotify<BizPush> mKTVNotify = new IProtoNotify<BizPush>(){

        public String serviceName() {
            return "net.ihago.ktv.api.biz";
        }

        public void onNotify(@NonNull BizPush notify) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVRoomService", (String)"received ktv notify value: %d", (Object[])new Object[]{notify.getUriValue()});
            }
            KTVRoomServices.this.hasRetryedTerminateSong = false;
            switch (notify.uri) {
                case kUriNotUse: {
                    break;
                }
                case kUriAddSongNotify: {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"KTVAddSong", (String)"receive add song notify current time: %s", (Object[])new Object[]{System.currentTimeMillis()});
                    }
                    KTVRoomServices.this.handleAddNotify(notify.add_song_notify);
                    break;
                }
                case kUriSongSetTopNotify: {
                    KTVRoomServices.this.handleSetTopNotify(notify.song_set_top_notify);
                    break;
                }
                case kUriDelSongNotify: {
                    KTVRoomServices.this.handleDelNotify(notify.del_song_notify);
                    break;
                }
                case kUriStartSingNotify: {
                    KTVRoomServices.this.handleStartNotify(notify.start_sing_notify);
                    break;
                }
                case kUriPauseNotify: {
                    KTVRoomServices.this.handlePauseNotify(notify.pause_song_notify);
                    break;
                }
                case kUriTerminateSongNotify: {
                    KTVRoomServices.this.handleTerminateNotify(notify.terminate_song_notify);
                    break;
                }
                case kUriAudioPositionNotify: {
                    break;
                }
                case KUriBroadcastTransmissionNotify: {
                    break;
                }
            }
        }
    };

    public KTVRoomServices(IKTVManager iktvManager) {
        super(iktvManager);
    }

    @Override
    public void onCreate(KTVBaseContext context) {
        super.onCreate(context);
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVRoomService", (String)"KTVRoomServices onCreate", (Object[])new Object[0]);
        }
        this.mRoomId = context.getRoomData().getRoomId();
        this.registerKTVNotify();
        this.fetchKTVRoomOrderedSongList(null);
        this.bindData();
        KTVEventReportUtil.setHiidoEventData(this.mRoomId);
    }

    public void bindData() {
        this.mBinder.clearAllKvoConnections();
        this.mBinder.singleBindSourceTo((KvoSource)this.mKTVRoomData.getCurrentSongInfo());
        this.getContext().getRoomContext().getChannel().getSeatService().addSeatUpdateListener((ISeatUpdateListener)this);
        this.getContext().getRoomContext().getChannel().getRoleService().addDataListener((IRoleService.IMemberOrMasterChangeListener)this);
    }

    @KvoMethodAnnotation(sourceClass=KTVRoomSongInfo.class, name="uid")
    public void onCurrentSingerChanged(KvoEventIntent event) {
        boolean isInSeat = this.getContext().getRoomContext().getChannel().getSeatService().isInSeat(AccountUtil.getUid());
        this.mKTVRoomData.isInSeat(isInSeat);
        if (((KTVRoomSongInfo)event.source()).isSinger()) {
            this.mKTVRoomData.setSelectSongPolicy(2);
            this.mKTVRoomData.getRoleInfo().setSelectSongPolicy(1);
            this.mKTVRoomData.getRoleInfo().setPauseSongPolicy(1);
            this.mKTVRoomData.getRoleInfo().setCutSongPolicy(1);
        } else {
            boolean isInFirstSeat = this.getContext().getRoomContext().getChannel().getSeatService().isInFirstSeat(AccountUtil.getUid());
            if (isInFirstSeat) {
                this.mKTVRoomData.getRoleInfo().setPauseSongPolicy(1);
                this.mKTVRoomData.getRoleInfo().setCutSongPolicy(1);
            } else {
                this.mKTVRoomData.getRoleInfo().setPauseSongPolicy(0);
                this.mKTVRoomData.getRoleInfo().setCutSongPolicy(0);
            }
            int policy = 2;
            if (!isInSeat) {
                policy = 1;
            }
            this.mKTVRoomData.setSelectSongPolicy(policy);
        }
        int role = this.getContext().getRoomContext().getChannel().getRoleService().getRoleCache(AccountUtil.getUid());
        this.mKTVRoomData.isOwnerOrMaster(role, this.getContext().getRoomContext().getChannel().getRoleService().isMeAnchor());
    }

    public void onSeatUpdate(List<SeatUser> seatUserList) {
        boolean isInSeat = this.getContext().getRoomContext().getChannel().getSeatService().isInSeat(AccountUtil.getUid());
        this.mKTVRoomData.isInSeat(isInSeat);
        if (isInSeat) {
            this.mKTVRoomData.setSelectSongPolicy(2);
            boolean inFirstSeat = this.getContext().getRoomContext().getChannel().getSeatService().isInFirstSeat(AccountUtil.getUid());
            boolean isSinger = this.mKTVRoomData.getCurrentSongInfo().isSinger();
            if (inFirstSeat || isSinger) {
                this.mKTVRoomData.enablePauseOrCutSong(true);
            } else {
                this.mKTVRoomData.enablePauseOrCutSong(false);
            }
        } else {
            this.mKTVRoomData.setSelectSongPolicy(1);
            this.mKTVRoomData.enablePauseOrCutSong(false);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVRoomService", (String)"KTVRoomServices onDestroy", (Object[])new Object[0]);
        }
        this.mRoomId = "";
        this.hasRetryedTerminateSong = false;
        this.mCurrentVersion = 0;
        this.mMyResouceIds.clear();
        this.mMySongList.clear();
        this.unRegisterKTVNotify();
        this.mBinder.clearAllKvoConnections();
        this.getContext().getRoomContext().getChannel().getSeatService().removeSeatUpdateListener((ISeatUpdateListener)this);
        KTVEventReportUtil.clearHiidoEventData();
    }

    public boolean isMySong(String resourceId) {
        for (KTVRoomSongInfo songInfo : this.mMySongList) {
            if (songInfo == null || !StringUtils.equal((String)songInfo.getResourceId(), (String)resourceId)) continue;
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVList", (String)"is my request song : %s", (Object[])new Object[]{resourceId});
            }
            return true;
        }
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVList", (String)"is not my request song : %s", (Object[])new Object[]{resourceId});
        }
        return false;
    }

    public boolean canAddSong() {
        if (this.mKTVRoomSongInfoList.size() >= 50 || this.mMySongList.size() >= 25) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVList", (String)"reach limit, cannot request song", (Object[])new Object[0]);
            }
            return false;
        }
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVList", (String)"not reach limit, can request song", (Object[])new Object[0]);
        }
        return true;
    }

    public List<KTVRoomSongInfo> getKTVRoomSongInfoList() {
        return this.mKTVRoomSongInfoList;
    }

    public KTVRoomData getCurrentKTVRoomData() {
        return this.mKTVRoomData;
    }

    public void reportAudioPosition(@NonNull KTVAudioPosition audioPosition, @Nullable KTVCommonCallback<KTVAudioPosition> callback) {
        KTVProtoService.getInstance().reportAudioPosition(this.mRoomId, audioPosition, new IKTVProtoCallback<ReportAudioPositionRsp>(){

            @Override
            public void onSuccess(@NonNull ReportAudioPositionRsp data) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVRoomService", (String)"reportAudioPosition onSelected", (Object[])new Object[0]);
                }
            }

            @Override
            public void onError(int code, String errorMessage) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVRoomService", (String)"reportAudioPosition onError code: %d,error: %s", (Object[])new Object[]{code, errorMessage});
                }
            }
        });
    }

    public GiftItemInfo getGiftInfo() {
        KtvGiftConfig ktvGiftConfig;
        AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.KTV_GIFT_CONFIG);
        if (configData instanceof KtvGiftConfig && (ktvGiftConfig = (KtvGiftConfig)configData).getData() != null && ktvGiftConfig.getData().getSwitch() && ktvGiftConfig.getData().getList().size() > 0) {
            int propsId = ((KtvGiftConfig.GiftItem)ktvGiftConfig.getData().getList().get(0)).getPropsId();
            GiftItemInfo giftItemInfo = ((IGiftService)ServiceManagerProxy.getService(IGiftService.class)).getGift(GiftChannel.KTV_ROOM_USED_CHANNEL.getChannel(), propsId);
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVRoomService", (String)"getGiftInfo: %s", (Object[])new Object[]{giftItemInfo});
            }
            return giftItemInfo;
        }
        return null;
    }

    private void updateMySongList() {
        this.mMyResouceIds.clear();
        this.mMySongList.clear();
        for (KTVRoomSongInfo songInfo : this.mKTVRoomSongInfoList) {
            if (songInfo == null || songInfo.getUid() != AccountUtil.getUid() || this.mMyResouceIds.contains(songInfo.getResourceId())) continue;
            this.mMySongList.add(songInfo);
            this.mMyResouceIds.add(songInfo.getResourceId());
        }
    }

    public CopyOnWriteArrayList<KTVRoomSongInfo> getMySongList() {
        return this.mMySongList;
    }

    private void setKTVRoomSongInfoListInner(List<KTVRoomSongInfo> ktvRoomSongInfoList) {
        this.handleRemoveSong(ktvRoomSongInfoList);
        this.setKTVRoomSongInfoList(ktvRoomSongInfoList);
    }

    private void setKTVRoomSongInfoList(List<KTVRoomSongInfo> ktvRoomSongInfoList) {
        if (!FP.empty(ktvRoomSongInfoList)) {
            this.mKTVRoomSongInfoList = new ArrayList<KTVRoomSongInfo>(ktvRoomSongInfoList);
            this.setKTVRoomData(ktvRoomSongInfoList.get(0), this.mRoomId);
        } else {
            this.mKTVRoomSongInfoList = new ArrayList<KTVRoomSongInfo>();
            this.setKTVRoomData(null, this.mRoomId);
        }
        this.updateMySongList();
        this.notifyKvoEvent(kvo_mKTVRoomSongInfoList);
    }

    private void handleRemoveSong(List<KTVRoomSongInfo> newList) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVRoomService", (String)"handleRemoveSong, newList size =  %s", (Object[])new Object[]{newList == null ? 0 : newList.size()});
        }
        if (newList == null) {
            return;
        }
        for (KTVRoomSongInfo songInfo : this.mKTVRoomSongInfoList) {
            if (songInfo == null) continue;
            boolean isExist = false;
            for (KTVRoomSongInfo item : newList) {
                if (item == null || !StringUtils.equal((String)songInfo.getSongId(), (String)item.getSongId())) continue;
                isExist = true;
                break;
            }
            if (isExist || songInfo.getUid() != AccountUtil.getUid()) continue;
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVRoomService", (String)"handleRemoveSong, songInfo =  %s", (Object[])new Object[]{songInfo.toString()});
            }
            this.getKtvManager().getKTVMusicListProvider().setMusicRequestStatus(songInfo.getResourceId(), false);
        }
    }

    private void setKTVRoomData(KTVRoomSongInfo songInfo, String roomId) {
        KTVRoomSongInfo currentSongInfo = this.mKTVRoomData.getCurrentSongInfo();
        if (currentSongInfo != null && songInfo != null && !StringUtils.equal((String)currentSongInfo.getSongId(), (String)songInfo.getSongId()) && StringUtils.isNotEmpty((String)currentSongInfo.getSongId())) {
            currentSongInfo.setStatus(3);
        }
        this.mKTVRoomData.setKTVRoomData(songInfo, roomId);
    }

    private boolean needSyncStatus(KTVRoomSongInfo songInfo) {
        if (songInfo == null) {
            return false;
        }
        KTVRoomSongInfo currentSongInfo = this.mKTVRoomData.getCurrentSongInfo();
        if (currentSongInfo == null) {
            return false;
        }
        if (songInfo.isSinger() && StringUtils.equal((String)currentSongInfo.getSongId(), (String)songInfo.getSongId()) && currentSongInfo.getStatus() != songInfo.getStatus()) {
            if (currentSongInfo.getStatus() == 1) {
                this.startSong(currentSongInfo.getSongId(), null);
            } else if (currentSongInfo.getStatus() == 2) {
                this.pauseSong(currentSongInfo.getSongId(), null);
            }
            return true;
        }
        return false;
    }

    public void fetchKTVRoomOrderedSongList(@Nullable KTVCommonCallback<KTVRoomOrderedListInfo> callback) {
        this.fetchKTVRoomOrderedSongList(this.mRoomId, 0, -1, callback);
    }

    public void fetchKTVRoomOrderedSongList(@NonNull String roomId, int offset, int queryCount, final @Nullable KTVCommonCallback<KTVRoomOrderedListInfo> callback) {
        KTVProtoService.getInstance().fetchKTVRoomOrderedSongList(roomId, offset, queryCount, new IKTVProtoCallback<GetRoomKaraokeInfoRsp>(){

            @Override
            public void onSuccess(@NonNull GetRoomKaraokeInfoRsp data) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVRoomService", (String)"fetchKTVRoomOrderedSongList onSelected,total song list size: %d", (Object[])new Object[]{data.total_songs_count});
                }
                KTVRoomOrderedListInfo ktvRoomOrderedListInfo = KTVRoomOrderedListInfo.convertTo((GetRoomKaraokeInfoRsp)data);
                KTVRoomServices.this.mCurrentVersion = ktvRoomOrderedListInfo.getVersion();
                KTVRoomServices.this.setKTVRoomSongInfoListInner(ktvRoomOrderedListInfo.getSongInfoList());
                if (callback != null) {
                    callback.onSuccess((Object)ktvRoomOrderedListInfo);
                }
            }

            @Override
            public void onError(int code, String errorMessage) {
                FeatureLog.e((String)"FTKTVRoomService", (String)"fetchKTVRoomOrderedSongList onError code: %d,error: %s", (Object[])new Object[]{code, errorMessage});
                if (callback != null) {
                    callback.onFail(code, errorMessage);
                }
            }
        });
    }

    public void addSong(@NonNull String songId, final @Nullable KTVCommonCallback<Boolean> callback) {
        KTVProtoService.getInstance().karaokeAddSong(this.mRoomId, songId, new IKTVProtoCallback<KaraokeAddSongRsp>(){

            @Override
            public void onSuccess(@NonNull KaraokeAddSongRsp data) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVRoomService", (String)"addSong onSelected", (Object[])new Object[0]);
                }
                if (callback != null) {
                    callback.onSuccess((Object)true);
                }
            }

            @Override
            public void onError(int code, String errorMessage) {
                FeatureLog.e((String)"FTKTVRoomService", (String)"addSong onError code: %d,error: %s", (Object[])new Object[]{code, errorMessage});
                if (callback != null) {
                    callback.onFail(code, errorMessage);
                }
            }
        });
    }

    public void setSongTop(@NonNull String songId, final @Nullable KTVCommonCallback<Boolean> callback) {
        KTVProtoService.getInstance().karaokeSongSetTop(this.mRoomId, songId, new IKTVProtoCallback<KaraokeSongSetTopRsp>(){

            @Override
            public void onSuccess(@NonNull KaraokeSongSetTopRsp data) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVRoomService", (String)"set song top onSelected", (Object[])new Object[0]);
                }
                if (callback != null) {
                    callback.onSuccess((Object)true);
                }
            }

            @Override
            public void onError(int code, String errorMessage) {
                FeatureLog.e((String)"FTKTVRoomService", (String)"setSongTop onError: %s", (Object[])new Object[]{errorMessage});
                if (callback != null) {
                    callback.onFail(code, errorMessage);
                }
            }
        });
    }

    public void startSong(@NonNull String songId, final @Nullable KTVCommonCallback<Boolean> callback) {
        KTVProtoService.getInstance().karaokeStartSing(this.mRoomId, songId, new IKTVProtoCallback<KaraokeStartSingRsp>(){

            @Override
            public void onSuccess(@NonNull KaraokeStartSingRsp data) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVRoomService", (String)"start song onSelected", (Object[])new Object[0]);
                }
                if (null != ServiceManagerProxy.getServiceManager() && null != ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)) {
                    int result;
                    ReverbExParameter parameter;
                    if (0 != data.sound_parameters.size()) {
                        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setEnableReverb(true);
                        parameter = new ReverbExParameter();
                        Map map = data.sound_parameters;
                        if (map.containsKey("reverber-ance")) {
                            parameter.mReverberance = ((Float)map.get("reverber-ance")).floatValue();
                        }
                        if (map.containsKey("room-size")) {
                            parameter.mRoomSize = ((Float)map.get("room-size")).floatValue();
                        }
                        if (map.containsKey("tonelow")) {
                            parameter.mToneLow = ((Float)map.get("tonelow")).floatValue();
                        }
                        if (map.containsKey("drygain")) {
                            parameter.mDryGain = ((Float)map.get("drygain")).floatValue();
                        }
                        if (map.containsKey("hfdamp-ing")) {
                            parameter.mHfDamping = ((Float)map.get("hfdamp-ing")).floatValue();
                        }
                        if (map.containsKey("tonehigh")) {
                            parameter.mToneHigh = ((Float)map.get("tonehigh")).floatValue();
                        }
                        if (map.containsKey("wetgain")) {
                            parameter.mWetGain = ((Float)map.get("wetgain")).floatValue();
                        }
                        if (map.containsKey("predelay")) {
                            parameter.mPreDelay = ((Float)map.get("predelay")).floatValue();
                        }
                        if (map.containsKey("stere-owidth")) {
                            parameter.mStereoWidth = ((Float)map.get("stere-owidth")).floatValue();
                        }
                        if (0 == (result = ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setReverbExParameter(parameter))) {
                            if (FeatureLog.isLogLevelBlowInfo()) {
                                FeatureLog.i((String)"FTKTVBase", (String)"\u8bbe\u7f6e\u6df7\u54cd\u6210\u529f: %s", (Object[])new Object[]{parameter.toString()});
                            }
                        } else {
                            FeatureLog.e((String)"FTKTVBase", (String)"\u8bbe\u7f6e\u6df7\u54cd\u5931\u8d25: result=%s", (Object[])new Object[]{result});
                        }
                    } else {
                        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setEnableReverb(false);
                    }
                    if (0 != data.equalizer.size()) {
                        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setEnableEqualizer(true);
                        int[] gains = new int[data.equalizer.size()];
                        for (int i = 0; i < data.equalizer.size(); ++i) {
                            gains[i] = (Integer)data.equalizer.get(i);
                        }
                        int result2 = ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setEqGains(gains);
                        if (0 == result2) {
                            if (FeatureLog.isLogLevelBlowInfo()) {
                                FeatureLog.i((String)"FTKTVBase", (String)"\u8bbe\u7f6e\u5747\u8861\u5668\u6210\u529f: %s", (Object[])new Object[]{Arrays.toString(gains)});
                            }
                        } else {
                            FeatureLog.e((String)"FTKTVBase", (String)"\u8bbe\u7f6e\u5747\u8861\u5668\u5931\u8d25: result=%s", (Object[])new Object[]{result2});
                        }
                    } else {
                        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setEnableEqualizer(false);
                    }
                    if (0 != data.compressor.size()) {
                        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setEnableCompressor(true);
                        parameter = new CompressorParam();
                        Map map = data.compressor;
                        if (map.containsKey("threshold")) {
                            parameter.mThreshold = (Integer)map.get("threshold");
                        }
                        if (map.containsKey("makeupGain")) {
                            parameter.mMakeupGain = (Integer)map.get("makeupGain");
                        }
                        if (map.containsKey("ratio")) {
                            parameter.mRatio = (Integer)map.get("ratio");
                        }
                        if (map.containsKey("knee")) {
                            parameter.mKnee = (Integer)map.get("knee");
                        }
                        if (map.containsKey("releaseTime")) {
                            parameter.mReleaseTime = (Integer)map.get("releaseTime");
                        }
                        if (map.containsKey("attackTime")) {
                            parameter.mAttackTime = (Integer)map.get("attackTime");
                        }
                        if (0 == (result = ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setCompressorParam((CompressorParam)parameter))) {
                            if (FeatureLog.isLogLevelBlowInfo()) {
                                FeatureLog.i((String)"FTKTVBase", (String)"\u8bbe\u7f6e\u538b\u7f29\u5668\u6210\u529f: %s", (Object[])new Object[]{parameter.toString()});
                            }
                        } else {
                            FeatureLog.e((String)"FTKTVBase", (String)"\u8bbe\u7f6e\u538b\u7f29\u5668\u5931\u8d25: result=%s", (Object[])new Object[]{result});
                        }
                    } else {
                        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setEnableCompressor(false);
                    }
                    if (data.limiter.size() == 9) {
                        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setEnableLimiter(true);
                        parameter = new LimterParam();
                        List params = data.limiter;
                        parameter.fCeiling = ((Float)params.get(0)).floatValue();
                        parameter.fThreshold = ((Float)params.get(1)).floatValue();
                        parameter.fPreGain = ((Float)params.get(2)).floatValue();
                        parameter.fRelease = ((Float)params.get(3)).floatValue();
                        parameter.fAttack = ((Float)params.get(4)).floatValue();
                        parameter.fLookahead = ((Float)params.get(5)).floatValue();
                        parameter.fLookaheadRatio = ((Float)params.get(6)).floatValue();
                        parameter.fRMS = ((Float)params.get(7)).floatValue();
                        parameter.fStLink = ((Float)params.get(8)).floatValue();
                        result = ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setLimiterParam((LimterParam)parameter);
                        if (0 == result) {
                            if (FeatureLog.isLogLevelBlowInfo()) {
                                FeatureLog.i((String)"FTKTVBase", (String)"\u8bbe\u7f6e\u538b\u9650\u5668\u6210\u529f: %s", (Object[])new Object[]{parameter.toString()});
                            }
                        } else {
                            FeatureLog.e((String)"FTKTVBase", (String)"\u8bbe\u7f6e\u538b\u9650\u5668\u5931\u8d25: result=%s", (Object[])new Object[]{result});
                        }
                    } else {
                        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setEnableLimiter(false);
                    }
                }
                if (callback != null) {
                    callback.onSuccess((Object)true);
                }
            }

            @Override
            public void onError(int code, String errorMessage) {
                FeatureLog.e((String)"FTKTVRoomService", (String)"start song onError: %s", (Object[])new Object[]{errorMessage});
                if (callback != null) {
                    callback.onFail(code, errorMessage);
                }
            }
        });
    }

    public void pauseSong(@NonNull String songId, final @Nullable KTVCommonCallback<Boolean> callback) {
        KTVProtoService.getInstance().karaokePauseSong(this.mRoomId, songId, new IKTVProtoCallback<KaraokePauseSongRsp>(){

            @Override
            public void onSuccess(@NonNull KaraokePauseSongRsp data) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVRoomService", (String)"pause song onSelected", (Object[])new Object[0]);
                }
                if (callback != null) {
                    callback.onSuccess((Object)true);
                }
            }

            @Override
            public void onError(int code, String errorMessage) {
                FeatureLog.e((String)"FTKTVRoomService", (String)"pauseSong onError: %s", (Object[])new Object[]{errorMessage});
                if (callback != null) {
                    callback.onFail(code, errorMessage);
                }
            }
        });
    }

    public void deleteSong(@NonNull String songId, final @Nullable KTVCommonCallback<Boolean> callback) {
        KTVProtoService.getInstance().karaokeDeleteSong(this.mRoomId, songId, new IKTVProtoCallback<KaraokeDelSongRsp>(){

            @Override
            public void onSuccess(@NonNull KaraokeDelSongRsp data) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVRoomService", (String)"delete song onSelected", (Object[])new Object[0]);
                }
                if (callback != null) {
                    callback.onSuccess((Object)true);
                }
            }

            @Override
            public void onError(int code, String errorMessage) {
                FeatureLog.e((String)"FTKTVRoomService", (String)"deleteSong onError: %s", (Object[])new Object[]{errorMessage});
                if (callback != null) {
                    callback.onFail(code, errorMessage);
                }
            }
        });
    }

    public void terminateSong(final @NonNull String songId, int flag, final @Nullable KTVCommonCallback<Boolean> callback) {
        if (this.mRoomId.isEmpty() && this.mContext != null && this.mContext.getRoomData() != null) {
            this.mRoomId = this.mContext.getRoomData().getRoomId();
        }
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVRoomService", (String)"terminateSong roomId:%s,songId:%s,flag:%d", (Object[])new Object[]{this.mRoomId, songId, flag});
        }
        KTVProtoService.getInstance().karaokeTerminateSong(this.mRoomId, songId, flag, new IKTVProtoCallback<KaraokeTerminateSongRsp>(){

            @Override
            public void onSuccess(@NonNull KaraokeTerminateSongRsp data) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVRoomService", (String)"terminate song onSelected", (Object[])new Object[0]);
                }
                if (callback != null) {
                    callback.onSuccess((Object)true);
                }
            }

            @Override
            public void onError(int code, String errorMessage) {
                FeatureLog.e((String)"FTKTVRoomService", (String)"terminateSong onError: %s", (Object[])new Object[]{errorMessage});
                if (callback != null) {
                    callback.onFail(code, errorMessage);
                }
                if (!KTVRoomServices.this.hasRetryedTerminateSong) {
                    YYTaskExecutor.postToMainThread(() -> {
                        if (KTVRoomServices.this.getCurrentKTVRoomData() != null && KTVRoomServices.this.getCurrentKTVRoomData().getCurrentSongInfo() != null && songId.equals(KTVRoomServices.this.getCurrentKTVRoomData().getCurrentSongInfo().getSongId())) {
                            KTVRoomServices.this.terminateSong(songId, 1, null);
                            KTVRoomServices.this.hasRetryedTerminateSong = true;
                        }
                    }, (long)1000L);
                }
            }
        });
    }

    public void registerAddSongNotify(IKTVNotifyHandler<KTVRoomSongInfo> notify) {
        this.mAddSongNotifySet.add(notify);
    }

    public void unRegisterAddSongNotify(IKTVNotifyHandler<KTVRoomSongInfo> notify) {
        this.mAddSongNotifySet.remove(notify);
    }

    public void registerDelSongNotify(IKTVNotifyHandler<List<KTVRoomOperateInfo>> notify) {
        this.mDelSongNotifySet.add(notify);
    }

    public void unRegisterDelSongNotify(IKTVNotifyHandler<List<KTVRoomOperateInfo>> notify) {
        this.mDelSongNotifySet.remove(notify);
    }

    public void registerTerminateSongNotify(IKTVNotifyHandler<KTVRoomOperateInfo> notify) {
        this.mTerminateSongNotifySet.add(notify);
    }

    public void unRegisterTerminateSongNotify(IKTVNotifyHandler<KTVRoomOperateInfo> notify) {
        this.mTerminateSongNotifySet.remove(notify);
    }

    public void registerSetTopSongNotify(IKTVNotifyHandler<KTVRoomOperateInfo> notify) {
        this.mSetTopSongNotifySet.add(notify);
    }

    public void unRegisterSetTopSongNotify(IKTVNotifyHandler<KTVRoomOperateInfo> notify) {
        this.mSetTopSongNotifySet.remove(notify);
    }

    private void registerKTVNotify() {
        ProtoManager.getInstance().registerNotify(this.mKTVNotify);
    }

    private void unRegisterKTVNotify() {
        ProtoManager.getInstance().unregisterNotify(this.mKTVNotify);
    }

    private boolean shouldFetch(int version) {
        return version - this.mCurrentVersion != 1;
    }

    private void handleAddNotify(@NonNull AddSongNotify notify) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVRoomService", (String)"add song notify version: %d", (Object[])new Object[]{notify.version});
        }
        KaraokeSongInfo song = notify.song;
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVRoomService", (String)"add song notify song id: %s", (Object[])new Object[]{song == null ? "unKnown" : song.id});
        }
        KTVRoomSongInfo ktvRoomSongInfo = null;
        if (song != null) {
            ktvRoomSongInfo = KTVRoomSongInfo.convertTo((KaraokeSongInfo)song);
        }
        if (this.shouldFetch(notify.version)) {
            this.fetchKTVRoomOrderedSongList(null);
        } else if (ktvRoomSongInfo != null) {
            ArrayList<KTVRoomSongInfo> tempList = new ArrayList<KTVRoomSongInfo>(this.mKTVRoomSongInfoList);
            tempList.add(ktvRoomSongInfo);
            this.setKTVRoomSongInfoListInner(tempList);
        }
        if (ktvRoomSongInfo != null) {
            for (IKTVNotifyHandler<KTVRoomSongInfo> handler : this.mAddSongNotifySet) {
                handler.onHandleNotify((Object)ktvRoomSongInfo);
            }
        }
        this.mCurrentVersion = notify.version;
    }

    private void moveToTop(KTVRoomSongInfo songInfo) {
        KTVRoomSongInfo firstSong;
        ArrayList<KTVRoomSongInfo> tempList = new ArrayList<KTVRoomSongInfo>(this.mKTVRoomSongInfoList.size());
        for (KTVRoomSongInfo roomSongInfo : this.mKTVRoomSongInfoList) {
            if (roomSongInfo == null || StringUtils.equal((String)roomSongInfo.getSongId(), (String)songInfo.getSongId())) continue;
            tempList.add(roomSongInfo);
        }
        if (!FP.empty(tempList) && (firstSong = (KTVRoomSongInfo)tempList.get(0)) != null) {
            tempList.add(1, songInfo);
        }
        this.setKTVRoomSongInfoListInner(tempList);
    }

    private void handleSetTopNotify(@NonNull SongSetTopNotify notify) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVRoomService", (String)"set song top notify version: %d", (Object[])new Object[]{notify.version});
        }
        KTVRoomOperateInfo ktvRoomOperateInfo = null;
        if (this.shouldFetch(notify.version)) {
            this.fetchKTVRoomOrderedSongList(null);
        } else {
            KaraokeSongInfo song = notify.song;
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVRoomService", (String)"set top song notify song id: %s", (Object[])new Object[]{song == null ? "unKnown" : song.id});
            }
            if (song != null) {
                KTVRoomSongInfo ktvRoomSongInfo = KTVRoomSongInfo.convertTo((KaraokeSongInfo)song);
                this.moveToTop(ktvRoomSongInfo);
                ktvRoomOperateInfo = new KTVRoomOperateInfo.Builder().ktvRoomSongInfo(ktvRoomSongInfo).operateUid(notify.opt_uid.longValue()).build();
            }
        }
        if (ktvRoomOperateInfo != null) {
            for (IKTVNotifyHandler<KTVRoomOperateInfo> handler : this.mSetTopSongNotifySet) {
                if (handler == null) continue;
                handler.onHandleNotify(ktvRoomOperateInfo);
            }
        }
        this.mCurrentVersion = notify.version;
    }

    private void handleDelNotify(@NonNull DelSongNotify notify) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVRoomService", (String)"delete song notify version: %d", (Object[])new Object[]{notify.version});
        }
        ArrayList deletedSongList = new ArrayList(notify.song);
        ArrayList<KTVRoomOperateInfo> deletedKTVRoomSongList = new ArrayList<KTVRoomOperateInfo>(deletedSongList.size());
        if (this.shouldFetch(notify.version)) {
            this.fetchKTVRoomOrderedSongList(null);
        } else if (!FP.empty(deletedSongList)) {
            ArrayList<KTVRoomSongInfo> tempList = new ArrayList<KTVRoomSongInfo>(this.mKTVRoomSongInfoList);
            int size = this.mKTVRoomSongInfoList.size();
            for (int i = 0; i < size; ++i) {
                KTVRoomSongInfo songInfo = this.mKTVRoomSongInfoList.get(i);
                if (songInfo == null) continue;
                int count = deletedSongList.size();
                for (int j = 0; j < count; ++j) {
                    KaraokeSongInfo deletedSongInfo = (KaraokeSongInfo)deletedSongList.get(j);
                    if (deletedSongInfo == null || !StringUtils.equal((String)songInfo.getSongId(), (String)deletedSongInfo.id)) continue;
                    deletedKTVRoomSongList.add(new KTVRoomOperateInfo.Builder().ktvRoomSongInfo(songInfo).operateUid(notify.opt_uid.longValue()).operateFlag(notify.del_flag.intValue()).build());
                    tempList.remove(songInfo);
                }
            }
            this.setKTVRoomSongInfoListInner(tempList);
        }
        for (IKTVNotifyHandler<List<KTVRoomOperateInfo>> handler : this.mDelSongNotifySet) {
            handler.onHandleNotify(deletedKTVRoomSongList);
        }
        this.mCurrentVersion = notify.version;
    }

    private void handleNotify(KaraokeSongInfo song) {
        if (song == null) {
            return;
        }
        KTVRoomSongInfo ktvRoomSongInfo = KTVRoomSongInfo.convertTo((KaraokeSongInfo)song);
        ArrayList<KTVRoomSongInfo> tempList = new ArrayList<KTVRoomSongInfo>(this.mKTVRoomSongInfoList);
        int size = this.mKTVRoomSongInfoList.size();
        for (int i = 0; i < size; ++i) {
            KTVRoomSongInfo info = this.mKTVRoomSongInfoList.get(i);
            if (info == null || !StringUtils.equal((String)info.getSongId(), (String)ktvRoomSongInfo.getSongId())) continue;
            tempList.remove(i);
            tempList.add(i, ktvRoomSongInfo);
            break;
        }
        this.setKTVRoomSongInfoListInner(tempList);
    }

    private void handleStartNotify(StartSingNotify notify) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVRoomService", (String)"start song notify version: %d", (Object[])new Object[]{notify.version});
        }
        if (this.shouldFetch(notify.version)) {
            this.fetchKTVRoomOrderedSongList(null);
        } else {
            KaraokeSongInfo song = notify.song;
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVRoomService", (String)"start song notify song id: %s", (Object[])new Object[]{song == null ? "unKnown" : song.id});
            }
            this.handleNotify(song);
        }
        this.mCurrentVersion = notify.version;
    }

    private void handlePauseNotify(@NonNull PauseSongNotify notify) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVRoomService", (String)"pause song notify version: %d", (Object[])new Object[]{notify.version});
        }
        if (this.shouldFetch(notify.version)) {
            this.fetchKTVRoomOrderedSongList(null);
        } else {
            KaraokeSongInfo song = notify.song;
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVRoomService", (String)"pause song notify song id: %s", (Object[])new Object[]{song == null ? "unKnown" : song.id});
            }
            this.handleNotify(song);
        }
        this.mCurrentVersion = notify.version;
    }

    private void handleTerminateNotify(@NonNull TerminateSongNotify notify) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVRoomService", (String)"terminate song notify version: %d, flag:%s, optUid:%s", (Object[])new Object[]{notify.version, notify.flag, notify.opt_uid});
        }
        KaraokeSongInfo song = notify.terminate_song;
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVRoomService", (String)"terminate song notify song id: %s", (Object[])new Object[]{song == null ? "unKnown" : song.id});
        }
        KaraokeSongInfo nextSong = notify.next_song;
        KTVRoomSongInfo songInfo = KTVRoomSongInfo.convertTo((KaraokeSongInfo)song);
        KTVRoomSongInfo nextSongInfo = KTVRoomSongInfo.convertTo((KaraokeSongInfo)nextSong);
        if (this.shouldFetch(notify.version)) {
            this.fetchKTVRoomOrderedSongList(null);
        } else {
            ArrayList<KTVRoomSongInfo> tempList = new ArrayList<KTVRoomSongInfo>(this.mKTVRoomSongInfoList);
            int size = this.mKTVRoomSongInfoList.size();
            for (int i = 0; i < size; ++i) {
                KTVRoomSongInfo info = this.mKTVRoomSongInfoList.get(i);
                if (info == null || !StringUtils.equal((String)info.getSongId(), (String)songInfo.getSongId())) continue;
                tempList.remove(i);
                break;
            }
            this.setKTVRoomSongInfoListInner(tempList);
        }
        KTVRoomOperateInfo operateInfo = new KTVRoomOperateInfo.Builder().ktvRoomSongInfo(songInfo).operateUid(notify.opt_uid.longValue()).operateFlag(notify.flag.intValue()).build();
        for (IKTVNotifyHandler<KTVRoomOperateInfo> handler : this.mTerminateSongNotifySet) {
            handler.onHandleNotify((Object)operateInfo);
        }
        this.mCurrentVersion = notify.version;
    }

    @Override
    public void onNetChanged(int status) {
        if (status == 1 || status == 3) {
            this.fetchKTVRoomOrderedSongList(null);
        }
    }

    public void setHeadset(boolean plug) {
        this.hasHeadset = plug;
    }

    public boolean hasHeadset() {
        return this.hasHeadset;
    }

    public void onRoleChanged(String channelId, long uid, int roleType) {
        if (!StringUtils.equal((String)this.mRoomId, (String)channelId) || uid != AccountUtil.getUid()) {
            return;
        }
        this.mKTVRoomData.isOwnerOrMaster(roleType, this.getContext().getRoomContext().getChannel().getRoleService().isMeAnchor());
    }
}

