/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.live;

import android.content.Context;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.live.LiveCallback;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IMediaService;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.cbase.module.ktv.live.IKtvLiveOperator;
import com.yy.hiyo.channel.cbase.module.ktv.live.IKtvPlayContract;
import com.yy.hiyo.channel.cbase.utils.perf.ChannelPathLog;
import com.yy.hiyo.channel.cbase.utils.preference.RoomSetting;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.live.KtvPlayPresenter;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b*\u0001\u0012\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\b\u0010\u001e\u001a\u00020\u001cH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0$H\u0016J\b\u0010%\u001a\u00020\fH\u0016J\b\u0010&\u001a\u00020\fH\u0002J$\u0010'\u001a\u00020\u001c2\b\u0010\u0005\u001a\u0004\u0018\u00010(2\b\u0010)\u001a\u0004\u0018\u00010(2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u001cH\u0016J\b\u0010-\u001a\u00020\u001cH\u0016J\b\u0010.\u001a\u00020\fH\u0016J(\u0010/\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u00100\u001a\u00020+2\u0006\u00101\u001a\u00020+2\u0006\u00102\u001a\u00020+H\u0016J(\u00103\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u00100\u001a\u00020+2\u0006\u00101\u001a\u00020+2\u0006\u00104\u001a\u00020\fH\u0016J\u0010\u00105\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0016J\u0010\u00106\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0016J\u0010\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u000eH\u0016J\u0010\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\f2\u0006\u0010;\u001a\u00020\u0004H\u0002J\b\u0010<\u001a\u00020\u001cH\u0016J\b\u0010=\u001a\u00020\u001cH\u0002J\b\u0010>\u001a\u00020\u001cH\u0016J\b\u0010?\u001a\u00020\u001cH\u0002J\b\u0010@\u001a\u00020\u001cH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/yy/hiyo/channel/plugins/ktv/live/KtvPlayPresenter;", "Lcom/yy/hiyo/channel/cbase/module/ktv/live/IKtvPlayContract$IKtvPlayPresenter;", "Lcom/yy/appbase/live/LiveCallback;", "mRoomOwnerUid", "", "channel", "Lcom/yy/hiyo/channel/base/service/IChannel;", "(JLcom/yy/hiyo/channel/base/service/IChannel;)V", "mCurrentRemoteUID", "mDelayShowRunnable", "Ljava/lang/Runnable;", "mHasVideoStream", "", "mIKtvPlayView", "Lcom/yy/hiyo/channel/cbase/module/ktv/live/IKtvPlayContract$IKtvPlayView;", "mLiveInfoSets", "", "mOperator", "com/yy/hiyo/channel/plugins/ktv/live/KtvPlayPresenter$mOperator$1", "Lcom/yy/hiyo/channel/plugins/ktv/live/KtvPlayPresenter$mOperator$1;", "mVideoOpen", "mViewDelayMillis", "mVoiceService", "Lcom/yy/hiyo/voice/base/channelvoice/IKtvLiveServiceExtend;", "kotlin.jvm.PlatformType", "mediaService", "Lcom/yy/hiyo/channel/base/service/IMediaService;", "checkVideoStop", "", "anchorId", "destroy", "getContract", "Lcom/yy/hiyo/channel/cbase/module/ktv/live/IKtvLiveOperator;", "handleVideoOpen", "handleVideoStop", "isDestroyData", "Landroidx/lifecycle/LiveData;", "isVideoOpened", "needShowVideoSchemeTip", "onJoinChannelSuccess", "", "p1", "elapsed", "", "onKTVDestroy", "onVideoAndVoiceSwitch", "onVideoMode", "onVideoSizeChange", "width", "height", "rotation", "onVideoStart", "isCdn", "onVideoStop", "onVideoStreamOpen", "setView", "view", "Lcom/yy/hiyo/channel/cbase/module/ktv/live/IKtvPlayContract$IPlayView;", "skipCallback", "uid", "start", "startTip", "stopWatchLive", "subscribeStreamInfo", "unsubscribeStreamInfo", "ktv_release"})
public final class KtvPlayPresenter
implements IKtvPlayContract.IKtvPlayPresenter,
LiveCallback {
    private final mOperator.1 mOperator;
    private final IMediaService mediaService;
    private final IKtvLiveServiceExtend mVoiceService;
    private IKtvPlayContract.IKtvPlayView mIKtvPlayView;
    private boolean mVideoOpen;
    private boolean mHasVideoStream;
    private final long mViewDelayMillis = 200L;
    private final Runnable mDelayShowRunnable;
    private long mCurrentRemoteUID;
    private Set<Long> mLiveInfoSets;
    private final long mRoomOwnerUid;
    private final IChannel channel;

    public void setView(@NotNull IKtvPlayContract.IKtvPlayView view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        IKtvPlayContract.IKtvPlayView iKtvPlayView = this.mIKtvPlayView = view;
        if (iKtvPlayView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mIKtvPlayView");
        }
        iKtvPlayView.setPresenter((Object)this);
    }

    @NotNull
    public IKtvLiveOperator getContract() {
        return this.mOperator;
    }

    public void start() {
        this.subscribeStreamInfo();
    }

    public void onKTVDestroy() {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mDelayShowRunnable);
    }

    private final void subscribeStreamInfo() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"KtvPlayPresenter", (String)"subscribeStreamInfo", (Object[])new Object[0]);
        }
        if (!this.mVideoOpen) {
            this.mVideoOpen = true;
            this.mediaService.pendingCallback().registerCallback((LiveCallback)this);
        }
    }

    public void onVideoStart(long anchorId, int width, int height, boolean isCdn) {
        MLog.info((Object)"KtvPlayPresenter", (String)("onVideoStart anchorId:" + anchorId + " myuid:" + AccountUtil.getUid()), (Object[])new Object[0]);
        if (this.skipCallback(anchorId)) {
            return;
        }
        this.mHasVideoStream = true;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
            final /* synthetic */ KtvPlayPresenter this$0;

            public final void run() {
                KtvPlayPresenter.access$startTip(this.this$0);
                KtvPlayPresenter.access$getMIKtvPlayView$p(this.this$0).showHideLoading(false);
            }
            {
                this.this$0 = ktvPlayPresenter;
            }
        });
    }

    public void onVideoStreamOpen(long anchorId) {
        MLog.info((Object)"KtvPlayPresenter", (String)("onVideoStreamOpen anchorId:" + anchorId + " myuid:" + AccountUtil.getUid()), (Object[])new Object[0]);
        if (this.skipCallback(anchorId) || RuntimeContext.isHagoPartySdk()) {
            return;
        }
        this.mLiveInfoSets.add(anchorId);
        this.handleVideoOpen(anchorId);
    }

    private final void handleVideoOpen(long anchorId) {
        if (this.mCurrentRemoteUID <= 0L) {
            this.mCurrentRemoteUID = anchorId;
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, anchorId){
                final /* synthetic */ KtvPlayPresenter this$0;
                final /* synthetic */ long $anchorId;

                public final void run() {
                    ChannelPathLog.getEnterChannelLogger((String)KtvPlayPresenter.access$getChannel$p(this.this$0).getChannelId()).add("VideoPlayer Pre WatchLive", new Object[0]);
                    KtvPlayPresenter.access$setMVideoOpen$p(this.this$0, true);
                    KtvPlayPresenter.access$getMVoiceService$p(this.this$0).startWatchLive(KtvPlayPresenter.access$getMIKtvPlayView$p(this.this$0).getPlayView(), this.$anchorId, "sd", null);
                    KtvPlayPresenter.access$getMIKtvPlayView$p(this.this$0).showHideLoading(true);
                    ChannelPathLog.getEnterChannelLogger((String)KtvPlayPresenter.access$getChannel$p(this.this$0).getChannelId()).add("VideoPlayer After WatchLive", new Object[0]);
                }
                {
                    this.this$0 = ktvPlayPresenter;
                    this.$anchorId = l;
                }
            });
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mDelayShowRunnable);
            YYTaskExecutor.postToMainThread((Runnable)this.mDelayShowRunnable, (long)this.mViewDelayMillis);
            this.mHasVideoStream = true;
            IPluginService iPluginService = this.channel.getPluginService();
            Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService, (String)"channel.pluginService");
            iPluginService.getCurPluginData().putExt("ktv_open_video_uid", (Object)anchorId);
        }
    }

    public void onJoinChannelSuccess(@Nullable String channel, @Nullable String p1, int elapsed) {
    }

    public void onVideoStop(long anchorId) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"KtvPlayPresenter", (String)("onVideoStop  anchorId:" + anchorId), (Object[])new Object[0]);
        }
        if (this.skipCallback(anchorId)) {
            return;
        }
        if (this.mCurrentRemoteUID != anchorId) {
            return;
        }
        this.checkVideoStop(anchorId);
    }

    private final void checkVideoStop(long anchorId) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"KtvPlayPresenter", (String)("handleVideoStop,[anchorIds]:" + this.mLiveInfoSets + ' '), (Object[])new Object[0]);
        }
        long preRemoteUid = this.mCurrentRemoteUID;
        this.mCurrentRemoteUID = 0L;
        this.mLiveInfoSets.remove(anchorId);
        if (this.mLiveInfoSets.isEmpty()) {
            this.handleVideoStop(anchorId);
        } else {
            this.mVoiceService.stopWatchLive(this.channel.getChannelId(), preRemoteUid);
            long firstUsefulUid = ((Number)CollectionsKt.first((Iterable)this.mLiveInfoSets)).longValue();
            if (firstUsefulUid > 0L) {
                this.handleVideoOpen(firstUsefulUid);
            }
        }
    }

    private final void handleVideoStop(long anchorId) {
        this.mHasVideoStream = false;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, anchorId){
            final /* synthetic */ KtvPlayPresenter this$0;
            final /* synthetic */ long $anchorId;

            public final void run() {
                KtvPlayPresenter.access$getMVoiceService$p(this.this$0).stopWatchLive(KtvPlayPresenter.access$getChannel$p(this.this$0).getChannelId(), this.$anchorId);
                KtvPlayPresenter.access$getMIKtvPlayView$p(this.this$0).hideOrShowPlayView(false);
                KtvPlayPresenter.access$getMIKtvPlayView$p(this.this$0).updateVideoIcon(false, false);
            }
            {
                this.this$0 = ktvPlayPresenter;
                this.$anchorId = l;
            }
        });
        IPluginService iPluginService = this.channel.getPluginService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService, (String)"channel.pluginService");
        iPluginService.getCurPluginData().putExt("ktv_open_video_uid", (Object)0L);
    }

    public void onVideoSizeChange(long anchorId, int width, int height, int rotation) {
    }

    public void stopWatchLive() {
        this.unsubscribeStreamInfo();
    }

    public boolean isVideoOpened() {
        return this.mVideoOpen;
    }

    private final void unsubscribeStreamInfo() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"KtvPlayPresenter", (String)("unsubscribeStreamInfo  mVideoOpen:" + this.mVideoOpen), (Object[])new Object[0]);
        }
        if (this.mVideoOpen) {
            this.mVideoOpen = false;
            this.mediaService.pendingCallback().unregisterCallback((LiveCallback)this);
            IKtvPlayContract.IKtvPlayView iKtvPlayView = this.mIKtvPlayView;
            if (iKtvPlayView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mIKtvPlayView");
            }
            iKtvPlayView.hideOrShowPlayView(false);
            this.mVoiceService.stopWatchLive(this.channel.getChannelId(), this.mCurrentRemoteUID > 0L ? this.mCurrentRemoteUID : this.mRoomOwnerUid);
            this.mHasVideoStream = false;
        }
    }

    public void onVideoAndVoiceSwitch() {
        if (this.mVideoOpen) {
            IKtvPlayContract.IKtvPlayView iKtvPlayView = this.mIKtvPlayView;
            if (iKtvPlayView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mIKtvPlayView");
            }
            iKtvPlayView.hideOrShowPlayView(false);
            IKtvPlayContract.IKtvPlayView iKtvPlayView2 = this.mIKtvPlayView;
            if (iKtvPlayView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mIKtvPlayView");
            }
            iKtvPlayView2.updateVideoIcon(false, true);
            this.mVoiceService.stopWatchLive(this.channel.getChannelId(), this.mCurrentRemoteUID);
            this.mVideoOpen = false;
        } else if (this.mHasVideoStream) {
            this.mVideoOpen = true;
            long remoteUID = this.mCurrentRemoteUID > 0L ? this.mCurrentRemoteUID : this.mRoomOwnerUid;
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mDelayShowRunnable);
            YYTaskExecutor.postToMainThread((Runnable)this.mDelayShowRunnable, (long)this.mViewDelayMillis);
            ChannelPathLog.getEnterChannelLogger((String)this.channel.getChannelId()).add("VideoPlayer Pre WatchLive", new Object[0]);
            IKtvPlayContract.IKtvPlayView iKtvPlayView = this.mIKtvPlayView;
            if (iKtvPlayView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mIKtvPlayView");
            }
            this.mVoiceService.startWatchLive(iKtvPlayView.getPlayView(), remoteUID, "sd", null);
            ChannelPathLog.getEnterChannelLogger((String)this.channel.getChannelId()).add("VideoPlayer After WatchLive", new Object[0]);
            IKtvPlayContract.IKtvPlayView iKtvPlayView3 = this.mIKtvPlayView;
            if (iKtvPlayView3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mIKtvPlayView");
            }
            iKtvPlayView3.updateVideoIcon(true, true);
        } else {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.voice_room_no_video);
        }
    }

    public boolean onVideoMode() {
        return this.mHasVideoStream;
    }

    private final void startTip() {
        if (this.needShowVideoSchemeTip()) {
            IKtvPlayContract.IKtvPlayView iKtvPlayView = this.mIKtvPlayView;
            if (iKtvPlayView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mIKtvPlayView");
            }
            iKtvPlayView.showVideoSchemeTip();
        }
    }

    private final boolean needShowVideoSchemeTip() {
        boolean isFirstOpenVideo = RoomSetting.getPreference().getBoolean("FirstShowVideo", true);
        if (isFirstOpenVideo) {
            RoomSetting.getPreference().edit().putBoolean("FirstShowVideo", false).apply();
        }
        return isFirstOpenVideo;
    }

    private final boolean skipCallback(long uid) {
        return AccountUtil.getUid() == uid;
    }

    public void destroy() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"KtvPlayPresenter", (String)"destroy", (Object[])new Object[0]);
        }
        this.stopWatchLive();
        this.mediaService.pendingCallback().destroy();
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mDelayShowRunnable);
        IKtvPlayContract.IKtvPlayView iKtvPlayView = this.mIKtvPlayView;
        if (iKtvPlayView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mIKtvPlayView");
        }
        iKtvPlayView.removePLayView();
        this.mCurrentRemoteUID = 0L;
    }

    @NotNull
    public LiveData<Boolean> isDestroyData() {
        MutableLiveData mutableLiveData = new MutableLiveData();
        boolean bl = false;
        boolean bl2 = false;
        MutableLiveData $this$apply = mutableLiveData;
        boolean bl3 = false;
        $this$apply.setValue((Object)true);
        return (LiveData)mutableLiveData;
    }

    public void setView(@NotNull IKtvPlayContract.IPlayView view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
    }

    public KtvPlayPresenter(long mRoomOwnerUid, @NotNull IChannel channel) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        this.mRoomOwnerUid = mRoomOwnerUid;
        this.channel = channel;
        this.mOperator = new IKtvLiveOperator(){};
        IMediaService iMediaService = this.channel.getMediaService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iMediaService, (String)"channel.mediaService");
        this.mediaService = iMediaService;
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        if (iServiceManager == null) {
            Intrinsics.throwNpe();
        }
        this.mVoiceService = (IKtvLiveServiceExtend)iServiceManager.getService(IKtvLiveServiceExtend.class);
        this.mViewDelayMillis = 200L;
        this.mDelayShowRunnable = new Runnable(this){
            final /* synthetic */ KtvPlayPresenter this$0;

            public final void run() {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"KtvPlayPresenter", (String)"execute mDelayShowRunnable", (Object[])new Object[0]);
                }
                KtvPlayPresenter.access$getMIKtvPlayView$p(this.this$0).hideOrShowPlayView(true);
                KtvPlayPresenter.access$getMIKtvPlayView$p(this.this$0).updateVideoIcon(true, false);
            }
            {
                this.this$0 = ktvPlayPresenter;
            }
        };
        KtvPlayPresenter ktvPlayPresenter = this;
        boolean bl = false;
        ktvPlayPresenter.mLiveInfoSets = set = (Set)new LinkedHashSet();
        this.mediaService.pendingCallback().registerCallback((LiveCallback)this);
    }

    public void onSourceChange(boolean isCdn) {
        LiveCallback.DefaultImpls.onSourceChange((LiveCallback)this, (boolean)isCdn);
    }

    public static final /* synthetic */ void access$startTip(KtvPlayPresenter $this) {
        $this.startTip();
    }

    public static final /* synthetic */ IKtvPlayContract.IKtvPlayView access$getMIKtvPlayView$p(KtvPlayPresenter $this) {
        IKtvPlayContract.IKtvPlayView iKtvPlayView = $this.mIKtvPlayView;
        if (iKtvPlayView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mIKtvPlayView");
        }
        return iKtvPlayView;
    }

    public static final /* synthetic */ void access$setMIKtvPlayView$p(KtvPlayPresenter $this, IKtvPlayContract.IKtvPlayView iKtvPlayView) {
        $this.mIKtvPlayView = iKtvPlayView;
    }

    public static final /* synthetic */ IChannel access$getChannel$p(KtvPlayPresenter $this) {
        return $this.channel;
    }

    public static final /* synthetic */ boolean access$getMVideoOpen$p(KtvPlayPresenter $this) {
        return $this.mVideoOpen;
    }

    public static final /* synthetic */ void access$setMVideoOpen$p(KtvPlayPresenter $this, boolean bl) {
        $this.mVideoOpen = bl;
    }

    public static final /* synthetic */ IKtvLiveServiceExtend access$getMVoiceService$p(KtvPlayPresenter $this) {
        return $this.mVoiceService;
    }
}

