/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.singers;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.yy.base.featurelog.FeatureLog;
import com.yy.hiyo.channel.plugins.ktv.apiservice.KTVProtoService;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVHandler;
import com.yy.hiyo.channel.plugins.ktv.common.bean.KTVSingersData;
import com.yy.hiyo.channel.plugins.ktv.common.bean.KTVSingersItemInfo;
import com.yy.hiyo.channel.plugins.ktv.common.callback.IKTVProtoCallback;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.IPanelHideListener;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.ISelectSongListener;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.singers.KTVSingersMvp;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.singers.KTVSingersView;
import com.yy.hiyo.channel.plugins.ktv.utils.KTVEventReportUtil;
import com.yy.hiyo.mvp.base.BasePresenter;
import java.util.ArrayList;
import net.ihago.ktv.api.search.GetSingerRsp;
import net.ihago.ktv.api.search.Singer;
import net.ihago.ktv.api.search.SingerType;

public class KTVSingersPresenter
extends BasePresenter
implements KTVSingersMvp.IPresenter,
IPanelHideListener {
    private ViewGroup mWrapper;
    private KTVSingersView mView;
    private IKTVHandler mKtvHandler;
    private Context mContext;
    private ISelectSongListener mSelectSongListener;
    private KTVSingersData mData;

    public KTVSingersPresenter(Context context, IKTVHandler ktvHandler, ViewGroup wrapper) {
        this.mContext = context;
        this.mKtvHandler = ktvHandler;
        this.mWrapper = wrapper;
    }

    @Override
    public void showView() {
        this.mView = new KTVSingersView(this.mContext, this.mKtvHandler);
        this.mView.setPresenter(this);
        this.mView.setOnSelectSongListener(this.mSelectSongListener);
        this.mWrapper.addView((View)this.mView);
        this.fetchSingers();
        KTVEventReportUtil.reportSingersShow();
    }

    private void fetchSingers() {
        if (null != this.mData) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVRoomService", (String)"fetch all singers, data already fetched.", (Object[])new Object[0]);
            }
            if (null != this.mView) {
                this.mView.showSuccess(this.mData);
            }
            return;
        }
        KTVProtoService.getInstance().fetchSingers(this.mKtvHandler.getmRoomDataContainer().getRoomId(), new IKTVProtoCallback<GetSingerRsp>(){

            @Override
            public void onSuccess(@NonNull GetSingerRsp data) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVRoomService", (String)"fetch all singers onSelected", (Object[])new Object[0]);
                }
                ArrayList allSingerList = new ArrayList();
                ArrayList<KTVSingersItemInfo> allList = new ArrayList<KTVSingersItemInfo>();
                ArrayList<KTVSingersItemInfo> femaleList = new ArrayList<KTVSingersItemInfo>();
                ArrayList<KTVSingersItemInfo> maleList = new ArrayList<KTVSingersItemInfo>();
                ArrayList<KTVSingersItemInfo> bandList = new ArrayList<KTVSingersItemInfo>();
                String allLetter = "*";
                if (0 != data.top_n.size()) {
                    allList.add(new KTVSingersItemInfo(0, allLetter, null));
                    for (Singer singer : data.top_n) {
                        allList.add(new KTVSingersItemInfo(1, allLetter, singer));
                    }
                }
                if (0 != data.from_a_to_z.size()) {
                    allSingerList.addAll(data.from_a_to_z);
                }
                if (0 != data.not_a_to_z.size()) {
                    allSingerList.addAll(data.not_a_to_z);
                }
                if (0 != allSingerList.size()) {
                    String femaleLetter = "";
                    String maleLetter = "";
                    String bandLetter = "";
                    for (Singer singer : allSingerList) {
                        if (singer.singer_type == SingerType.kSingerTypeFemale) {
                            if (!femaleLetter.equals(singer.letter_of_first_char.toUpperCase())) {
                                femaleLetter = singer.letter_of_first_char.toUpperCase();
                                femaleList.add(new KTVSingersItemInfo(0, femaleLetter, null));
                            }
                            femaleList.add(new KTVSingersItemInfo(1, femaleLetter, singer));
                        } else if (singer.singer_type == SingerType.kSingerTypeMale) {
                            if (!maleLetter.equals(singer.letter_of_first_char.toUpperCase())) {
                                maleLetter = singer.letter_of_first_char.toUpperCase();
                                maleList.add(new KTVSingersItemInfo(0, maleLetter, null));
                            }
                            maleList.add(new KTVSingersItemInfo(1, maleLetter, singer));
                        } else if (singer.singer_type == SingerType.kSingerTypeBand) {
                            if (!bandLetter.equals(singer.letter_of_first_char.toUpperCase())) {
                                bandLetter = singer.letter_of_first_char.toUpperCase();
                                bandList.add(new KTVSingersItemInfo(0, bandLetter, null));
                            }
                            bandList.add(new KTVSingersItemInfo(1, bandLetter, singer));
                        }
                        if (!allLetter.equals(singer.letter_of_first_char.toUpperCase())) {
                            allLetter = singer.letter_of_first_char.toUpperCase();
                            allList.add(new KTVSingersItemInfo(0, allLetter, null));
                        }
                        allList.add(new KTVSingersItemInfo(1, allLetter, singer));
                    }
                }
                KTVSingersPresenter.this.mData = new KTVSingersData();
                KTVSingersPresenter.this.mData.setAllList(allList);
                KTVSingersPresenter.this.mData.setFemaleList(femaleList);
                KTVSingersPresenter.this.mData.setMaleList(maleList);
                KTVSingersPresenter.this.mData.setBandList(bandList);
                if (null != KTVSingersPresenter.this.mView) {
                    KTVSingersPresenter.this.mView.showSuccess(KTVSingersPresenter.this.mData);
                }
            }

            @Override
            public void onError(int code, String errorMessage) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTKTVRoomService", (String)"fetch all singers fail, code=%s", (Object[])new Object[]{code});
                }
                if (null != KTVSingersPresenter.this.mView) {
                    KTVSingersPresenter.this.mView.showError();
                }
            }
        });
    }

    @Override
    public void onPanelHiden() {
        if (null != this.mWrapper && null != this.mView) {
            this.mWrapper.removeView((View)this.mView);
            this.mView = null;
        }
    }

    public void setOnSelectSongListener(ISelectSongListener listener) {
        this.mSelectSongListener = listener;
    }
}

