/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.coins.base;

import android.content.SharedPreferences;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.SharedPreferencesUtils;

public class GameCoinsFlags {
    private static final String TAG = "FTGameCoins";
    private static final String SP_NAME = "GameCoinsData";
    private static final String KEY_TIP_GAME_COINS_WALLET = "key_tip_game_coins_wallet";
    private static final String KEY_TIP_PLAY_GAME_COINS = "key_tip_play_game_coins";
    private static final String KEY_TIP_FIRST_BONUS = "key_tip_first_bonus_";
    private static final String KEY_TIPS_HAS_PALY_COINS_GAME = "key_tips_has_play_coins_game_";
    private static final String KEY_GUEST_REGISTER_COIN_REWARD_TEST_UID = "key_guest_register_coin_reward_test_uid";
    private static SharedPreferences mGameCoinsSharedPreferences;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SharedPreferences getGameCoinsSharedPreferences() {
        if (mGameCoinsSharedPreferences != null) return mGameCoinsSharedPreferences;
        Class<GameCoinsFlags> clazz = GameCoinsFlags.class;
        synchronized (GameCoinsFlags.class) {
            if (mGameCoinsSharedPreferences != null) return mGameCoinsSharedPreferences;
            mGameCoinsSharedPreferences = SharedPreferencesUtils.INSTANCE.getSharedPreferences(RuntimeContext.sApplicationContext, SP_NAME, 0);
            // ** MonitorExit[var0] (shouldn't be in output)
            return mGameCoinsSharedPreferences;
        }
    }

    public static boolean getGameCoinsWalletTipValue() {
        boolean value = GameCoinsFlags.getGameCoinsSharedPreferences().getBoolean(KEY_TIP_GAME_COINS_WALLET, false);
        FeatureLog.d((String)TAG, (String)"GameCoinsFlags getGameCoinsWalletTipValue : %s", (Object[])new Object[]{value});
        return value;
    }

    public static void updateGameCoinsWalletTipValue() {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)TAG, (String)"GameCoinsFlags updateGameCoinsWalletTipValue", (Object[])new Object[0]);
        }
        GameCoinsFlags.getGameCoinsSharedPreferences().edit().putBoolean(KEY_TIP_GAME_COINS_WALLET, true).apply();
    }

    public static boolean getGameCoinsPlayTipValue() {
        boolean value = GameCoinsFlags.getGameCoinsSharedPreferences().getBoolean(KEY_TIP_PLAY_GAME_COINS, false);
        FeatureLog.d((String)TAG, (String)"GameCoinsFlags getGameCoinsPlayTipValue : %s", (Object[])new Object[]{value});
        return value;
    }

    public static void updateGameCoinsPlayTipValue() {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)TAG, (String)"GameCoinsFlags updateGameCoinsPlayTipValue", (Object[])new Object[0]);
        }
        GameCoinsFlags.getGameCoinsSharedPreferences().edit().putBoolean(KEY_TIP_PLAY_GAME_COINS, true).apply();
    }

    public static boolean getGameCoinsFirstBonusValue(long uid) {
        boolean value = GameCoinsFlags.getGameCoinsSharedPreferences().getBoolean(KEY_TIP_FIRST_BONUS + uid, false);
        FeatureLog.d((String)TAG, (String)"GameCoinsFlags getGameCoinsFirstBonusValue : %s  uid: %s", (Object[])new Object[]{value, uid});
        return value;
    }

    public static boolean hasContainsKeyPlayCoinsGame(long uid) {
        boolean value = GameCoinsFlags.getGameCoinsSharedPreferences().contains(KEY_TIPS_HAS_PALY_COINS_GAME + uid);
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)TAG, (String)"GameCoinsFlags hasContainsKeyPlayCoinsGame: %s uid: %s", (Object[])new Object[]{value, uid});
        }
        return value;
    }

    public static void setPlayCoinsGameValue(boolean value, long uid) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)TAG, (String)"GameCoinsFlags setPlayCoinsGameValue: %s  uid: %s", (Object[])new Object[]{value, uid});
        }
        GameCoinsFlags.getGameCoinsSharedPreferences().edit().putBoolean(KEY_TIPS_HAS_PALY_COINS_GAME + uid, value).apply();
    }

    public static boolean getPlayCoinsGameValue(long uid) {
        boolean value = GameCoinsFlags.getGameCoinsSharedPreferences().getBoolean(KEY_TIPS_HAS_PALY_COINS_GAME + uid, true);
        FeatureLog.d((String)TAG, (String)"GameCoinsFlags getPlayCoinsGameValue: %s  uid: %s", (Object[])new Object[]{value, uid});
        return value;
    }

    public static void setCoinRewardGuestUid(long uid) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)TAG, (String)"GameCoinsFlags setCoinRewardGuestUid: %d", (Object[])new Object[]{uid});
        }
        GameCoinsFlags.getGameCoinsSharedPreferences().edit().putLong(KEY_GUEST_REGISTER_COIN_REWARD_TEST_UID, uid).apply();
    }

    public static long getCoinRewardGuestUid() {
        long uid = GameCoinsFlags.getGameCoinsSharedPreferences().getLong(KEY_GUEST_REGISTER_COIN_REWARD_TEST_UID, 0L);
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)TAG, (String)"GameCoinsFlags getCoinRewardGuestUid: %d", (Object[])new Object[]{uid});
        }
        return uid;
    }
}

