/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.bocai.ui.view.game.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.plugins.bocai.R;
import com.yy.hiyo.channel.plugins.bocai.base.OnAnimFinishCallback;
import com.yy.hiyo.channel.plugins.bocai.data.bean.ResultGiftItemData;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class ResultGiftListView
extends YYFrameLayout {
    private static int MAX_ITEM_WIDTH = ResolutionUtils.dip2Px((float)36.0f);
    private static int MAX_ITEM_HOR_MARGIN = ResolutionUtils.dip2Px((float)7.0f);
    private static int MAX_ITEM_TEXT_SIZE = ResolutionUtils.dip2Px((float)12.0f);
    private static int MAX_ITEM_AVATAR_SIZE = ResolutionUtils.dip2Px((float)25.0f);
    private static int MAX_ITEM_GIFT_ICON_SIZE = ResolutionUtils.dip2Px((float)32.0f);
    private static long ADD_ANIM_DURATION = 300L;
    private List<GiftViewHolder> mViewHolderList = new ArrayList<GiftViewHolder>();
    private int mItemCount = 8;
    private int mAvailableWidth = 0;
    private HolderViewSize mHolderViewSize;
    private boolean isAddAniming = false;
    private Queue<GiftViewHolder> mGiftItemAnimQueue = new LinkedList<GiftViewHolder>();

    public ResultGiftListView(Context context) {
        super(context);
        this.init();
    }

    public ResultGiftListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ResultGiftListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
    }

    public void setItemCount(int itemCount) {
        this.mItemCount = itemCount;
        this.mHolderViewSize = null;
    }

    public void setAvailableWidth(int availableWidth) {
        this.mAvailableWidth = availableWidth;
        this.getLayoutParams().width = availableWidth;
        this.mHolderViewSize = null;
    }

    public void setResultGiftItems(List<ResultGiftItemData> items) {
        this.mViewHolderList.clear();
        this.removeAllViews();
        if (items == null) {
            return;
        }
        List<ResultGiftItemData> finalItemList = items.size() > this.mItemCount ? items.subList(0, this.mItemCount) : items;
        HolderViewSize holderViewSize = this.getHolderViewSize();
        int itemHolderWidth = holderViewSize.width + holderViewSize.horMargin * 2;
        int startTranslationX = (this.mAvailableWidth - itemHolderWidth * finalItemList.size()) / 2;
        for (ResultGiftItemData itemData : finalItemList) {
            GiftViewHolder viewHolder = new GiftViewHolder((ViewGroup)this);
            viewHolder.setShowLeaveAvatar(false);
            viewHolder.setData(itemData, holderViewSize);
            viewHolder.getItemView().setTranslationX((float)startTranslationX);
            this.addView(viewHolder.getItemView());
            this.mViewHolderList.add(viewHolder);
            startTranslationX += itemHolderWidth;
        }
    }

    public void addResultGiftItem(ResultGiftItemData item) {
        if (item == null) {
            return;
        }
        if (this.mViewHolderList.size() >= this.mItemCount) {
            return;
        }
        GiftViewHolder viewHolder = new GiftViewHolder((ViewGroup)this);
        viewHolder.setData(item, this.getHolderViewSize());
        this.mGiftItemAnimQueue.add(viewHolder);
        this.checkAnimQueueAndRun();
    }

    private void checkAnimQueueAndRun() {
        if (this.isAddAniming) {
            return;
        }
        GiftViewHolder viewHolder = this.mGiftItemAnimQueue.poll();
        if (viewHolder == null) {
            return;
        }
        this.isAddAniming = true;
        this.movePreItemWithAnim(() -> {
            this.insertItemWithAnim(viewHolder, () -> {
                this.isAddAniming = false;
                this.checkAnimQueueAndRun();
            });
            this.mViewHolderList.add(viewHolder);
        });
    }

    private void movePreItemWithAnim(final OnAnimFinishCallback callback) {
        HolderViewSize holderViewSize = this.getHolderViewSize();
        ArrayList<ObjectAnimator> animatorList = new ArrayList<ObjectAnimator>();
        for (GiftViewHolder holder : this.mViewHolderList) {
            float from = holder.getItemView().getTranslationX();
            float to = LanguageUtils.isRtl() ? from + ((float)holderViewSize.width / 2.0f + (float)holderViewSize.horMargin) : from - ((float)holderViewSize.width / 2.0f + (float)holderViewSize.horMargin);
            ObjectAnimator animator = ObjectAnimator.ofFloat((Object)holder.getItemView(), (String)"translationX", (float[])new float[]{from, to});
            animatorList.add(animator);
        }
        if (animatorList.size() > 0) {
            AnimatorSet animatorSet = new AnimatorSet();
            animatorSet.setDuration(ADD_ANIM_DURATION);
            animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    if (callback != null) {
                        callback.onAnimFinish();
                    }
                }
            });
            animatorSet.playTogether(animatorList);
            animatorSet.start();
        } else if (callback != null) {
            callback.onAnimFinish();
        }
    }

    private void insertItemWithAnim(final GiftViewHolder holder, final OnAnimFinishCallback callback) {
        HolderViewSize holderViewSize = this.getHolderViewSize();
        int itemWidth = holderViewSize.width + holderViewSize.horMargin * 2;
        int contentWidth = itemWidth * (this.mViewHolderList.size() + 1);
        int transXValue = (this.mAvailableWidth - contentWidth) / 2 + contentWidth - itemWidth;
        if (LanguageUtils.isRtl()) {
            transXValue = -transXValue;
        }
        this.addView(holder.getItemView());
        holder.getItemView().setTranslationX((float)transXValue);
        holder.getItemView().setTranslationY((float)this.getMeasuredHeight());
        ObjectAnimator transYAnimator = ObjectAnimator.ofFloat((Object)holder.getItemView(), (String)"translationY", (float[])new float[]{this.getMeasuredHeight(), 0.0f});
        ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)holder.getItemView(), (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.setDuration(ADD_ANIM_DURATION);
        animatorSet.playTogether(new Animator[]{transYAnimator, alphaAnimator});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                holder.onItemEnterAnimFinish();
                if (callback != null) {
                    callback.onAnimFinish();
                }
            }
        });
        animatorSet.start();
    }

    public List<GiftViewHolder> getViewHolderList() {
        return this.mViewHolderList;
    }

    private HolderViewSize getHolderViewSize() {
        if (this.mHolderViewSize == null) {
            this.mHolderViewSize = new HolderViewSize();
            if (this.mItemCount > 0) {
                float scale = (float)this.mAvailableWidth / (float)((MAX_ITEM_WIDTH + MAX_ITEM_HOR_MARGIN * 2) * this.mItemCount);
                if (scale > 1.0f) {
                    scale = 1.0f;
                }
                this.mHolderViewSize.width = (int)((float)MAX_ITEM_WIDTH * scale);
                this.mHolderViewSize.horMargin = (int)((float)MAX_ITEM_HOR_MARGIN * scale);
                this.mHolderViewSize.avatarSize = (int)((float)MAX_ITEM_AVATAR_SIZE * scale);
                this.mHolderViewSize.giftIconSize = (int)((float)MAX_ITEM_GIFT_ICON_SIZE * scale);
                this.mHolderViewSize.textSize = (int)((float)MAX_ITEM_TEXT_SIZE * scale);
            }
        }
        return this.mHolderViewSize;
    }

    static class HolderViewSize {
        public int width = 0;
        public int horMargin = 0;
        public int giftIconSize = 0;
        public int textSize = 0;
        public int avatarSize = 0;

        HolderViewSize() {
        }
    }

    public static class GiftViewHolder {
        private static final long SCALE_ANIM_DURATION = 300L;
        private View mItemView;
        private RelativeLayout mRlGiftContainer;
        private RecycleImageView mIvGift;
        private TextView mTvCount;
        private RoundImageView mIvLeaveAvatar;
        private boolean mShowLeaveAvatar = true;

        public GiftViewHolder(@NonNull ViewGroup parent) {
            this.mItemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.layout_bocai_result_gift_item_channel, parent, false);
            this.mRlGiftContainer = (RelativeLayout)this.mItemView.findViewById(R.id.rl_gift_container);
            this.mIvGift = (RecycleImageView)this.mItemView.findViewById(R.id.iv_gift);
            this.mTvCount = (TextView)this.mItemView.findViewById(R.id.tv_count);
            this.mIvLeaveAvatar = (RoundImageView)this.mItemView.findViewById(R.id.iv_leave_avatar);
        }

        public View getItemView() {
            return this.mItemView;
        }

        public RecycleImageView getGiftView() {
            return this.mIvGift;
        }

        public void setShowLeaveAvatar(boolean showLeaveAvatar) {
            this.mShowLeaveAvatar = showLeaveAvatar;
        }

        public void setData(ResultGiftItemData data, final HolderViewSize holderViewSize) {
            this.initViewSize(holderViewSize);
            this.mTvCount.setText((CharSequence)StringUtils.format((String)"x%d", (Object[])new Object[]{data.getGameResultInfo().getAmount()}));
            String giftUrl = data.getGameResultInfo().getGiftUrl() + YYImageUtils.getThumbnailPostfixPx((int)holderViewSize.giftIconSize, (int)holderViewSize.giftIconSize, (boolean)true);
            ImageLoader.loadImage((ImageView)this.mIvGift, (String)giftUrl, (int)0, (int)R.drawable.icon_gift_default);
            long uid = data.getGameResultInfo().getUid();
            if (data.isInSeat() || !this.mShowLeaveAvatar) {
                this.mRlGiftContainer.setVisibility(0);
                this.mIvLeaveAvatar.setVisibility(8);
            } else {
                ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(uid, new OnProfileCallback(){

                    public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                        if (userInfoKSList == null || userInfoKSList.size() == 0) {
                            return;
                        }
                        UserInfoKS userInfoKS = userInfoKSList.get(0);
                        String avatarUrl = userInfoKS.avatar + YYImageUtils.getThumbnailPostfixPx((int)holderViewSize.avatarSize, (int)holderViewSize.avatarSize, (boolean)true);
                        if (mIvLeaveAvatar != null) {
                            ImageLoader.loadImage((ImageView)mIvLeaveAvatar, (String)avatarUrl, (int)0, (int)R.drawable.ic_bocai_default_avatar);
                        }
                    }

                    public void onFail(int id2, String msg, String response) {
                    }

                    public int id() {
                        return 0;
                    }
                });
                this.mRlGiftContainer.setVisibility(4);
                this.mIvLeaveAvatar.setVisibility(0);
            }
        }

        public void onItemEnterAnimFinish() {
            if (!this.mShowLeaveAvatar) {
                return;
            }
            if (this.mRlGiftContainer != null && this.mRlGiftContainer.getVisibility() != 0) {
                YYTaskExecutor.postToMainThread(this::startAvatarToGiftAnim, (long)300L);
            }
        }

        private void startAvatarToGiftAnim() {
            ObjectAnimator avatarScaleX = ObjectAnimator.ofFloat((Object)this.mIvLeaveAvatar, (String)"scaleX", (float[])new float[]{1.0f, 0.0f});
            ObjectAnimator avatarScaleY = ObjectAnimator.ofFloat((Object)this.mIvLeaveAvatar, (String)"scaleY", (float[])new float[]{1.0f, 0.0f});
            ObjectAnimator giftScaleX = ObjectAnimator.ofFloat((Object)this.mRlGiftContainer, (String)"scaleX", (float[])new float[]{0.0f, 1.0f});
            ObjectAnimator giftScaleY = ObjectAnimator.ofFloat((Object)this.mRlGiftContainer, (String)"scaleY", (float[])new float[]{0.0f, 1.0f});
            AnimatorSet animatorSet = new AnimatorSet();
            animatorSet.setDuration(300L);
            animatorSet.playTogether(new Animator[]{avatarScaleX, avatarScaleY, giftScaleX, giftScaleY});
            animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    if (mRlGiftContainer != null) {
                        mRlGiftContainer.setVisibility(0);
                    }
                }

                public void onAnimationEnd(Animator animation) {
                    if (mIvLeaveAvatar != null) {
                        mIvLeaveAvatar.setVisibility(8);
                    }
                }
            });
            animatorSet.start();
        }

        private void initViewSize(HolderViewSize viewSize) {
            FrameLayout.LayoutParams rootLp = (FrameLayout.LayoutParams)this.mItemView.getLayoutParams();
            rootLp.width = viewSize.width;
            rootLp.leftMargin = viewSize.horMargin;
            rootLp.rightMargin = viewSize.horMargin;
            RelativeLayout.LayoutParams giftIconLp = (RelativeLayout.LayoutParams)this.mIvGift.getLayoutParams();
            giftIconLp.width = viewSize.giftIconSize;
            giftIconLp.height = viewSize.giftIconSize;
            RelativeLayout.LayoutParams leaveAvatarLp = (RelativeLayout.LayoutParams)this.mIvLeaveAvatar.getLayoutParams();
            leaveAvatarLp.width = viewSize.avatarSize;
            leaveAvatarLp.height = viewSize.avatarSize;
            this.mIvLeaveAvatar.setBorderRadius(ResolutionUtils.dip2Px((float)(viewSize.avatarSize / 2)));
            this.mTvCount.setTextSize(0, (float)viewSize.textSize);
        }
    }
}

