/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.audiopk.pk.top;

import android.content.Context;
import android.os.Message;
import android.view.View;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.EntryInfo;
import com.yy.hiyo.channel.base.FirstEntType;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.IHolderPresenter;
import com.yy.hiyo.channel.plugins.audiopk.pk.AbsAudioPkPresenter;
import com.yy.hiyo.channel.plugins.audiopk.pk.media.LinkMicMediaPresenter;
import com.yy.hiyo.channel.plugins.audiopk.pk.surrender.PkSurrenderPresenter;
import com.yy.hiyo.channel.plugins.audiopk.pk.top.PkTopView;
import com.yy.hiyo.channel.plugins.audiopk.room.AudioPkContext;
import com.yy.hiyo.pk.base.audio.bean.PkTeam;
import com.yy.webservice.WebEnvSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.channel.srv.roompk.TeamTheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\u0006\u0010\u0018\u001a\u00020\u0013J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0016H\u0016J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0013H\u0016J\u0006\u0010&\u001a\u00020\u0013R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR*\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR*\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006'"}, d2={"Lcom/yy/hiyo/channel/plugins/audiopk/pk/top/PkTopPresenter;", "Lcom/yy/hiyo/channel/plugins/audiopk/pk/AbsAudioPkPresenter;", "Lcom/yy/hiyo/channel/cbase/context/IHolderPresenter;", "()V", "mView", "Lcom/yy/hiyo/channel/plugins/audiopk/pk/top/PkTopView;", "getMView", "()Lcom/yy/hiyo/channel/plugins/audiopk/pk/top/PkTopView;", "setMView", "(Lcom/yy/hiyo/channel/plugins/audiopk/pk/top/PkTopView;)V", "<set-?>", "Landroidx/lifecycle/LiveData;", "", "viewEnableVoice", "getViewEnableVoice", "()Landroidx/lifecycle/LiveData;", "viewVisibleSurrender", "getViewVisibleSurrender", "enableVoice", "", "enable", "getMyThemeId", "", "getOtherThemeId", "gotoOtherRoom", "onDestroy", "onInit", "mvpContext", "Lcom/yy/hiyo/channel/plugins/audiopk/room/AudioPkContext;", "onStateChanged", "pkId", "", "oldState", "newState", "setContainer", "container", "Landroid/view/View;", "showRuleDialog", "surrender", "audiopk_debug"})
public class PkTopPresenter
extends AbsAudioPkPresenter
implements IHolderPresenter {
    @NotNull
    private LiveData<Boolean> viewEnableVoice;
    @NotNull
    private LiveData<Boolean> viewVisibleSurrender;
    @Nullable
    private PkTopView mView;

    @NotNull
    public final LiveData<Boolean> getViewEnableVoice() {
        LiveData<Boolean> liveData = this.viewEnableVoice;
        if (liveData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewEnableVoice");
        }
        return liveData;
    }

    @NotNull
    public final LiveData<Boolean> getViewVisibleSurrender() {
        LiveData<Boolean> liveData = this.viewVisibleSurrender;
        if (liveData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewVisibleSurrender");
        }
        return liveData;
    }

    @Nullable
    protected final PkTopView getMView() {
        return this.mView;
    }

    protected final void setMView(@Nullable PkTopView pkTopView) {
        this.mView = pkTopView;
    }

    public void onInit(@NotNull AudioPkContext mvpContext) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mvpContext), (String)"mvpContext");
        super.onInit((IChannelPageContext)mvpContext);
        IPluginService iPluginService = this.getChannel().getPluginService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService, (String)"channel.pluginService");
        this.viewEnableVoice = iPluginService.getCurPluginData().mode == 16 ? (LiveData)((LinkMicMediaPresenter)this.getPresenter(LinkMicMediaPresenter.class)).isOtherRoomVoiceEnableLiveData() : (LiveData)new MutableLiveData();
        IPluginService iPluginService2 = this.getChannel().getPluginService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService2, (String)"channel.pluginService");
        this.viewVisibleSurrender = iPluginService2.getCurPluginData().mode == 16 ? (LiveData)((PkSurrenderPresenter)this.getPresenter(PkSurrenderPresenter.class)).getViewVisibleSurrender() : (LiveData)new MutableLiveData((Object)false);
    }

    public void setContainer(@NotNull View container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        if (!(container instanceof YYPlaceHolderView)) {
            return;
        }
        FragmentActivity fragmentActivity = ((AudioPkContext)this.getMvpContext()).getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"mvpContext.context");
        this.mView = new PkTopView((Context)fragmentActivity);
        YYPlaceHolderView yYPlaceHolderView = (YYPlaceHolderView)container;
        PkTopView pkTopView = this.mView;
        if (pkTopView == null) {
            Intrinsics.throwNpe();
        }
        yYPlaceHolderView.inflate((View)pkTopView);
        PkTopView pkTopView2 = this.mView;
        if (pkTopView2 == null) {
            Intrinsics.throwNpe();
        }
        pkTopView2.setPresenter((LifecycleOwner)this.getMvpContext(), this);
    }

    public final void gotoOtherRoom() {
        Object object = ((AudioPkContext)this.getMvpContext()).getPkData().getOtherTeam();
        if (object == null || (object = object.getCid()) == null) {
            return;
        }
        Object otherRoomCid = object;
        Message message = Message.obtain();
        message.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
        EnterParam enterParam = EnterParam.obtain((String)otherRoomCid, (int)142);
        enterParam.entryInfo = new EntryInfo(FirstEntType.INSIDE_CHANNEL, "10", null, 4, null);
        message.obj = enterParam;
        MsgDispatcher.getInstance().sendMessage(message);
    }

    public final void enableVoice(boolean enable) {
        LinkMicMediaPresenter linkMicMediaPresenter = (LinkMicMediaPresenter)this.getPresenter(LinkMicMediaPresenter.class);
        if (enable) {
            linkMicMediaPresenter.enableOtherRoomVoice();
        } else {
            linkMicMediaPresenter.disableOtherRoomVoice();
        }
    }

    public final void surrender() {
        ((PkSurrenderPresenter)this.getPresenter(PkSurrenderPresenter.class)).surrender();
    }

    public void showRuleDialog() {
        block0: {
            WebEnvSettings wes = new WebEnvSettings();
            wes.url = UriProvider.getAudioPkRule();
            wes.disablePullRefresh = true;
            IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
            if (iServiceManager == null || (iServiceManager = (IWebService)iServiceManager.getService(IWebService.class)) == null) break block0;
            iServiceManager.loadUrl(wes);
        }
    }

    public final int getMyThemeId() {
        PkTeam pkTeam = ((AudioPkContext)this.getMvpContext()).getPkData().getOwnTeam();
        return pkTeam != null ? pkTeam.getTheme() : TeamTheme.TEAM_THEME_NONE.getValue();
    }

    public final int getOtherThemeId() {
        PkTeam pkTeam = ((AudioPkContext)this.getMvpContext()).getPkData().getOtherTeam();
        return pkTeam != null ? pkTeam.getTheme() : TeamTheme.TEAM_THEME_NONE.getValue();
    }

    @Override
    public void onStateChanged(@NotNull String pkId, int oldState, int newState) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)pkId, (String)"pkId");
            if (newState == 100) break block1;
            PkTopView pkTopView = this.mView;
            if (pkTopView != null) {
                pkTopView.changeCommonState();
            }
        }
    }

    public void onDestroy() {
        block0: {
            super.onDestroy();
            PkTopView pkTopView = this.mView;
            if (pkTopView == null) break block0;
            pkTopView.destroy();
        }
    }
}

