/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.util;

import android.content.Context;
import android.view.View;
import androidx.annotation.Size;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.ui.StatusBarManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\n\u00a8\u0006\r"}, d2={"Lcom/yy/appbase/util/ScreenWrapperUtils;", "", "()V", "getViewPoint", "", "view", "Landroid/view/View;", "isAbsolute", "", "outLocation", "", "paraseLocationInWindow", "location", "appbase_release"})
public final class ScreenWrapperUtils {
    public static final ScreenWrapperUtils INSTANCE;

    public final void paraseLocationInWindow(@Nullable int[] location) {
        if (location != null && location.length == 2 && !StatusBarManager.INSTANCE.isTranslucent()) {
            location[1] = location[1] == 0 ? 0 : location[1] - SystemUtils.getStatusBarHeight((Context)RuntimeContext.sApplicationContext);
        }
    }

    public final void getViewPoint(@Nullable View view, boolean isAbsolute, @Size(value=2L) @Nullable int[] outLocation) {
        boolean bl = outLocation != null && outLocation.length >= 2;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "outLocation must be an array of two integers";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        outLocation[0] = 0;
        outLocation[1] = 0;
        if (view != null) {
            view.getLocationInWindow(outLocation);
            int width = view.getWidth();
            int hight = view.getHeight();
            this.paraseLocationInWindow(outLocation);
            if (LanguageUtils.isRtl() && !isAbsolute) {
                ScreenUtils screenUtils = ScreenUtils.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)screenUtils, (String)"ScreenUtils.getInstance()");
                outLocation[0] = -(screenUtils.getWidthPixels() - outLocation[0]) + width / 2;
            } else {
                outLocation[0] = outLocation[0] + width / 2;
            }
            outLocation[1] = outLocation[1] + hight / 2;
        }
    }

    private ScreenWrapperUtils() {
    }

    static {
        ScreenWrapperUtils screenWrapperUtils;
        INSTANCE = screenWrapperUtils = new ScreenWrapperUtils();
    }
}

