/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.util;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;

public final class KeyboardHelper {
    private static final String KEY_KEYBOARD_HEIGHT = "KEYBOARD_HEIGHT";
    private static final String CAN_GET_ATTACH_INFO = "CAN_GET_ATTACH_INFO";
    private static final int DEF_KEYBOARD_HEIGHT_WITH_DP = 270;
    private static int sDefKeyboardHeight = -1;

    public static int getKeyboardHeight() {
        int height;
        if (sDefKeyboardHeight < 0) {
            sDefKeyboardHeight = ResolutionUtils.dip2Px((float)270.0f);
        }
        sDefKeyboardHeight = (height = SettingFlags.getIntValue((String)KEY_KEYBOARD_HEIGHT, (int)0)) > 100 && sDefKeyboardHeight != height && height < ScreenUtils.getInstance().getHeightPixels() * 2 / 3 ? height : sDefKeyboardHeight;
        return sDefKeyboardHeight;
    }

    public static void setKeyboardHeight(int height) {
        MLog.info((Object)"KEYBOARD", (String)"setKeyboardHeight height=%s", (Object[])new Object[]{height});
        if (height > 100 && sDefKeyboardHeight != height) {
            SettingFlags.setIntValue((String)KEY_KEYBOARD_HEIGHT, (int)height);
            sDefKeyboardHeight = height;
        }
    }

    public static void watchKeyboardStatus(View view, OnKeyboardShowListener listener2) {
        view.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)listener2);
    }

    public static void unwatchKeyboardStatus(View view, OnKeyboardShowListener listener2) {
        if (view == null || listener2 == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)listener2);
        } else {
            view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)listener2);
        }
        View rootView = view.getRootView();
        if (rootView != null) {
            rootView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)listener2);
        }
    }

    public static abstract class OnKeyboardShowListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private int keyboardHeight = 0;
        private boolean isInDialog = false;
        private boolean mIsSoftKeyboardShowing = false;
        View activityRootView;
        WeakReference<View> activityRootViewW;
        private int contentHeight = -1;
        private static Field mAttachInfoField;
        private static Field mStableInsetsField;
        private static boolean canGetAttachInfo;

        public OnKeyboardShowListener(View activityRootView) {
            this.activityRootView = activityRootView;
        }

        public OnKeyboardShowListener(View activityRootView, boolean useW) {
            View view = this.activityRootView = useW ? null : activityRootView;
            if (useW) {
                this.activityRootViewW = new WeakReference<View>(activityRootView);
            }
        }

        private View getView() {
            if (this.activityRootView != null) {
                return this.activityRootView;
            }
            if (this.activityRootViewW != null) {
                this.activityRootViewW.get();
            }
            return null;
        }

        public void removeRootView() {
            if (this.activityRootView != null) {
                this.activityRootView = null;
            }
        }

        public void setInDialog(boolean inDialog) {
            this.isInDialog = inDialog;
        }

        private int getUsableScreenHeight() {
            View view = this.getView();
            if (view == null) {
                return 1;
            }
            if (Build.VERSION.SDK_INT >= 17 && this.isInDialog) {
                DisplayMetrics metrics = new DisplayMetrics();
                WindowManager windowManager = (WindowManager)view.getContext().getSystemService("window");
                windowManager.getDefaultDisplay().getMetrics(metrics);
                return metrics.heightPixels;
            }
            return view.getRootView().getHeight();
        }

        public static int getViewInset(View view) {
            if (view == null || Build.VERSION.SDK_INT < 21 || view.getHeight() == ResolutionUtils.getScreenHeight((Context)view.getContext()) || view.getHeight() == ResolutionUtils.getScreenHeight((Context)view.getContext()) - SystemUtils.getStatusBarHeight((Context)view.getContext())) {
                return 0;
            }
            if (!(canGetAttachInfo = SettingFlags.getBoolean((String)KeyboardHelper.CAN_GET_ATTACH_INFO, (boolean)canGetAttachInfo))) {
                return 0;
            }
            try {
                Object mAttachInfo;
                if (mAttachInfoField == null) {
                    mAttachInfoField = View.class.getDeclaredField("mAttachInfo");
                    mAttachInfoField.setAccessible(true);
                }
                if ((mAttachInfo = mAttachInfoField.get(view)) != null) {
                    if (mStableInsetsField == null) {
                        mStableInsetsField = mAttachInfo.getClass().getDeclaredField("mStableInsets");
                        mStableInsetsField.setAccessible(true);
                    }
                    Rect insets = (Rect)mStableInsetsField.get(mAttachInfo);
                    MLog.debug((Object)"KEYBOARD", (String)("insets.bottom =" + insets.bottom), (Object[])new Object[0]);
                    return insets.bottom;
                }
            }
            catch (NoSuchFieldException e) {
                canGetAttachInfo = false;
                SettingFlags.setBoolean((String)KeyboardHelper.CAN_GET_ATTACH_INFO, (boolean)false);
                MLog.error((Object)"KEYBOARD", (Throwable)e);
            }
            catch (Exception e) {
                MLog.error((Object)"KEYBOARD", (String)"getViewInset error ", (Throwable)e, (Object[])new Object[0]);
            }
            return 0;
        }

        public void onGlobalLayout() {
            boolean isKeyboardShowing;
            Rect r = new Rect();
            View view = this.getView();
            if (view != null) {
                view.getRootView().getWindowVisibleDisplayFrame(r);
            }
            MLog.debug((Object)"KEYBOARD", (String)("getWindowVisibleDisplayFrame bottom" + r.bottom + ", r.top=" + r.top), (Object[])new Object[0]);
            if (this.contentHeight < 0) {
                this.contentHeight = this.getUsableScreenHeight();
                MLog.debug((Object)"KEYBOARD", (String)("contentHeight=" + this.contentHeight), (Object[])new Object[0]);
            }
            int deltaHeight = 0;
            deltaHeight = view != null ? this.contentHeight - (r.bottom - r.top) - r.top - OnKeyboardShowListener.getViewInset(view) : this.contentHeight - (r.bottom - r.top) - r.top - 0;
            if (this.isInDialog) {
                isKeyboardShowing = deltaHeight > 200;
            } else {
                boolean bl = isKeyboardShowing = deltaHeight > Math.min(ScreenUtils.getInstance().dip2px(200), this.contentHeight / 3);
            }
            if (this.mIsSoftKeyboardShowing != isKeyboardShowing) {
                this.mIsSoftKeyboardShowing = isKeyboardShowing;
                if (this.keyboardHeight == 0) {
                    this.keyboardHeight = deltaHeight;
                }
                KeyboardHelper.setKeyboardHeight(this.keyboardHeight);
                this.onShow(this.mIsSoftKeyboardShowing, this.keyboardHeight);
            }
        }

        public abstract void onShow(boolean var1, int var2);

        static {
            canGetAttachInfo = true;
        }
    }
}

