/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.util;

import android.text.InputFilter;
import com.yy.base.utils.StringUtils;
import java.util.Locale;

public class ArStringUtils {
    private static final String sArbInput = "0123456789\u0660\u06f0\u0661\u0662\u0663\u0664\u06f4\u0665\u06f5\u0666\u06f6\u0667\u0668\u0669";

    public static boolean isArLanguage() {
        Locale aDefault = Locale.getDefault();
        if (aDefault == null) {
            return false;
        }
        String language = aDefault.getLanguage();
        return "ar".equalsIgnoreCase(language);
    }

    public static InputFilter[] getArbInputFilters() {
        return new InputFilter[]{(source, start, end, dest, dstart, dend) -> {
            for (int i = start; i < end; ++i) {
                if (sArbInput.contains(source.charAt(i) + "")) continue;
                return "";
            }
            return null;
        }};
    }

    public static String transformArToNormalNumInArLocal(String number) {
        if (ArStringUtils.isArLanguage()) {
            return ArStringUtils.transformArToNormalNum(number);
        }
        return number;
    }

    private static String transformArToNormalNum(String number) {
        if (StringUtils.isEmpty((String)number)) {
            return "";
        }
        StringBuilder outPut = new StringBuilder();
        for (int i = 0; i < number.length(); ++i) {
            char c = number.charAt(i);
            if (c == '\u0660' || c == '\u06f0' || c == '0') {
                outPut.append(0);
                continue;
            }
            if (c == '\u0661' || c == '1') {
                outPut.append(1);
                continue;
            }
            if (c == '\u0662' || c == '2') {
                outPut.append(2);
                continue;
            }
            if (c == '\u0663' || c == '3') {
                outPut.append(3);
                continue;
            }
            if (c == '\u0664' || c == '\u06f4' || c == '4') {
                outPut.append(4);
                continue;
            }
            if (c == '\u0665' || c == '\u06f5' || c == '5') {
                outPut.append(5);
                continue;
            }
            if (c == '\u0666' || c == '\u06f6' || c == '6') {
                outPut.append(6);
                continue;
            }
            if (c == '\u0667' || c == '7') {
                outPut.append(7);
                continue;
            }
            if (c == '\u0668' || c == '8') {
                outPut.append(8);
                continue;
            }
            if (c != '\u0669' && c != '9') continue;
            outPut.append(9);
        }
        return outPut.toString();
    }

    public static String transformNormalToArNumInArLocal(String number) {
        if (ArStringUtils.isArLanguage()) {
            return ArStringUtils.transformNormalToArNum(number);
        }
        return number;
    }

    private static String transformNormalToArNum(String number) {
        if (StringUtils.isEmpty((String)number)) {
            return "";
        }
        StringBuilder outPut = new StringBuilder();
        for (int i = 0; i < number.length(); ++i) {
            char c = number.charAt(i);
            if (c == '0') {
                outPut.append('\u06f0');
                continue;
            }
            if (c == '1') {
                outPut.append('\u0661');
                continue;
            }
            if (c == '2') {
                outPut.append('\u0662');
                continue;
            }
            if (c == '3') {
                outPut.append('\u0663');
                continue;
            }
            if (c == '4') {
                outPut.append('\u0664');
                continue;
            }
            if (c == '5') {
                outPut.append('\u0665');
                continue;
            }
            if (c == '6') {
                outPut.append('\u0666');
                continue;
            }
            if (c == '7') {
                outPut.append('\u0667');
                continue;
            }
            if (c == '8') {
                outPut.append('\u0668');
                continue;
            }
            if (c != '9') continue;
            outPut.append('\u0669');
        }
        return outPut.toString();
    }
}

