/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.util;

import android.text.TextUtils;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.BirthdayDefines;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.AgeRestrainConfig;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import java.util.Calendar;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AgeUtils {
    private static final String TAG = "AgeUtils";

    public static boolean isAgeInValid(String birthday) {
        if (NewABDefine.HAGO_AGE_BLOCK.getTest() == null || NAB.A.equals(NewABDefine.HAGO_AGE_BLOCK.getTest())) {
            MLog.info((Object)TAG, (String)"checkAagInvalid ABResult:A", (Object[])new Object[0]);
            return false;
        }
        int age = AgeUtils.getAgeFromBirthTime(birthday);
        int ageRestrain = BirthdayDefines.getAgeRestrain();
        MLog.info((Object)TAG, (String)"checkAagInvalid age:%s year:%s", (Object[])new Object[]{age, ageRestrain});
        return TextUtils.isEmpty((CharSequence)birthday) || age < ageRestrain;
    }

    public static boolean isOldAmericaUser(String birthday) {
        AgeRestrainConfig data2;
        AConfigData configData2 = UnifyConfig.INSTANCE.getConfigData(BssCode.AGE_RESTRAIN_CONFIG);
        boolean isTargetCountry = false;
        if (configData2 instanceof AgeRestrainConfig && (data2 = (AgeRestrainConfig)configData2).getData() != null && data2.getData().getAppEntryCountry() != null) {
            List<String> appEntryCountry = data2.getData().getAppEntryCountry();
            isTargetCountry = appEntryCountry.contains(AccountUtil.realCountry());
        }
        if ("2007-01-01".equals(birthday) && (isTargetCountry |= "us".equals(AccountUtil.realCountry())) && !SettingFlags.getBoolean((String)("birth" + AccountUtil.getUid()), (boolean)false)) {
            SettingFlags.setBoolean((String)("birth" + AccountUtil.getUid()), (boolean)true);
            return true;
        }
        return false;
    }

    @NotNull
    public static String getBirthdayString(int year, int month, int dayOfMonth) {
        String dayStr;
        String monthStr = String.valueOf(month);
        if (!TextUtils.isEmpty((CharSequence)monthStr) && monthStr.length() == 1) {
            monthStr = "0" + monthStr;
        }
        if (!TextUtils.isEmpty((CharSequence)(dayStr = String.valueOf(dayOfMonth))) && dayStr.length() == 1) {
            dayStr = "0" + dayStr;
        }
        return year + "-" + monthStr + "-" + dayStr;
    }

    public static int getAgeFromBirthTime(String birthTimeString) {
        if (TextUtils.isEmpty((CharSequence)birthTimeString)) {
            return 0;
        }
        MLog.info((Object)TAG, (String)("birthTimeString: " + birthTimeString), (Object[])new Object[0]);
        String[] strs = birthTimeString.trim().split("-");
        int selectYear = 0;
        int selectMonth = 0;
        int selectDay = 0;
        try {
            selectYear = Integer.parseInt(strs[0]);
            selectMonth = Integer.parseInt(strs[1]);
            selectDay = Integer.parseInt(strs[2]);
        }
        catch (NumberFormatException e) {
            MLog.error((Object)TAG, (String)"NumberFormatException", (Throwable)e, (Object[])new Object[0]);
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        int yearNow = cal.get(1);
        int monthNow = cal.get(2) + 1;
        int dayNow = cal.get(5);
        int yearMinus = yearNow - selectYear;
        int monthMinus = monthNow - selectMonth;
        int dayMinus = dayNow - selectDay;
        int age = yearMinus;
        if (monthMinus < 0) {
            --age;
        } else if (monthMinus == 0 && dayMinus <= 0) {
            --age;
        }
        return Math.max(age, 0);
    }
}

