/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config.taskopt;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.taskopt.TaskOptConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.json.JsonParser;

public class TaskOptConfig
extends AConfigData {
    private static final String TAG = "TaskOptConfig";
    private static TaskOptConfigData mData;

    @Override
    public BssCode getBssCode() {
        return BssCode.TASK_OPT_CONFIG;
    }

    @Override
    public void parseConfig(final String configs) {
        if (StringUtils.isEmpty((String)configs)) {
            MLog.error((Object)TAG, (String)"config is empty!", (Object[])new Object[0]);
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    TaskOptConfig.this.parseConfigInner(configs);
                }
            }, (long)0L);
        } else {
            this.parseConfigInner(configs);
        }
    }

    private void parseConfigInner(String configs) {
        block4: {
            try {
                mData = (TaskOptConfigData)JsonParser.parseJsonObject((String)configs, TaskOptConfigData.class);
                SettingFlags.setBoolean((String)"TaskOptConfigFile", (boolean)TaskOptConfig.mData.fileSwtich);
                SettingFlags.setBoolean((String)"TaskOptConfigIdleExe", (boolean)TaskOptConfig.mData.idleExecuteSwitch);
                SettingFlags.getBoolean((String)"TaskOptConfigSharef", (boolean)TaskOptConfig.mData.sharedPrefSwitch);
                SettingFlags.setIntValue((String)"TaskOptConfigSharefTime", (int)TaskOptConfig.mData.sharedPrefWriteTime);
                if (SystemUtils.isShowEnvSetting()) {
                    MLog.info((Object)TAG, (String)"parse config: %s", (Object[])new Object[]{configs});
                } else {
                    MLog.info((Object)TAG, (String)"parse config: %d", (Object[])new Object[]{configs.length()});
                }
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"parse config error: %s", (Throwable)e, (Object[])new Object[0]);
                if (!SystemUtils.isShowEnvSetting()) break block4;
                throw new RuntimeException(e);
            }
        }
    }

    private static void initData() {
        if (mData == null) {
            mData = new TaskOptConfigData();
            if (SettingFlags.hasInited()) {
                TaskOptConfig.mData.fileSwtich = SettingFlags.getBoolean((String)"TaskOptConfigFile", (boolean)true);
                TaskOptConfig.mData.idleExecuteSwitch = SettingFlags.getBoolean((String)"TaskOptConfigIdleExe", (boolean)true);
                TaskOptConfig.mData.sharedPrefSwitch = SettingFlags.getBoolean((String)"TaskOptConfigSharef", (boolean)true);
                TaskOptConfig.mData.sharedPrefWriteTime = SettingFlags.getIntValue((String)"TaskOptConfigSharefTime", (int)1000);
            }
        }
    }

    public static boolean isIdleExecuteSwitch() {
        TaskOptConfig.initData();
        return TaskOptConfig.mData.idleExecuteSwitch;
    }

    public static boolean isFileOptSwitchOn() {
        TaskOptConfig.initData();
        return TaskOptConfig.mData.fileSwtich;
    }

    public static boolean isSharedPrefSwitch() {
        TaskOptConfig.initData();
        return TaskOptConfig.mData.sharedPrefSwitch;
    }

    public static int getSharedPrefWriteTime() {
        TaskOptConfig.initData();
        return TaskOptConfig.mData.sharedPrefWriteTime;
    }
}

