/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class VoiceRoomCalculatorConfig
extends AConfigData {
    private static final String TAG = "VoiceRoomCalculatorConfig";
    private String mCalculator = "";
    private List<String> mCharmValueList = new ArrayList<String>();

    @Override
    public BssCode getBssCode() {
        return BssCode.VOICE_ROOM_CALCULATOR_INSTRUCTION;
    }

    @Override
    public void parseConfig(String configs) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"configs %s", (Object[])new Object[]{configs});
        }
        if (StringUtils.isEmpty((String)configs)) {
            return;
        }
        try {
            JSONObject jsonObject = JsonParser.obtainJSONObject((String)configs);
            if (jsonObject.has("calculator")) {
                JSONObject calculatorObject = jsonObject.optJSONObject("calculator");
                if (calculatorObject.has("charm_value_calculator")) {
                    this.mCalculator = calculatorObject.optString("charm_value_calculator");
                }
                if (calculatorObject.has("charm_value")) {
                    JSONArray charmValueArray = calculatorObject.optJSONArray("charm_value");
                    for (int i = 0; i < charmValueArray.length(); ++i) {
                        this.mCharmValueList.add(charmValueArray.getString(i));
                    }
                }
            }
            MLog.info((Object)TAG, (String)"parseConfig:%s, %s", (Object[])new Object[]{this.mCalculator, this.mCharmValueList.toString()});
        }
        catch (Throwable e) {
            MLog.info((Object)TAG, (String)"parseConfig %s", (Object[])new Object[]{configs});
        }
    }

    public String getCalculator() {
        return this.mCalculator;
    }

    public List<String> getCharmValueList() {
        return this.mCharmValueList;
    }
}

