/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.json.JsonParser;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class VietnamInviteFriendConfig
extends AConfigData {
    private static final String TAG = "VietnamInviteFriendConfig";
    private List<String> hotPlatformList;
    private String tipPlatform;
    private String shareBg;
    private List<String> platformList;

    @Override
    public BssCode getBssCode() {
        return BssCode.VIETNAM_INVITE_FRIEND;
    }

    @Override
    public void parseConfig(String configs) {
        MLog.info((Object)TAG, (String)"parseConfig config: %s", (Object[])new Object[]{configs});
        if (FP.empty((CharSequence)configs)) {
            return;
        }
        try {
            JSONArray platformArray;
            JSONObject jsonObject = JsonParser.obtainJSONObject((String)configs);
            this.tipPlatform = jsonObject.optString("tipPlatform");
            this.shareBg = jsonObject.getString("shareBg");
            JSONArray jsonArray = jsonObject.getJSONArray("hotPlatform");
            if (jsonArray != null && jsonArray.length() > 0) {
                int length = jsonArray.length();
                this.hotPlatformList = new ArrayList<String>(length);
                for (int i = 0; i < length; ++i) {
                    this.hotPlatformList.add(jsonArray.getString(i));
                }
            }
            if ((platformArray = jsonObject.getJSONArray("platform")) != null && platformArray.length() > 0) {
                int length = platformArray.length();
                this.platformList = new ArrayList<String>(length);
                for (int i = 0; i < length; ++i) {
                    this.platformList.add(platformArray.getString(i));
                }
            }
            MLog.info((Object)TAG, (String)"parseConfig result: tipPlatform: %s  hotPlatform: %s  shareBg: %s", (Object[])new Object[]{this.tipPlatform, this.hotPlatformList, this.shareBg});
        }
        catch (Throwable e) {
            MLog.info((Object)TAG, (String)"parseConfig error: %s", (Object[])new Object[]{e});
        }
    }

    public List<String> getPlatformList() {
        return this.platformList;
    }

    public List<String> getHotPlatformList() {
        return this.hotPlatformList;
    }

    public String getTipPlatform() {
        return this.tipPlatform;
    }

    public String getShareBg() {
        return this.shareBg;
    }
}

