/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.json.JsonParser;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

@DontProguardClass
public class TeamMultiGameConfigData
extends AConfigData {
    private static ArrayList<String> sGameKeys = new ArrayList();
    private ConcurrentHashMap<String, GameConfigItem> mGameConfigs = new ConcurrentHashMap();

    @Override
    public BssCode getBssCode() {
        return BssCode.TEAM_GAME_MULTI_CONFIG;
    }

    @Override
    public void parseConfig(String configs) {
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)"TeamMultiGameConfigData", (String)"configs %s", (Object[])new Object[]{configs});
        }
        this.mConfigContent = configs;
        try {
            JSONObject jo = JsonParser.obtainJSONObject((String)configs);
            this.mGameConfigs.clear();
            if (!jo.has("gamelist")) {
                return;
            }
            JSONArray gameList = jo.getJSONArray("gamelist");
            JSONObject gameItem = null;
            Object gamename = null;
            Object gameId = null;
            for (int i = 0; i < gameList.length(); ++i) {
                gameItem = gameList.optJSONObject(i);
                if (gameItem == null) continue;
                this.parseItem(gameItem);
            }
        }
        catch (Throwable e) {
            MLog.info((Object)"TeamMultiGameConfigData", (String)"parseConfig %s", (Object[])new Object[]{configs});
        }
    }

    private void parseItem(JSONObject data2) {
        if (data2 == null) {
            return;
        }
        try {
            GameConfigItem item = (GameConfigItem)JsonParser.parseJsonObject((String)data2.toString(), GameConfigItem.class);
            this.mGameConfigs.put(item.getGameid(), item);
        }
        catch (Throwable e) {
            MLog.error((Object)"TeamMultiGameConfigData", (Throwable)e);
            MLog.info((Object)"TeamMultiGameConfigData", (String)"parseItem value %s", (Object[])new Object[]{data2});
        }
    }

    public GameConfigItem getGame(String gameId) {
        return this.mGameConfigs.get(gameId);
    }

    static {
        sGameKeys.add("wolfgame");
    }

    @DontProguardClass
    public static class GameConfigItem {
        private String gamename;
        private String gameid;
        private int gamebackbtnshow;
        private int guideswitch;
        private String modeCenterGuide;
        private List<TemplateListBean> templateList;

        public String getGamename() {
            return this.gamename;
        }

        public void setGamename(String gamename) {
            this.gamename = gamename;
        }

        public String getGameid() {
            return this.gameid;
        }

        public void setGameid(String gameid) {
            this.gameid = gameid;
        }

        public int getGamebackbtnshow() {
            return this.gamebackbtnshow;
        }

        public void setGamebackbtnshow(int gamebackbtnshow) {
            this.gamebackbtnshow = gamebackbtnshow;
        }

        public int getGuideswitch() {
            return this.guideswitch;
        }

        public void setGuideswitch(int guideswitch) {
            this.guideswitch = guideswitch;
        }

        public List<TemplateListBean> getTemplateList() {
            return this.templateList;
        }

        public void setTemplateList(List<TemplateListBean> templateList) {
            this.templateList = templateList;
        }

        public String getModeCenterGuide() {
            return this.modeCenterGuide;
        }

        public void setModeCenterGuide(String modeCenterGuide) {
            this.modeCenterGuide = modeCenterGuide;
        }

        @DontProguardClass
        public static class TemplateListBean {
            private int id;
            private String bgurl;
            private String bgurlLandscape;
            private int bgurlninepatch;
            private int facebooklogintype;
            private String guideurl;
            private String shareurl;
            private String sharetitle;
            private String sharesubtitle;
            private String shareimage;
            private String sharecontent;

            public int getId() {
                return this.id;
            }

            public void setId(int id2) {
                this.id = id2;
            }

            public String getBgurl() {
                return this.bgurl;
            }

            public void setBgurl(String bgurl) {
                this.bgurl = bgurl;
            }

            public String getBgurlLandscape() {
                return this.bgurlLandscape;
            }

            public void setBgurlLandscape(String bgurlLandscape) {
                this.bgurlLandscape = bgurlLandscape;
            }

            public int getBgurlninepatch() {
                return this.bgurlninepatch;
            }

            public void setBgurlninepatch(int bgurlninepatch) {
                this.bgurlninepatch = bgurlninepatch;
            }

            public int getFacebooklogintype() {
                return this.facebooklogintype;
            }

            public void setFacebooklogintype(int facebooklogintype) {
                this.facebooklogintype = facebooklogintype;
            }

            public String getGuideurl() {
                return this.guideurl;
            }

            public void setGuideurl(String guideurl) {
                this.guideurl = guideurl;
            }

            public String getShareurl() {
                return this.shareurl;
            }

            public void setShareurl(String shareurl) {
                this.shareurl = shareurl;
            }

            public String getSharetitle() {
                return this.sharetitle;
            }

            public void setSharetitle(String sharetitle) {
                this.sharetitle = sharetitle;
            }

            public String getSharesubtitle() {
                return this.sharesubtitle;
            }

            public void setSharesubtitle(String sharesubtitle) {
                this.sharesubtitle = sharesubtitle;
            }

            public String getShareimage() {
                return this.shareimage;
            }

            public void setShareimage(String shareimage) {
                this.shareimage = shareimage;
            }

            public String getSharecontent() {
                return this.sharecontent;
            }

            public void setSharecontent(String sharecontent) {
                this.sharecontent = sharecontent;
            }
        }
    }
}

