/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import com.google.gson.annotations.SerializedName;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TeamGameMatchMsgsConfig
extends AConfigData {
    private static final String DEFAULT_KEY = "default";
    private Map<String, TeamMatchMsgs> msgsMap = new HashMap<String, TeamMatchMsgs>();

    @Override
    public BssCode getBssCode() {
        return BssCode.TEAM_GAME_MATCH_MSGS;
    }

    @Override
    public void parseConfig(String configs) {
        if (StringUtils.isNotEmpty((String)configs)) {
            try {
                List list = JsonParser.parseJsonList((String)configs, TeamMatchMsgs.class);
                if (list != null && !list.isEmpty()) {
                    for (TeamMatchMsgs matchMsgs : list) {
                        if (matchMsgs == null) continue;
                        this.msgsMap.put(matchMsgs.gameId, matchMsgs);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public TeamMatchMsgs getTeamMsgs(String key, boolean notExistReturnDefault) {
        TeamMatchMsgs matchMsgs = null;
        if (StringUtils.isEmpty((String)key) && notExistReturnDefault) {
            matchMsgs = this.msgsMap.get(DEFAULT_KEY);
            return matchMsgs;
        }
        if (StringUtils.isNotEmpty((String)key) && (matchMsgs = this.msgsMap.get(key)) == null && notExistReturnDefault) {
            matchMsgs = this.msgsMap.get(DEFAULT_KEY);
        }
        return matchMsgs;
    }

    public static final class TeamMatchMsgs {
        @SerializedName(value="gameId")
        private String gameId;
        @SerializedName(value="msgs")
        private List<String> msgs;

        public List<String> getMsgs() {
            return this.msgs;
        }
    }
}

