/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import com.google.gson.annotations.SerializedName;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.json.JsonParser;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ShareConfig
extends AConfigData {
    private static final String TAG = "ShareConfig";
    private static final String DEFAULT_LANG = "en";
    ConcurrentHashMap<String, ShareConfigData> shareConfigDataConcurrentHashMap = new ConcurrentHashMap();

    @Override
    public BssCode getBssCode() {
        return BssCode.SHARE_CONFIG;
    }

    @Override
    public void parseConfig(String configs) {
        if (RuntimeContext.sIsDebuggable && configs != null) {
            MLog.info((Object)TAG, (String)("configs = " + configs), (Object[])new Object[0]);
        }
        try {
            List configDataList = JsonParser.parseJsonList((String)configs, ShareConfigData.class);
            for (ShareConfigData shareConfigData : configDataList) {
                this.shareConfigDataConcurrentHashMap.put(shareConfigData.getLanguageId(), shareConfigData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ShareConfigData getShareConfigByLang(String lang) {
        if (this.shareConfigDataConcurrentHashMap.get(lang) != null) {
            return this.shareConfigDataConcurrentHashMap.get(lang);
        }
        return this.shareConfigDataConcurrentHashMap.get(DEFAULT_LANG);
    }

    @DontProguardClass
    public class ShareConfigData {
        private String languageId;
        private String content;
        @SerializedName(value="download_url")
        private String mDownloadUrl;
        @SerializedName(value="image_url")
        private String mImageUrl;
        private Map<String, Map<String, String>> ext;

        public String getLanguageId() {
            return this.languageId;
        }

        public void setLanguageId(String languageId) {
            this.languageId = languageId;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getDownloadUrl() {
            return this.mDownloadUrl;
        }

        public void setDownloadUrl(String downloadUrl) {
            this.mDownloadUrl = downloadUrl;
        }

        public String getImageUrl() {
            return this.mImageUrl;
        }

        public void setImageUrl(String imageUrl) {
            this.mImageUrl = imageUrl;
        }

        public Map<String, String> getExtByKey(String key) {
            if (this.ext != null) {
                return this.ext.get(key);
            }
            return null;
        }
    }
}

