/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import android.text.TextUtils;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.json.JsonParser;
import java.util.List;

public class RecommendGameConfig
extends AConfigData {
    public static final String TAG = "RecommendGameConfig";
    @SerializedName(value="banner")
    private List<RecommendBanner> bannerList;
    @SerializedName(value="dynamic_cover")
    private List<RecommendCover> coverList;

    @Override
    public void parseConfig(String configs) {
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)TAG, (String)"configs %s", (Object[])new Object[]{configs});
        }
        if (TextUtils.isEmpty((CharSequence)configs) || AccountUtil.getUid() <= 0L) {
            MLog.info((Object)TAG, (String)"config does not have list", (Object[])new Object[0]);
            return;
        }
        try {
            RecommendGameConfig gameConfig = (RecommendGameConfig)JsonParser.parseJsonObject((String)configs, RecommendGameConfig.class);
            if (gameConfig != null) {
                this.bannerList = gameConfig.bannerList;
                this.coverList = gameConfig.coverList;
            }
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)"json parse exception : %s", (Object[])new Object[]{e});
        }
    }

    public List<RecommendBanner> getBannerList() {
        return this.bannerList;
    }

    public List<RecommendCover> getCoverList() {
        return this.coverList;
    }

    @Override
    public BssCode getBssCode() {
        return BssCode.RECOMMEND_GAMES;
    }

    @DontProguardClass
    public static class RecommendCover {
        public String id;
        public String videoUrl;
        public boolean isSatisfy = true;

        public String toString() {
            return "[id = " + this.id + "\nvideoUrl = " + this.videoUrl + "\nisSatisfy = " + this.isSatisfy + "]";
        }
    }

    @DontProguardClass
    public static class RecommendBanner {
        public String itemId;
        public String id;
        public String imgUrl;
        public String jumpUri;
        public boolean isSatisfy = true;

        public String toString() {
            return "[id = " + this.id + "\nimgUrl = " + this.imgUrl + "\njumpUri = " + this.jumpUri + "\nisSatisfy = " + this.isSatisfy + "]";
        }
    }
}

