/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import org.json.JSONException;
import org.json.JSONObject;

public class PerformanceConfigData
extends AConfigData {
    private static final String TAG = "PerformanceConfigData";

    @Override
    public BssCode getBssCode() {
        return BssCode.PERFORMANCE_CONFIG;
    }

    @Override
    public boolean recycleAfterParse() {
        return true;
    }

    @Override
    public void parseConfig(String configs) {
        this.parsePerfConfig(configs);
    }

    private void parsePerfConfig(String config) {
        block17: {
            if (StringUtils.isEmpty((String)config)) {
                MLog.info((Object)TAG, (String)"config empty!", (Object[])new Object[0]);
                return;
            }
            this.mConfigContent = config;
            if (RuntimeContext.sIsDebuggable) {
                MLog.info((Object)TAG, (String)"config:%s", (Object[])new Object[]{config});
            } else {
                MLog.info((Object)TAG, (String)"config size:%d", (Object[])new Object[]{config.length()});
            }
            try {
                JSONObject jo = JsonParser.obtainJSONObject((String)config);
                this.parseBoolValueToKeysAndValues(jo, "autorecycle");
                this.parseIntValueToKeysAndValues(jo, "loglevel");
                this.parseIntValueToKeysAndValues(jo, "lowloglevel");
                this.parseIntValueToKeysAndValues(jo, "lowphoneact");
                this.parseIntValueToKeysAndValues(jo, "bigimagerecyclesize");
                this.parseBoolValueToKeysAndValues(jo, "bigimagerecycle");
                this.parseBoolValueToKeysAndValues(jo, "exitkill");
                this.parseBoolValueToKeysAndValues(jo, "xiaoxiaolerecord");
                this.parseBoolValueToKeysAndValues(jo, "collectdownload");
                this.parseIntValueToKeysAndValues(jo, "gamecachemaxsize");
                this.parseBoolValueToKeysAndValues(jo, "wsclientgzip");
                this.parseBoolValueToKeysAndValues(jo, "storeasize");
                this.parseBoolValueToKeysAndValues(jo, "msgcollect");
                this.parseBoolValueToKeysAndValues(jo, "msglistcollect");
                this.parseIntValueToKeysAndValues(jo, "msglisttime");
                this.parseBoolValueToKeysAndValues(jo, "globalperfcollect");
                this.parseBoolValueToKeysAndValues(jo, "usewebp");
                this.parseBoolValueToKeysAndValues(jo, "pkmatchretry");
                this.parseIntValueToKeysAndValues(jo, "pkmatchtime");
                this.parseIntValueToKeysAndValues(jo, "globalpcreporttime");
                this.parseIntValueToKeysAndValues(jo, "globalpcsavetime");
                this.parseBoolValueToKeysAndValues(jo, "globalpcjudgewin");
                this.parseBoolValueToKeysAndValues(jo, "globalnetimage");
                this.parseBoolValueToKeysAndValues(jo, "globalnetimagenew");
                this.parseBoolValueToKeysAndValues(jo, "globalnetws");
                this.parseBoolValueToKeysAndValues(jo, "globalnethttp");
                this.parseBoolValueToKeysAndValues(jo, "gameuseclientws");
                this.parseIntValueToKeysAndValues(jo, "facebooklogintype");
                this.parseBoolValueToKeysAndValues(jo, "normalmetric");
                this.parseIntValueToKeysAndValues(jo, "normalmetricpercent");
                this.parseBoolValueToKeysAndValues(jo, "perfmetric");
                this.parseIntValueToKeysAndValues(jo, "perfmetricpercent");
                this.parseBoolValueToKeysAndValues(jo, "nethttpmetric");
                this.parseIntValueToKeysAndValues(jo, "nethttpmetricpercent");
                this.parseBoolValueToKeysAndValues(jo, "netwsmetric");
                this.parseIntValueToKeysAndValues(jo, "netwsmetricpercent");
                this.parseBoolValueToKeysAndValues(jo, "useoldfeedback");
                this.parseBoolValueToKeysAndValues(jo, "facebookloginprotect");
                this.parseBoolValueToKeysAndValues(jo, "googleloginprotect");
                this.parseBoolValueToKeysAndValues(jo, "shortcuts");
                this.parseBoolValueToKeysAndValues(jo, "instagrams");
                this.parseBoolValueToKeysAndValues(jo, "gameprotect");
                this.parseBoolValueToKeysAndValues(jo, "application_crash_swit");
                this.parseStringValueToKeysAndValues(jo, "patch_host");
                this.parseBoolValueToKeysAndValues(jo, "imageusehttp");
                this.parseBoolValueToKeysAndValues(jo, "usehttpprotect");
                this.parseBoolValueToKeysAndValues(jo, "lrrretryswitch");
                this.parseIntValueToKeysAndValues(jo, "lrrretrytimes");
                this.parseIntValueToKeysAndValues(jo, "lrrfirstct");
                this.parseIntValueToKeysAndValues(jo, "lrrsecondct");
                this.parseIntValueToKeysAndValues(jo, "lrrfthreect");
                this.parseIntValueToKeysAndValues(jo, "second_friend_list_switch");
                this.parseBoolValueToKeysAndValues(jo, "crashfd");
                this.parseBoolValueToKeysAndValues(jo, "crashsvg");
                this.parseIntValueToKeysAndValues(jo, "logintipstype");
                this.parseBoolValueToKeysAndValues(jo, "useoldLangselect");
                this.parseBoolValueToKeysAndValues(jo, "hiidoinitapp");
                this.parseBoolValueToKeysAndValues(jo, "loginuseip");
                this.parseBoolValueToKeysAndValues(jo, "checkwhenneterror");
                this.parseBoolValueToKeysAndValues(jo, "shownetunavailabletips");
                this.parseBoolValueToKeysAndValues(jo, "googleloginnetretry");
                this.parseIntValueToKeysAndValues(jo, "wsctout");
                this.parseIntValueToKeysAndValues(jo, "yyvoice_room_adjust_value");
                this.parseIntValueToKeysAndValues(jo, "room_screen_send_frequency");
                this.parseBoolValueToKeysAndValues(jo, "hywebpre");
                this.parseIntValueToKeysAndValues(jo, "hago_photo_switch");
                this.parseBoolValueToKeysAndValues(jo, "network_diagnosis");
                this.parseBoolValueToKeysAndValues(jo, "httpipretry");
                this.parseBoolValueToKeysAndValues(jo, "heartToCproxy");
                this.parseIntValueToKeysAndValues(jo, "netdiag_errortimes");
                this.parseBoolValueToKeysAndValues(jo, "enable_audio_high_quality");
                this.parseBoolValueToKeysAndValues(jo, "enable_media_mode");
                this.parseBoolValueToKeysAndValues(jo, "enable_prefetch_stream");
                this.parseBoolValueToKeysAndValues(jo, "key_isSupportLinkMic");
                this.parseBoolValueToKeysAndValues(jo, "key_isSupportLinkMicHago");
                this.parseIntValueToKeysAndValues(jo, "key_linkmic_delaytimer");
                this.parseIntValueToKeysAndValues(jo, "voice_media_coding_rate");
                this.parseIntValueToKeysAndValues(jo, "voice_media_coding_rate_b");
                this.parseIntValueToKeysAndValues(jo, "voice_commute_mode");
                this.parseBoolValueToKeysAndValues(jo, "mute_invalid_audio");
                this.parseBoolValueToKeysAndValues(jo, "delete_expired_msg");
                this.parseBoolValueToKeysAndValues(jo, "ktv_singers_only_show_all");
                this.parseBoolValueToKeysAndValues(jo, "samecity_list_city_from_geocoder");
                this.parseBoolValueToKeysAndValues(jo, "ktv_composer_and_writer_show");
                this.parseBoolValueToKeysAndValues(jo, "session_page_delay");
                this.parseBoolValueToKeysAndValues(jo, "gameproxycollect");
                this.parseBoolValueToKeysAndValues(jo, "dnscollect");
                this.parseBoolValueToKeysAndValues(jo, "accountlogin");
                this.parseBoolValueToKeysAndValues(jo, "md5string");
                this.parseIntValueToKeysAndValues(jo, "test_net_switch");
                this.parseStringValueToKeysAndValues(jo, "test_net_url");
                this.parseStringValueToKeysAndValues(jo, "test_net_quic_url");
                this.parseStringValueToKeysAndValues(jo, "test_net_tlsv1_3_url");
                this.parseIntValueToKeysAndValues(jo, "test_net_body_length");
                this.parseStringValueToKeysAndValues(jo, "test_net_host");
                this.parseIntValueToKeysAndValues(jo, "test_net_method");
                this.parseStringValueToKeysAndValues(jo, "test_net_uri_list");
                this.parseStringValueToKeysAndValues(jo, "test_net_quic_percent");
                this.parseStringValueToKeysAndValues(jo, "test_net_host_map");
                this.parseStringValueToKeysAndValues(jo, "test_net_need_stat");
                this.parseBoolValueToKeysAndValues(jo, "cdn_switch");
                this.parseStringValueToKeysAndValues(jo, "cdn_host_list_percent");
                this.parseBoolValueToKeysAndValues(jo, "hywebpre");
                this.parseBoolValueToKeysAndValues(jo, "hywebinterept");
                this.parseBoolValueToKeysAndValues(jo, "hywebpendantinterept");
                this.parseIntValueToKeysAndValues(jo, "webpreloadNum");
                this.parseIntValueToKeysAndValues(jo, "storage_warning_value");
                this.parseBoolValueToKeysAndValues(jo, "cunreadrefresh");
                this.parseIntValueToKeysAndValues(jo, "googlelogintype");
                this.parseBoolValueToKeysAndValues(jo, "imagegetusewangsu");
                this.parseBoolValueToKeysAndValues(jo, "openserverproxy");
                this.parseBoolValueToKeysAndValues(jo, "normalhttpproxyback");
                this.parseIntValueToKeysAndValues(jo, "serverpingtimegap");
                this.parseIntValueToKeysAndValues(jo, "proxyjudgetype");
                this.parseBoolValueToKeysAndValues(jo, "usesystemping");
                this.parseBoolValueToKeysAndValues(jo, "cdndownloadusehttp");
                this.parseBoolValueToKeysAndValues(jo, "webviewhardware");
                this.parseBoolValueToKeysAndValues(jo, "collecttemporarydata");
                this.parseBoolValueToKeysAndValues(jo, "httpconnectionretry");
                this.parseBoolValueToKeysAndValues(jo, "imageloaderusenewpool");
                this.parseBoolValueToKeysAndValues(jo, "gamehttpusenewpool");
                this.parseBoolValueToKeysAndValues(jo, "httptimeoutswitch");
                this.parseStringValueToKeysAndValues(jo, "httptimeoutvalue");
                this.parseIntValueToKeysAndValues(jo, "useconnectpollpercent");
                this.parseIntValueToKeysAndValues(jo, "clearconnectpollwhenerror");
                this.parseBoolValueToKeysAndValues(jo, "crashprotectswitch");
                this.parseBoolValueToKeysAndValues(jo, "yytaskcrashreport2");
                this.parseIntValueToKeysAndValues(jo, "yytaskexetimeout");
                this.parseIntValueToKeysAndValues(jo, "yytaskwaittimeout");
                this.parseIntValueToKeysAndValues(jo, "crashprotecttimes");
                this.parseIntValueToKeysAndValues(jo, "slientdownloadlimit");
                this.parseBoolValueToKeysAndValues(jo, "KLCWSSO");
                this.parseBoolValueToKeysAndValues(jo, "KSAHF");
                this.parseBoolValueToKeysAndValues(jo, "KLCWSSO");
                this.parseBoolValueToKeysAndValues(jo, "open_memory_log");
                this.parseIntValueToKeysAndValues(jo, "crash_log_size");
                this.parseIntValueToKeysAndValues(jo, "radio_live_code_rate");
                this.parseBoolValueToKeysAndValues(jo, "radio_anchor_use_high_quality");
                this.parseIntValueToKeysAndValues(jo, "radioWatchCheck");
                this.parseBoolValueToKeysAndValues(jo, "groupmetrics");
                this.parseBoolValueToKeysAndValues(jo, "webviewreuse");
                this.parseBoolValueToKeysAndValues(jo, "webprerender");
                this.parseBoolValueToKeysAndValues(jo, "ktvmetrics");
                this.parseBoolValueToKeysAndValues(jo, "svgaautopause");
                this.parseStringValueToKeysAndValues(jo, "ingrayver");
                this.parseBoolValueToKeysAndValues(jo, "key_proce_hot_switch");
                this.parseBoolValueToKeysAndValues(jo, "key_loginfnap");
                this.parseIntValueToKeysAndValues(jo, "httperrorpercent");
                this.parseBoolValueToKeysAndValues(jo, "delay_register_non_core_controllers");
                this.parseBoolValueToKeysAndValues(jo, "keybbson");
                this.parseBoolValueToKeysAndValues(jo, "enable_window_swipe");
                this.parseBoolValueToKeysAndValues(jo, "x2c_switch");
                this.parseBoolValueToKeysAndValues(jo, "key_user_enter_action_switch");
                this.parseBoolValueToKeysAndValues(jo, "starupidlequeue");
                this.parseBoolValueToKeysAndValues(jo, "anruploadlogs");
                this.parseBoolValueToKeysAndValues(jo, "countryusehago");
                this.parseBoolValueToKeysAndValues(jo, "keyGameThreadInspector");
                this.parseBoolValueToKeysAndValues(jo, "keyAsyncDestroySlObject");
                this.parseBoolValueToKeysAndValues(jo, "keyAsyncWriteV8Bytecode");
                this.parseBoolValueToKeysAndValues(jo, "keyDbInSubThread");
                this.parseBoolValueToKeysAndValues(jo, "webincremental");
                this.parseBoolValueToKeysAndValues(jo, "key_removetoken_by_host");
                this.parseBoolValueToKeysAndValues(jo, "wsTokenProtectNew");
                this.parseBoolValueToKeysAndValues(jo, "keyUseExecutorNew2");
                this.parseBoolValueToKeysAndValues(jo, "keynetopenthreadopt");
                this.parseBoolValueToKeysAndValues(jo, "keysharepref_monitor");
                this.parseBoolValueToKeysAndValues(jo, "threadPriorityAdjust");
                this.parseIntValueToKeysAndValues(jo, "thread_pool_type_new");
                this.parseIntValueToKeysAndValues(jo, "thread_pool_all_use_scheduled");
                this.parseIntValueToKeysAndValues(jo, "window_invisible_opt");
                this.parseBoolValueToKeysAndValues(jo, "keyfixsplashshow");
                this.parseBoolValueToKeysAndValues(jo, "pageview_recovery_opt2");
                this.parseIntValueToKeysAndValues(jo, "homepagepreload_opt");
                this.parseBoolValueToKeysAndValues(jo, "keyvoiceandtextchannelExist");
                this.parseIntValueToKeysAndValues(jo, "videoshowreactiontime");
                this.parseBoolValueToKeysAndValues(jo, "adjustensureradippresenter");
                this.parseBoolValueToKeysAndValues(jo, "wsrequestresend");
                this.parseBoolValueToKeysAndValues(jo, "andPermissionFix");
                this.parseBoolValueToKeysAndValues(jo, "key_is_udbtwo_enable");
                this.parseBoolValueToKeysAndValues(jo, "imageemptyurl2");
                this.parseBoolValueToKeysAndValues(jo, "imageuseourexcutornew");
                this.parseBoolValueToKeysAndValues(jo, "imagedecodefix");
                this.parseBoolValueToKeysAndValues(jo, "enableclearpresenter");
                this.parseBoolValueToKeysAndValues(jo, "yytaskexecutefix");
                this.parseBoolValueToKeysAndValues(jo, "windowattacheventadjust");
                this.parseIntValueToKeysAndValues(jo, "hometabrecycle");
                this.parseIntValueToKeysAndValues(jo, "viewrecycletype");
                this.parseBoolValueToKeysAndValues(jo, "channellogswitch");
                this.parseBoolValueToKeysAndValues(jo, "miniviewshowtimeadjust");
                this.parseIntValueToKeysAndValues(jo, "heart_monitor_times_in_three_min");
                this.parseBoolValueToKeysAndValues(jo, "heart_monitor_stat_retry");
                this.parseBoolValueToKeysAndValues(jo, "heart_monitor_open_retry");
                this.parseBoolValueToKeysAndValues(jo, "key_hiido_group_report");
                this.parseBoolValueToKeysAndValues(jo, "float_notify_toast_priority_switch");
                this.parseBoolValueToKeysAndValues(jo, "key_log_upload");
                this.parseStringValueToKeysAndValues(jo, "udb_hosts");
                this.parseBoolValueToKeysAndValues(jo, "revenuesdk_v3");
                this.parseBoolValueToKeysAndValues(jo, "notify_size");
                this.parseIntValueToKeysAndValues(jo, "game_home_crash");
                this.parseBoolValueToKeysAndValues(jo, "key_auto_recycle_svga");
                this.parseBoolValueToKeysAndValues(jo, "page_speed_monitor_three_enable");
                this.parseBoolValueToKeysAndValues(jo, "server_not_found_enable_1");
                this.parseBoolValueToKeysAndValues(jo, "basic_perf_sample_three_enable");
                this.parseBoolValueToKeysAndValues(jo, "basic_perf_fps_sample_three_enable");
                this.parseBoolValueToKeysAndValues(jo, "page_response_op_enable");
                this.parseBoolValueToKeysAndValues(jo, "business_risk_enable");
                this.parseBoolValueToKeysAndValues(jo, "business_super_risk_enable");
                this.parseBoolValueToKeysAndValues(jo, "use_our_executor_enable");
                this.parseBoolValueToKeysAndValues(jo, "use_bg_timer_handler_enable");
                this.parseBoolValueToKeysAndValues(jo, "use_new_thread_priority_enable");
                this.parseBoolValueToKeysAndValues(jo, "hook_thread_pool_two_enable");
                this.parseBoolValueToKeysAndValues(jo, "hook_handler_thread_enable");
                this.parseBoolValueToKeysAndValues(jo, "abtest_op_enable");
                this.parseBoolValueToKeysAndValues(jo, "hook_one_thread_two_enable");
                this.parseBoolValueToKeysAndValues(jo, "page_response_thread_op_three_enable");
                this.parseIntValueToKeysAndValues(jo, "key_download_limited_speed");
                this.parseIntValueToKeysAndValues(jo, "key_download_normal_speed");
                this.parseBoolValueToKeysAndValues(jo, "split_rpc_set");
                this.parseBoolValueToKeysAndValues(jo, "enable_multi_video_base_beauty");
                int logLevel = this.getIntValue("loglevel", -1);
                int lowLogLevel = this.getIntValue("lowloglevel", -1);
                if (logLevel != -1) {
                    SettingFlags.setIntValue((String)"loglevel", (int)logLevel);
                }
                if (lowLogLevel != -1) {
                    SettingFlags.setIntValue((String)"lowloglevel", (int)lowLogLevel);
                }
                if (this.containsKey("recycleimageOn")) {
                    boolean actSuperLowPhoneSwitch = this.getBoolValue("recycleimageOn", false);
                    SettingFlags.setBoolean((String)"recycleimageOn", (boolean)actSuperLowPhoneSwitch);
                }
                if (this.containsKey("bigimagerecycle")) {
                    boolean bigImageRecycleSwitch = this.getBoolValue("bigimagerecycle", false);
                    SettingFlags.setBoolean((String)"bigimagerecycle", (boolean)bigImageRecycleSwitch);
                }
                if (this.containsKey("autorecycle")) {
                    boolean localResRecycle = this.getBoolValue("autorecycle", true);
                    SettingFlags.setBoolean((String)"localresrecycle", (boolean)localResRecycle);
                }
                if (this.containsKey("exitkill")) {
                    SettingFlags.setBoolean((String)"exitkillprocess", (boolean)this.getBoolValue("exitkill", true));
                }
                if (this.containsKey("collectdownload")) {
                    SettingFlags.setBoolean((String)"collectdownload", (boolean)this.getBoolValue("collectdownload", true));
                }
                if (this.containsKey("gamecachemaxsize")) {
                    int size = this.getIntValue("gamecachemaxsize", 100);
                    if (size < 50) {
                        size = 50;
                    }
                    SettingFlags.setIntValue((String)"gamecachemaxsize", (int)size);
                }
                if (this.containsKey("wsclientgzip")) {
                    SettingFlags.setBoolean((String)"wsclientgzip", (boolean)this.getBoolValue("wsclientgzip", true));
                }
                this.saveBoolValueToSettingFlags("keyUseExecutorNew2", "keyUseExecutorNew2", false);
                this.saveBoolValueToSettingFlags("keynetopenthreadopt", "keynetopenthreadopt", true);
                this.saveBoolValueToSettingFlags("threadPriorityAdjust", "threadPriorityAdjust", true);
                this.saveIntValueToSettingFlags("thread_pool_type_new", "thread_pool_type_new", 3);
                this.saveIntValueToSettingFlags("thread_pool_all_use_scheduled", "thread_pool_all_use_scheduled", 1);
                this.saveIntValueToSettingFlags("window_invisible_opt", "window_invisible_opt", 0);
                this.saveBoolValueToSettingFlags("pageview_recovery_opt2", "pageview_recovery_opt2", true);
                this.saveIntValueToSettingFlags("homepagepreload_opt", "homepagepreload_opt", -1);
                this.saveBoolValueToSettingFlags("keyfixsplashshow", "keyfixsplashshow", true);
                this.saveBoolValueToSettingFlags("keysharepref_monitor", "keysharepref_monitor", true);
                this.saveBoolValueToSettingFlags("globalperfcollect", "globalperfcollect", false);
                this.saveBoolValueToSettingFlags("msgcollect", "msgcollect", false);
                this.saveBoolValueToSettingFlags("msglistcollect", "msglistcollect", false);
                this.saveIntValueToSettingFlags("msglisttime", "msglisttime", 300);
                this.saveBoolValueToSettingFlags("usewebp", "usewebp", true);
                this.saveBoolValueToSettingFlags("storeasize", "checksasize", true);
                this.saveBoolValueToSettingFlags("countryusehago", "countryusehago", true);
                this.saveIntValueToSettingFlags("pkmatchtime", "pkmatchgametime", 8);
                this.saveBoolValueToSettingFlags("pkmatchretry", "pkmatchgameretry", true);
                this.saveBoolValueToSettingFlags("globalpcjudgewin", "globalpcjudgewin", true);
                this.saveIntValueToSettingFlags("globalpcsavetime", "globalpcsavetime", 8000);
                this.saveIntValueToSettingFlags("globalpcreporttime", "globalpcreporttime", 300000);
                this.saveBoolValueToSettingFlags("globalnetimage", "globalnetimage", false);
                this.saveBoolValueToSettingFlags("keyGameThreadInspector", "keyGameThreadInspector", false);
                this.saveBoolValueToSettingFlags("keyAsyncDestroySlObject", "keyAsyncDestroySlObject", true);
                this.saveBoolValueToSettingFlags("keyAsyncWriteV8Bytecode", "keyAsyncWriteV8Bytecode", true);
                this.saveBoolValueToSettingFlags("keyDbInSubThread", "keyDbInSubThread", true);
                this.saveBoolValueToSettingFlags("globalnetimagenew", "globalnetimagenew", false);
                this.saveBoolValueToSettingFlags("globalnethttp", "globalnethttp", false);
                this.saveBoolValueToSettingFlags("globalnetws", "globalnetws", false);
                this.saveBoolValueToSettingFlags("gameuseclientws", "gameuseclientws", true);
                this.saveIntValueToSettingFlags("facebooklogintype", "facebooklogintype", 1);
                this.saveBoolValueToSettingFlags("normalmetric", "normalmetricswitch", true);
                this.saveIntValueToSettingFlags("normalmetricpercent", "normalmetricpercent", 100);
                this.saveBoolValueToSettingFlags("nethttpmetric", "httpmetricswitch", true);
                this.saveIntValueToSettingFlags("nethttpmetricpercent", "httpmetricpercent", 100);
                this.saveBoolValueToSettingFlags("netwsmetric", "wsmetricswitch", true);
                this.saveIntValueToSettingFlags("netwsmetricpercent", "wsmetricpercent", 100);
                this.saveBoolValueToSettingFlags("perfmetric", "perfmetricswitch", true);
                this.saveIntValueToSettingFlags("perfmetricpercent", "perfmetricpercent", 100);
                this.saveBoolValueToSettingFlags("googleloginnetretry", "gloginnetretry", false);
                this.saveBoolValueToSettingFlags("googleloginprotect", "googleloginprotect", false);
                this.saveBoolValueToSettingFlags("facebookloginprotect", "facebookloginprotect", false);
                this.saveBoolValueToSettingFlags("instagrams", "instagram", true);
                this.saveBoolValueToSettingFlags("shortcuts", "shortcutswitch", true);
                this.saveBoolValueToSettingFlags("gameprotect", "gameprotect", true);
                this.saveBoolValueToSettingFlags("application_crash_swit", "application_crash_swit", false);
                this.saveStringValueToSettingFlags("patch_host", "patch_host");
                this.saveBoolValueToSettingFlags("imageusehttp", "imageusehttp", true);
                this.saveBoolValueToSettingFlags("usehttpprotect", "usehttpprotect", true);
                this.saveIntValueToSettingFlags("second_friend_list_switch", "second_friend_list_switch", 0);
                this.saveBoolValueToSettingFlags("crashfd", "crashcfd", false);
                this.saveBoolValueToSettingFlags("crashsvg", "crashsvg", true);
                this.saveIntValueToSettingFlags("logintipstype", "logintipstype", 1);
                this.saveBoolValueToSettingFlags("useoldLangselect", "useoldgamelangselect", false);
                this.saveBoolValueToSettingFlags("hiidoinitapp", "hiidoinitapp", false);
                this.saveBoolValueToSettingFlags("loginuseip", "loginuseip", true);
                this.saveBoolValueToSettingFlags("checkwhenneterror", "checkwhenneterror", true);
                this.saveBoolValueToSettingFlags("shownetunavailabletips", "shownetunavailabletips", true);
                this.saveIntValueToSettingFlags("wsctout", "wsctout", 10000);
                this.saveIntValueToSettingFlags("yyvoice_room_adjust_value", "yyvoice_room_value", 10);
                this.saveBoolValueToSettingFlags("hywebpre", "hywebpre", false);
                this.saveBoolValueToSettingFlags("hywebinterept", "hywebinterept", true);
                this.saveBoolValueToSettingFlags("hywebpendantinterept", "hywebpendantinterept", true);
                this.saveIntValueToSettingFlags("room_screen_send_frequency", "room_screen_send_frequency", 3000);
                this.saveIntValueToSettingFlags("hago_photo_switch", "hago_photo_switch", 0);
                this.saveBoolValueToSettingFlags("network_diagnosis", "network_diagnosis", false);
                this.saveBoolValueToSettingFlags("httpipretry", "httpipretry", false);
                this.saveBoolValueToSettingFlags("heartToCproxy", "heartToCproxy", false);
                this.saveIntValueToSettingFlags("netdiag_errortimes", "netdiag_errortimes", 5);
                this.saveBoolValueToSettingFlags("session_page_delay", "session_page_delay", false);
                this.saveBoolValueToSettingFlags("gameproxycollect", "gameproxycollect", false);
                this.saveBoolValueToSettingFlags("dnscollect", "dnscollect", false);
                this.saveBoolValueToSettingFlags("md5string", "md5string", true);
                this.parseIntValueToKeysAndValues(jo, "test_net_dns_switch");
                this.saveStringValueToSettingFlags("test_net_url", "test_net_url");
                this.saveIntValueToSettingFlags("test_net_body_length", "test_net_body_length", 0);
                this.saveStringValueToSettingFlags("test_net_host", "test_net_host");
                this.saveIntValueToSettingFlags("test_net_method", "test_net_method", 0);
                this.saveStringValueToSettingFlags("test_net_uri_list", "test_net_uri_list");
                this.saveIntValueToSettingFlags("test_net_quic_percent", "test_net_quic_percent", 50);
                this.saveStringValueToSettingFlags("test_net_host_map", "test_net_host_map");
                this.saveIntValueToSettingFlags("test_net_need_stat", "test_net_need_stat", 1);
                this.saveBoolValueToSettingFlags("cdn_switch", "cdn_switch", false);
                this.saveStringValueToSettingFlags("cdn_host_list_percent", "cdn_host_list_percent");
                this.saveBoolValueToSettingFlags("accountlogin", "accountlogin", true);
                this.saveIntValueToSettingFlags("webpreloadNum", "webpreloadNum", 3);
                this.saveIntValueToSettingFlags("storage_warning_value", "storage_warning_value", 30);
                this.saveBoolValueToSettingFlags("imagegetusewangsu", "imagegetusewangsu", false);
                this.saveIntValueToSettingFlags("googlelogintype", "googlelogintype", 7);
                this.saveBoolValueToSettingFlags("openserverproxy", "openserverproxy", true);
                this.saveBoolValueToSettingFlags("normalhttpproxyback", "normalhttpproxyback", true);
                this.saveIntValueToSettingFlags("serverpingtimegap", "serverpingtimegap", 30);
                this.saveIntValueToSettingFlags("proxyjudgetype", "proxyjudgetype", 1);
                this.saveBoolValueToSettingFlags("usesystemping", "usesystemping", false);
                this.saveBoolValueToSettingFlags("cdndownloadusehttp", "cdndownloadusehttp", true);
                this.saveBoolValueToSettingFlags("webviewhardware", "webviewhardware", true);
                this.saveBoolValueToSettingFlags("collecttemporarydata", "collecttemporarydata", false);
                this.saveBoolValueToSettingFlags("httpconnectionretry", "httpconnectionretry", false);
                this.saveBoolValueToSettingFlags("imageloaderusenewpool", "imageloaderusenewpool", true);
                this.saveBoolValueToSettingFlags("gamehttpusenewpool", "gamehttpusenewpool", true);
                this.saveBoolValueToSettingFlags("httptimeoutswitch", "httptimeoutswitch", true);
                this.saveStringValueToSettingFlags("httptimeoutvalue", "httptimeoutvalue");
                this.saveIntValueToSettingFlags("useconnectpollpercent", "useconnectpollpercent", 100);
                this.saveIntValueToSettingFlags("clearconnectpollwhenerror", "clearconnectpollwhenerror", 100);
                this.saveBoolValueToSettingFlags("crashprotectswitch", "crashprotectswitch", false);
                this.saveBoolValueToSettingFlags("yytaskcrashreport2", "yytaskcrashreport2", true);
                this.saveIntValueToSettingFlags("yytaskexetimeout", "yytaskexetimeout", 8000);
                this.saveIntValueToSettingFlags("yytaskwaittimeout", "yytaskwaittimeout", 5000);
                this.saveIntValueToSettingFlags("crashprotecttimes", "crashprotecttimes", 2);
                this.saveIntValueToSettingFlags("slientdownloadlimit", "slientdownloadlimit", 100);
                this.saveBoolValueToSettingFlags("KLCWSSO", "KLCWSSO", true);
                this.saveBoolValueToSettingFlags("KSAHF", "KSAHF", true);
                this.saveBoolValueToSettingFlags("KLCWSSO", "KLCWSSO", true);
                this.saveBoolValueToSettingFlags("open_memory_log", "open_memory_log", false);
                this.saveIntValueToSettingFlags("crash_log_size", "crash_log_size", 512);
                this.saveBoolValueToSettingFlags("webviewreuse", "webviewreuse", true);
                this.saveBoolValueToSettingFlags("cunreadrefresh", "cunreadrefresh", true);
                this.saveBoolValueToSettingFlags("webprerender", "webprerender", true);
                this.saveBoolValueToSettingFlags("groupmetrics", "groupmetrics", false);
                this.saveBoolValueToSettingFlags("ktvmetrics", "ktvmetrics", false);
                this.saveBoolValueToSettingFlags("keybbson", "keybbson", false);
                this.saveBoolValueToSettingFlags("svgaautopause", "svgaautopause", false);
                this.saveStringValueToSettingFlags("ingrayver", "ingrayver");
                this.saveBoolValueToSettingFlags("anruploadlogs", "anruploadlogs", true);
                this.saveBoolValueToSettingFlags("key_proce_hot_switch", "key_proce_hot_switch", false);
                this.saveBoolValueToSettingFlags("key_loginfnap", "key_loginfnap", false);
                this.saveIntValueToSettingFlags("httperrorpercent", "httperrorpercent", 0);
                this.saveBoolValueToSettingFlags("delay_register_non_core_controllers", "delay_register_non_core_controllers", false);
                this.saveBoolValueToSettingFlags("enable_window_swipe", "enable_window_swipe", false);
                this.saveIntValueToSettingFlags("radio_live_code_rate", "radio_live_code_rate", 2);
                this.saveIntValueToSettingFlags("radioWatchCheck", "radioWatchCheck", 10000);
                this.saveBoolValueToSettingFlags("radio_anchor_use_high_quality", "radio_anchor_use_high_quality", true);
                this.saveBoolValueToSettingFlags("x2c_switch", "x2c_switch", true);
                this.saveBoolValueToSettingFlags("key_user_enter_action_switch", "key_user_enter_action_switch", true);
                this.saveBoolValueToSettingFlags("starupidlequeue", "starupidlequeue", true);
                this.saveBoolValueToSettingFlags("webincremental", "webincremental", RuntimeContext.isInGray());
                this.saveBoolValueToSettingFlags("key_removetoken_by_host", "key_removetoken_by_host", false);
                this.saveBoolValueToSettingFlags("wsTokenProtectNew", "wsTokenProtectNew", true);
                this.saveBoolValueToSettingFlags("keyvoiceandtextchannelExist", "keyvoiceandtextchannelExist", true);
                this.parseIntValueToKeysAndValues(jo, "bizhong_strategy_query", 7);
                this.parseIntValueToKeysAndValues(jo, "bizhong_strategy_report", 7);
                this.saveIntValueToSettingFlags("bizhong_strategy_query", "bizhong_strategy_query", 7);
                this.saveIntValueToSettingFlags("bizhong_strategy_report", "bizhong_strategy_report", 7);
                this.saveBoolValueToSettingFlags("adjustensureradippresenter", "adjustensureradippresenter", false);
                this.saveBoolValueToSettingFlags("wsrequestresend", "wsrequestresend", false);
                this.saveBoolValueToSettingFlags("andPermissionFix", "andPermissionFix", true);
                this.saveBoolValueToSettingFlags("imageemptyurl2", "imageemptyurl2", false);
                this.saveBoolValueToSettingFlags("imageuseourexcutornew", "imageuseourexcutornew", false);
                this.saveBoolValueToSettingFlags("imagedecodefix", "imagedecodefix", true);
                this.saveBoolValueToSettingFlags("windowattacheventadjust", "windowattacheventadjust", true);
                this.saveBoolValueToSettingFlags("miniviewshowtimeadjust", "miniviewshowtimeadjust", true);
                this.saveBoolValueToSettingFlags("key_is_udbtwo_enable", "key_is_udbtwo_enable", false);
                this.saveStringValueToSettingFlags("udb_hosts", "key_udb_hosts");
                this.saveBoolValueToSettingFlags("key_hiido_group_report", "key_hiido_group_report", false);
                this.saveBoolValueToSettingFlags("key_isSupportLinkMic", "key_isSupportLinkMic", false);
                this.saveIntValueToSettingFlags("key_linkmic_delaytimer", "key_linkmic_delaytimer", 0);
                this.saveBoolValueToSettingFlags("float_notify_toast_priority_switch", "float_notify_toast_priority_switch", false);
                if (RuntimeContext.sIsHagoApp) {
                    this.saveBoolValueToSettingFlags("key_isSupportLinkMic", "key_isSupportLinkMicHago", false);
                } else {
                    this.saveBoolValueToSettingFlags("key_isSupportLinkMic", "key_isSupportLinkMic", false);
                }
                this.saveBoolValueToSettingFlags("key_log_upload", "key_log_upload", false);
                this.saveIntValueToSettingFlags("key_linkmic_delaytimer", "key_linkmic_delaytimer", 0);
                this.saveBoolValueToSettingFlags("key_isSupportLinkMicHago", "key_isSupportLinkMicHago", false);
                this.saveBoolValueToSettingFlags("key_isSupportLinkMic", "key_isSupportLinkMic", false);
                this.saveBoolValueToSettingFlags("key_log_upload", "key_log_upload", false);
                this.saveIntValueToSettingFlags("key_linkmic_delaytimer", "key_linkmic_delaytimer", 0);
                this.saveBoolValueToSettingFlags("delete_expired_msg", "delete_expired_msg", true);
                this.saveBoolValueToSettingFlags("enableclearpresenter", "enableclearpresenter", true);
                this.saveBoolValueToSettingFlags("revenuesdk_v3", "revenuesdk_v3", true);
                this.saveBoolValueToSettingFlags("notify_size", "notify_size", true);
                this.saveIntValueToSettingFlags("game_home_crash", "game_home_crash", 1);
                this.saveBoolValueToSettingFlags("key_auto_recycle_svga", "key_auto_recycle_svga", true);
                this.saveBoolValueToSettingFlags("yytaskexecutefix", "yytaskexecutefix", false);
                this.saveBoolValueToSettingFlags("channellogswitch", "channellogswitch", false);
                this.saveBoolValueToSettingFlags("float_notify_toast_priority_switch", "float_notify_toast_priority_switch", false);
                this.saveIntValueToSettingFlags("hometabrecycle", "hometabrecycle", 0);
                this.saveIntValueToSettingFlags("viewrecycletype", "viewrecycletype", 1);
                this.saveIntValueToSettingFlags("heart_monitor_times_in_three_min", "heart_monitor_times_in_three_min", 25);
                this.saveBoolValueToSettingFlags("heart_monitor_stat_retry", "heart_monitor_stat_retry", true);
                this.saveBoolValueToSettingFlags("heart_monitor_open_retry", "heart_monitor_open_retry", true);
                this.saveBoolValueToSettingFlags("page_speed_monitor_three_enable", "page_speed_monitor_three_enable", false);
                this.saveBoolValueToSettingFlags("server_not_found_enable_1", "server_not_found_enable_1", false);
                this.saveBoolValueToSettingFlags("basic_perf_sample_three_enable", "basic_perf_sample_three_enable", false);
                this.saveBoolValueToSettingFlags("basic_perf_fps_sample_three_enable", "basic_perf_fps_sample_three_enable", false);
                this.saveBoolValueToSettingFlags("page_response_op_enable", "page_response_op_enable", false);
                this.saveBoolValueToSettingFlags("business_risk_enable", "business_risk_enable", false);
                this.saveBoolValueToSettingFlags("business_super_risk_enable", "business_super_risk_enable", false);
                this.saveBoolValueToSettingFlags("use_our_executor_enable", "use_our_executor_enable", false);
                this.saveBoolValueToSettingFlags("use_bg_timer_handler_enable", "use_bg_timer_handler_enable", false);
                this.saveBoolValueToSettingFlags("use_new_thread_priority_enable", "use_new_thread_priority_enable", false);
                this.saveBoolValueToSettingFlags("hook_thread_pool_two_enable", "hook_thread_pool_two_enable", false);
                this.saveBoolValueToSettingFlags("hook_one_thread_two_enable", "hook_one_thread_two_enable", false);
                this.saveBoolValueToSettingFlags("hook_handler_thread_enable", "hook_handler_thread_enable", false);
                this.saveBoolValueToSettingFlags("abtest_op_enable", "abtest_op_enable", false);
                this.saveBoolValueToSettingFlags("page_response_thread_op_three_enable", "page_response_thread_op_three_enable", false);
                this.saveIntValueToSettingFlags("key_download_limited_speed", "key_download_limited_speed", -1);
                this.saveIntValueToSettingFlags("key_download_normal_speed", "key_download_normal_speed", -1);
                this.saveBoolValueToSettingFlags("split_rpc_set", "split_rpc_set", RuntimeContext.isInGray());
                this.saveBoolValueToSettingFlags("enable_multi_video_base_beauty", "enable_multi_video_base_beauty", true);
                SettingFlagBaseKeys.onPerformanceConfigDataUpdated();
                YYTaskExecutor.postToMainThread(() -> NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_PERFORMANCE_UPDATE)));
            }
            catch (JSONException e) {
                MLog.error((Object)TAG, (Throwable)e);
                if (!SystemUtils.isShowEnvSetting()) break block17;
                throw new RuntimeException(e);
            }
        }
    }

    private void saveIntValueToSettingFlags(String perfConfigKey, String settingFlagKey, int defaultValue) {
        if (this.containsKey(perfConfigKey)) {
            try {
                SettingFlags.setIntValue((String)settingFlagKey, (int)this.getIntValue(perfConfigKey, defaultValue));
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
    }

    private void saveBoolValueToSettingFlags(String perfConfigKey, String settingFlagKey, boolean defaultValue) {
        if (this.containsKey(perfConfigKey)) {
            try {
                SettingFlags.setBoolean((String)settingFlagKey, (boolean)this.getBoolValue(perfConfigKey, defaultValue));
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
    }

    private void saveStringValueToSettingFlags(String perfConfigKey, String settingFlagKey) {
        if (this.containsKey(perfConfigKey)) {
            try {
                SettingFlags.setStringValue((String)settingFlagKey, (String)this.getStringValue(perfConfigKey));
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
    }
}

