/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.NotifyFrequencyConfigData;
import com.yy.appbase.unifyconfig.config.NotifyFrequencyConfigItem;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.json.JsonParser;

public class NotifyFrequencyConfig
extends AConfigData {
    private static final String TAG = "NotifyFrequency_Config";
    private static NotifyFrequencyConfigData mData;

    @Override
    public BssCode getBssCode() {
        return BssCode.NOTIFY_FREQUENCY_CONFIG;
    }

    @Override
    public void parseConfig(final String configs) {
        if (StringUtils.isEmpty((String)configs)) {
            MLog.error((Object)TAG, (String)"config is empty!", (Object[])new Object[0]);
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    NotifyFrequencyConfig.this.parseConfigInner(configs);
                }
            }, (long)0L);
        } else {
            this.parseConfigInner(configs);
        }
    }

    private void parseConfigInner(String configs) {
        block4: {
            try {
                mData = (NotifyFrequencyConfigData)JsonParser.parseJsonObject((String)configs, NotifyFrequencyConfigData.class);
                if (SystemUtils.isShowEnvSetting()) {
                    MLog.info((Object)TAG, (String)"parse config: %s", (Object[])new Object[]{configs});
                } else {
                    MLog.info((Object)TAG, (String)"parse config: %d", (Object[])new Object[]{configs.length()});
                }
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"parse config error: %s", (Throwable)e, (Object[])new Object[0]);
                if (!SystemUtils.isShowEnvSetting()) break block4;
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean isTotalSwitchOn() {
        if (mData == null) {
            return false;
        }
        return NotifyFrequencyConfig.mData.swtichOn;
    }

    public static boolean isStatSwitchOn() {
        if (mData == null) {
            return false;
        }
        return NotifyFrequencyConfig.mData.statSwitchOn;
    }

    public static int getCacheExceedLimitNum() {
        if (!NotifyFrequencyConfig.isStatSwitchOn()) {
            return -1;
        }
        if (mData == null || NotifyFrequencyConfig.mData.cacheExceedLimitNum <= 1) {
            return -1;
        }
        return NotifyFrequencyConfig.mData.cacheExceedLimitNum;
    }

    private static NotifyFrequencyConfigItem findItem(String sname, int uri) {
        NotifyFrequencyConfigData data2 = mData;
        if (data2 == null) {
            return null;
        }
        if (!data2.swtichOn) {
            return null;
        }
        if (data2.channels != null && data2.channels.size() > 0 && data2.itemsByChannel != null && data2.itemsByChannel.size() > 0) {
            String curChannel = "";
            RuntimeContext.ChannelHeartItem item = RuntimeContext.getCoexistenceChannel();
            curChannel = item != null && StringUtils.isNotEmpty((String)item.getRoomId()) ? item.getRoomId() : RuntimeContext.getChannelId();
            boolean findChannel = false;
            if (StringUtils.isNotEmpty((String)curChannel)) {
                for (String channelOne : data2.channels) {
                    if (!StringUtils.equal((String)channelOne, (String)curChannel)) continue;
                    findChannel = true;
                    break;
                }
            }
            if (findChannel) {
                for (NotifyFrequencyConfigItem itemOne : data2.itemsByChannel) {
                    if (itemOne == null || !StringUtils.equal((String)itemOne.serviceName, (String)sname) || (uri >= 0 || itemOne.uri >= 0) && itemOne.uri != uri) continue;
                    return itemOne;
                }
            }
        }
        if (data2.items != null && data2.items.size() > 0) {
            NotifyFrequencyConfigItem item = null;
            for (NotifyFrequencyConfigItem itemOne : data2.items) {
                if (itemOne == null || !StringUtils.equal((String)itemOne.serviceName, (String)sname) || (uri >= 0 || itemOne.uri > 0) && itemOne.uri != uri) continue;
                item = itemOne;
                break;
            }
            return item;
        }
        return null;
    }

    public static boolean isFrequencyLimitSwitchOn(String sname) {
        NotifyFrequencyConfigData data2 = mData;
        if (data2 == null) {
            return false;
        }
        if (!data2.swtichOn) {
            return false;
        }
        boolean result = NotifyFrequencyConfig.isFrequencyLimitSwitchOn(sname, -1);
        if (!result) {
            return NotifyFrequencyConfigItem.isSwitchOnByPhoneType(data2.allOpenByPhoneType);
        }
        return true;
    }

    public static boolean isFrequencyLimitSwitchOn(String sname, int uri) {
        NotifyFrequencyConfigItem item = NotifyFrequencyConfig.findItem(sname, uri);
        if (item != null) {
            if (!NotifyFrequencyConfigItem.isSwitchOnByPhoneType(item.swtichOnByPhoneType)) {
                if (uri < 0) {
                    NotifyFrequencyConfigData data2 = mData;
                    if (data2 == null) {
                        return false;
                    }
                    return NotifyFrequencyConfigItem.isSwitchOnByPhoneType(data2.allOpenByPhoneType);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static long getFrequencyTime(String sname, int uri) {
        NotifyFrequencyConfigData data2 = mData;
        if (data2 == null) {
            return -1L;
        }
        if (!data2.swtichOn) {
            return -1L;
        }
        NotifyFrequencyConfigItem item = NotifyFrequencyConfig.findItem(sname, uri);
        if (item != null) {
            return item.frequencyTime > 0L ? item.frequencyTime : 0L;
        }
        return data2.allDefaultFrequencyTime > 0L ? data2.allDefaultFrequencyTime : 0L;
    }

    public static boolean canNotifyList(String sname, int uri) {
        NotifyFrequencyConfigData data2 = mData;
        if (data2 == null) {
            return false;
        }
        if (!data2.swtichOn) {
            return false;
        }
        NotifyFrequencyConfigItem item = NotifyFrequencyConfig.findItem(sname, uri);
        if (item != null) {
            return NotifyFrequencyConfigItem.isSwitchOnByPhoneType(item.canNotifyListByPhoneType);
        }
        return NotifyFrequencyConfigItem.isSwitchOnByPhoneType(data2.allNotifyListByPhoneType);
    }

    public static int getForceClearThreshold(String sname, int uri) {
        NotifyFrequencyConfigData data2 = mData;
        if (data2 == null || !data2.swtichOn) {
            return Integer.MAX_VALUE;
        }
        NotifyFrequencyConfigItem item = NotifyFrequencyConfig.findItem(sname, uri);
        if (item != null && NotifyFrequencyConfigItem.isSwitchOnByPhoneType(item.swtichOnByPhoneType) && item.forceClearThreshold > 20) {
            return item.forceClearThreshold;
        }
        return Integer.MAX_VALUE;
    }

    public static boolean isReplaceable(String sname, int uri) {
        NotifyFrequencyConfigData data2 = mData;
        if (data2 == null || !data2.swtichOn) {
            return false;
        }
        NotifyFrequencyConfigItem item = NotifyFrequencyConfig.findItem(sname, uri);
        if (item != null && item.canReplaceableUris != null && item.canReplaceableUris.size() > 0) {
            return item.canReplaceableUris.contains(uri);
        }
        return false;
    }
}

