/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class ImCommonPushConfig
extends AConfigData {
    private static final String TAG = "ImCommonPushConfig";
    private List<ImCommonPushContent> mCommonPushContentList;

    @Override
    public BssCode getBssCode() {
        return BssCode.IM_COMMON_PUSH;
    }

    @Override
    public void parseConfig(String configs) {
        MLog.debug((Object)TAG, (String)"parseConfig configs: %s", (Object[])new Object[]{configs});
        if (FP.empty((CharSequence)configs) || configs.equals("{}")) {
            return;
        }
        try {
            JSONArray jsonArray = new JSONArray(configs);
            this.mCommonPushContentList = new ArrayList<ImCommonPushContent>(jsonArray.length());
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject o = jsonArray.getJSONObject(i);
                ImCommonPushContent content = new ImCommonPushContent();
                content.title = o.optString("title");
                content.text = o.optString("text");
                content.jumpUrl = o.optString("jump_url");
                content.imageUrl = o.optString("image_url");
                content.notify = o.optBoolean("notify");
                content.mABKey = o.optString("ABKey");
                content.mABValue = o.optString("ABValue");
                content.id = o.optInt("id");
                JSONArray conditionArray = o.getJSONArray("show_condition");
                if (conditionArray.length() > 0) {
                    content.mConditionList = new ArrayList<ImCommonPushCondition>(conditionArray.length());
                    for (int j = 0; j < conditionArray.length(); ++j) {
                        JSONObject conditionObject = conditionArray.getJSONObject(j);
                        ImCommonPushCondition condition = new ImCommonPushCondition();
                        condition.registerDay = conditionObject.optInt("registerDay", -1);
                        condition.openAppCount = conditionObject.optInt("openAppCount", -1);
                        JSONArray ageRangeJa = conditionObject.optJSONArray("ageRange");
                        if (ageRangeJa != null && ageRangeJa.length() > 0) {
                            condition.ageRange = new int[ageRangeJa.length()];
                            for (int k = 0; k < ageRangeJa.length(); ++k) {
                                condition.ageRange[k] = ageRangeJa.getInt(k);
                            }
                        }
                        content.mConditionList.add(condition);
                    }
                }
                content.jumpUrlWithPlaceHolder = o.optString("jumpUrlWithPlaceHolder");
                JSONArray placeHolders = o.optJSONArray("placeHolders");
                content.placeHolders.clear();
                if (placeHolders != null && placeHolders.length() > 0) {
                    for (int index = 0; index < placeHolders.length(); ++index) {
                        String s = placeHolders.optString(index);
                        if (!StringUtils.isNotEmpty((String)s)) continue;
                        content.placeHolders.add(s);
                    }
                }
                this.mCommonPushContentList.add(content);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"parseConfig ex: %s", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public List<ImCommonPushContent> getCommonPushContentList() {
        return this.mCommonPushContentList;
    }

    public static class ImCommonPushCondition {
        public int registerDay;
        public int openAppCount;
        public int[] ageRange;

        public String toString() {
            return "ImCommonPushCondition{registerDay=" + this.registerDay + ", openAppCount=" + this.openAppCount + '}';
        }
    }

    public static class ImCommonPushContent {
        public String title;
        public String text;
        public String jumpUrl;
        public String imageUrl;
        public boolean notify;
        public String mABKey;
        public String mABValue;
        public int id;
        public List<ImCommonPushCondition> mConditionList;
        public String jumpUrlWithPlaceHolder;
        public List<String> placeHolders = new ArrayList<String>();

        public String toString() {
            return "ImCommonPushContent{title='" + this.title + '\'' + ", text='" + this.text + '\'' + ", jumpUrl='" + this.jumpUrl + '\'' + ", imageUrl='" + this.imageUrl + '\'' + ", notify=" + this.notify + ", mABKey='" + this.mABKey + '\'' + ", mABValue='" + this.mABValue + '\'' + ", id=" + this.id + ", mConditionList=" + this.mConditionList + ", jumpUrlWithPlaceHolder = " + this.jumpUrlWithPlaceHolder + ", placeHolderSize=" + this.placeHolders.size() + '}';
        }
    }
}

