/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.HostPreConnectConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.utils.json.JsonParser;
import com.yy.grace.NetworkConverter;
import com.yy.grace.network.cronet.NetworkCronet;
import com.yy.grace.network.okhttp.NetworkOkHttp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class HostPreConnectConfig
extends AConfigData {
    private static final ArrayList<NetworkConverter.Factory.HostNetWorkMap> sLoginHostNetWorkMapArrayList = new ArrayList();
    private static final ArrayList<NetworkConverter.Factory.HostNetWorkMap> sChannelHostNetWorkMapArrayList = new ArrayList();
    private static final ArrayList<NetworkConverter.Factory.HostNetWorkMap> sRechargeHostNetWorkMapArrayList = new ArrayList();

    @Override
    public BssCode getBssCode() {
        return BssCode.PRE_CONNECT;
    }

    @Override
    public boolean isLogoutKeep() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseConfig(String configs) {
        MLog.debug((Object)"HostPreConnectConfig", (String)("config = " + configs), (Object[])new Object[0]);
        HostPreConnectConfig hostPreConnectConfig = this;
        synchronized (hostPreConnectConfig) {
            sLoginHostNetWorkMapArrayList.clear();
            sChannelHostNetWorkMapArrayList.clear();
            sRechargeHostNetWorkMapArrayList.clear();
            HostPreConnectConfigData hostPreConnectConfigData = (HostPreConnectConfigData)JsonParser.parseJsonObject((String)configs, HostPreConnectConfigData.class);
            if (hostPreConnectConfigData != null) {
                this.parseHostPreConnectList(hostPreConnectConfigData.loginHostPreConnectConfig, sLoginHostNetWorkMapArrayList);
                this.parseHostPreConnectList(hostPreConnectConfigData.channelHostPreConnectConfig, sChannelHostNetWorkMapArrayList);
                this.parseHostPreConnectList(hostPreConnectConfigData.rechargeHostPreConnectConfig, sRechargeHostNetWorkMapArrayList);
            }
        }
    }

    private void parseHostPreConnectList(HostPreConnectConfigData.HostPreConnectConfig hostPreConnectConfig, ArrayList<NetworkConverter.Factory.HostNetWorkMap> list) {
        if (hostPreConnectConfig != null && hostPreConnectConfig.hosts != null && hostPreConnectConfig.hosts.size() > 0) {
            for (HostPreConnectConfigData.HostPreConnectConfigItem item : hostPreConnectConfig.hosts) {
                NetworkConverter.Factory.HostNetWorkMap hostNetWorkMap = new NetworkConverter.Factory.HostNetWorkMap();
                hostNetWorkMap.host = item.host;
                for (int i : item.networks) {
                    if (i == 1) {
                        hostNetWorkMap.networkList.add(NetworkOkHttp.network());
                        continue;
                    }
                    if (i != 2) continue;
                    hostNetWorkMap.networkList.add(NetworkCronet.network());
                }
                list.add(hostNetWorkMap);
            }
        }
    }

    public static List<NetworkConverter.Factory.HostNetWorkMap> getLoginHostNetWorkMapArrayList() {
        return new CopyOnWriteArrayList<NetworkConverter.Factory.HostNetWorkMap>(sLoginHostNetWorkMapArrayList);
    }

    public static List<NetworkConverter.Factory.HostNetWorkMap> getChannelHostNetWorkMapArrayList() {
        return new CopyOnWriteArrayList<NetworkConverter.Factory.HostNetWorkMap>(sChannelHostNetWorkMapArrayList);
    }

    public static List<NetworkConverter.Factory.HostNetWorkMap> getRechargeHostNetWorkMapArrayList() {
        return new CopyOnWriteArrayList<NetworkConverter.Factory.HostNetWorkMap>(sRechargeHostNetWorkMapArrayList);
    }
}

