/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.yy.appbase.AppKeysDef;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BackupHostConfig
extends AConfigData {
    private static final String FILE_NAME = "HagoLiteBackupHostConfig";
    public static final String ABTEST = "AbTest";
    public static final String CRASH = "Crash";
    public static final String CRASH_DAU = "CrashDau";
    public static final String CRASH_ANR = "CrashAnr";
    public static final String CRASH_FEEDBACK = "CrashFeedBack";
    public static final String FEEDBACK = "FeedBack";
    private static boolean sIsOpen;
    private static Map<String, String> sExactlyHostMap;
    private static Map<String, String> sFuzzyHostMap;
    private static volatile boolean sHasSetStaticData;
    private static volatile List<String> sFirstHostSuffixList;
    private static volatile List<String> sCdnFirstHostSuffixList;
    public static Map<String, String> sReplaceHostList;
    public static Map<String, String> sHardCodeHostMap;
    public static volatile boolean sReplaceOurUrlHttpToHttps;
    public static volatile boolean sReplaceAllHttpToHttps;
    public static volatile boolean sReplaceWebHttpToHttps;
    private static volatile List<String> sReplaceUrlHttpToHttpsExactly;
    private static volatile List<String> sReplaceUrlHttpToHttpsFuzzy;
    private static volatile Map<String, String> sOurSdkUri;

    @Override
    public BssCode getBssCode() {
        return BackupHostConfig.getRealBssCode();
    }

    public static BssCode getRealBssCode() {
        if (AppKeysDef.isHago()) {
            return BssCode.HAGO_APP_BACKUP_HOST;
        }
        if (AppKeysDef.isOla()) {
            return BssCode.PARTY_APP_BACKUP_HOST;
        }
        if (AppKeysDef.isNT()) {
            return BssCode.HAGO_SDK_NT_BACKUP_HOST;
        }
        if (RuntimeContext.isHagoPartySdk()) {
            return BssCode.HAGO_SDK_BACKUP_HOST;
        }
        return BssCode.HAGO_APP_BACKUP_HOST;
    }

    @Override
    public void parseConfig(final String configs) {
        try {
            if (StringUtils.isNotEmpty((String)configs)) {
                MLog.info((Object)"BackupHostConfig config:", (String)configs, (Object[])new Object[0]);
            }
            HagoLiteBackupHostConfigData data2 = (HagoLiteBackupHostConfigData)JsonParser.parseJsonTye((String)configs, HagoLiteBackupHostConfigData.class);
            BackupHostConfig.setStaticData(data2);
            YYTaskExecutor.getDefaultIdleExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    BackupHostConfig.saveToFile(configs);
                    MLog.info((Object)"BackupUrlConfig", (String)"save!", (Object[])new Object[0]);
                }
            });
        }
        catch (Exception e) {
            MLog.error((Object)"BackupUrlConfig", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setStaticData(HagoLiteBackupHostConfigData data2) {
        sHasSetStaticData = true;
        if (data2 != null) {
            Map<String, String> map = sExactlyHostMap;
            synchronized (map) {
                sIsOpen = data2.isOpen;
                sExactlyHostMap.clear();
                sFuzzyHostMap.clear();
                sFirstHostSuffixList = null;
                if (data2.suffixList != null) {
                    sFirstHostSuffixList = data2.suffixList;
                }
                sCdnFirstHostSuffixList = null;
                if (data2.cdnSuffixList != null) {
                    sCdnFirstHostSuffixList = data2.cdnSuffixList;
                }
                if (!FP.empty(data2.exactData)) {
                    for (HostPair pair : data2.exactData) {
                        sExactlyHostMap.put(pair.oldHost, pair.newHost);
                    }
                }
                if (!FP.empty(data2.fuzzyData)) {
                    for (HostPair pair : data2.fuzzyData) {
                        sFuzzyHostMap.put(pair.oldHost, pair.newHost);
                    }
                }
                if (data2.streamhostlist != null) {
                    sReplaceHostList = new HashMap<String, String>(data2.streamhostlist);
                }
                sReplaceAllHttpToHttps = data2.replaceAllHttpToHttps;
                sReplaceOurUrlHttpToHttps = data2.replaceOurUrlHttpToHttps;
                sReplaceWebHttpToHttps = data2.replaceWebHttpToHttps;
                if (data2.replaceUrlHttpToHttps != null) {
                    sReplaceUrlHttpToHttpsExactly = data2.replaceUrlHttpToHttps;
                }
                if (data2.replaceUrlHttpToHttpsFuzzy != null) {
                    sReplaceUrlHttpToHttpsFuzzy = data2.replaceUrlHttpToHttpsFuzzy;
                }
                if (data2.ourSdkUri != null) {
                    sOurSdkUri = data2.ourSdkUri;
                }
            }
        }
    }

    private static synchronized void saveToFile(String configs) {
        FileStorageUtils.getInstance().saveToFile(true, configs, FILE_NAME);
    }

    private static synchronized void setDataFromFile() {
        String str = FileStorageUtils.getInstance().getStrFromFile(true, FILE_NAME);
        if (StringUtils.isNotEmpty((String)str)) {
            HagoLiteBackupHostConfigData data2 = (HagoLiteBackupHostConfigData)JsonParser.parseJsonTye((String)str, HagoLiteBackupHostConfigData.class);
            BackupHostConfig.setStaticData(data2);
        } else {
            sHasSetStaticData = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExactBackupHost(@NonNull String oldHost) {
        if (!sHasSetStaticData) {
            BackupHostConfig.setDataFromFile();
        }
        if (!sIsOpen || StringUtils.isEmpty((String)oldHost)) {
            return "";
        }
        Map<String, String> map = sExactlyHostMap;
        synchronized (map) {
            String newHost = sExactlyHostMap.get(oldHost);
            return TextUtils.isEmpty((CharSequence)newHost) ? "" : newHost;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFuzzyBackupHostSuffix(@NonNull String oldHost) {
        if (!sHasSetStaticData) {
            BackupHostConfig.setDataFromFile();
        }
        if (!sIsOpen || StringUtils.isEmpty((String)oldHost)) {
            return "";
        }
        String newHost = null;
        Map<String, String> map = sFuzzyHostMap;
        synchronized (map) {
            Set<String> keys = sFuzzyHostMap.keySet();
            if (keys != null && keys.size() > 0) {
                for (String key : keys) {
                    if (!oldHost.endsWith(key)) continue;
                    newHost = sFuzzyHostMap.get(key);
                    break;
                }
            }
        }
        return TextUtils.isEmpty(newHost) ? "" : newHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFuzzyBackupUrl(String oldUrl, @NonNull String oldUrlHost) {
        if (!sHasSetStaticData) {
            BackupHostConfig.setDataFromFile();
        }
        if (!sIsOpen || StringUtils.isEmpty((String)oldUrl) || StringUtils.isEmpty((String)oldUrlHost)) {
            return oldUrl;
        }
        String newHostSuffix = null;
        String oldHostSuffix = null;
        Map<String, String> map = sFuzzyHostMap;
        synchronized (map) {
            Set<String> keys = sFuzzyHostMap.keySet();
            if (keys != null && keys.size() > 0) {
                for (String key : keys) {
                    if (!oldUrlHost.endsWith(key)) continue;
                    newHostSuffix = sFuzzyHostMap.get(key);
                    oldHostSuffix = key;
                    break;
                }
            }
        }
        if (StringUtils.isNotEmpty(newHostSuffix)) {
            return oldUrl.replace(oldHostSuffix, newHostSuffix);
        }
        return oldUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFuzzyBackupHost(@NonNull String oldUrlHost) {
        if (!sHasSetStaticData) {
            BackupHostConfig.setDataFromFile();
        }
        if (!sIsOpen || StringUtils.isEmpty((String)oldUrlHost)) {
            return oldUrlHost;
        }
        String newHostSuffix = null;
        String oldHostSuffix = null;
        Map<String, String> map = sExactlyHostMap;
        synchronized (map) {
            Set<String> keys = sFuzzyHostMap.keySet();
            if (keys != null && keys.size() > 0) {
                for (String key : keys) {
                    if (!oldUrlHost.endsWith(key)) continue;
                    newHostSuffix = sFuzzyHostMap.get(key);
                    oldHostSuffix = key;
                    break;
                }
            }
        }
        if (StringUtils.isNotEmpty(newHostSuffix)) {
            return oldUrlHost.replace(oldHostSuffix, newHostSuffix);
        }
        return oldUrlHost;
    }

    public static List<String> getOurFirstHostSuffixList() {
        if (!sHasSetStaticData) {
            BackupHostConfig.setDataFromFile();
        }
        return sFirstHostSuffixList;
    }

    public static List<String> getOurCdnFirstHostSuffixList() {
        if (!sHasSetStaticData) {
            BackupHostConfig.setDataFromFile();
        }
        return sCdnFirstHostSuffixList;
    }

    public static String getOurSDKURI(String sdkName) {
        if (!sHasSetStaticData) {
            BackupHostConfig.setDataFromFile();
        }
        return sOurSdkUri.get(sdkName);
    }

    public static String replaceUrlHttpToHttps(String url, String hostOfUrl) {
        List<String> replaceUrlHttpToHttpsExactly;
        List<String> replaceUrlHttpToHttpsFuzzy;
        if (StringUtils.isEmpty((String)url) || !url.startsWith("http://")) {
            return url;
        }
        if (!sHasSetStaticData) {
            BackupHostConfig.setDataFromFile();
        }
        if ((replaceUrlHttpToHttpsFuzzy = sReplaceUrlHttpToHttpsFuzzy) != null && replaceUrlHttpToHttpsFuzzy.size() > 0 && StringUtils.isNotEmpty((String)hostOfUrl)) {
            for (String item : replaceUrlHttpToHttpsFuzzy) {
                if (!hostOfUrl.endsWith(item) || !StringUtils.isNotEmpty((String)item)) continue;
                return URLUtils.replaceHttpToHttps((String)url);
            }
        }
        if ((replaceUrlHttpToHttpsExactly = sReplaceUrlHttpToHttpsExactly) != null && replaceUrlHttpToHttpsExactly.size() > 0) {
            for (String item : sReplaceUrlHttpToHttpsExactly) {
                if (!url.startsWith(item) || !StringUtils.isNotEmpty((String)item)) continue;
                return URLUtils.replaceHttpToHttps((String)url);
            }
        }
        return url;
    }

    static {
        sExactlyHostMap = new HashMap<String, String>();
        sFuzzyHostMap = new HashMap<String, String>();
        sHasSetStaticData = false;
        sReplaceHostList = new HashMap<String, String>();
        sHardCodeHostMap = new HashMap<String, String>();
        sReplaceOurUrlHttpToHttps = false;
        sReplaceAllHttpToHttps = false;
        sReplaceWebHttpToHttps = false;
        sOurSdkUri = new HashMap<String, String>(5);
        sHardCodeHostMap.put("lpf-aliyun-sg-livepull.ihago.net", "lpf-aliyun-sg-livepull-a.ihago.net");
        sHardCodeHostMap.put("lpf-aliyun-in-livepull.ihago.net", "lpf-aliyun-in-livepull-a.ihago.net");
        sHardCodeHostMap.put("lpf-aliyun-id-livepull.ihago.net", "lpf-aliyun-id-livepull-a.ihago.net");
        sHardCodeHostMap.put("lpf-aliyun-de-livepull.ihago.net", "lpf-aliyun-de-livepull-a.ihago.net");
        sHardCodeHostMap.put("lpf-ws-br-livepull.ihago.net", "lpf-ws-br-livepull.ihago.net");
        sHardCodeHostMap.put("lpf-ws-usa-livepull.ihago.net", "lpf-ws-us-livepull.ihago.net");
    }

    @DontProguardClass
    public static class HostPair {
        public String oldHost = "";
        public String newHost = "";

        public String toString() {
            return "HostPair{oldHost='" + this.oldHost + '\'' + ", newHost='" + this.newHost + '\'' + '}';
        }
    }

    @DontProguardClass
    public static class HagoLiteBackupHostConfigData {
        public List<HostPair> exactData;
        public List<HostPair> fuzzyData;
        public List<String> suffixList;
        public List<String> cdnSuffixList;
        public Map<String, String> streamhostlist;
        public boolean isOpen = false;
        public boolean replaceOurUrlHttpToHttps = false;
        public boolean replaceAllHttpToHttps = false;
        public boolean replaceWebHttpToHttps = false;
        List<String> replaceUrlHttpToHttps;
        List<String> replaceUrlHttpToHttpsFuzzy;
        public Map<String, String> ourSdkUri;
    }
}

