/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.unifyconfig.config;

import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.base.utils.StringUtils;
import org.json.JSONObject;

public abstract class AConfigData {
    protected ArrayMap<String, Object> mKeyAndValues = new ArrayMap();
    public String mConfigContent;

    public abstract BssCode getBssCode();

    @WorkerThread
    public abstract void parseConfig(String var1);

    public boolean parseDefault() {
        return false;
    }

    public boolean recycleAfterParse() {
        return false;
    }

    public void recycle() {
        this.mKeyAndValues.clear();
    }

    public boolean isLogoutKeep() {
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AConfigData)) {
            return false;
        }
        return this.getBssCode() == ((AConfigData)o).getBssCode();
    }

    public int hashCode() {
        if (this.getBssCode() != null) {
            return 31 * this.getBssCode().hashCode();
        }
        return super.hashCode();
    }

    @Nullable
    public Object getValue(String key) {
        return this.mKeyAndValues.get((Object)key);
    }

    public int getIntValue(String key, int defaultValue) {
        if (this.mKeyAndValues.containsKey((Object)key)) {
            Object object = this.mKeyAndValues.get((Object)key);
            if (object instanceof Integer) {
                return (Integer)object;
            }
            if (object instanceof String) {
                return StringUtils.parseInt((String)((String)object), (int)defaultValue);
            }
        }
        return defaultValue;
    }

    public long getLongValue(String key, long defaultValue) {
        if (this.mKeyAndValues.containsKey((Object)key)) {
            Object object = this.mKeyAndValues.get((Object)key);
            if (object instanceof Long) {
                return (Long)object;
            }
            if (object instanceof String) {
                return StringUtils.parseLong((String)((String)object), (long)defaultValue);
            }
        }
        return defaultValue;
    }

    public boolean getBoolValue(String key, boolean defaultValue) {
        if (this.mKeyAndValues.containsKey((Object)key)) {
            Object object = this.mKeyAndValues.get((Object)key);
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object instanceof String) {
                return StringUtils.parseInt((String)((String)object)) == 1;
            }
            if (object instanceof Integer) {
                return (Integer)object == 1;
            }
        }
        return defaultValue;
    }

    public String getStringValue(String key, String defaultValue) {
        if (this.mKeyAndValues.containsKey((Object)key)) {
            Object object = this.mKeyAndValues.get((Object)key);
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof Boolean) {
                return (Boolean)object != false ? "1" : "0";
            }
            if (object instanceof Integer) {
                return String.valueOf(object);
            }
        }
        return defaultValue;
    }

    public String getStringValue(String key) {
        return this.getStringValue(key, null);
    }

    public boolean containsKey(String key) {
        return this.mKeyAndValues.containsKey((Object)key);
    }

    protected void parseIntValueToKeysAndValues(JSONObject jo, String key) {
        try {
            if (jo.has(key)) {
                this.mKeyAndValues.put((Object)key, (Object)jo.getInt(key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void parseIntValueToKeysAndValues(JSONObject jo, String key, int defalurValue) {
        try {
            if (jo.has(key)) {
                this.mKeyAndValues.put((Object)key, (Object)jo.optInt(key, defalurValue));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void parseBoolValueToKeysAndValues(JSONObject jo, String key) {
        try {
            if (jo.has(key)) {
                this.mKeyAndValues.put((Object)key, (Object)(jo.getInt(key) == 1 ? 1 : 0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void parseLongValueToKeysAndValues(JSONObject jo, String key) {
        try {
            if (jo.has(key)) {
                this.mKeyAndValues.put((Object)key, (Object)jo.getLong(key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void parseStringValueToKeysAndValues(JSONObject jo, String key) {
        try {
            if (jo.has(key)) {
                this.mKeyAndValues.put((Object)key, (Object)jo.getString(key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

