/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.volume;

import android.content.Context;
import android.media.AudioManager;
import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemServiceUtils;

public final class VolumeUtils {
    private static final String TAG = "PKGameVolumeModel";
    private static final int GAME_VOLUME = 50;
    private static final int PLAYER_VOLUME = 80;
    private static final String PK_GAME_VOLUME = "pk_game_volume";
    private static final String PK_PLAYER_VOLUME = "pk_player_volume";
    private static volatile int mPlayerVolume = 100;
    public static final int HIDE_VOLUME_VIEW_TIME = 3000;

    private VolumeUtils() {
    }

    @Nullable
    public static AudioManager getAudioManager() {
        return SystemServiceUtils.getAudioManager((Context)RuntimeContext.sApplicationContext);
    }

    public static void adjustPlayerVolume(final int volume, boolean sendPKMic) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                AudioManager audioManager = VolumeUtils.getAudioManager();
                if (audioManager == null) {
                    return;
                }
                double percent = (double)volume / 100.0;
                int playerVolume = (int)(percent * (double)VolumeUtils.getPlayerMaxVolume());
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)VolumeUtils.TAG, (String)"adjustPlayerVolume %d", (Object[])new Object[]{playerVolume});
                }
                audioManager.setStreamVolume(0, playerVolume, 0);
                if (volume == 0) {
                    // empty if block
                }
                mPlayerVolume = volume;
            }
        });
    }

    public static int getPlayerMaxVolume() {
        AudioManager audioManager = VolumeUtils.getAudioManager();
        if (audioManager == null) {
            return 0;
        }
        return audioManager.getStreamMaxVolume(0);
    }

    public static int getPlayerVolume() {
        AudioManager audioManager = VolumeUtils.getAudioManager();
        if (audioManager == null) {
            return 0;
        }
        int callVolume = audioManager.getStreamVolume(0);
        MLog.info((Object)TAG, (String)"getPlayerVolume mPlayerVolume:%d,callVolume:%d", (Object[])new Object[]{mPlayerVolume, callVolume});
        if (mPlayerVolume == 0 && callVolume <= 1) {
            return 0;
        }
        if (mPlayerVolume > 0 && callVolume == 0) {
            return 1;
        }
        return callVolume;
    }

    public static void adjustGameVolume(final int volume) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                AudioManager audioManager = VolumeUtils.getAudioManager();
                if (audioManager == null) {
                    return;
                }
                double percent = (double)volume / 100.0;
                int gameVolume = (int)(percent * (double)VolumeUtils.getGameMaxVolume());
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)VolumeUtils.TAG, (String)"adjustGameVolume max %d", (Object[])new Object[]{VolumeUtils.getGameMaxVolume()});
                }
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)VolumeUtils.TAG, (String)"adjustGameVolume %d", (Object[])new Object[]{gameVolume});
                }
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)VolumeUtils.TAG, (String)"adjustGameVolume mode:%d", (Object[])new Object[]{audioManager.getMode()});
                }
                audioManager.setMode(0);
                try {
                    audioManager.setStreamVolume(3, gameVolume, 0);
                }
                catch (SecurityException e) {
                    MLog.error((Object)VolumeUtils.TAG, (Throwable)e);
                }
            }
        });
    }

    public static int getGameMaxVolume() {
        AudioManager audioManager = VolumeUtils.getAudioManager();
        if (audioManager == null) {
            return 0;
        }
        return audioManager.getStreamMaxVolume(3);
    }

    public static int getGameVolume() {
        AudioManager audioManager = VolumeUtils.getAudioManager();
        if (audioManager == null) {
            return 0;
        }
        return audioManager.getStreamVolume(3);
    }

    public static void initVolume() {
    }

    public static void saveVolume(int game, int player) {
    }

    public static void resetVolume() {
    }

    public static void mutePlayerVolume() {
    }
}

