/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.viewpager;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.core.os.ParcelableCompat;
import androidx.core.os.ParcelableCompatCreatorCallbacks;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.ui.widget.viewpager.DelegatingPagerAdapter;
import com.yy.appbase.ui.widget.viewpager.ViewPagerFixed;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SystemUtils;
import java.util.HashMap;

public class YYViewPager
extends ViewPagerFixed {
    private int mLayoutDirection = 0;
    private HashMap<ViewPager.OnPageChangeListener, ReversingOnPageChangeListener> mPageChangeListeners = new HashMap();

    public YYViewPager(Context context) {
        super(context);
    }

    public YYViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void onRtlPropertiesChanged(int layoutDirection) {
        int viewCompatLayoutDirection;
        super.onRtlPropertiesChanged(layoutDirection);
        int n = viewCompatLayoutDirection = layoutDirection == 1 ? 1 : 0;
        if (viewCompatLayoutDirection != this.mLayoutDirection) {
            PagerAdapter adapter = super.getAdapter();
            int position = 0;
            if (adapter != null) {
                position = this.getCurrentItem();
            }
            this.mLayoutDirection = viewCompatLayoutDirection;
            if (adapter != null) {
                adapter.notifyDataSetChanged();
                this.setCurrentItem(position);
            }
        }
    }

    public void setAdapter(PagerAdapter adapter) {
        if (adapter != null) {
            if (!this.isInEditMode()) {
                super.setAdapter(new ReversingAdapter(adapter));
            }
        } else {
            super.setAdapter(null);
        }
        this.setCurrentItem(0);
    }

    public PagerAdapter getAdapter() {
        ReversingAdapter adapter = (ReversingAdapter)super.getAdapter();
        return adapter == null ? null : adapter.getDelegate();
    }

    private boolean isRtl() {
        return this.mLayoutDirection == 1;
    }

    public int getCurrentItem() {
        int item = super.getCurrentItem();
        PagerAdapter adapter = super.getAdapter();
        if (adapter != null && this.isRtl()) {
            item = adapter.getCount() - item - 1;
        }
        return item;
    }

    public void setCurrentItem(int position, boolean smoothScroll) {
        PagerAdapter adapter = super.getAdapter();
        if (adapter != null && this.isRtl()) {
            position = adapter.getCount() - position - 1;
        }
        super.setCurrentItem(position, smoothScroll);
    }

    public void setCurrentItem(int position) {
        PagerAdapter adapter = super.getAdapter();
        if (adapter != null && this.isRtl()) {
            position = adapter.getCount() - position - 1;
        }
        super.setCurrentItem(position);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.mLayoutDirection);
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        this.mLayoutDirection = ss.mLayoutDirection;
        super.onRestoreInstanceState(ss.mViewPagerSavedState);
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener2) {
        super.setOnPageChangeListener((ViewPager.OnPageChangeListener)new ReversingOnPageChangeListener(listener2));
    }

    public void addOnPageChangeListener(ViewPager.OnPageChangeListener listener2) {
        ReversingOnPageChangeListener reversingListener = new ReversingOnPageChangeListener(listener2);
        this.mPageChangeListeners.put(listener2, reversingListener);
        super.addOnPageChangeListener((ViewPager.OnPageChangeListener)reversingListener);
    }

    public void removeOnPageChangeListener(ViewPager.OnPageChangeListener listener2) {
        ReversingOnPageChangeListener reverseListener = this.mPageChangeListeners.remove(listener2);
        if (reverseListener != null) {
            super.removeOnPageChangeListener((ViewPager.OnPageChangeListener)reverseListener);
        }
    }

    public void clearOnPageChangeListeners() {
        super.clearOnPageChangeListeners();
        this.mPageChangeListeners.clear();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == 0) {
            int height = 0;
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                child.measure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                int h = child.getMeasuredHeight();
                if (h <= height) continue;
                height = h;
            }
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public class ReversingAdapter
    extends DelegatingPagerAdapter {
        private int primaryItemPos;
        private Object primaryItem;

        public ReversingAdapter(PagerAdapter adapter) {
            super(adapter);
            this.primaryItemPos = -1;
            this.primaryItem = null;
        }

        @Override
        public void destroyItem(ViewGroup container, int position, Object object) {
            if (YYViewPager.this.isRtl()) {
                position = this.getCount() - position - 1;
            }
            super.destroyItem(container, position, object);
        }

        @Override
        public void destroyItem(View container, int position, Object object) {
            if (YYViewPager.this.isRtl()) {
                position = this.getCount() - position - 1;
            }
            super.destroyItem(container, position, object);
        }

        @Override
        public int getItemPosition(Object object) {
            int position = super.getItemPosition(object);
            if (YYViewPager.this.isRtl()) {
                position = position == -1 || position == -2 ? -2 : this.getCount() - position - 1;
            }
            return position;
        }

        @Override
        public CharSequence getPageTitle(int position) {
            if (YYViewPager.this.isRtl()) {
                position = this.getCount() - position - 1;
            }
            return super.getPageTitle(position);
        }

        @Override
        public float getPageWidth(int position) {
            if (YYViewPager.this.isRtl()) {
                position = this.getCount() - position - 1;
            }
            return super.getPageWidth(position);
        }

        @Override
        public Object instantiateItem(ViewGroup container, int position) {
            if (YYViewPager.this.isRtl()) {
                position = this.getCount() - position - 1;
            }
            return super.instantiateItem(container, position);
        }

        @Override
        public Object instantiateItem(View container, int position) {
            if (YYViewPager.this.isRtl()) {
                position = this.getCount() - position - 1;
            }
            return super.instantiateItem(container, position);
        }

        @Override
        public void setPrimaryItem(View container, int position, Object object) {
            if (YYViewPager.this.isRtl()) {
                position = this.getCount() - position - 1;
            }
            super.setPrimaryItem(container, position, object);
        }

        @Override
        public void setPrimaryItem(ViewGroup container, int position, Object object) {
            if (YYViewPager.this.isRtl()) {
                position = this.getCount() - position - 1;
            }
            this.primaryItem = object;
            this.primaryItemPos = position;
            if (SystemUtils.isShowEnvSetting()) {
                MLog.info((Object)"ViewPagerFixed", (String)"setPrimaryItem pos:%d, object:%s", (Object[])new Object[]{this.primaryItemPos, object});
            }
            super.setPrimaryItem(container, position, object);
        }

        public int getPrimaryItemPos() {
            return this.primaryItemPos;
        }

        public Object getPrimaryItem() {
            return this.primaryItem;
        }
    }

    private class ReversingOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private final ViewPager.OnPageChangeListener mListener;

        public ReversingOnPageChangeListener(ViewPager.OnPageChangeListener listener2) {
            this.mListener = listener2;
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            int width = YYViewPager.this.getWidth();
            PagerAdapter adapter = YYViewPager.super.getAdapter();
            if (YYViewPager.this.isRtl() && adapter != null) {
                int remainingWidth;
                int count = adapter.getCount();
                for (remainingWidth = (int)((float)width * (1.0f - adapter.getPageWidth(position))) + positionOffsetPixels; position < count && remainingWidth > 0; remainingWidth -= (int)((float)width * adapter.getPageWidth(++position))) {
                }
                position = count - position - 1;
                positionOffsetPixels = -remainingWidth;
                positionOffset = (float)positionOffsetPixels / ((float)width * adapter.getPageWidth(position));
            }
            this.mListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }

        public void onPageSelected(int position) {
            PagerAdapter adapter = YYViewPager.super.getAdapter();
            if (YYViewPager.this.isRtl() && adapter != null) {
                position = adapter.getCount() - position - 1;
            }
            this.mListener.onPageSelected(position);
        }

        public void onPageScrollStateChanged(int state) {
            this.mListener.onPageScrollStateChanged(state);
        }
    }

    public static class SavedState
    implements Parcelable {
        private final Parcelable mViewPagerSavedState;
        private final int mLayoutDirection;
        public static final Parcelable.Creator<SavedState> CREATOR = ParcelableCompat.newCreator((ParcelableCompatCreatorCallbacks)new ParcelableCompatCreatorCallbacks<SavedState>(){

            public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        });

        private SavedState(Parcelable viewPagerSavedState, int layoutDirection) {
            this.mViewPagerSavedState = viewPagerSavedState;
            this.mLayoutDirection = layoutDirection;
        }

        private SavedState(Parcel in, ClassLoader loader) {
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            this.mViewPagerSavedState = in.readParcelable(loader);
            this.mLayoutDirection = in.readInt();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            out.writeParcelable(this.mViewPagerSavedState, flags);
            out.writeInt(this.mLayoutDirection);
        }
    }
}

