/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.viewpager;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Px;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.R;
import com.yy.appbase.ui.widget.viewpager.YYViewPager;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.IRecycleView;
import com.yy.base.memoryrecycle.views.RecycleUtils;
import com.yy.base.taskexecutor.ReflectionHelper;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import java.util.ArrayList;

public class ViewPagerFixed
extends ViewPager
implements IRecycleView {
    private static MyGLobalOnPageChangeListener sGlobalOnPageChangeListener;
    private boolean mIsAttachToWindow;
    private YYViewPager.ReversingAdapter mReversingAdapter;
    private boolean mCloseRecoveryBySelect = false;

    public ViewPagerFixed(Context context) {
        super(context);
        this.initGlobalOnPageChangeListener();
    }

    public Object infoForChildNow(View child) {
        Class[] classes = new Class[]{View.class};
        Object[] args = new Object[]{child};
        Object object = ReflectionHelper.invokeObjectMethod((Object)((Object)this), (String)"infoForChild", (Class[])classes, (Object[])args);
        if (object != null) {
            return object;
        }
        return null;
    }

    public Object infoForPositionNow(int position) {
        Class[] classes = new Class[]{Integer.class};
        Object[] args = new Object[]{position};
        Object object = ReflectionHelper.invokeObjectMethod((Object)((Object)this), (String)"infoForPosition", (Class[])classes, (Object[])args);
        if (object != null) {
            return object;
        }
        return null;
    }

    public ViewPagerFixed(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initGlobalOnPageChangeListener();
    }

    public void closeRecoveryBySelect(boolean close) {
        this.mCloseRecoveryBySelect = close;
    }

    public boolean getCloseRecoveryBySelectFlag() {
        return this.mCloseRecoveryBySelect;
    }

    public void setAdapter(YYViewPager.ReversingAdapter adapter) {
        this.mReversingAdapter = adapter;
        if (SystemUtils.isShowEnvSetting()) {
            MLog.info((Object)"ViewPagerFixed", (String)" set ReversingAdapter:%s", (Object[])new Object[]{this.mReversingAdapter});
        }
        super.setAdapter((PagerAdapter)adapter);
    }

    private void initGlobalOnPageChangeListener() {
        this.setTag(R.id.yy_view_pager_id, true);
        super.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){
            private int curPos;

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                if (sGlobalOnPageChangeListener != null) {
                    sGlobalOnPageChangeListener.onPageScrolled(ViewPagerFixed.this, position, positionOffset, positionOffsetPixels);
                }
            }

            public void onPageSelected(int position) {
                if (sGlobalOnPageChangeListener != null) {
                    sGlobalOnPageChangeListener.onPageSelected(ViewPagerFixed.this, position);
                }
                this.curPos = position;
            }

            public void onPageScrollStateChanged(int state) {
                if (sGlobalOnPageChangeListener != null) {
                    sGlobalOnPageChangeListener.onPageScrollStateChanged(ViewPagerFixed.this, state);
                }
                if (state == 0) {
                    final int lastCurPos = this.curPos;
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (lastCurPos == curPos && ViewPagerFixed.this.isAttachToWindow()) {
                                ViewPagerFixed.this.doRecycleByPageSlect(curPos);
                            }
                        }
                    });
                }
            }
        });
    }

    public View getCurrentView(int position) {
        int curPostion = this.getCurrentItem();
        Object primaryItem = null;
        int primaryItemPos = -2;
        View curPage = null;
        if (this.mReversingAdapter != null) {
            primaryItem = this.mReversingAdapter.getPrimaryItem();
            primaryItemPos = this.mReversingAdapter.getPrimaryItemPos();
        }
        if (primaryItemPos == position && position >= 0 && primaryItem instanceof View) {
            curPage = (View)primaryItem;
            View subView = this.getChildAt(curPostion);
            if (SystemUtils.isShowEnvSetting()) {
                MLog.info((Object)"ViewPagerFixed", (String)"pos:%d, curPrimaryItemPage:%s, subView:%s", (Object[])new Object[]{position, curPage, subView});
            }
        }
        return curPage;
    }

    private void doRecycleByPageSlect(int position) {
        if (!SettingFlags.getBoolean((String)"pageview_recovery_opt2", (boolean)false) && !SystemUtils.isShowEnvSetting()) {
            return;
        }
        View curPage = this.getCurrentView(position);
        if (SystemUtils.isShowEnvSetting()) {
            MLog.info((Object)"ViewPagerFixed", (String)"onPageSelected:%d, view:%s", (Object[])new Object[]{position, curPage});
        }
        if (this.getCloseRecoveryBySelectFlag()) {
            return;
        }
        if (curPage != null) {
            this.markNotSelect(curPage, true);
            ArrayList<View> needMarkNotSelectViews = new ArrayList<View>();
            View subView = null;
            for (int i = 0; i < this.getChildCount(); ++i) {
                subView = this.getChildAt(i);
                if (curPage == subView) continue;
                needMarkNotSelectViews.add(subView);
            }
            if (needMarkNotSelectViews.size() > 0) {
                for (View item : needMarkNotSelectViews) {
                    this.markNotSelect(item, false);
                }
            }
        } else {
            ArrayList<View> needMarkNotSelectViews = new ArrayList<View>();
            for (int i = 0; i < this.getChildCount(); ++i) {
                needMarkNotSelectViews.add(this.getChildAt(i));
            }
            if (needMarkNotSelectViews.size() > 0) {
                for (View item : needMarkNotSelectViews) {
                    this.markNotSelect(item, true);
                }
            }
            if (SystemUtils.isShowEnvSetting()) {
                MLog.info((Object)"ViewPagerFixed", (String)"onPageSelected, but get curpage failed!", (Object[])new Object[0]);
            }
        }
    }

    private void markNotSelect(View view, boolean select) {
        ViewGroup viewGroup = null;
        if (!(view instanceof ViewGroup)) {
            if (view instanceof RecycleImageView) {
                ((RecycleImageView)view).forceNotRecoverWhenWindowVisible(!select);
                return;
            }
            return;
        }
        viewGroup = (ViewGroup)view;
        int childSize = viewGroup.getChildCount();
        if (childSize > 0) {
            View child = null;
            for (int i = 0; i < childSize; ++i) {
                child = viewGroup.getChildAt(i);
                if (child instanceof RecycleImageView) {
                    ((RecycleImageView)child).forceNotRecoverWhenWindowVisible(!select);
                    continue;
                }
                this.markNotSelect(child, select);
            }
        }
    }

    public static void setGlobalOnPageChangeListener(MyGLobalOnPageChangeListener globalOnPageChangeListener) {
        sGlobalOnPageChangeListener = globalOnPageChangeListener;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        try {
            return super.onTouchEvent(ev);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        try {
            return super.onInterceptTouchEvent(ev);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void setBackgroundToNull() {
        super.setBackgroundDrawable(null);
    }

    public Drawable getBackgroundInner() {
        return super.getBackground();
    }

    public boolean isAttachToWindow() {
        return this.mIsAttachToWindow;
    }

    public void onWindowRealVisible() {
        RecycleUtils.onWindowShown((ViewGroup)this);
    }

    public void onWindowInvisible() {
        RecycleUtils.onWindowHidden((ViewGroup)this);
    }

    public boolean closeAutoRecycleDrawables() {
        return false;
    }

    protected void onAttachedToWindow() {
        this.mIsAttachToWindow = true;
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        this.mIsAttachToWindow = false;
        super.onDetachedFromWindow();
    }

    public static interface MyGLobalOnPageChangeListener {
        public void onPageScrolled(ViewPagerFixed var1, int var2, float var3, @Px int var4);

        public void onPageSelected(ViewPagerFixed var1, int var2);

        public void onPageScrollStateChanged(ViewPagerFixed var1, int var2);
    }
}

