/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.tablayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.R;
import com.yy.appbase.ui.widget.tablayout.MsgView;
import com.yy.appbase.ui.widget.tablayout.OnTabPositionChangedListener;
import com.yy.appbase.ui.widget.tablayout.OnTabSelectListener;
import com.yy.appbase.ui.widget.viewpager.YYViewPager;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.LanguageUtils;
import java.util.ArrayList;
import java.util.Collections;

public class SlidingTabLayout
extends HorizontalScrollView
implements ViewPager.OnPageChangeListener {
    private static final String TAG = "SlidingTabLayout";
    private static final int STYLE_NORMAL = 0;
    private static final int STYLE_TRIANGLE = 1;
    private static final int STYLE_BLOCK = 2;
    private static final int TEXT_BOLD_NONE = 0;
    private static final int TEXT_BOLD_WHEN_SELECT = 1;
    private static final int TEXT_BOLD_BOTH = 2;
    private static final int SCROLL_INIT = 0;
    private static final int SCROLL_NEXT = 1;
    private static final int SCROLL_BACK = 2;
    private Context mContext;
    private ViewPager mViewPager;
    private ArrayList<TabItem> mTabItemList = new ArrayList(0);
    private ArrayList<String> mTitles;
    private LinearLayout mTabsContainer;
    private int mCurrentTab;
    private float mCurrentPositionOffset;
    private OnTabPositionChangedListener mTabPositionChangedListener;
    private Rect mIndicatorRect = new Rect();
    private Rect mTabRect = new Rect();
    private GradientDrawable mIndicatorDrawable = new GradientDrawable();
    private Paint mRectPaint = new Paint(1);
    private Paint mDividerPaint = new Paint(1);
    private Paint mTrianglePaint = new Paint(1);
    private Path mTrianglePath = new Path();
    private int mIndicatorStyle = 0;
    private boolean mTabSpaceEqual;
    private boolean mTextRobotoBold;
    private float mTabWidth = -1.0f;
    private float mTabPadding = this.dp2px(20.0f);
    private int mIndicatorColor = ColorUtils.parseColor((String)"#ffffff");
    private float mIndicatorHeight = this.dp2px(2.0f);
    private float mIndicatorWidth;
    private float mIndicatorCornerRadius;
    private float mIndicatorMarginLeft;
    private float mIndicatorMarginTop;
    private float mIndicatorMarginRight;
    private float mIndicatorMarginBottom;
    private int mIndicatorGravity = 80;
    private boolean mIndicatorWidthEqualTitle;
    private int mUnderlineColor = ColorUtils.parseColor((String)"#ffffff");
    private float mUnderlineHeight;
    private int mUnderlineGravity = 80;
    private int mDividerColor = ColorUtils.parseColor((String)"#ffffff");
    private float mDividerWidth;
    private float mDividerPadding = this.dp2px(12.0f);
    private float mTextsize = this.sp2px(14.0f);
    private int mTextSelectColor = ColorUtils.parseColor((String)"#ffffff");
    private int mTextUnselectColor = ColorUtils.parseColor((String)"#AAffffff");
    private float mTextSelectSize;
    private float mTextUnSelectSize;
    private boolean mTextSizeAnim;
    private int mTextBold = 0;
    private boolean mTextAllCaps;
    private boolean mTabCenterHorizontal;
    private int mTabEllipsize = -1;
    private float mStartPadding = 0.0f;
    private int mLastScrollX;
    private boolean mSnapOnTabClick;
    private int mTextSelectBackground;
    private int mTextUnselectBackground;
    private Rect mTextPadding = new Rect();
    private Rect mTextMargin = new Rect();
    private int mScrollType = 0;
    private int mClickTabIndex = -1;
    private int mScrollFrontTabIndex;
    private GradientDrawable mAnimTipGradientDrawable;
    private float margin;
    private Paint mTextPaint = new Paint(1);
    private OnTabSelectListener mListener;

    public SlidingTabLayout(Context context) {
        this(context, null, 0);
    }

    public SlidingTabLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SlidingTabLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setFillViewport(true);
        this.setWillNotDraw(false);
        this.setClipChildren(false);
        this.setClipToPadding(false);
        this.mContext = context;
        this.mTabsContainer = new YYLinearLayout(context);
        this.mTabsContainer.setClipChildren(false);
        this.mTabsContainer.setClipToPadding(false);
        this.addView((View)this.mTabsContainer, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.obtainAttributes(context, attrs);
        if (this.mTabCenterHorizontal) {
            this.mTabsContainer.setGravity(1);
        }
    }

    private void obtainAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.SlidingTabLayout);
        this.mIndicatorStyle = ta.getInt(R.styleable.SlidingTabLayout_tl_indicator_style, 0);
        this.mIndicatorColor = ta.getColor(R.styleable.SlidingTabLayout_tl_indicator_color, ColorUtils.parseColor((String)(this.mIndicatorStyle == 2 ? "#4B6A87" : "#ffffff")));
        this.mIndicatorHeight = ta.getDimension(R.styleable.SlidingTabLayout_tl_indicator_height, (float)this.dp2px(this.mIndicatorStyle == 1 ? 4.0f : (float)(this.mIndicatorStyle == 2 ? -1 : 2)));
        this.mIndicatorWidth = ta.getDimension(R.styleable.SlidingTabLayout_tl_indicator_width, (float)this.dp2px(this.mIndicatorStyle == 1 ? 10.0f : -1.0f));
        this.mIndicatorCornerRadius = ta.getDimension(R.styleable.SlidingTabLayout_tl_indicator_corner_radius, (float)this.dp2px(this.mIndicatorStyle == 2 ? -1.0f : 0.0f));
        this.mIndicatorMarginLeft = ta.getDimension(R.styleable.SlidingTabLayout_tl_indicator_margin_left, 0.0f);
        this.mIndicatorMarginTop = ta.getDimension(R.styleable.SlidingTabLayout_tl_indicator_margin_top, (float)this.dp2px(this.mIndicatorStyle == 2 ? 7.0f : 0.0f));
        this.mIndicatorMarginRight = ta.getDimension(R.styleable.SlidingTabLayout_tl_indicator_margin_right, 0.0f);
        this.mIndicatorMarginBottom = ta.getDimension(R.styleable.SlidingTabLayout_tl_indicator_margin_bottom, (float)this.dp2px(this.mIndicatorStyle == 2 ? 7.0f : 0.0f));
        this.mIndicatorGravity = ta.getInt(R.styleable.SlidingTabLayout_tl_indicator_gravity, 80);
        this.mIndicatorWidthEqualTitle = ta.getBoolean(R.styleable.SlidingTabLayout_tl_indicator_width_equal_title, false);
        this.mUnderlineColor = ta.getColor(R.styleable.SlidingTabLayout_tl_underline_color, ColorUtils.parseColor((String)"#ffffff"));
        this.mUnderlineHeight = ta.getDimension(R.styleable.SlidingTabLayout_tl_underline_height, 0.0f);
        this.mUnderlineGravity = ta.getInt(R.styleable.SlidingTabLayout_tl_underline_gravity, 80);
        this.mDividerColor = ta.getColor(R.styleable.SlidingTabLayout_tl_divider_color, ColorUtils.parseColor((String)"#ffffff"));
        this.mDividerWidth = ta.getDimension(R.styleable.SlidingTabLayout_tl_divider_width, 0.0f);
        this.mDividerPadding = ta.getDimension(R.styleable.SlidingTabLayout_tl_divider_padding, (float)this.dp2px(12.0f));
        this.mTextsize = ta.getDimension(R.styleable.SlidingTabLayout_tl_textsize, (float)this.sp2px(14.0f));
        this.mTextSelectSize = ta.getDimension(R.styleable.SlidingTabLayout_tl_textSelectSize, 0.0f);
        this.mTextUnSelectSize = ta.getDimension(R.styleable.SlidingTabLayout_tl_textUnselectSize, 0.0f);
        this.mTextSelectBackground = ta.getResourceId(R.styleable.SlidingTabLayout_tl_textSelectBackground, 0);
        this.mTextUnselectBackground = ta.getResourceId(R.styleable.SlidingTabLayout_tl_textUnselectBackground, 0);
        this.mTextSizeAnim = ta.getBoolean(R.styleable.SlidingTabLayout_tl_tab_textSize_anim, false);
        this.mTextSelectColor = ta.getColor(R.styleable.SlidingTabLayout_tl_textSelectColor, ColorUtils.parseColor((String)"#ffffff"));
        this.mTextUnselectColor = ta.getColor(R.styleable.SlidingTabLayout_tl_textUnselectColor, ColorUtils.parseColor((String)"#AAffffff"));
        this.mTextBold = ta.getInt(R.styleable.SlidingTabLayout_tl_textBold, 0);
        this.mTextAllCaps = ta.getBoolean(R.styleable.SlidingTabLayout_tl_textAllCaps, false);
        this.mTabCenterHorizontal = ta.getBoolean(R.styleable.SlidingTabLayout_tl_tab_centerHorizontal, false);
        this.mTextPadding.left = ta.getDimensionPixelSize(R.styleable.SlidingTabLayout_tl_textPaddingStart, 0);
        this.mTextPadding.right = ta.getDimensionPixelSize(R.styleable.SlidingTabLayout_tl_textPaddingEnd, 0);
        this.mTextPadding.top = ta.getDimensionPixelSize(R.styleable.SlidingTabLayout_tl_textPaddingTop, 0);
        this.mTextPadding.bottom = ta.getDimensionPixelSize(R.styleable.SlidingTabLayout_tl_textPaddingBottom, 0);
        this.mTextMargin.left = ta.getDimensionPixelSize(R.styleable.SlidingTabLayout_tl_textMarginStart, 0);
        this.mTextMargin.right = ta.getDimensionPixelSize(R.styleable.SlidingTabLayout_tl_textMarginEnd, 0);
        this.mTextMargin.top = ta.getDimensionPixelSize(R.styleable.SlidingTabLayout_tl_textMarginTop, 0);
        this.mTextMargin.bottom = ta.getDimensionPixelSize(R.styleable.SlidingTabLayout_tl_textMarginBottom, 0);
        this.mTabSpaceEqual = ta.getBoolean(R.styleable.SlidingTabLayout_tl_tab_space_equal, false);
        this.mTextRobotoBold = ta.getBoolean(R.styleable.SlidingTabLayout_tl_text_roboto_bold, false);
        this.mTabWidth = ta.getDimension(R.styleable.SlidingTabLayout_tl_tab_width, -1.0f);
        this.mTabEllipsize = ta.getInt(R.styleable.SlidingTabLayout_tl_tab_ellipsize, -1);
        this.mTabPadding = ta.getDimension(R.styleable.SlidingTabLayout_tl_tab_padding, this.mTabSpaceEqual || this.mTabWidth > 0.0f ? 0.0f : (float)this.dp2px(20.0f));
        this.mStartPadding = ta.getDimension(R.styleable.SlidingTabLayout_tl_tab_start_padding, (float)this.dp2px(15.0f));
        if (this.mStartPadding <= 0.0f) {
            this.mStartPadding = this.mTabPadding;
        }
        ta.recycle();
    }

    public void setViewPager(ViewPager vp) {
        if (vp == null || vp.getAdapter() == null) {
            throw new IllegalStateException("ViewPager or ViewPager adapter can not be NULL !");
        }
        this.mViewPager = vp;
        this.mViewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.mCurrentTab = 0;
        this.notifyDataSetChanged();
    }

    public void setViewPager(YYViewPager vp, String[] titles) {
        if (vp == null || vp.getAdapter() == null) {
            throw new IllegalStateException("ViewPager or ViewPager adapter can not be NULL !");
        }
        if (titles == null || titles.length == 0) {
            throw new IllegalStateException("Titles can not be EMPTY !");
        }
        if (titles.length != vp.getAdapter().getCount()) {
            throw new IllegalStateException("Titles length must be the same as the page count !");
        }
        this.mViewPager = vp;
        this.mTitles = new ArrayList(titles.length);
        Collections.addAll(this.mTitles, titles);
        this.mViewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.notifyDataSetChanged();
    }

    public void setViewPager(YYViewPager vp, String[] titles, FragmentActivity fa, ArrayList<Fragment> fragments) {
        if (vp == null) {
            throw new IllegalStateException("ViewPager can not be NULL !");
        }
        if (titles == null || titles.length == 0) {
            throw new IllegalStateException("Titles can not be EMPTY !");
        }
        this.mViewPager = vp;
        this.mViewPager.setAdapter((PagerAdapter)new InnerPagerAdapter(fa.getSupportFragmentManager(), fragments, titles));
        this.mViewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.notifyDataSetChanged();
    }

    public void notifyDataSetChanged() {
        this.mTabsContainer.removeAllViews();
        this.mTabItemList.clear();
        if (null == this.mViewPager || this.mViewPager.getAdapter() == null) {
            MLog.error((Object)TAG, (String)"notifyDataSetChanged mViewPager = null", (Object[])new Object[0]);
            return;
        }
        int tabCount = this.mTitles == null ? this.mViewPager.getAdapter().getCount() : this.mTitles.size();
        for (int i = 0; i < tabCount; ++i) {
            TabItem tabItem = this.createTabItem(i, this.mTitles == null ? this.mViewPager.getAdapter().getPageTitle(i) : (CharSequence)this.mTitles.get(i));
            this.mTabItemList.add(tabItem);
        }
        this.updateTabStyles();
    }

    private TabItem createTabItem(int index, CharSequence title) {
        ViewGroup root = (ViewGroup)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.sliding_tablayout_layout_tab, null);
        TabItem item = new TabItem();
        item.rootView = root;
        item.titleView = (TextView)root.findViewById(R.id.tv_tab_title);
        item.msgView = (MsgView)root.findViewById(R.id.rtv_msg_tip);
        item.redPoint = root.findViewById(R.id.view_red_point);
        item.index = index;
        item.title = title;
        item.titleView.setText(title);
        root.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (null == SlidingTabLayout.this.mViewPager) {
                    MLog.error((Object)SlidingTabLayout.TAG, (String)"tabView click mViewPager = null", (Object[])new Object[0]);
                    return;
                }
                int position = SlidingTabLayout.this.mTabsContainer.indexOfChild(v);
                if (position != -1) {
                    if (SlidingTabLayout.this.mViewPager.getCurrentItem() != position) {
                        if (SlidingTabLayout.this.mSnapOnTabClick) {
                            SlidingTabLayout.this.mViewPager.setCurrentItem(position, false);
                        } else {
                            SlidingTabLayout.this.mViewPager.setCurrentItem(position);
                        }
                        if (SlidingTabLayout.this.mListener != null) {
                            SlidingTabLayout.this.mListener.onTabSelect(position);
                        }
                    } else if (SlidingTabLayout.this.mListener != null) {
                        SlidingTabLayout.this.mListener.onTabReselect(position);
                    }
                }
            }
        });
        LinearLayout.LayoutParams params = this.mTabWidth > 0.0f ? new LinearLayout.LayoutParams((int)this.mTabWidth, -1) : (this.mTabSpaceEqual ? new LinearLayout.LayoutParams(0, -1, 1.0f) : new LinearLayout.LayoutParams(-2, -1));
        this.mTabsContainer.addView((View)root, index, (ViewGroup.LayoutParams)params);
        return item;
    }

    public void addNewTab(String title) {
        if (null == this.mViewPager || this.mViewPager.getAdapter() == null) {
            MLog.error((Object)TAG, (String)"addNewTab mViewPager = null", (Object[])new Object[0]);
            return;
        }
        TabItem tabItem = this.createTabItem(this.mTabItemList.size(), this.mTitles == null ? this.mViewPager.getAdapter().getPageTitle(this.mTabItemList.size()) : title);
        this.mTabItemList.add(tabItem);
        this.updateTabStyles();
    }

    private void updateTabStyles() {
        for (int i = 0; i < this.mTabItemList.size(); ++i) {
            TabItem tabItem = this.mTabItemList.get(i);
            boolean isSelected = i == this.mCurrentTab;
            TextView tvTabTitle = tabItem.titleView;
            ViewGroup rootView = tabItem.rootView;
            if (rootView == null || tvTabTitle == null) continue;
            tvTabTitle.setTextColor(isSelected ? this.mTextSelectColor : this.mTextUnselectColor);
            tvTabTitle.setTextSize(0, this.getTextSize(isSelected));
            int backgroundRes = 0;
            backgroundRes = isSelected ? this.mTextSelectBackground : this.mTextUnselectBackground;
            tvTabTitle.setBackgroundResource(backgroundRes);
            int paddingMiddle = (int)this.mTabPadding;
            int paddingStart = (int)this.mStartPadding;
            if (paddingStart == 0) {
                paddingStart = paddingMiddle;
            }
            if (i != 0) {
                if (i == this.mTabItemList.size() - 1) {
                    paddingMiddle = paddingStart = 0;
                } else {
                    paddingStart = 0;
                }
            }
            rootView.setPaddingRelative(paddingStart, rootView.getPaddingTop(), paddingMiddle, rootView.getPaddingBottom());
            tvTabTitle.setPaddingRelative(this.mTextPadding.left, this.mTextPadding.top, this.mTextPadding.right, this.mTextPadding.bottom);
            ViewGroup.LayoutParams lpTvTab = tvTabTitle.getLayoutParams();
            if (lpTvTab instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)lpTvTab;
                lp.setMarginStart(this.mTextMargin.left);
                lp.setMarginEnd(this.mTextMargin.right);
                lp.bottomMargin = this.mTextMargin.bottom;
                lp.topMargin = this.mTextMargin.top;
                tvTabTitle.setLayoutParams(lpTvTab);
            }
            if (this.mTabEllipsize == 0) {
                tvTabTitle.setEllipsize(null);
            } else {
                tvTabTitle.setEllipsize(TextUtils.TruncateAt.END);
            }
            if (this.mTextAllCaps) {
                tvTabTitle.setText((CharSequence)tvTabTitle.getText().toString().toUpperCase());
            }
            if (this.mTextBold == 2) {
                tvTabTitle.setTypeface(Typeface.DEFAULT_BOLD);
            } else if (this.mTextBold == 0) {
                tvTabTitle.getPaint().setFakeBoldText(false);
            }
            if (this.mTextRobotoBold) {
                tvTabTitle.setTypeface(Typeface.create((String)"sans-serif-medium", (int)0));
            }
            if (this.mTextBold == 1 && isSelected) {
                tvTabTitle.getPaint().setFakeBoldText(true);
            }
            if (isSelected) {
                if (tabItem.rootView.getWidth() == 0 || this.getWidth() == 0) {
                    this.mTabsContainer.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                        public boolean onPreDraw() {
                            SlidingTabLayout.this.mTabsContainer.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                            SlidingTabLayout.this.scrollToCurrentTab();
                            return true;
                        }
                    });
                } else {
                    this.scrollToCurrentTab();
                }
            }
            if (!this.mTextSizeAnim) continue;
            if (isSelected) {
                this.showAnimTipView(i);
                continue;
            }
            this.hideMsg(i);
        }
    }

    public void setTextFont(FontUtils.FontType type2) {
        for (int i = 0; i < this.mTabItemList.size(); ++i) {
            TabItem tabItem = this.mTabItemList.get(i);
            TextView tvTabTitle = tabItem.titleView;
            if (tvTabTitle == null) continue;
            tvTabTitle.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)type2));
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mScrollType == 0 && positionOffset > 0.0f) {
            this.mScrollType = position >= this.mCurrentTab ? 1 : 2;
            this.mScrollFrontTabIndex = this.mCurrentTab;
        }
        this.mCurrentTab = position;
        this.mCurrentPositionOffset = LanguageUtils.isLtr() ? positionOffset : -positionOffset;
        this.startTextSizeAnim(position, positionOffset);
        this.scrollToCurrentTab();
        this.invalidate();
        if (positionOffset == 0.0f) {
            this.updateTabSelection(position);
            this.mScrollType = 0;
            this.mClickTabIndex = -1;
        }
    }

    public void onPageSelected(int position) {
        if (this.mScrollType == 0) {
            this.mClickTabIndex = position;
        }
    }

    public void onPageScrollStateChanged(int state) {
    }

    private void scrollToCurrentTab() {
        TabItem tabItem = this.getTabItemOrNull(this.mCurrentTab);
        if (tabItem == null) {
            return;
        }
        int p = 0;
        if (this.mCurrentTab == 0) {
            p = this.mTabsContainer.getPaddingStart();
        }
        int offset = (int)(this.mCurrentPositionOffset * (float)tabItem.rootView.getWidth()) + p;
        int newScrollX = tabItem.rootView.getLeft() + offset;
        if (this.mCurrentTab > 0 || offset > 0) {
            newScrollX -= this.getWidth() / 2 - this.getPaddingLeft();
            this.calcIndicatorRect();
            newScrollX += (this.mTabRect.right - this.mTabRect.left) / 2;
        }
        if (newScrollX != this.mLastScrollX) {
            this.mLastScrollX = newScrollX;
            this.scrollTo(newScrollX, 0);
        }
    }

    private void startTextSizeAnim(int position, float positionOffset) {
        float textSize;
        TabItem nextItem;
        float textSize2;
        TextView tabTitle;
        int nextTab;
        if (this.mTextSelectSize <= 0.0f || this.mTextUnSelectSize <= 0.0f || this.mTextUnSelectSize == this.mTextSelectSize) {
            return;
        }
        if (this.mScrollType == 0) {
            return;
        }
        float diff = this.mTextSelectSize - this.mTextUnSelectSize;
        if (this.mScrollType == 1) {
            if (this.mClickTabIndex >= 0) {
                int distance = Math.abs(this.mClickTabIndex - position);
                if (distance > 1) {
                    return;
                }
                nextTab = this.mClickTabIndex;
            } else {
                nextTab = positionOffset == 0.0f ? position : position + 1;
            }
            if (this.mScrollFrontTabIndex == position - 1) {
                if (positionOffset == 0.0f) {
                    positionOffset = 1.0f;
                } else {
                    TabItem tabItem = this.getTabItemOrNull(this.mScrollFrontTabIndex);
                    if (tabItem != null) {
                        tabTitle = tabItem.titleView;
                        tabTitle.setTextSize(0, this.mTextUnSelectSize);
                        tabTitle.setTextColor(this.mTextUnselectColor);
                        tabTitle.getPaint().setFakeBoldText(false);
                        this.hideMsg(this.mScrollFrontTabIndex);
                    }
                    this.mScrollFrontTabIndex = position;
                }
            } else if (this.mScrollFrontTabIndex != position && positionOffset == 0.0f) {
                positionOffset = 1.0f;
            }
            TabItem tabItem = this.getTabItemOrNull(this.mScrollFrontTabIndex);
            if (tabItem != null) {
                tabTitle = tabItem.titleView;
                textSize2 = this.mTextSelectSize - diff * positionOffset;
                tabTitle.setTextSize(0, textSize2);
                if (this.mTextBold == 1) {
                    if (positionOffset < 0.6f) {
                        tabTitle.setTextColor(this.mTextSelectColor);
                        tabTitle.getPaint().setFakeBoldText(true);
                    } else {
                        tabTitle.setTextColor(this.mTextUnselectColor);
                        tabTitle.getPaint().setFakeBoldText(false);
                    }
                }
                if (positionOffset < 0.15f) {
                    this.showAnimTipView(this.mScrollFrontTabIndex, 1.0f - positionOffset, textSize2, true);
                } else {
                    this.hideMsg(this.mScrollFrontTabIndex);
                }
            }
            if (nextTab == this.mScrollFrontTabIndex) {
                return;
            }
            nextItem = this.getTabItemOrNull(nextTab);
            if (nextItem != null) {
                TextView tabTitle2 = nextItem.titleView;
                textSize = this.mTextUnSelectSize + diff * positionOffset;
                tabTitle2.setTextSize(0, textSize);
                if (this.mTextBold == 1) {
                    if (positionOffset > 0.6f) {
                        tabTitle2.getPaint().setFakeBoldText(true);
                        tabTitle2.setTextColor(this.mTextSelectColor);
                    } else {
                        tabTitle2.setTextColor(this.mTextUnselectColor);
                        tabTitle2.getPaint().setFakeBoldText(false);
                    }
                }
                if (positionOffset > 0.85f) {
                    this.showAnimTipView(nextTab, positionOffset, textSize, true);
                } else {
                    this.hideMsg(nextTab);
                }
            }
        }
        if (this.mScrollType == 2) {
            TabItem tabItem;
            if (this.mClickTabIndex >= 0) {
                int distance = Math.abs(this.mClickTabIndex - position);
                if (distance >= 1) {
                    return;
                }
                nextTab = this.mClickTabIndex;
            } else {
                nextTab = position;
            }
            if (this.mScrollFrontTabIndex == position) {
                if (positionOffset == 0.0f) {
                    positionOffset = 1.0f;
                }
            } else if (this.mScrollFrontTabIndex - position == 1) {
                if ((float)position == 0.0f) {
                    // empty if block
                }
            } else {
                TabItem tabItem2 = this.getTabItemOrNull(this.mScrollFrontTabIndex);
                if (tabItem2 != null) {
                    tabTitle = tabItem2.titleView;
                    tabTitle.setTextSize(0, this.mTextUnSelectSize);
                    tabTitle.setTextColor(this.mTextUnselectColor);
                    tabTitle.getPaint().setFakeBoldText(false);
                    this.hideMsg(this.mScrollFrontTabIndex);
                }
                this.mScrollFrontTabIndex = position + 1;
            }
            if ((tabItem = this.getTabItemOrNull(this.mScrollFrontTabIndex)) != null) {
                tabTitle = tabItem.titleView;
                textSize2 = this.mTextSelectSize - (1.0f - positionOffset) * diff;
                tabTitle.setTextSize(0, textSize2);
                if (this.mTextBold == 1) {
                    if (positionOffset > 0.3f) {
                        tabTitle.getPaint().setFakeBoldText(true);
                        tabTitle.setTextColor(this.mTextSelectColor);
                    } else {
                        tabTitle.setTextColor(this.mTextUnselectColor);
                        tabTitle.getPaint().setFakeBoldText(false);
                    }
                }
                if (positionOffset > 0.85f) {
                    this.showAnimTipView(this.mScrollFrontTabIndex, positionOffset, textSize2, true);
                } else {
                    this.hideMsg(this.mScrollFrontTabIndex);
                }
            }
            if (nextTab == this.mScrollFrontTabIndex) {
                return;
            }
            nextItem = this.getTabItemOrNull(nextTab);
            if (nextItem != null) {
                TextView tabTitle3 = nextItem.titleView;
                textSize = this.mTextUnSelectSize + (1.0f - positionOffset) * diff;
                tabTitle3.setTextSize(0, textSize);
                if (this.mTextBold == 1) {
                    if (positionOffset < 0.3f) {
                        tabTitle3.getPaint().setFakeBoldText(true);
                        tabTitle3.setTextColor(this.mTextSelectColor);
                    } else {
                        tabTitle3.getPaint().setFakeBoldText(false);
                        tabTitle3.setTextColor(this.mTextUnselectColor);
                    }
                }
                if (positionOffset < 0.15f) {
                    this.showAnimTipView(nextTab, 1.0f - positionOffset, textSize, true);
                } else {
                    this.hideMsg(nextTab);
                }
            }
        }
    }

    public void updateTabSelection(int position) {
        for (int i = 0; i < this.mTabItemList.size(); ++i) {
            TabItem tabItem = this.mTabItemList.get(i);
            boolean isSelect = i == position;
            TextView tabTitle = tabItem.titleView;
            if (tabTitle == null) continue;
            tabTitle.setTextColor(isSelect ? this.mTextSelectColor : this.mTextUnselectColor);
            if (this.mTextBold == 1) {
                tabTitle.getPaint().setFakeBoldText(isSelect);
            }
            if (this.mTextSelectSize == 0.0f || this.mTextUnSelectSize == 0.0f) {
                tabTitle.setTextSize(0, this.mTextsize);
            } else {
                tabTitle.setTextSize(0, isSelect ? this.mTextSelectSize : this.mTextUnSelectSize);
            }
            int backgroundRes = 0;
            backgroundRes = isSelect ? this.mTextSelectBackground : this.mTextUnselectBackground;
            tabTitle.setBackgroundResource(backgroundRes);
            if (!this.mTextSizeAnim) continue;
            if (isSelect) {
                this.showAnimTipView(i);
                continue;
            }
            this.hideMsg(i);
        }
        if (this.mTabPositionChangedListener != null) {
            this.mTabPositionChangedListener.onUpdateTabPosition(position);
        }
    }

    private TabItem getTabItemOrNull(int position) {
        if (position < 0 || position >= this.mTabItemList.size()) {
            return null;
        }
        return this.mTabItemList.get(position);
    }

    private void showAnimTipView(int position) {
        this.showAnimTipView(position, 1.0f, this.mTextSelectSize, false);
    }

    private void showAnimTipView(int position, float ratio, float textSize, boolean force) {
        if (!this.mTextSizeAnim) {
            return;
        }
        TabItem tabItem = this.getTabItemOrNull(position);
        if (tabItem == null) {
            return;
        }
        ViewGroup rootView = tabItem.rootView;
        if (rootView == null) {
            return;
        }
        int height = rootView.getHeight();
        int width = rootView.getWidth();
        if (height == 0 || width == 0) {
            this.mTabsContainer.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener((View)rootView, tabItem, position, ratio, textSize, force){
                final /* synthetic */ View val$rootView;
                final /* synthetic */ TabItem val$tabItem;
                final /* synthetic */ int val$position;
                final /* synthetic */ float val$ratio;
                final /* synthetic */ float val$textSize;
                final /* synthetic */ boolean val$force;
                {
                    this.val$rootView = view;
                    this.val$tabItem = tabItem;
                    this.val$position = n;
                    this.val$ratio = f;
                    this.val$textSize = f2;
                    this.val$force = bl;
                }

                public boolean onPreDraw() {
                    SlidingTabLayout.this.mTabsContainer.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    int realHeight = this.val$rootView.getHeight();
                    int realWidth = this.val$rootView.getWidth();
                    SlidingTabLayout.this.realShowAnimTipView(this.val$tabItem, realHeight, realWidth, this.val$position, this.val$ratio, this.val$textSize, this.val$force);
                    return true;
                }
            });
        } else {
            this.realShowAnimTipView(tabItem, height, width, position, ratio, textSize, force);
        }
    }

    private void realShowAnimTipView(TabItem tabItem, int height, int width, int position, float ratio, float textSize, boolean force) {
        int leftMargin;
        if (position != this.mCurrentTab && !force) {
            return;
        }
        TextView tabTitle = tabItem.titleView;
        MsgView msgView = tabItem.msgView;
        msgView.setOnlyBackgrounp(true);
        if (this.mAnimTipGradientDrawable == null) {
            this.mAnimTipGradientDrawable = new GradientDrawable();
            this.mAnimTipGradientDrawable.setShape(1);
            this.mAnimTipGradientDrawable.setColor(ColorUtils.parseColor((String)"#ffc102"));
        }
        msgView.setBackground((Drawable)this.mAnimTipGradientDrawable);
        if (msgView.getVisibility() != 0) {
            msgView.setVisibility(0);
        }
        int size = (int)((float)this.dp2px(16.0f) * ratio);
        this.mTextPaint.setTextSize(textSize);
        float textWidth = this.mTextPaint.measureText(tabTitle.getText().toString());
        float textHeight = this.mTextPaint.descent() - this.mTextPaint.ascent();
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)msgView.getLayoutParams();
        lp.leftMargin = leftMargin = (int)((float)width - ((float)width - textWidth) / 2.0f - 0.75f * (float)size);
        if (Build.VERSION.SDK_INT > 16) {
            lp.setMarginStart(leftMargin);
        }
        lp.topMargin = (int)(((float)height - textHeight) / 2.0f);
        lp.width = size;
        lp.height = size;
        msgView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    private void calcIndicatorRect() {
        ViewGroup currentTabView;
        TabItem tabItem = this.getTabItemOrNull(this.mCurrentTab);
        ViewGroup viewGroup = currentTabView = tabItem == null ? null : tabItem.rootView;
        if (currentTabView == null) {
            return;
        }
        float left = currentTabView.getLeft();
        float right = currentTabView.getRight();
        if (this.mIndicatorStyle == 0 && this.mIndicatorWidthEqualTitle) {
            TextView tabTitle = tabItem.titleView;
            this.mTextPaint.setTextSize(this.getTextSize(true));
            float textWidth = this.mTextPaint.measureText(tabTitle.getText().toString());
            this.margin = (right - left - textWidth) / 2.0f;
        }
        if (this.mCurrentTab < this.mTabItemList.size() - 1) {
            TabItem nextTabItem = this.mTabItemList.get(this.mCurrentTab + 1);
            ViewGroup nextTabView = nextTabItem.rootView;
            float nextTabLeft = nextTabView.getLeft();
            float nextTabRight = nextTabView.getRight();
            left += this.mCurrentPositionOffset * (nextTabLeft - left);
            right += this.mCurrentPositionOffset * (nextTabRight - right);
            if (this.mIndicatorStyle == 0 && this.mIndicatorWidthEqualTitle) {
                TextView nextTabTitle = nextTabItem.titleView;
                this.mTextPaint.setTextSize(this.getTextSize(false));
                float nextTextWidth = this.mTextPaint.measureText(nextTabTitle.getText().toString());
                float nextMargin = (nextTabRight - nextTabLeft - nextTextWidth) / 2.0f;
                this.margin += this.mCurrentPositionOffset * (nextMargin - this.margin);
            }
        }
        this.mIndicatorRect.left = (int)left;
        this.mIndicatorRect.right = (int)right;
        if (this.mIndicatorStyle == 0 && this.mIndicatorWidthEqualTitle) {
            this.mIndicatorRect.left = (int)(left + this.margin - 1.0f);
            this.mIndicatorRect.right = (int)(right - this.margin - 1.0f);
        }
        this.mTabRect.left = (int)left;
        this.mTabRect.right = (int)right;
        if (!(this.mIndicatorWidth < 0.0f)) {
            float indicatorLeft = (float)currentTabView.getLeft() + ((float)currentTabView.getWidth() - this.mIndicatorWidth) / 2.0f;
            if (this.mCurrentTab < this.mTabItemList.size() - 1) {
                TabItem nextItem = this.mTabItemList.get(this.mCurrentTab + 1);
                ViewGroup nextTab = nextItem.rootView;
                indicatorLeft += this.mCurrentPositionOffset * (float)(currentTabView.getWidth() + nextTab.getWidth()) / 2.0f;
            }
            this.mIndicatorRect.left = (int)indicatorLeft;
            this.mIndicatorRect.right = (int)((float)this.mIndicatorRect.left + this.mIndicatorWidth);
            if (this.mTextSizeAnim) {
                float mPositionOffset = Math.abs(this.mCurrentPositionOffset);
                int width = mPositionOffset <= 0.5f ? (int)(this.mIndicatorWidth + this.mIndicatorWidth * 2.0f * mPositionOffset) : (int)(this.mIndicatorWidth + this.mIndicatorWidth * 2.0f * (1.0f - mPositionOffset));
                this.mIndicatorRect.right = this.mIndicatorRect.left + width;
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInEditMode() || this.mTabItemList.size() <= 0) {
            return;
        }
        int height = this.getHeight();
        int paddingLeft = this.getPaddingLeft();
        if (this.mDividerWidth > 0.0f) {
            this.mDividerPaint.setStrokeWidth(this.mDividerWidth);
            this.mDividerPaint.setColor(this.mDividerColor);
            for (int i = 0; i < this.mTabItemList.size() - 1; ++i) {
                TabItem tabItem = this.mTabItemList.get(i);
                ViewGroup tab = tabItem.rootView;
                canvas.drawLine((float)(paddingLeft + tab.getRight()), this.mDividerPadding, (float)(paddingLeft + tab.getRight()), (float)height - this.mDividerPadding, this.mDividerPaint);
            }
        }
        if (this.mUnderlineHeight > 0.0f) {
            this.mRectPaint.setColor(this.mUnderlineColor);
            if (this.mUnderlineGravity == 80) {
                canvas.drawRect((float)paddingLeft, (float)height - this.mUnderlineHeight, (float)(this.mTabsContainer.getWidth() + paddingLeft), (float)height, this.mRectPaint);
            } else {
                canvas.drawRect((float)paddingLeft, 0.0f, (float)(this.mTabsContainer.getWidth() + paddingLeft), this.mUnderlineHeight, this.mRectPaint);
            }
        }
        this.calcIndicatorRect();
        if (this.mIndicatorStyle == 1) {
            if (this.mIndicatorHeight > 0.0f) {
                this.mTrianglePaint.setColor(this.mIndicatorColor);
                this.mTrianglePath.reset();
                this.mTrianglePath.moveTo((float)(paddingLeft + this.mIndicatorRect.left), (float)height);
                this.mTrianglePath.lineTo((float)(paddingLeft + (this.mIndicatorRect.left + this.mIndicatorRect.right) / 2), (float)height - this.mIndicatorHeight);
                this.mTrianglePath.lineTo((float)(paddingLeft + this.mIndicatorRect.right), (float)height);
                this.mTrianglePath.close();
                canvas.drawPath(this.mTrianglePath, this.mTrianglePaint);
            }
        } else if (this.mIndicatorStyle == 2) {
            if (this.mIndicatorHeight < 0.0f) {
                this.mIndicatorHeight = (float)height - this.mIndicatorMarginTop - this.mIndicatorMarginBottom;
            }
            if (this.mIndicatorHeight > 0.0f) {
                if (this.mIndicatorCornerRadius < 0.0f || this.mIndicatorCornerRadius > this.mIndicatorHeight / 2.0f) {
                    this.mIndicatorCornerRadius = this.mIndicatorHeight / 2.0f;
                }
                this.mIndicatorDrawable.setColor(this.mIndicatorColor);
                this.mIndicatorDrawable.setBounds(paddingLeft + (int)this.mIndicatorMarginLeft + this.mIndicatorRect.left, (int)this.mIndicatorMarginTop, (int)((float)(paddingLeft + this.mIndicatorRect.right) - this.mIndicatorMarginRight), (int)(this.mIndicatorMarginTop + this.mIndicatorHeight));
                this.mIndicatorDrawable.setCornerRadius(this.mIndicatorCornerRadius);
                this.mIndicatorDrawable.draw(canvas);
            }
        } else if (this.mIndicatorHeight > 0.0f) {
            this.mIndicatorDrawable.setColor(this.mIndicatorColor);
            if (this.mIndicatorGravity == 80) {
                this.mIndicatorDrawable.setBounds(paddingLeft + (int)this.mIndicatorMarginLeft + this.mIndicatorRect.left, height - (int)this.mIndicatorHeight - (int)this.mIndicatorMarginBottom, paddingLeft + this.mIndicatorRect.right - (int)this.mIndicatorMarginRight, height - (int)this.mIndicatorMarginBottom);
            } else {
                this.mIndicatorDrawable.setBounds(paddingLeft + (int)this.mIndicatorMarginLeft + this.mIndicatorRect.left, (int)this.mIndicatorMarginTop, paddingLeft + this.mIndicatorRect.right - (int)this.mIndicatorMarginRight, (int)this.mIndicatorHeight + (int)this.mIndicatorMarginTop);
            }
            this.mIndicatorDrawable.setCornerRadius(this.mIndicatorCornerRadius);
            this.mIndicatorDrawable.draw(canvas);
        }
    }

    public void setCurrentTab(int currentTab, boolean smoothScroll) {
        if (null == this.mViewPager) {
            MLog.error((Object)TAG, (String)"setCurrentTab mViewPager = null", (Object[])new Object[0]);
            return;
        }
        this.mCurrentTab = currentTab;
        this.mViewPager.setCurrentItem(currentTab, smoothScroll);
    }

    public void setIndicatorGravity(int indicatorGravity) {
        this.mIndicatorGravity = indicatorGravity;
        this.invalidate();
    }

    public void setIndicatorMargin(float indicatorMarginLeft, float indicatorMarginTop, float indicatorMarginRight, float indicatorMarginBottom) {
        this.mIndicatorMarginLeft = indicatorMarginLeft;
        this.mIndicatorMarginTop = indicatorMarginTop;
        this.mIndicatorMarginRight = indicatorMarginRight;
        this.mIndicatorMarginBottom = indicatorMarginBottom;
        this.invalidate();
    }

    public void setIndicatorWidthEqualTitle(boolean indicatorWidthEqualTitle) {
        this.mIndicatorWidthEqualTitle = indicatorWidthEqualTitle;
        this.invalidate();
    }

    public void setUnderlineGravity(int underlineGravity) {
        this.mUnderlineGravity = underlineGravity;
        this.invalidate();
    }

    public void setTextSize(float textsize) {
        this.mTextsize = textsize;
        this.updateTabStyles();
    }

    public void setTextSelectSize(float textsize) {
        this.mTextSelectSize = textsize;
        this.updateTabStyles();
    }

    public void setTextUnSelectSize(float textsize) {
        this.mTextUnSelectSize = textsize;
        this.updateTabStyles();
    }

    public void setTextSelectBackground(int background) {
        this.mTextSelectBackground = background;
        this.updateTabStyles();
    }

    public void setTextUnselectBackground(int background) {
        this.mTextUnselectBackground = background;
        this.updateTabStyles();
    }

    public void setTextPadding(int paddingStart, int paddingTop, int paddingEnd, int paddingBottom) {
        this.mTextPadding.set(paddingStart, paddingTop, paddingEnd, paddingBottom);
        this.updateTabStyles();
    }

    public void setTextPaddingStart(int paddingStart) {
        this.mTextPadding.left = paddingStart;
        this.updateTabStyles();
    }

    public void setTextPaddingEnd(int paddingEnd) {
        this.mTextPadding.right = paddingEnd;
        this.updateTabStyles();
    }

    public void setTextPaddingTop(int paddingTop) {
        this.mTextPadding.top = paddingTop;
        this.updateTabStyles();
    }

    public void setTextPaddingBottom(int paddingBottom) {
        this.mTextPadding.bottom = paddingBottom;
        this.updateTabStyles();
    }

    public void setSnapOnTabClick(boolean snapOnTabClick) {
        this.mSnapOnTabClick = snapOnTabClick;
    }

    public int getTabCount() {
        return this.mTabItemList.size();
    }

    public int getCurrentTab() {
        return this.mCurrentTab;
    }

    public void setCurrentTab(int currentTab) {
        if (null == this.mViewPager) {
            MLog.error((Object)TAG, (String)"setCurrentTab mViewPager = null", (Object[])new Object[0]);
            return;
        }
        this.mCurrentTab = currentTab;
        this.mViewPager.setCurrentItem(currentTab);
    }

    public int getIndicatorStyle() {
        return this.mIndicatorStyle;
    }

    public void setIndicatorStyle(int indicatorStyle) {
        this.mIndicatorStyle = indicatorStyle;
        this.invalidate();
    }

    public float getTabPadding() {
        return this.mTabPadding;
    }

    public void setTabPadding(float tabPadding) {
        this.mTabPadding = tabPadding;
        this.updateTabStyles();
    }

    public void setTabStartPadding(float tabStartPadding) {
        this.mStartPadding = tabStartPadding;
        this.updateTabStyles();
    }

    public float getTabStartPadding() {
        return this.mStartPadding;
    }

    public boolean isTabSpaceEqual() {
        return this.mTabSpaceEqual;
    }

    public void setTabSpaceEqual(boolean tabSpaceEqual) {
        this.mTabSpaceEqual = tabSpaceEqual;
        this.updateTabStyles();
    }

    public float getTabWidth() {
        return this.mTabWidth;
    }

    public void setTabWidth(float tabWidth) {
        this.mTabWidth = this.dp2px(tabWidth);
        this.updateTabStyles();
    }

    public int getIndicatorColor() {
        return this.mIndicatorColor;
    }

    public void setIndicatorColor(int indicatorColor) {
        this.mIndicatorColor = indicatorColor;
        this.invalidate();
    }

    public float getIndicatorHeight() {
        return this.mIndicatorHeight;
    }

    public void setIndicatorHeight(float indicatorHeight) {
        this.mIndicatorHeight = indicatorHeight;
        this.invalidate();
    }

    public float getIndicatorWidth() {
        return this.mIndicatorWidth;
    }

    public void setIndicatorWidth(float indicatorWidth) {
        this.mIndicatorWidth = indicatorWidth;
        this.invalidate();
    }

    public float getIndicatorCornerRadius() {
        return this.mIndicatorCornerRadius;
    }

    public void setIndicatorCornerRadius(float indicatorCornerRadius) {
        this.mIndicatorCornerRadius = indicatorCornerRadius;
        this.invalidate();
    }

    public float getIndicatorMarginLeft() {
        return this.mIndicatorMarginLeft;
    }

    public float getIndicatorMarginTop() {
        return this.mIndicatorMarginTop;
    }

    public void setIndicatorMarginTop(float indicatorMarginTop) {
        this.mIndicatorMarginTop = indicatorMarginTop;
        this.invalidate();
    }

    public void setIndicatorMarginLeft(float indicatorMarginLeft) {
        this.mIndicatorMarginLeft = indicatorMarginLeft;
        this.invalidate();
    }

    public void setIndicatorMarginBottom(float indicatorMarginBottom) {
        this.mIndicatorMarginBottom = indicatorMarginBottom;
        this.invalidate();
    }

    public void setIndicatorMarginRight(float indicatorMarginRight) {
        this.mIndicatorMarginRight = indicatorMarginRight;
        this.invalidate();
    }

    public float getIndicatorMarginRight() {
        return this.mIndicatorMarginRight;
    }

    public float getIndicatorMarginBottom() {
        return this.mIndicatorMarginBottom;
    }

    public int getUnderlineColor() {
        return this.mUnderlineColor;
    }

    public void setUnderlineColor(int underlineColor) {
        this.mUnderlineColor = underlineColor;
        this.invalidate();
    }

    public float getUnderlineHeight() {
        return this.mUnderlineHeight;
    }

    public void setUnderlineHeight(float underlineHeight) {
        this.mUnderlineHeight = this.dp2px(underlineHeight);
        this.invalidate();
    }

    public int getDividerColor() {
        return this.mDividerColor;
    }

    public void setDividerColor(int dividerColor) {
        this.mDividerColor = dividerColor;
        this.invalidate();
    }

    public float getDividerWidth() {
        return this.mDividerWidth;
    }

    public void setDividerWidth(float dividerWidth) {
        this.mDividerWidth = this.dp2px(dividerWidth);
        this.invalidate();
    }

    public float getDividerPadding() {
        return this.mDividerPadding;
    }

    public void setDividerPadding(float dividerPadding) {
        this.mDividerPadding = this.dp2px(dividerPadding);
        this.invalidate();
    }

    public float getTextSize(boolean isSelect) {
        if (this.mTextUnSelectSize > 0.0f && this.mTextSelectSize > 0.0f) {
            if (isSelect) {
                return this.mTextSelectSize;
            }
            return this.mTextUnSelectSize;
        }
        return this.mTextsize;
    }

    public int getTextSelectColor() {
        return this.mTextSelectColor;
    }

    public void setTextSelectColor(int textSelectColor) {
        this.mTextSelectColor = textSelectColor;
        this.updateTabStyles();
    }

    public int getTextUnselectColor() {
        return this.mTextUnselectColor;
    }

    public void setTextUnselectColor(int textUnselectColor) {
        this.mTextUnselectColor = textUnselectColor;
        this.updateTabStyles();
    }

    public int getTextBold() {
        return this.mTextBold;
    }

    public void setTextBold(int textBold) {
        this.mTextBold = textBold;
        this.updateTabStyles();
    }

    public boolean isTextAllCaps() {
        return this.mTextAllCaps;
    }

    public void setTextAllCaps(boolean textAllCaps) {
        this.mTextAllCaps = textAllCaps;
        this.updateTabStyles();
    }

    public TextView getTitleView(int tab) {
        TabItem tabItem = this.getTabItemOrNull(tab);
        return tabItem == null ? null : tabItem.titleView;
    }

    public boolean isTabCenterHorizontal() {
        return this.mTabCenterHorizontal;
    }

    public void setTabCenterHorizontal(boolean tabCenterHorizontal) {
        this.mTabCenterHorizontal = tabCenterHorizontal;
        if (this.mTabCenterHorizontal) {
            this.mTabsContainer.setGravity(1);
        }
    }

    public void showMsg(int position, int num) {
        if (num <= 0) {
            this.showRedDot(position);
        } else {
            TabItem tabItem;
            MsgView tipView;
            if (position >= this.mTabItemList.size()) {
                position = this.mTabItemList.size() - 1;
            }
            MsgView msgView = tipView = (tabItem = this.getTabItemOrNull(position)) == null ? null : tabItem.msgView;
            if (tipView != null && tipView.getVisibility() != 0) {
                tipView.setVisibility(0);
                if (num > 0) {
                    tipView.setText(String.valueOf(num));
                } else {
                    tipView.setText("");
                }
            }
        }
    }

    public void showDot(int position) {
        if (position >= this.mTabItemList.size()) {
            position = this.mTabItemList.size() - 1;
        }
        this.showMsg(position, 0);
    }

    public void showRedDot(int position) {
        TabItem tabItem;
        View redPointView;
        if (position >= this.mTabItemList.size()) {
            position = this.mTabItemList.size() - 1;
        }
        View view = redPointView = (tabItem = this.getTabItemOrNull(position)) == null ? null : tabItem.redPoint;
        if (redPointView != null) {
            redPointView.setVisibility(0);
        }
    }

    public void hideRedDot(int position) {
        TabItem tabItem;
        View redPointView;
        if (position >= this.mTabItemList.size()) {
            position = this.mTabItemList.size() - 1;
        }
        View view = redPointView = (tabItem = this.getTabItemOrNull(position)) == null ? null : tabItem.redPoint;
        if (redPointView != null) {
            redPointView.setVisibility(8);
        }
    }

    public boolean isRedDotShow(int position) {
        TabItem tabItem;
        View redPointView;
        if (position >= this.mTabItemList.size()) {
            position = this.mTabItemList.size() - 1;
        }
        View view = redPointView = (tabItem = this.getTabItemOrNull(position)) == null ? null : tabItem.redPoint;
        if (redPointView != null) {
            return redPointView.getVisibility() == 0;
        }
        return false;
    }

    public void hideMsg(int position) {
        TabItem tabItem;
        MsgView tipView;
        if (position >= this.mTabItemList.size()) {
            position = this.mTabItemList.size() - 1;
        }
        MsgView msgView = tipView = (tabItem = this.getTabItemOrNull(position)) == null ? null : tabItem.msgView;
        if (tipView != null) {
            tipView.setVisibility(8);
        }
    }

    public MsgView getMsgView(int position) {
        TabItem tabItem;
        if (position >= this.mTabItemList.size()) {
            position = this.mTabItemList.size() - 1;
        }
        return (tabItem = this.getTabItemOrNull(position)) == null ? null : tabItem.msgView;
    }

    public void setOnTabSelectListener(OnTabSelectListener listener2) {
        this.mListener = listener2;
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("instanceState", super.onSaveInstanceState());
        bundle.putInt("mCurrentTab", this.mCurrentTab);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mCurrentTab = bundle.getInt("mCurrentTab");
            state = bundle.getParcelable("instanceState");
            if (this.mCurrentTab != 0 && this.mTabsContainer.getChildCount() > 0) {
                this.updateTabSelection(this.mCurrentTab);
                this.scrollToCurrentTab();
            }
        }
        super.onRestoreInstanceState(state);
    }

    public void setOnTabPositionChangedListener(OnTabPositionChangedListener mListener) {
        this.mTabPositionChangedListener = mListener;
    }

    protected int dp2px(float dp) {
        if (this.mContext == null) {
            this.mContext = RuntimeContext.sApplicationContext;
        }
        float scale = this.mContext.getResources().getDisplayMetrics().density;
        return (int)(dp * scale + 0.5f);
    }

    protected int sp2px(float sp) {
        if (this.mContext == null) {
            this.mContext = RuntimeContext.sApplicationContext;
        }
        float scale = this.mContext.getResources().getDisplayMetrics().scaledDensity;
        return (int)(sp * scale + 0.5f);
    }

    static class InnerPagerAdapter
    extends FragmentPagerAdapter {
        private ArrayList<Fragment> fragments = new ArrayList(0);
        private String[] titles;

        public InnerPagerAdapter(FragmentManager fm, ArrayList<Fragment> fragments, String[] titles) {
            super(fm);
            this.fragments = fragments;
            this.titles = titles;
        }

        public int getCount() {
            return this.fragments.size();
        }

        public CharSequence getPageTitle(int position) {
            return this.titles[position];
        }

        public Fragment getItem(int position) {
            return this.fragments.get(position);
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
        }

        public int getItemPosition(Object object) {
            return -2;
        }
    }

    private class TabItem {
        public ViewGroup rootView;
        public TextView titleView;
        public MsgView msgView;
        public View redPoint;
        public int index;
        public CharSequence title;

        private TabItem() {
        }
    }
}

