/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.tab;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.R;
import com.yy.appbase.ui.widget.tab.BadgeView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageButton;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.ResolutionUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@Deprecated
public class PagerSlidingTabStrip
extends HorizontalScrollView {
    private static final int[] ATTRS = new int[]{16842901, 16842904};
    private final PageListener pageListener = new PageListener();
    private static final String FADING_NORMAL = "normal";
    private static final String FADING_SELECTED = "selected";
    public SlidingTabListener delegatePageListener;
    OnClickCallBack onClickCallBack;
    List<Map<String, View>> tabViews = new ArrayList<Map<String, View>>();
    private LinearLayout.LayoutParams matchparentTabLayoutParams;
    private LinearLayout.LayoutParams defaultTabLayoutParams;
    private LinearLayout.LayoutParams expandedTabLayoutParams;
    private LinearLayout tabsContainer;
    private ViewPager pager;
    private int tabCount;
    private int currentPosition = 0;
    private float currentPositionOffset = 0.0f;
    private int selectedPosition = 0;
    private Paint rectPaint;
    private Paint dividerPaint;
    private RectF rect;
    private int indicatorColor = -30464;
    private int underlineColor = -8960;
    private int dividerColor = -259;
    private boolean smoothScroll = false;
    private boolean shouldExpand = false;
    private boolean expandWrap = false;
    private boolean textAllCaps = false;
    private int scrollOffset;
    private int indicatorHeight = 3;
    private int underlineHeight = 0;
    private int dividerPadding = 12;
    private int tabPadding = 16;
    private int indicatorPadding = 5;
    private int dividerWidth = 1;
    private int lineBottomPadding = 4;
    private float rectOvalRx = 2.0f;
    private float rectOvalRy = 2.0f;
    private int oldPage;
    private int tabTextSize = 14;
    private int tabPressTextSize = 15;
    private int tabTextColor = -6710887;
    private int tabPressTextColor = -13421773;
    private Typeface tabTypeface = null;
    private int tabTypefaceStyle = 0;
    private int lastScrollX = 0;
    private boolean centerMode = false;
    private int tabBackgroundResId = R.drawable.pst_background_tab;
    private CustomTabDecorator tabDecorator;
    private CustomTabUpdateTextDecorator tabUpdateTextDecorator;
    private Locale locale;
    private Context context;
    private boolean mFadeEnabled = false;
    private boolean useFadeEffect = false;
    private boolean hasOffset = false;
    private int paddingLeft;
    private MyViewTreeGlobalLayoutObserver mMyGlobalLayoutObserver;
    private boolean needAnimate = true;
    private IndicatorSizeFetcher mFetcher = new IndicatorSizeFetcher(){

        @Override
        public float getLength(int position) {
            return TypedValue.applyDimension((int)2, (float)14.0f, (DisplayMetrics)PagerSlidingTabStrip.this.getResources().getDisplayMetrics());
        }
    };
    private IndicatorSizeFetcher mAutoAdjustFetcher = new IndicatorSizeFetcher(){

        @Override
        public float getLength(int position) {
            float width = PagerSlidingTabStrip.this.getContentTextRect(position).width();
            if (width != -1.0f) {
                return width;
            }
            return TypedValue.applyDimension((int)2, (float)14.0f, (DisplayMetrics)PagerSlidingTabStrip.this.getResources().getDisplayMetrics());
        }
    };
    private float zoomMax = 0.2f;
    private State mState;
    private OnTabClickListener mOnTabClickListener;
    LinearLayout.LayoutParams mAverageMarginTabParams = new LinearLayout.LayoutParams(-2, -1);
    LinearLayout.LayoutParams mAverageMarginGapViewParams = new LinearLayout.LayoutParams(-1, 0, 1.0f);
    private boolean isAverageMargin = false;

    public PagerSlidingTabStrip(Context context) {
        this(context, null);
    }

    public PagerSlidingTabStrip(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PagerSlidingTabStrip(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.context = context;
        this.setFillViewport(true);
        this.setWillNotDraw(false);
        this.tabsContainer = new YYLinearLayout(context);
        this.tabsContainer.setOrientation(0);
        this.tabsContainer.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        this.scrollOffset = ResolutionUtils.getScreenWidth((Context)context);
        this.indicatorHeight = (int)TypedValue.applyDimension((int)1, (float)this.indicatorHeight, (DisplayMetrics)dm);
        this.underlineHeight = (int)TypedValue.applyDimension((int)1, (float)this.underlineHeight, (DisplayMetrics)dm);
        this.dividerPadding = (int)TypedValue.applyDimension((int)1, (float)this.dividerPadding, (DisplayMetrics)dm);
        this.tabPadding = (int)TypedValue.applyDimension((int)1, (float)this.tabPadding, (DisplayMetrics)dm);
        this.indicatorPadding = (int)TypedValue.applyDimension((int)1, (float)this.indicatorPadding, (DisplayMetrics)dm);
        this.dividerWidth = (int)TypedValue.applyDimension((int)1, (float)this.dividerWidth, (DisplayMetrics)dm);
        this.tabTextSize = (int)TypedValue.applyDimension((int)2, (float)this.tabTextSize, (DisplayMetrics)dm);
        this.tabPressTextSize = (int)TypedValue.applyDimension((int)2, (float)this.tabPressTextSize, (DisplayMetrics)dm);
        this.lineBottomPadding = (int)TypedValue.applyDimension((int)1, (float)this.lineBottomPadding, (DisplayMetrics)dm);
        this.rectOvalRx = (int)TypedValue.applyDimension((int)1, (float)this.rectOvalRx, (DisplayMetrics)dm);
        this.rectOvalRy = (int)TypedValue.applyDimension((int)1, (float)this.rectOvalRy, (DisplayMetrics)dm);
        TypedArray a = context.obtainStyledAttributes(attrs, ATTRS);
        this.tabTextSize = a.getDimensionPixelSize(0, this.tabTextSize);
        this.tabPressTextSize = a.getDimensionPixelSize(0, this.tabPressTextSize);
        this.tabTextColor = a.getColor(1, this.tabTextColor);
        a.recycle();
        a = context.obtainStyledAttributes(attrs, R.styleable.PagerSlidingTabStrip);
        this.indicatorColor = a.getColor(R.styleable.PagerSlidingTabStrip_pstsIndicatorColor, this.indicatorColor);
        this.dividerColor = a.getColor(R.styleable.PagerSlidingTabStrip_pstsDividerColor, this.dividerColor);
        this.indicatorHeight = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsIndicatorHeight, this.indicatorHeight);
        this.underlineHeight = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsUnderlineHeight, this.underlineHeight);
        this.dividerPadding = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsDividerPadding, this.dividerPadding);
        this.tabPadding = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsTabPaddingLeftRight, this.tabPadding);
        this.indicatorPadding = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsIndicatorPadding, this.indicatorPadding);
        this.tabBackgroundResId = a.getResourceId(R.styleable.PagerSlidingTabStrip_pstsTabBackground, this.tabBackgroundResId);
        this.shouldExpand = a.getBoolean(R.styleable.PagerSlidingTabStrip_pstsShouldExpand, this.shouldExpand);
        this.expandWrap = a.getBoolean(R.styleable.PagerSlidingTabStrip_pstsExpandWrap, this.expandWrap);
        this.textAllCaps = a.getBoolean(R.styleable.PagerSlidingTabStrip_pstsTextAllCaps, this.textAllCaps);
        this.smoothScroll = a.getBoolean(R.styleable.PagerSlidingTabStrip_pstsSmoothScroll, this.smoothScroll);
        this.tabTextSize = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsTextSize, this.tabTextSize);
        this.tabPressTextSize = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsPressTextSize, this.tabPressTextSize);
        this.lineBottomPadding = a.getDimensionPixelSize(R.styleable.PagerSlidingTabStrip_pstsLineBottomPadding, this.lineBottomPadding);
        this.centerMode = a.getBoolean(R.styleable.PagerSlidingTabStrip_pstsCenterMode, false);
        this.tabTextColor = a.getColor(R.styleable.PagerSlidingTabStrip_pstsTextColor, this.tabTextColor);
        this.tabPressTextColor = a.getColor(R.styleable.PagerSlidingTabStrip_pstsTextPressColor, this.tabPressTextColor);
        this.isAverageMargin = a.getBoolean(R.styleable.PagerSlidingTabStrip_pstsAverageMargin, this.isAverageMargin);
        a.recycle();
        this.rect = new RectF();
        this.rectPaint = new Paint();
        this.rectPaint.setAntiAlias(true);
        this.rectPaint.setStyle(Paint.Style.FILL);
        this.dividerPaint = new Paint();
        this.dividerPaint.setAntiAlias(true);
        this.dividerPaint.setStrokeWidth((float)this.dividerWidth);
        this.paddingLeft = this.getPaddingLeft();
        this.defaultTabLayoutParams = new LinearLayout.LayoutParams(-2, -1);
        this.expandedTabLayoutParams = new LinearLayout.LayoutParams(-1, -1, 1.0f);
        this.matchparentTabLayoutParams = new LinearLayout.LayoutParams(-1, -1);
        if (this.locale == null) {
            this.locale = this.getResources().getConfiguration().locale;
        }
        if (this.centerMode) {
            this.tabsContainer.setGravity(17);
        }
        this.addView((View)this.tabsContainer);
    }

    public void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(left, top, right, bottom);
        this.paddingLeft = left;
    }

    public void setOnClickCallBack(OnClickCallBack callBack) {
        this.onClickCallBack = callBack;
    }

    public void setTabTextColor(int tabTextColor) {
        this.tabTextColor = tabTextColor;
    }

    public void setViewPager(ViewPager pager) {
        this.pager = pager;
        if (pager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        pager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this.pageListener);
        this.notifyDataSetChanged();
    }

    public void setOnPageChangeListener(SlidingTabListener listener2) {
        this.delegatePageListener = listener2;
    }

    public void notifyDataSetChanged() {
        this.tabsContainer.removeAllViews();
        this.tabCount = this.pager.getAdapter().getCount();
        for (int i = 0; i < this.tabCount; ++i) {
            if (this.pager.getAdapter() instanceof IconTabProvider) {
                this.addIconTab(i, ((IconTabProvider)this.pager.getAdapter()).getPageIconResId(i));
                continue;
            }
            if (this.pager.getAdapter() instanceof CustomTabProvider) {
                this.addTab(i, ((CustomTabProvider)this.pager.getAdapter()).getPageViewLayout(i));
                continue;
            }
            if (this.mFadeEnabled) {
                this.addFadingTextTab(i, this.pager.getAdapter().getPageTitle(i));
                continue;
            }
            this.addTextTab(i, this.pager.getAdapter().getPageTitle(i));
        }
        if (this.mMyGlobalLayoutObserver == null) {
            this.mMyGlobalLayoutObserver = new MyViewTreeGlobalLayoutObserver(this);
            this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.mMyGlobalLayoutObserver);
        }
        if (this.isAverageMargin) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    int screenWidth;
                    int tabsContainerWidth;
                    if (PagerSlidingTabStrip.this.tabsContainer != null && PagerSlidingTabStrip.this.tabsContainer.getChildCount() > 1 && (tabsContainerWidth = PagerSlidingTabStrip.this.tabsContainer.getWidth()) > (screenWidth = ResolutionUtils.getScreenWidth((Context)RuntimeContext.sApplicationContext))) {
                        PagerSlidingTabStrip.this.setViewSize(PagerSlidingTabStrip.this.tabsContainer.getChildAt(0), 0, 0);
                        PagerSlidingTabStrip.this.setViewSize(PagerSlidingTabStrip.this.tabsContainer.getChildAt(PagerSlidingTabStrip.this.tabsContainer.getChildCount() - 1), 0, 0);
                    }
                }
            });
        }
    }

    private void setViewSize(View view, int width, int height) {
        if (view == null || !(view.getParent() instanceof LinearLayout)) {
            return;
        }
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)view.getLayoutParams();
        if (lp == null) {
            lp = new LinearLayout.LayoutParams(width, height);
        } else {
            lp.width = width;
            lp.height = height;
        }
        view.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    private void handleGlobalLayout() {
        this.currentPosition = this.pager.getCurrentItem();
        this.scrollToChild(this.currentPosition, 0);
        this.updateTab();
        this.mMyGlobalLayoutObserver = null;
    }

    private void addTextTab(int position, CharSequence title) {
        YYTextView tab = new YYTextView(this.getContext());
        tab.setTextSize(0, (float)this.tabTextSize);
        tab.setText(title);
        tab.setGravity(17);
        tab.setSingleLine();
        this.addTab(position, (View)tab);
    }

    private void addFadingTextTab(int position, CharSequence title) {
        YYTextView tab = new YYTextView(this.getContext());
        tab.setText(title);
        tab.setGravity(17);
        tab.setSingleLine();
        tab.setTextColor(this.tabTextColor);
        tab.setTextSize(0, (float)this.tabTextSize);
        YYTextView tab2 = new YYTextView(this.getContext());
        tab2.setText(title);
        tab2.setGravity(17);
        tab2.setSingleLine();
        tab2.setTextColor(this.tabPressTextColor);
        tab2.setTextSize(0, (float)this.tabPressTextSize);
        tab2.setTypeface(null, 1);
        YYFrameLayout framelayout = new YYFrameLayout(this.context);
        framelayout.addView((View)tab, 0, (ViewGroup.LayoutParams)this.matchparentTabLayoutParams);
        framelayout.addView((View)tab2, 1, (ViewGroup.LayoutParams)this.matchparentTabLayoutParams);
        HashMap<String, YYTextView> map = new HashMap<String, YYTextView>();
        tab.setAlpha(1.0f);
        map.put(FADING_NORMAL, tab);
        tab2.setAlpha(0.0f);
        map.put(FADING_SELECTED, tab2);
        this.tabViews.add(position, map);
        this.addTab(position, (View)framelayout);
    }

    private Rect getTextRect(TextView textView, String text, int size) {
        Object paint = textView == null || textView.getPaint() == null ? new Paint() : textView.getPaint();
        Rect rect = new Rect();
        paint.setTextSize((float)size);
        paint.getTextBounds(text, 0, text.length(), rect);
        return rect;
    }

    private void addIconTab(int position, int resId) {
        YYImageButton tab = new YYImageButton(this.getContext());
        tab.setImageResource(resId);
        this.addTab(position, (View)tab);
    }

    public void setReddotMargin(int left, int top, int right, int bottom) {
        int count = this.tabsContainer.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = this.tabsContainer.getChildAt(i).findViewById(R.id.red_dot);
            if (!(view instanceof BadgeView)) continue;
            BadgeView badgeView = (BadgeView)view;
            badgeView.setBadgeMargin(left, top, right, bottom);
        }
    }

    private void addTab(final int position, View tab) {
        tab.setFocusable(true);
        tab.setId(R.id.tab_content);
        tab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PagerSlidingTabStrip.this.pager.getCurrentItem() == position && PagerSlidingTabStrip.this.onClickCallBack != null) {
                    PagerSlidingTabStrip.this.onClickCallBack.notifyScrollToHead(position);
                }
                if (PagerSlidingTabStrip.this.mOnTabClickListener != null) {
                    PagerSlidingTabStrip.this.mOnTabClickListener.onClick(position, PagerSlidingTabStrip.this.pager.getCurrentItem());
                }
                if (PagerSlidingTabStrip.this.pager != null) {
                    PagerSlidingTabStrip.this.pager.setCurrentItem(position, PagerSlidingTabStrip.this.smoothScroll);
                }
                PagerSlidingTabStrip.this.currentPosition = position;
                PagerSlidingTabStrip.this.scrollToChild(position, 0);
            }
        });
        tab.setPadding(this.tabPadding, 0, this.tabPadding, 0);
        if (this.isAverageMargin) {
            if (position == 0) {
                this.tabsContainer.addView((View)new YYView(this.getContext()), 0, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.tabPadding, 0));
            }
            int copyPosition = 2 * position + 1;
            this.tabsContainer.addView((View)new YYView(this.getContext()), copyPosition, (ViewGroup.LayoutParams)this.mAverageMarginGapViewParams);
            this.tabsContainer.addView(tab, copyPosition + 1, (ViewGroup.LayoutParams)this.mAverageMarginTabParams);
            tab.setTag((Object)(copyPosition + 1));
            if (position == this.tabCount - 1) {
                this.tabsContainer.addView((View)new YYView(this.getContext()), copyPosition + 2, (ViewGroup.LayoutParams)this.mAverageMarginGapViewParams);
                this.tabsContainer.addView((View)new YYView(this.getContext()), copyPosition + 3, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.tabPadding, 0));
            }
        } else {
            tab.setTag((Object)position);
            this.tabsContainer.addView(tab, position, (ViewGroup.LayoutParams)(this.shouldExpand ? this.expandedTabLayoutParams : this.defaultTabLayoutParams));
        }
        BadgeView badgeView = new BadgeView(this.getContext());
        badgeView.setBadgeGravity(17);
        badgeView.setTargetView(tab);
        Rect rect = this.getContentTextRect(position);
        int paddingleft = (int)((float)(rect.width() / 2) + ResolutionUtils.convertDpToPixel((float)6.5f, (Context)this.getContext()));
        int paddingbottom = (int)((float)(rect.height() / 2) + ResolutionUtils.convertDpToPixel((float)5.0f, (Context)this.getContext()));
        badgeView.setBadgeMarginPx(paddingleft, 0, 0, paddingbottom);
    }

    private void updateTabStyles() {
        for (int i = 0; i < this.tabCount; ++i) {
            View v = this.tabsContainer.getChildAt(i).findViewById(R.id.tab_content);
            v.setBackgroundResource(this.tabBackgroundResId);
            boolean selected = i == this.currentPosition;
            if (this.tabDecorator != null) {
                this.tabDecorator.onSelected(i, selected, v);
            }
            if (!(v instanceof TextView)) continue;
            TextView tab = (TextView)v;
            tab.setTypeface(this.tabTypeface, this.tabTypefaceStyle);
            if (i == this.currentPosition) {
                tab.setTextColor(this.tabPressTextColor);
                tab.setTextSize(0, (float)this.tabPressTextSize);
            } else {
                tab.setTextColor(this.tabTextColor);
                tab.setTextSize(0, (float)this.tabTextSize);
            }
            if (!this.textAllCaps) continue;
            if (Build.VERSION.SDK_INT >= 14) {
                tab.setAllCaps(true);
                continue;
            }
            tab.setText((CharSequence)tab.getText().toString().toUpperCase(this.locale));
        }
    }

    public void reset() {
        this.currentPosition = 0;
        this.selectedPosition = 0;
        this.pager.setCurrentItem(0);
        this.updateTabTextStyles();
    }

    private void updateTabTextStyles() {
        for (int i = 0; i < this.tabCount; ++i) {
            View select;
            View normal;
            int pos;
            int n = pos = this.isAverageMargin ? 2 * i + 2 : i;
            if (this.tabsContainer.getChildAt(pos) == null || this.tabViews.isEmpty()) continue;
            if (i == this.selectedPosition) {
                normal = this.tabViews.get(i).get(FADING_NORMAL);
                select = this.tabViews.get(i).get(FADING_SELECTED);
                normal.setAlpha(0.0f);
                select.setAlpha(1.0f);
                if (!(normal instanceof TextView) || !(select instanceof TextView)) continue;
                ((TextView)normal).setTextSize(0, (float)this.tabTextSize);
                ((TextView)select).setTextSize(0, (float)this.tabPressTextSize);
                continue;
            }
            normal = this.tabViews.get(i).get(FADING_NORMAL);
            select = this.tabViews.get(i).get(FADING_SELECTED);
            normal.setAlpha(1.0f);
            select.setAlpha(0.0f);
            if (!(normal instanceof TextView) || !(select instanceof TextView)) continue;
            ((TextView)normal).setTextSize(0, (float)this.tabTextSize);
            ((TextView)select).setTextSize(0, (float)this.tabTextSize);
        }
    }

    private void updateTab() {
        if (this.mFadeEnabled) {
            this.updateTabTextStyles();
        } else {
            this.updateTabStyles();
        }
    }

    private void scrollToChild(int position, int offset) {
        if (this.tabCount == 0) {
            return;
        }
        int newScrollX = 0;
        position = this.isAverageMargin ? position * 2 + 2 : position;
        View childAt = this.tabsContainer.getChildAt(position);
        int textLength = 0;
        if (childAt != null) {
            textLength = childAt.getWidth() / 2;
        }
        if (position > 0) {
            int left = 0;
            if (childAt != null) {
                left = childAt.getLeft();
            }
            newScrollX = left + offset + textLength;
        } else if (childAt != null) {
            newScrollX = childAt.getLeft();
        }
        if (position > 0 || offset > 0) {
            newScrollX = this.hasOffset ? (newScrollX -= this.scrollOffset) : (newScrollX -= this.scrollOffset / 2);
        }
        if (newScrollX != this.lastScrollX) {
            this.lastScrollX = newScrollX;
            this.smoothScrollTo(newScrollX, 0);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInEditMode() || this.tabCount == 0) {
            return;
        }
        int height = this.getHeight();
        this.rectPaint.setColor(this.underlineColor);
        if (this.tabsContainer.getChildAt(this.currentPosition) == null) {
            this.currentPosition = 0;
        }
        int pos = this.isAverageMargin ? this.currentPosition * 2 + 1 + 1 : this.currentPosition;
        int nextPos = this.isAverageMargin ? pos + 2 : pos + 1;
        View currentTab = this.tabsContainer.getChildAt(pos);
        float lineLeft = currentTab.getLeft();
        float lineRight = currentTab.getRight();
        float currentTextLong = this.mFetcher.getLength(pos);
        float paddingLong = (lineRight - lineLeft - currentTextLong) / 2.0f - (float)this.indicatorPadding;
        lineLeft += paddingLong;
        lineRight -= paddingLong;
        if (this.currentPositionOffset > 0.0f && this.currentPosition < this.tabCount - 1) {
            View nextTab = this.tabsContainer.getChildAt(nextPos);
            float nextTabLeft = nextTab.getLeft();
            float nextTabRight = nextTab.getRight();
            float nextTextLong = this.mFetcher.getLength(nextPos);
            float nextpaddingLong = (nextTabRight - nextTabLeft - nextTextLong) / 2.0f - (float)this.indicatorPadding;
            lineLeft = this.currentPositionOffset * (nextTabLeft + nextpaddingLong) + (1.0f - this.currentPositionOffset) * lineLeft;
            lineRight = this.currentPositionOffset * (nextTabRight - nextpaddingLong) + (1.0f - this.currentPositionOffset) * lineRight;
        }
        this.rect.left = lineLeft + (float)this.paddingLeft;
        this.rect.top = height - this.lineBottomPadding - this.indicatorHeight;
        this.rect.right = lineRight + (float)this.paddingLeft;
        this.rect.bottom = height - this.lineBottomPadding;
        canvas.drawRoundRect(this.rect, this.rectOvalRx, this.rectOvalRy, this.rectPaint);
    }

    public void showOrHideRed(int index, boolean isShow) {
        View v;
        if (index < this.tabCount && index >= 0 && (v = this.tabsContainer.getChildAt(index).findViewById(R.id.red_dot)) instanceof BadgeView) {
            BadgeView badge = (BadgeView)v;
            badge.showBadgeRedDot(isShow);
        }
    }

    public int getLineBottomPadding() {
        return this.lineBottomPadding;
    }

    public void setLineBottomPadding(int lineBottomPadding) {
        this.lineBottomPadding = lineBottomPadding;
        this.invalidate();
    }

    public void setIndicatorColorResource(int resId) {
        this.indicatorColor = this.getResources().getColor(resId);
        this.invalidate();
    }

    public int getIndicatorColor() {
        return this.indicatorColor;
    }

    public void setIndicatorColor(int indicatorColor) {
        this.indicatorColor = indicatorColor;
        this.invalidate();
    }

    public int getIndicatorHeight() {
        return this.indicatorHeight;
    }

    public void setIndicatorHeight(int indicatorLineHeightPx) {
        this.indicatorHeight = indicatorLineHeightPx;
        this.invalidate();
    }

    public void setUnderlineColorResource(int resId) {
        this.underlineColor = this.getResources().getColor(resId);
        this.invalidate();
    }

    public int getUnderlineColor() {
        return this.underlineColor;
    }

    public void setUnderlineColor(int underlineColor) {
        this.underlineColor = underlineColor;
        this.invalidate();
    }

    public void setDividerColorResource(int resId) {
        this.dividerColor = this.getResources().getColor(resId);
        this.invalidate();
    }

    public int getDividerColor() {
        return this.dividerColor;
    }

    public void setDividerColor(int dividerColor) {
        this.dividerColor = dividerColor;
        this.invalidate();
    }

    public int getUnderlineHeight() {
        return this.underlineHeight;
    }

    public void setUnderlineHeight(int underlineHeightPx) {
        this.underlineHeight = underlineHeightPx;
        this.invalidate();
    }

    public int getDividerPadding() {
        return this.dividerPadding;
    }

    public void setDividerPadding(int dividerPaddingPx) {
        this.dividerPadding = dividerPaddingPx;
        this.invalidate();
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public void setScrollOffset(int scrollOffsetPx) {
        this.scrollOffset = scrollOffsetPx;
        this.invalidate();
    }

    public void minusOffset(int minusOffset) {
        this.hasOffset = true;
        this.scrollOffset = (this.scrollOffset - minusOffset) / 2;
    }

    public boolean getShouldExpand() {
        return this.shouldExpand;
    }

    public void setShouldExpand(boolean shouldExpand) {
        this.shouldExpand = shouldExpand;
        this.requestLayout();
    }

    public boolean isTextAllCaps() {
        return this.textAllCaps;
    }

    public void setAllCaps(boolean textAllCaps) {
        this.textAllCaps = textAllCaps;
    }

    public int getTextSize() {
        return this.tabTextSize;
    }

    public void setTextSize(int textSizePx) {
        this.tabTextSize = textSizePx;
        this.updateTab();
    }

    public int getPressTextSize() {
        return this.tabPressTextSize;
    }

    public void setPressTextSize(int textSize) {
        this.tabPressTextColor = textSize;
        this.updateTabStyles();
    }

    public void setPressTextColor(int textColor) {
        this.tabPressTextColor = textColor;
        this.updateTab();
    }

    public void setTextColorResource(int resId) {
        this.tabTextColor = this.getResources().getColor(resId);
        this.updateTabStyles();
    }

    public int getTextColor() {
        return this.tabTextColor;
    }

    public void setTextColor(int textColor) {
        this.tabTextColor = textColor;
        this.updateTab();
    }

    public void setTypeface(Typeface typeface, int style2) {
        this.tabTypeface = typeface;
        this.tabTypefaceStyle = style2;
        this.updateTabStyles();
    }

    public int getTabBackground() {
        return this.tabBackgroundResId;
    }

    public void setTabBackground(int resId) {
        this.tabBackgroundResId = resId;
    }

    public void updateTextStyleTitle(int position, String text) {
        View selectTab;
        if (!(this.pager.getAdapter() instanceof IconTabProvider) && !(this.pager.getAdapter() instanceof CustomTabProvider) && (selectTab = this.tabsContainer.getChildAt(position).findViewById(R.id.tab_content)) instanceof TextView) {
            ((TextView)selectTab).setText((CharSequence)text);
            selectTab.setPadding(0, 0, 0, 0);
        }
    }

    public void updateTextStyleTitle(int position, String text, int resourcesId) {
        if (this.pager.getAdapter() instanceof IconTabProvider || this.pager.getAdapter() instanceof CustomTabProvider) {
            if (this.tabUpdateTextDecorator != null) {
                View selectTab = this.tabsContainer.getChildAt(position);
                this.tabUpdateTextDecorator.updateViewText(position, text, resourcesId, selectTab);
            }
        } else {
            View selectTab = this.tabsContainer.getChildAt(position);
            if (selectTab instanceof TextView) {
                ((TextView)selectTab).setText((CharSequence)text);
                ((TextView)selectTab).setPadding(0, 0, 0, 0);
            }
        }
    }

    public View getPositionView(int position) {
        return this.tabsContainer.getChildAt(position);
    }

    public int getTabPaddingLeftRight() {
        return this.tabPadding;
    }

    public void setTabPaddingLeftRight(int paddingPx) {
        this.tabPadding = paddingPx;
        this.updateTabStyles();
    }

    private Rect getContentTextRect(int position) {
        FrameLayout tabFl;
        View tab = this.tabsContainer.getChildAt(position).findViewById(R.id.tab_content);
        if (tab != null && tab instanceof TextView) {
            TextView textView = (TextView)tab;
            return this.getTextRect(textView, textView.toString(), this.tabTextSize);
        }
        if (tab != null && tab instanceof FrameLayout && (tabFl = (FrameLayout)tab).getChildAt(0) != null && tabFl.getChildAt(0) instanceof TextView) {
            TextView textView = (TextView)tabFl.getChildAt(0);
            return this.getTextRect(textView, textView.toString(), this.tabTextSize);
        }
        return new Rect();
    }

    public void setIndicatotLengthFetcher(IndicatorSizeFetcher fetcher) {
        this.mFetcher = fetcher;
    }

    public void setTabDecorator(CustomTabDecorator decorator) {
        this.tabDecorator = decorator;
    }

    public void setTabUpdateTextDecorator(CustomTabUpdateTextDecorator decorator) {
        this.tabUpdateTextDecorator = decorator;
    }

    public void setFadeEnabled(boolean enabled) {
        this.mFadeEnabled = enabled;
    }

    public void setUseFadeEffect(boolean mUseFadeEffect) {
        this.useFadeEffect = mUseFadeEffect;
    }

    public void setZoomMax(float zoomMax) {
        this.zoomMax = zoomMax;
    }

    private boolean isSmall(float positionOffset) {
        return (double)Math.abs(positionOffset) < 1.0E-4;
    }

    protected void animateFadeScale(View left, View right, float positionOffset, int position) {
        if (this.mState != State.IDLE) {
            int tabSize = this.tabViews.size();
            if (left != null && tabSize != 0 && tabSize >= position) {
                this.tabViews.get(position).get(FADING_NORMAL).setAlpha(positionOffset);
                this.tabViews.get(position).get(FADING_SELECTED).setAlpha(1.0f - positionOffset);
            }
            if (right != null && tabSize != 0 && tabSize >= position + 1) {
                this.tabViews.get(position + 1).get(FADING_NORMAL).setAlpha(1.0f - positionOffset);
                this.tabViews.get(position + 1).get(FADING_SELECTED).setAlpha(positionOffset);
            }
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.currentPosition = savedState.currentPosition;
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.currentPosition = this.currentPosition;
        return savedState;
    }

    public int getCurrentPosition() {
        if (this.pager == null) {
            return -1;
        }
        return this.pager.getCurrentItem();
    }

    public void setOnTabClickListener(OnTabClickListener listener2) {
        this.mOnTabClickListener = listener2;
    }

    private class PageListener
    implements ViewPager.OnPageChangeListener {
        private PageListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            PagerSlidingTabStrip.this.currentPosition = position;
            PagerSlidingTabStrip.this.currentPositionOffset = positionOffset;
            if (PagerSlidingTabStrip.this.mFadeEnabled) {
                boolean goingRight;
                if (PagerSlidingTabStrip.this.mState == State.IDLE && positionOffset > 0.0f) {
                    PagerSlidingTabStrip.this.oldPage = PagerSlidingTabStrip.this.pager.getCurrentItem();
                    PagerSlidingTabStrip.this.mState = position == PagerSlidingTabStrip.this.oldPage ? State.GOING_RIGHT : State.GOING_LEFT;
                }
                boolean bl = goingRight = position == PagerSlidingTabStrip.this.oldPage;
                if (PagerSlidingTabStrip.this.mState == State.GOING_RIGHT && !goingRight) {
                    PagerSlidingTabStrip.this.mState = State.GOING_LEFT;
                } else if (PagerSlidingTabStrip.this.mState == State.GOING_LEFT && goingRight) {
                    PagerSlidingTabStrip.this.mState = State.GOING_RIGHT;
                }
                float effectOffset = PagerSlidingTabStrip.this.isSmall(positionOffset) ? 0.0f : positionOffset;
                View mLeft = PagerSlidingTabStrip.this.tabsContainer.getChildAt(position);
                View mRight = PagerSlidingTabStrip.this.tabsContainer.getChildAt(position + 1);
                if (effectOffset == 0.0f) {
                    PagerSlidingTabStrip.this.mState = State.IDLE;
                }
                if (PagerSlidingTabStrip.this.needAnimate) {
                    PagerSlidingTabStrip.this.animateFadeScale(mLeft, mRight, effectOffset, position);
                }
                View v = PagerSlidingTabStrip.this.tabsContainer.getChildAt(position);
                int width = 0;
                if (v != null) {
                    width = v.getWidth();
                }
                PagerSlidingTabStrip.this.scrollToChild(position, (int)(positionOffset * (float)width));
                PagerSlidingTabStrip.this.invalidate();
            } else {
                View v = PagerSlidingTabStrip.this.tabsContainer.getChildAt(position);
                int width = 0;
                if (v != null) {
                    width = v.getWidth();
                }
                PagerSlidingTabStrip.this.scrollToChild(position, (int)(positionOffset * (float)width));
                PagerSlidingTabStrip.this.invalidate();
            }
            if (PagerSlidingTabStrip.this.delegatePageListener != null) {
                PagerSlidingTabStrip.this.delegatePageListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
            }
        }

        public void onPageScrollStateChanged(int state) {
            if (PagerSlidingTabStrip.this.useFadeEffect) {
                if (state == 0) {
                    PagerSlidingTabStrip.this.needAnimate = true;
                    PagerSlidingTabStrip.this.scrollToChild(PagerSlidingTabStrip.this.pager.getCurrentItem(), 0);
                    PagerSlidingTabStrip.this.mFadeEnabled = true;
                } else if (state == 1 || state == 2) {
                    // empty if block
                }
            }
            if (PagerSlidingTabStrip.this.delegatePageListener != null) {
                PagerSlidingTabStrip.this.delegatePageListener.onPageScrollStateChanged(state);
            }
        }

        public void onPageSelected(int position) {
            int oldPosition = PagerSlidingTabStrip.this.selectedPosition;
            PagerSlidingTabStrip.this.selectedPosition = position;
            if (PagerSlidingTabStrip.this.useFadeEffect) {
                PagerSlidingTabStrip.this.updateTabTextStyles();
                PagerSlidingTabStrip.this.needAnimate = false;
            } else {
                for (int i = 0; i <= PagerSlidingTabStrip.this.tabCount - 1; ++i) {
                    View tab = PagerSlidingTabStrip.this.tabsContainer.getChildAt(i).findViewById(R.id.tab_content);
                    if (tab instanceof TextView) {
                        if (i == position) {
                            ((TextView)tab).setTextColor(PagerSlidingTabStrip.this.tabPressTextColor);
                            ((TextView)tab).setTextSize(0, (float)PagerSlidingTabStrip.this.tabPressTextSize);
                        } else {
                            ((TextView)tab).setTextColor(PagerSlidingTabStrip.this.tabTextColor);
                            ((TextView)tab).setTextSize(0, (float)PagerSlidingTabStrip.this.tabTextSize);
                        }
                    }
                    if (PagerSlidingTabStrip.this.tabDecorator == null) continue;
                    PagerSlidingTabStrip.this.tabDecorator.onSelected(i, i == position, tab);
                }
            }
            if (PagerSlidingTabStrip.this.delegatePageListener != null) {
                PagerSlidingTabStrip.this.delegatePageListener.onPageSelected(oldPosition, position);
            }
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        int currentPosition;

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.currentPosition = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.currentPosition);
        }
    }

    private static class MyViewTreeGlobalLayoutObserver
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private WeakReference<PagerSlidingTabStrip> mPagerSlidingTabStrip;

        public MyViewTreeGlobalLayoutObserver(PagerSlidingTabStrip pagerSlidingTabStrip) {
            this.mPagerSlidingTabStrip = new WeakReference<PagerSlidingTabStrip>(pagerSlidingTabStrip);
        }

        @SuppressLint(value={"NewApi"})
        public void onGlobalLayout() {
            PagerSlidingTabStrip tabStrip;
            if (this.mPagerSlidingTabStrip != null && (tabStrip = (PagerSlidingTabStrip)((Object)this.mPagerSlidingTabStrip.get())) != null) {
                if (Build.VERSION.SDK_INT < 16) {
                    tabStrip.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    tabStrip.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                tabStrip.handleGlobalLayout();
            }
        }
    }

    public static interface OnTabClickListener {
        public void onClick(int var1, int var2);
    }

    public static interface SlidingTabListener {
        public void onPageScrolled(int var1, float var2, int var3);

        public void onPageSelected(int var1, int var2);

        public void onPageScrollStateChanged(int var1);
    }

    public static interface OnClickCallBack {
        public void notifyScrollToHead(int var1);
    }

    public static interface CustomTabUpdateTextDecorator {
        public void updateViewText(int var1, String var2, int var3, View var4);
    }

    public static interface CustomTabDecorator {
        public void onSelected(int var1, boolean var2, View var3);
    }

    public static interface IndicatorSizeFetcher {
        public float getLength(int var1);
    }

    public static interface CustomTabProvider {
        public View getPageViewLayout(int var1);
    }

    public static interface IconTabProvider {
        public int getPageIconResId(int var1);
    }

    private static enum State {
        IDLE,
        GOING_LEFT,
        GOING_RIGHT;

    }
}

