/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.status;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.opensource.svgaplayer.hago.SVGAVideoEntity;
import com.yy.appbase.R;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.inner.DResource;

public class LoadingStatusLayout
extends YYFrameLayout {
    private ProgressBar mProgressBar;
    private YYImageView mLoadingIcon;
    private YYTextView mLoadingText;
    private SVGAImageView mSvgaLoading;
    private boolean mSvgaAttached = false;
    private YYRelativeLayout mRootContainer;
    private YYRelativeLayout mLoadingContainer;
    private static final String DEFAULT_SVGA = "loading.svga";
    private String mSvgaUrl = "loading.svga";
    private DResource mSvgaResource = null;
    private int mSvgaWidth = 0;
    private int mSvgaHeight = 0;
    private boolean needAttachStart = false;

    public LoadingStatusLayout(Context context) {
        super(context);
        this.createView(context);
    }

    public LoadingStatusLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(context);
    }

    public LoadingStatusLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(context);
    }

    public LoadingStatusLayout(Context context, String svgaUrl, int svgaWidth, int svgaHeight) {
        super(context);
        this.mSvgaUrl = svgaUrl;
        this.mSvgaWidth = svgaWidth;
        this.mSvgaHeight = svgaHeight;
        this.createView(context);
    }

    public LoadingStatusLayout(Context context, DResource svgaID, int svgaWidth, int svgaHeight) {
        super(context);
        this.mSvgaResource = svgaID;
        this.mSvgaWidth = svgaWidth;
        this.mSvgaHeight = svgaHeight;
        this.createView(context);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return true;
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            if (this.mSvgaLoading != null) {
                if (this.mSvgaAttached) {
                    this.mSvgaLoading.startAnimation();
                } else {
                    this.needAttachStart = true;
                }
            }
        } else if (this.mSvgaLoading != null) {
            this.mSvgaLoading.stopAnimation();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    private void createView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.layout_loading_status, (ViewGroup)this);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.loading_progress);
        this.mLoadingIcon = (YYImageView)this.findViewById(R.id.loading_icon);
        this.mLoadingText = (YYTextView)this.findViewById(R.id.loading_text);
        this.mSvgaLoading = (SVGAImageView)this.findViewById(R.id.svga_loading);
        this.mRootContainer = (YYRelativeLayout)this.findViewById(R.id.loadingFragment);
        this.mLoadingContainer = (YYRelativeLayout)this.findViewById(R.id.loading_container);
        if (this.mSvgaWidth > 0 && this.mSvgaHeight > 0) {
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.mSvgaLoading.getLayoutParams();
            lp.width = this.mSvgaWidth;
            lp.height = this.mSvgaHeight;
            this.mSvgaLoading.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        ISvgaLoadCallback callback = new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                if (LoadingStatusLayout.this.mSvgaLoading != null && LoadingStatusLayout.this.mSvgaAttached && LoadingStatusLayout.this.getVisibility() == 0) {
                    LoadingStatusLayout.this.mSvgaLoading.startAnimation();
                } else if (LoadingStatusLayout.this.mSvgaLoading != null && !LoadingStatusLayout.this.mSvgaLoading.isAnimating()) {
                    LoadingStatusLayout.this.needAttachStart = true;
                }
            }

            public void onFailed(Exception e) {
            }
        };
        if (this.mSvgaResource != null) {
            DyResLoader.INSTANCE.loadSvga(this.mSvgaLoading, this.mSvgaResource, callback);
        } else {
            SvgaLoader.load((SVGAImageView)this.mSvgaLoading, (String)this.mSvgaUrl, (ISvgaLoadCallback)callback);
        }
        this.mSvgaLoading.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                LoadingStatusLayout.this.mSvgaAttached = true;
                if (LoadingStatusLayout.this.mSvgaLoading != null && !LoadingStatusLayout.this.mSvgaLoading.isAnimating() && LoadingStatusLayout.this.needAttachStart && LoadingStatusLayout.this.getVisibility() == 0) {
                    LoadingStatusLayout.this.needAttachStart = false;
                    LoadingStatusLayout.this.mSvgaLoading.startAnimation();
                }
            }

            public void onViewDetachedFromWindow(View v) {
                LoadingStatusLayout.this.mSvgaAttached = false;
                if (LoadingStatusLayout.this.mSvgaLoading != null) {
                    LoadingStatusLayout.this.mSvgaLoading.stopAnimation();
                    LoadingStatusLayout.this.needAttachStart = false;
                }
            }
        });
    }

    public void setLoadingIconShow(boolean isShow) {
        if (this.mLoadingIcon != null) {
            this.mLoadingIcon.setVisibility(isShow ? 0 : 8);
        }
    }

    public void setLoadingText(String text, boolean isShow) {
        if (this.mLoadingText != null && text != null) {
            this.mLoadingText.setVisibility(isShow ? 0 : 8);
            this.mLoadingText.setText((CharSequence)text);
        }
    }

    public void setLoadingProShow(boolean isShow) {
        if (this.mProgressBar != null) {
            this.mProgressBar.setVisibility(isShow ? 0 : 8);
        }
    }

    public void setSize(int width, int height) {
        ViewGroup.LayoutParams params = this.mSvgaLoading.getLayoutParams();
        params.width = ResolutionUtils.dip2Px((float)width);
        params.height = ResolutionUtils.dip2Px((float)height);
    }

    public void setLoadingCenter() {
        this.mRootContainer.setGravity(17);
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.mLoadingContainer.getLayoutParams();
        lp.topMargin = 0;
    }

    public void setLoadingTopMargin(int topMargin) {
        this.mRootContainer.setGravity(48);
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.mLoadingContainer.getLayoutParams();
        lp.topMargin = topMargin;
    }
}

