/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.status;

import android.content.Context;
import android.text.Spanned;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.core.widget.NestedScrollView;
import com.yy.appbase.R;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.ui.widget.status.ErrorStatusLayout;
import com.yy.appbase.ui.widget.status.INoDataCallback;
import com.yy.appbase.ui.widget.status.IRequestCallback;
import com.yy.appbase.ui.widget.status.LoadingMoreStatusLayout;
import com.yy.appbase.ui.widget.status.LoadingStatusLayout;
import com.yy.appbase.ui.widget.status.NetErrorTryAgainLayout;
import com.yy.appbase.ui.widget.status.NoDataCenterStatusLayout;
import com.yy.appbase.ui.widget.status.NoDataStatusLayout;
import com.yy.base.env.RuntimeContext;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.dyres.inner.DResource;

public class CommonStatusLayout
extends YYFrameLayout
implements INotify {
    private LoadingStatusLayout mLoadingLayout;
    private LoadingMoreStatusLayout mLoadingMore;
    private ErrorStatusLayout mErrorStatus;
    private ErrorStatusLayout mErrorNetworkStatus;
    private NoDataStatusLayout mNoDataStatus;
    private NoDataCenterStatusLayout mNoDataCenterStatus;
    private NetErrorTryAgainLayout mNetErrorTryAgainLayout;
    private View mCustomStatusView;
    private View.OnClickListener mListener;
    private IRequestCallback mRequestCallback;
    private INoDataCallback mNoDataCallback;
    private boolean mNetworkValid = true;
    private boolean mNeedRegisterNotify = true;
    private boolean mLoadingCenter = true;
    private int mLoadingTopMargin = 0;

    public CommonStatusLayout(Context context) {
        super(context);
        this.createView(context);
    }

    public CommonStatusLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(context);
    }

    public CommonStatusLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(context);
    }

    private void createView(Context context) {
        this.setClickable(false);
        this.mNetworkValid = NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this);
        this.mNeedRegisterNotify = false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mNeedRegisterNotify) {
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this);
            this.checkNet();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.mNeedRegisterNotify) {
            NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this);
        }
        this.mNeedRegisterNotify = true;
    }

    public void notify(Notification notification) {
        int id2 = notification.id;
        if (id2 == NotificationDef.N_NETWORK_STATE_CHANGE) {
            this.checkNet();
        }
    }

    private void checkNet() {
        boolean cur = NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext);
        if (!cur) {
            NetworkUtils.updateWsConnect((boolean)false);
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.NET_DISCONNECT));
        }
        if (this.mErrorNetworkStatus != null && !this.mNetworkValid && cur && this.mErrorNetworkStatus.getVisibility() == 0 && this.mRequestCallback != null) {
            this.mRequestCallback.onRequest(2);
        }
        this.mNetworkValid = cur;
    }

    public void setOnStatusClickListener(@Nullable View.OnClickListener l) {
        this.mListener = l;
    }

    public void setRequestCallback(IRequestCallback callback) {
        this.mRequestCallback = callback;
    }

    public void setNoDataCallback(INoDataCallback callback) {
        this.mNoDataCallback = callback;
    }

    public void setLoadingCenter() {
        this.mLoadingCenter = true;
        this.mLoadingTopMargin = 0;
    }

    public void setLoadingTopMargin(int topMargin) {
        this.mLoadingCenter = false;
        this.mLoadingTopMargin = topMargin;
    }

    public void showLoading() {
        if (this.mLoadingLayout == null) {
            this.mLoadingLayout = new LoadingStatusLayout(this.getContext());
        }
        if (this.mLoadingCenter) {
            this.mLoadingLayout.setLoadingCenter();
        } else {
            this.mLoadingLayout.setLoadingTopMargin(this.mLoadingTopMargin);
        }
        this.show((View)this.mLoadingLayout);
    }

    public void showLoading(String tips, String svgaUrl, int width, int height) {
        if (this.mLoadingLayout == null) {
            this.mLoadingLayout = new LoadingStatusLayout(this.getContext(), svgaUrl, width, height);
        }
        if (this.mLoadingCenter) {
            this.mLoadingLayout.setLoadingCenter();
        } else {
            this.mLoadingLayout.setLoadingTopMargin(this.mLoadingTopMargin);
        }
        this.show((View)this.mLoadingLayout);
        this.mLoadingLayout.setLoadingText(tips, true);
    }

    public void showLoading(String tips, DResource svga, int width, int height) {
        if (this.mLoadingLayout == null) {
            this.mLoadingLayout = new LoadingStatusLayout(this.getContext(), svga, width, height);
        }
        if (this.mLoadingCenter) {
            this.mLoadingLayout.setLoadingCenter();
        } else {
            this.mLoadingLayout.setLoadingTopMargin(this.mLoadingTopMargin);
        }
        this.show((View)this.mLoadingLayout);
        this.mLoadingLayout.setLoadingText(tips, true);
    }

    public void showLoading(String tips, boolean isShowIcon) {
        if (this.mLoadingLayout == null) {
            this.mLoadingLayout = new LoadingStatusLayout(this.getContext());
        }
        this.showLoading();
        this.mLoadingLayout.setLoadingIconShow(isShowIcon);
        this.mLoadingLayout.setLoadingText(tips, true);
    }

    public void showLoadingWithBG(int bgColor) {
        this.showLoadingWithBG(bgColor, true);
    }

    public void showLoadingWithBG(int bgColor, boolean isshowpro) {
        if (this.mLoadingLayout == null) {
            this.mLoadingLayout = new LoadingStatusLayout(this.getContext());
        }
        this.mLoadingLayout.setBackgroundColor(bgColor);
        this.mLoadingLayout.setLoadingProShow(isshowpro);
        this.showLoading();
    }

    public void hideLoading() {
        this.hide((View)this.mLoadingLayout);
    }

    public void showLoadingMore() {
        if (this.mLoadingMore == null) {
            this.mLoadingMore = new LoadingMoreStatusLayout(this.getContext());
        }
        this.show((View)this.mLoadingMore);
    }

    public void hideLoadingMore() {
        this.hide((View)this.mLoadingMore);
    }

    public void showError(int drawable2, String tips) {
        if (this.mErrorStatus == null) {
            this.mErrorStatus = new ErrorStatusLayout(this.getContext());
            this.mErrorStatus.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (CommonStatusLayout.this.mListener != null) {
                        CommonStatusLayout.this.mListener.onClick(v);
                    }
                    if (CommonStatusLayout.this.mRequestCallback != null) {
                        CommonStatusLayout.this.mRequestCallback.onRequest(1);
                    }
                }
            });
        }
        if (drawable2 > 0) {
            this.mErrorStatus.setStatusIcon(drawable2);
        }
        if (tips != null) {
            this.mErrorStatus.setStatusText(tips);
        }
        this.showError();
    }

    public void showNetworkError() {
        if (this.mErrorNetworkStatus == null) {
            this.mErrorNetworkStatus = new ErrorStatusLayout(this.getContext());
            this.mErrorNetworkStatus.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (CommonStatusLayout.this.mListener != null) {
                        CommonStatusLayout.this.mListener.onClick(v);
                    }
                }
            });
        }
        this.mErrorNetworkStatus.setStatusIcon(R.drawable.default_no_network);
        this.mErrorNetworkStatus.setStatusText(ResourceUtils.getString((int)R.string.check_network_and_retry));
        this.show((View)this.mErrorNetworkStatus);
        NetworkUtils.updateWsConnect((boolean)false);
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.NET_DISCONNECT));
    }

    public void showNetErrorTryAgain(View.OnClickListener listener2) {
        if (this.mNetErrorTryAgainLayout == null) {
            this.mNetErrorTryAgainLayout = new NetErrorTryAgainLayout(this.getContext());
            this.mNetErrorTryAgainLayout.setTryAgainListener(listener2);
        }
        this.show((View)this.mNetErrorTryAgainLayout);
    }

    public void showError() {
        if (this.mErrorStatus == null) {
            this.mErrorStatus = new ErrorStatusLayout(this.getContext());
            this.mErrorStatus.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (CommonStatusLayout.this.mListener != null) {
                        CommonStatusLayout.this.mListener.onClick(v);
                    }
                    if (CommonStatusLayout.this.mRequestCallback != null) {
                        CommonStatusLayout.this.mRequestCallback.onRequest(1);
                    }
                }
            });
        }
        this.show((View)this.mErrorStatus);
    }

    public void hideError() {
        this.hide((View)this.mErrorStatus);
    }

    public void showNoData() {
        if (this.mNoDataStatus == null) {
            this.mNoDataStatus = new NoDataStatusLayout(this.getContext());
            this.mNoDataStatus.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (CommonStatusLayout.this.mListener != null) {
                        CommonStatusLayout.this.mListener.onClick(v);
                    }
                    if (CommonStatusLayout.this.mNoDataCallback != null) {
                        CommonStatusLayout.this.mNoDataCallback.onNoDataClick();
                    }
                }
            });
        }
        this.show((View)this.mNoDataStatus);
    }

    public void showNoDataCenter() {
        if (this.mNoDataCenterStatus == null) {
            this.mNoDataCenterStatus = new NoDataCenterStatusLayout(this.getContext());
            this.mNoDataCenterStatus.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (CommonStatusLayout.this.mListener != null) {
                        CommonStatusLayout.this.mListener.onClick(v);
                    }
                    if (CommonStatusLayout.this.mNoDataCallback != null) {
                        CommonStatusLayout.this.mNoDataCallback.onNoDataClick();
                    }
                }
            });
        }
        this.show((View)this.mNoDataCenterStatus);
    }

    public void showNoDataCenter(@DrawableRes int iconId, @Nullable String text, @Nullable View extend) {
        this.showNoDataCenter();
        this.mNoDataCenterStatus.setStatusIcon(iconId);
        this.mNoDataCenterStatus.setStatusText(text);
        this.mNoDataCenterStatus.addCustomView(extend);
    }

    public boolean isShowLoading() {
        return this.mLoadingLayout != null && this.mLoadingLayout.getVisibility() == 0;
    }

    public void showNoData(@DrawableRes int iconId, @Nullable String text, @Nullable View extend) {
        this.showNoData();
        this.mNoDataStatus.setStatusIcon(iconId);
        this.mNoDataStatus.setStatusText(text);
        this.mNoDataStatus.addCustomView(extend);
    }

    public void showNoData(@DrawableRes int iconId, Spanned text) {
        this.showNoData();
        this.mNoDataStatus.setStatusIcon(iconId);
        this.mNoDataStatus.setStyleStatusText(text);
    }

    public void showNoData(int stringId) {
        this.showNoData();
        this.mNoDataStatus.setStatusText(ResourceUtils.getString((int)stringId));
    }

    public void hideNoData() {
        this.hide((View)this.mNoDataStatus);
    }

    public void hideAllStatus() {
        this.hide((View)this.mLoadingLayout);
        this.hide((View)this.mNoDataStatus);
        this.hide((View)this.mLoadingMore);
        this.hide((View)this.mErrorStatus);
        this.hide((View)this.mErrorNetworkStatus);
        this.hide((View)this.mNoDataCenterStatus);
        this.hide((View)this.mNetErrorTryAgainLayout);
        this.hide(this.mCustomStatusView);
    }

    private void hide(View view) {
        if (view != null) {
            view.setVisibility(8);
            this.removeView(view);
        }
    }

    private void show(View view) {
        if (view != null) {
            this.hideAllStatus();
            if (view.getParent() != null) {
                this.removeView(view);
            }
            this.addStatusLayout(view);
            view.setVisibility(0);
        }
    }

    private void addStatusLayout(View view) {
        if (view == null) {
            return;
        }
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)view.getLayoutParams();
        if (lp == null) {
            lp = new FrameLayout.LayoutParams(-1, -1);
        } else {
            lp.width = -1;
            lp.height = -1;
        }
        this.addView(view, this.getChildCount(), (ViewGroup.LayoutParams)lp);
    }

    public void showCustomStatusView(View view) {
        this.show(view);
        this.mCustomStatusView = view;
    }

    public void hideCustomStatusView() {
        this.hide(this.mCustomStatusView);
        this.mCustomStatusView = null;
    }

    public void showContent() {
        this.hideAllStatus();
    }

    public void setNestLayout() {
        NestedScrollView nestedScrollView = new NestedScrollView(this.getContext());
        nestedScrollView.addView((View)this);
    }

    public NoDataStatusLayout getNoDataStatusLayout() {
        return this.mNoDataStatus;
    }
}

