/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.status;

import android.content.Context;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.annotation.DrawableRes;
import androidx.core.widget.NestedScrollView;
import com.yy.appbase.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;

public abstract class BaseStatusLayout
extends YYFrameLayout {
    private NestedScrollView mRootView;
    protected LinearLayout mContainer;
    private YYImageView mStatusIcon;
    private YYTextView mStatusText;
    private YYLinearLayout mStatusExtend;

    public BaseStatusLayout(Context context) {
        super(context);
        this.createView(context);
    }

    public BaseStatusLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(context);
    }

    public BaseStatusLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(context);
    }

    private void createView(Context context) {
        this.setClickable(true);
        LayoutInflater.from((Context)context).inflate(R.layout.layout_status, (ViewGroup)this);
        this.mRootView = (NestedScrollView)this.findViewById(R.id.status_frame);
        this.mContainer = (LinearLayout)this.findViewById(R.id.status_container);
        this.mStatusIcon = (YYImageView)this.findViewById(R.id.icon_status);
        this.mStatusText = (YYTextView)this.findViewById(R.id.text_status);
        this.mStatusExtend = (YYLinearLayout)this.findViewById(R.id.status_extend_frame);
        if (this.getStatusIcon() > 0) {
            this.mStatusIcon.setBackgroundResource(this.getStatusIcon());
        }
        if (this.getStatusText() != null) {
            this.mStatusText.setText((CharSequence)this.getStatusText());
        }
        this.setContainerPosition();
    }

    protected void setContainerPosition() {
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mContainer.getLayoutParams();
        if (lp != null) {
            lp.topMargin = (int)((double)ResolutionUtils.getScreenHeight((Context)RuntimeContext.sApplicationContext) * 0.1);
            this.mContainer.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
    }

    @DrawableRes
    protected abstract int getStatusIcon();

    public void setStatusIcon(@DrawableRes int iconId) {
        if (this.mStatusIcon != null) {
            this.mStatusIcon.setBackgroundResource(iconId);
        }
    }

    protected abstract String getStatusText();

    public void setStatusText(String text) {
        if (this.mStatusText == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)text)) {
            this.mStatusText.setVisibility(8);
        } else {
            this.mStatusText.setVisibility(0);
            this.mStatusText.setText((CharSequence)text);
        }
    }

    public void setStatusTextColor(int color2) {
        if (this.mStatusText == null) {
            return;
        }
        this.mStatusText.setTextColor(ResourceUtils.getColor((int)color2));
    }

    public void setStyleStatusText(Spanned text) {
        if (this.mStatusText == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)text)) {
            this.mStatusText.setVisibility(8);
        } else {
            this.mStatusText.setVisibility(0);
            this.mStatusText.setText((CharSequence)text);
        }
    }

    public void setStatusTextVisibility(boolean visibility) {
        if (this.mStatusText == null) {
            return;
        }
        this.mStatusText.setVisibility(visibility ? 0 : 8);
    }

    public void addCustomView(View view) {
        if (this.mStatusExtend == null) {
            return;
        }
        this.mStatusExtend.removeAllViews();
        if (view != null) {
            this.mStatusExtend.addView(view);
            this.mStatusExtend.setVisibility(0);
        } else {
            this.mStatusExtend.setVisibility(8);
        }
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.mContainer.setOnClickListener(l);
    }

    public View getRootView() {
        return this.mRootView;
    }
}

