/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.rangebar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import com.yy.appbase.R;
import com.yy.appbase.ui.widget.rangebar.DrawableUtils;
import com.yy.appbase.ui.widget.rangebar.MathUtils;
import com.yy.appbase.ui.widget.rangebar.RangeProgressBar;
import com.yy.appbase.ui.widget.rangebar.SephirothViewCompat;
import com.yy.base.logger.MLog;

public class RangeSeekBar
extends RangeProgressBar {
    private static final String TAG = "RangeSeekBar";
    private int mInitialStartValue;
    private int mInitialEndValue;
    private final Rect mTempRect1 = new Rect();
    private final Rect mTempRect2 = new Rect();
    private OnRangeSeekBarChangeListener mOnRangeSeekBarChangeListener;
    private int mThumbWidth;
    private int mThumbHeight;
    private int mThumbOffset;
    private int mStepSize = 1;
    private int mThumbClipInset = 0;
    private Drawable mThumbStart;
    private Drawable mThumbEnd;
    private Drawable mTickMark;
    private ColorStateList mThumbTintList = null;
    private ColorStateList mTickMarkTintList = null;
    private PorterDuff.Mode mThumbTintMode = null;
    private PorterDuff.Mode mTickMarkTintMode = null;
    private boolean mHasThumbTint = false;
    private boolean mHasThumbTintMode = false;
    private boolean mHasTickMarkTint = false;
    private boolean mHasTickMarkTintMode = false;
    private boolean mSplitTrack;
    float mTouchProgressOffset;
    boolean mIsUserSeekable = true;
    private int mKeyProgressIncrement = 1;
    private static final int NO_ALPHA = 255;
    private float mDisabledAlpha;
    private int mScaledTouchSlop;
    private float mTouchDownX;
    private boolean mIsDragging;
    private WhichThumb mWhichThumb = WhichThumb.None;

    public RangeSeekBar(Context context) {
        this(context, null);
    }

    public RangeSeekBar(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.sephiroth_rangeSeekBarStyle);
    }

    public RangeSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public RangeSeekBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.mInitialProgressDone = false;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RangeSeekBar, defStyleAttr, defStyleRes);
        Drawable thumb = a.hasValue(R.styleable.RangeSeekBar_range_seekbar_leftThumb) ? a.getDrawable(R.styleable.RangeSeekBar_range_seekbar_leftThumb) : a.getDrawable(R.styleable.RangeSeekBar_android_thumb);
        Drawable thumb2 = a.hasValue(R.styleable.RangeSeekBar_range_seekbar_rightThumb) ? a.getDrawable(R.styleable.RangeSeekBar_range_seekbar_rightThumb) : a.getDrawable(R.styleable.RangeSeekBar_android_thumb);
        this.setThumb(thumb, WhichThumb.Start);
        this.setThumb(thumb2, WhichThumb.End);
        if (a.hasValue(R.styleable.RangeSeekBar_android_thumbTintMode)) {
            this.mThumbTintMode = DrawableUtils.parseTintMode(a.getInt(R.styleable.RangeSeekBar_android_thumbTintMode, -1), this.mThumbTintMode);
            this.mHasThumbTintMode = true;
        }
        if (a.hasValue(R.styleable.RangeSeekBar_android_thumbTint)) {
            this.mThumbTintList = a.getColorStateList(R.styleable.RangeSeekBar_android_thumbTint);
            this.mHasThumbTint = true;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            Drawable tickMark = a.getDrawable(R.styleable.RangeSeekBar_android_tickMark);
            MLog.verbose((Object)TAG, (String)"tickMark = %s", (Object[])new Object[]{tickMark});
            this.setTickMark(tickMark);
            if (a.hasValue(R.styleable.RangeSeekBar_android_tickMarkTintMode)) {
                this.mTickMarkTintMode = DrawableUtils.parseTintMode(a.getInt(R.styleable.RangeSeekBar_android_tickMarkTintMode, -1), this.mTickMarkTintMode);
                this.mHasTickMarkTintMode = true;
            }
            if (a.hasValue(R.styleable.RangeSeekBar_android_tickMarkTint)) {
                this.mTickMarkTintList = a.getColorStateList(R.styleable.RangeSeekBar_android_tickMarkTint);
                this.mHasTickMarkTint = true;
            }
        }
        this.mSplitTrack = a.getBoolean(R.styleable.RangeSeekBar_android_splitTrack, false);
        if (a.hasValue(R.styleable.RangeSeekBar_range_seekbar_stepSize)) {
            this.mStepSize = a.getInt(R.styleable.RangeSeekBar_range_seekbar_stepSize, 1);
        }
        this.setMinMaxStepSize(this.getMinMapStepSize());
        this.mThumbClipInset = a.getDimensionPixelSize(R.styleable.RangeSeekBar_range_seekbar_thumbInset, this.mThumbClipInset);
        int thumbOffset = a.getDimensionPixelOffset(R.styleable.RangeSeekBar_android_thumbOffset, this.getThumbOffset());
        this.setThumbOffset(thumbOffset);
        boolean useDisabledAlpha = a.getBoolean(R.styleable.RangeSeekBar_range_seekbar_useDisabledAlpha, true);
        a.recycle();
        this.mDisabledAlpha = useDisabledAlpha ? 0.5f : 1.0f;
        this.applyTickMarkTint();
        this.mScaledTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.setInitialProgress(this.mInitialStartValue, this.mInitialEndValue);
        this.setProgress(this.mInitialStartValue, this.mInitialEndValue);
        this.mInitialProgressDone = true;
    }

    private void adjustInitialProgressValues() {
        MLog.info((Object)TAG, (String)"adjustInitialProgressValues", (Object[])new Object[0]);
        if (this.mProgressStartMaxValue != -1 || this.mProgressEndMinValue != -1) {
            if (this.mProgressStartMaxValue != -1) {
                this.mInitialStartValue = Math.min(this.mInitialStartValue, this.mProgressStartMaxValue);
            }
            if (this.mProgressEndMinValue != -1) {
                this.mInitialEndValue = Math.max(this.mInitialEndValue, this.mProgressEndMinValue);
            }
        } else if (this.mMinMaxStepSize != 0 && this.mInitialEndValue - this.mInitialStartValue < this.mMinMaxStepSize) {
            this.mInitialStartValue = Math.max(0, this.mInitialEndValue - this.mMinMaxStepSize);
            this.mInitialEndValue = Math.min(this.getMax(), this.mInitialStartValue + this.mMinMaxStepSize);
        }
    }

    public void setStepSize(int value) {
        MLog.info((Object)TAG, (String)"setStepSize(%d)", (Object[])new Object[]{value});
        this.mStepSize = value;
        this.setMinMaxStepSize(this.getMinMapStepSize());
        this.setProgress(this.getProgressStart(), this.getProgressEnd());
    }

    @Override
    public void setMinMaxStepSize(int value) {
        super.setMinMaxStepSize(value);
        if (this.mMinMaxStepSize != 0 && this.mMinMaxStepSize % this.mStepSize != 0) {
            this.mMinMaxStepSize = Math.max(this.mStepSize, this.mMinMaxStepSize - this.mMinMaxStepSize % this.mStepSize);
        }
        MLog.info((Object)TAG, (String)"setMinMaxStepSize(%d --> %d)", (Object[])new Object[]{value, this.mMinMaxStepSize});
        if (this.mInitialProgressDone) {
            this.setProgress(this.getProgressStart(), this.getProgressEnd());
        }
    }

    @Override
    public void setProgressStartEndBoundaries(int startMax, int endMin) {
        super.setProgressStartEndBoundaries(startMax, endMin);
        if (this.mInitialProgressDone) {
            this.setProgress(this.getProgressStart(), this.getProgressEnd());
        }
    }

    @Override
    protected void setInitialProgress(int startProgress, int endProgress) {
        MLog.info((Object)TAG, (String)"setInitialProgress: %d - %d", (Object[])new Object[]{startProgress, endProgress});
        this.mInitialStartValue = startProgress;
        this.mInitialEndValue = endProgress;
        this.adjustInitialProgressValues();
    }

    @Override
    public void onProgressRefresh(boolean fromUser, int startValue, int endValue) {
        super.onProgressRefresh(fromUser, startValue, endValue);
        if (this.mOnRangeSeekBarChangeListener != null) {
            this.mOnRangeSeekBarChangeListener.onProgressChanged(this, startValue, endValue, fromUser);
        }
    }

    public void setOnRangeSeekBarChangeListener(OnRangeSeekBarChangeListener l) {
        this.mOnRangeSeekBarChangeListener = l;
    }

    public void setThumb(Drawable thumb, WhichThumb which) {
        boolean needUpdate;
        Drawable whichThumb;
        Drawable drawable2 = whichThumb = which == WhichThumb.Start ? this.mThumbStart : this.mThumbEnd;
        if (whichThumb != null && thumb != whichThumb) {
            whichThumb.setCallback(null);
            needUpdate = true;
        } else {
            needUpdate = false;
        }
        if (thumb != null) {
            thumb.setCallback((Drawable.Callback)this);
            DrawableCompat.setLayoutDirection((Drawable)thumb, (int)ViewCompat.getLayoutDirection((View)this));
            this.mThumbOffset = thumb.getIntrinsicWidth() / 2;
            this.mThumbWidth = thumb.getIntrinsicWidth();
            this.mThumbHeight = thumb.getIntrinsicHeight();
            if (needUpdate && (thumb.getIntrinsicWidth() != whichThumb.getIntrinsicWidth() || thumb.getIntrinsicHeight() != whichThumb.getIntrinsicHeight())) {
                this.requestLayout();
            }
        }
        if (which == WhichThumb.Start) {
            this.mThumbStart = thumb;
        } else {
            this.mThumbEnd = thumb;
        }
        this.applyThumbTintInternal(which);
        this.invalidate();
        if (needUpdate) {
            this.updateThumbAndTrackPos(this.getWidth(), this.getHeight());
            if (thumb != null && thumb.isStateful()) {
                int[] state = this.getDrawableState();
                thumb.setState(state);
            }
        }
    }

    public Drawable getThumbStart() {
        return this.mThumbStart;
    }

    public Drawable getThumbEnd() {
        return this.mThumbEnd;
    }

    public void setThumbTintList(@Nullable ColorStateList tint) {
        this.mThumbTintList = tint;
        this.mHasThumbTint = true;
        this.applyThumbTint();
    }

    @Nullable
    public ColorStateList getThumbTintList() {
        return this.mThumbTintList;
    }

    public void setThumbTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.mThumbTintMode = tintMode;
        this.mHasThumbTintMode = true;
        this.applyThumbTint();
    }

    @Nullable
    public PorterDuff.Mode getThumbTintMode() {
        return this.mThumbTintMode;
    }

    private void applyThumbTint() {
        this.applyThumbTintInternal(WhichThumb.Start);
        this.applyThumbTintInternal(WhichThumb.End);
    }

    private void applyThumbTintInternal(WhichThumb which) {
        Drawable thumb;
        Drawable drawable2 = thumb = which == WhichThumb.Start ? this.mThumbStart : this.mThumbEnd;
        if (thumb != null && (this.mHasThumbTint || this.mHasThumbTintMode)) {
            thumb = which == WhichThumb.Start ? (this.mThumbStart = thumb.mutate()) : (this.mThumbEnd = thumb.mutate());
            if (this.mHasThumbTint) {
                DrawableCompat.setTintList((Drawable)thumb, (ColorStateList)this.mThumbTintList);
            }
            if (this.mHasThumbTintMode) {
                DrawableCompat.setTintMode((Drawable)thumb, (PorterDuff.Mode)this.mThumbTintMode);
            }
            if (thumb.isStateful()) {
                thumb.setState(this.getDrawableState());
            }
        }
    }

    public int getThumbOffset() {
        return this.mThumbOffset;
    }

    public void setThumbOffset(int thumbOffset) {
        this.mThumbOffset = thumbOffset;
        this.invalidate();
    }

    public void setSplitTrack(boolean splitTrack) {
        this.mSplitTrack = splitTrack;
        this.invalidate();
    }

    public boolean getSplitTrack() {
        return this.mSplitTrack;
    }

    public void setTickMark(Drawable tickMark) {
        if (this.mTickMark != null) {
            this.mTickMark.setCallback(null);
        }
        this.mTickMark = tickMark;
        if (tickMark != null) {
            this.setProgressOffset(0);
            tickMark.setCallback((Drawable.Callback)this);
            if (tickMark.isStateful()) {
                tickMark.setState(this.getDrawableState());
            }
            int w = tickMark.getIntrinsicWidth();
            int h = tickMark.getIntrinsicHeight();
            int halfW = w >= 0 ? w / 2 : 1;
            int halfH = h >= 0 ? h / 2 : 1;
            tickMark.setBounds(-halfW, -halfH, halfW, halfH);
            this.applyTickMarkTint();
        }
        this.invalidate();
    }

    public Drawable getTickMark() {
        return this.mTickMark;
    }

    public void setTickMarkTintList(@Nullable ColorStateList tint) {
        this.mTickMarkTintList = tint;
        this.mHasTickMarkTint = true;
        this.applyTickMarkTint();
    }

    @Nullable
    public ColorStateList getTickMarkTintList() {
        return this.mTickMarkTintList;
    }

    public void setTickMarkTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.mTickMarkTintMode = tintMode;
        this.mHasTickMarkTintMode = true;
        this.applyTickMarkTint();
    }

    @Nullable
    public PorterDuff.Mode getTickMarkTintMode() {
        return this.mTickMarkTintMode;
    }

    protected void applyTickMarkTint() {
        if (this.mTickMark != null && (this.mHasTickMarkTint || this.mHasTickMarkTintMode)) {
            this.mTickMark = DrawableCompat.wrap((Drawable)this.mTickMark.mutate());
            if (this.mHasTickMarkTint) {
                DrawableCompat.setTintList((Drawable)this.mTickMark, (ColorStateList)this.mTickMarkTintList);
            }
            if (this.mHasTickMarkTintMode) {
                DrawableCompat.setTintMode((Drawable)this.mTickMark, (PorterDuff.Mode)this.mTickMarkTintMode);
            }
            if (this.mTickMark.isStateful()) {
                this.mTickMark.setState(this.getDrawableState());
            }
        }
    }

    public void setKeyProgressIncrement(int increment) {
        this.mKeyProgressIncrement = increment < 0 ? -increment : increment;
    }

    public float getKeyProgressIncrement() {
        return this.mKeyProgressIncrement;
    }

    @Override
    public synchronized void setMax(int max) {
        super.setMax(max);
        if (this.mKeyProgressIncrement == 0 || this.getMax() / this.mKeyProgressIncrement > 20) {
            this.setKeyProgressIncrement(this.getMax() / 20);
        }
    }

    @Override
    protected boolean verifyDrawable(@NonNull Drawable who) {
        return who == this.mThumbStart || who == this.mThumbEnd || who == this.mTickMark || super.verifyDrawable(who);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mThumbStart != null) {
            this.mThumbStart.jumpToCurrentState();
        }
        if (this.mThumbEnd != null) {
            this.mThumbEnd.jumpToCurrentState();
        }
        if (this.mTickMark != null) {
            this.mTickMark.jumpToCurrentState();
        }
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        MLog.info((Object)TAG, (String)"drawableStateChanged(%s)", (Object[])new Object[]{this.mWhichThumb});
        Drawable progressDrawable = this.getProgressDrawable();
        if (progressDrawable != null && this.mDisabledAlpha < 1.0f) {
            progressDrawable.setAlpha(this.isEnabled() ? 255 : (int)(255.0f * this.mDisabledAlpha));
        }
        if (this.mWhichThumb != WhichThumb.None) {
            Drawable thumb = this.mWhichThumb == WhichThumb.Start ? this.mThumbStart : this.mThumbEnd;
            this.setDrawableState(thumb, this.getDrawableState());
        } else {
            this.setDrawableState(this.mThumbStart, this.getDrawableState());
            this.setDrawableState(this.mThumbEnd, this.getDrawableState());
        }
        Drawable tickMark = this.mTickMark;
        if (tickMark != null && tickMark.isStateful() && tickMark.setState(this.getDrawableState())) {
            this.invalidateDrawable(tickMark);
        }
    }

    protected void setDrawableState(Drawable drawable2, int[] drawableState) {
        if (null != drawable2 && drawable2.isStateful() && drawable2.setState(drawableState)) {
            this.invalidateDrawable(drawable2);
        }
    }

    @Override
    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mThumbStart != null) {
            MLog.verbose((Object)TAG, (String)"setHotspot(mThumbStart, %.2f, %.2f)", (Object[])new Object[]{Float.valueOf(x), Float.valueOf(y)});
            DrawableCompat.setHotspot((Drawable)this.mThumbStart, (float)x, (float)y);
        }
        if (this.mThumbEnd != null) {
            MLog.verbose((Object)TAG, (String)"setHotspot(mThumbEnd, %.2f, %.2f)", (Object[])new Object[]{Float.valueOf(x), Float.valueOf(y)});
            DrawableCompat.setHotspot((Drawable)this.mThumbEnd, (float)x, (float)y);
        }
    }

    @Override
    public void onVisualProgressChanged(int id2, float scaleStart, float scaleEnd) {
        super.onVisualProgressChanged(id2, scaleStart, scaleEnd);
        if (id2 == 16908301 && this.mThumbStart != null && this.mThumbEnd != null) {
            this.setThumbPos(this.getWidth(), this.mThumbStart, scaleStart, WhichThumb.Start, Integer.MIN_VALUE);
            this.setThumbPos(this.getWidth(), this.mThumbEnd, scaleEnd, WhichThumb.End, Integer.MIN_VALUE);
            this.invalidate();
        }
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateThumbAndTrackPos(w, h);
    }

    private void updateThumbAndTrackPos(int w, int h) {
        Drawable background;
        int thumbOffset;
        int trackOffset;
        int offsetHeight;
        int thumbHeight;
        int paddedHeight = h - this.mPaddingTop - this.mPaddingBottom;
        Drawable track = this.getCurrentDrawable();
        Drawable thumb = this.mThumbStart;
        int trackHeight = Math.min(this.mMaxHeight, paddedHeight);
        int n = thumbHeight = thumb == null ? 0 : thumb.getIntrinsicHeight();
        if (thumbHeight > trackHeight) {
            offsetHeight = (paddedHeight - thumbHeight) / 2;
            trackOffset = offsetHeight + (thumbHeight - trackHeight) / 2;
            thumbOffset = offsetHeight;
        } else {
            trackOffset = offsetHeight = (paddedHeight - trackHeight) / 2;
            thumbOffset = offsetHeight + (trackHeight - thumbHeight) / 2;
        }
        if (track != null) {
            int trackWidth = w - this.mPaddingRight - this.mPaddingLeft;
            track.setBounds(0, trackOffset, trackWidth, trackOffset + trackHeight);
        }
        if (this.mThumbStart != null && this.mThumbEnd != null) {
            this.setThumbPos(w, this.mThumbStart, this.getScaleStart(), WhichThumb.Start, thumbOffset);
            this.setThumbPos(w, this.mThumbEnd, this.getScaleEnd(), WhichThumb.End, thumbOffset);
        }
        if ((background = this.getBackground()) != null && thumb != null) {
            Rect bounds = thumb.getBounds();
            background.setBounds(bounds);
            MLog.verbose((Object)TAG, (String)"setHotspot(background, %d, %d)", (Object[])new Object[]{bounds.centerX(), bounds.centerY()});
            DrawableCompat.setHotspotBounds((Drawable)background, (int)bounds.left, (int)bounds.top, (int)bounds.right, (int)bounds.bottom);
        }
    }

    private float getScaleStart() {
        float max = this.getMax();
        return max > 0.0f ? (float)this.getProgressStart() / max : 0.0f;
    }

    private float getScaleEnd() {
        float max = this.getMax();
        return max > 0.0f ? (float)this.getProgressEnd() / max : 0.0f;
    }

    private void setThumbPos(int w, Drawable thumb, float scale, WhichThumb which, int offset) {
        Drawable background;
        int bottom;
        int top;
        MLog.info((Object)TAG, (String)"setThumbPos(%d, %g, %s, %d)", (Object[])new Object[]{w, Float.valueOf(scale), which, offset});
        int available = w - this.mPaddingLeft - this.mPaddingRight - this.getProgressOffset();
        available -= this.mThumbWidth;
        int thumbPos = (int)(scale * (float)(available += this.mThumbOffset * 2) + 0.5f);
        if (offset == Integer.MIN_VALUE) {
            Rect oldBounds = thumb.getBounds();
            top = oldBounds.top;
            bottom = oldBounds.bottom;
        } else {
            top = offset;
            bottom = offset + this.mThumbHeight;
        }
        int left = thumbPos;
        int right = left + this.mThumbWidth;
        if (which == WhichThumb.End) {
            left += this.getProgressOffset();
            right += this.getProgressOffset();
        }
        if ((background = this.getBackground()) != null && which == this.mWhichThumb) {
            int offsetX = this.mPaddingLeft - this.mThumbOffset;
            int offsetY = this.mPaddingTop;
            background.setBounds(left + offsetX, top + offsetY, right + offsetX, bottom + offsetY);
            DrawableCompat.setHotspotBounds((Drawable)background, (int)(left + offsetX), (int)(top + offsetY), (int)(right + offsetX), (int)(bottom + offsetY));
        }
        thumb.setBounds(left, top, right, bottom);
    }

    @Override
    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawThumb(canvas);
    }

    @Override
    void drawTrack(Canvas canvas) {
        if (this.mThumbStart != null && this.mSplitTrack) {
            Rect tempRect = this.mTempRect1;
            this.mThumbStart.copyBounds(tempRect);
            tempRect.offset(this.mPaddingLeft - this.mThumbOffset, this.mPaddingTop);
            tempRect.left += this.mThumbClipInset;
            tempRect.right -= this.mThumbClipInset;
            int saveCount = canvas.save();
            canvas.clipRect(tempRect, Region.Op.DIFFERENCE);
            this.mThumbEnd.copyBounds(tempRect);
            tempRect.offset(this.mPaddingLeft - this.mThumbOffset, this.mPaddingTop);
            tempRect.left += this.mThumbClipInset;
            tempRect.right -= this.mThumbClipInset;
            canvas.clipRect(tempRect, Region.Op.DIFFERENCE);
            super.drawTrack(canvas);
            this.drawTickMarks(canvas);
            canvas.restoreToCount(saveCount);
        } else {
            super.drawTrack(canvas);
            this.drawTickMarks(canvas);
        }
    }

    void drawTickMarks(Canvas canvas) {
        float count;
        if (this.mTickMark != null && (count = (float)this.getMax()) > 1.0f) {
            float spacing = (float)(this.getWidth() - (this.mPaddingLeft + this.mPaddingRight)) / (count / (float)this.mStepSize);
            int saveCount = canvas.save();
            canvas.translate((float)this.mPaddingLeft, (float)this.getHeight() / 2.0f);
            int i = 0;
            while ((float)i <= count) {
                this.mTickMark.draw(canvas);
                canvas.translate(spacing, 0.0f);
                ++i;
            }
            canvas.restoreToCount(saveCount);
        }
    }

    void drawThumb(Canvas canvas) {
        if (this.mThumbStart != null && this.mThumbEnd != null) {
            int saveCount = canvas.save();
            canvas.translate((float)(this.mPaddingLeft - this.mThumbOffset), (float)this.mPaddingTop);
            this.mThumbStart.draw(canvas);
            this.mThumbEnd.draw(canvas);
            canvas.restoreToCount(saveCount);
        }
    }

    @Override
    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable d = this.getCurrentDrawable();
        int thumbHeight = this.mThumbStart == null ? 0 : this.mThumbStart.getIntrinsicHeight();
        int dw = 0;
        int dh = 0;
        if (d != null) {
            dw = Math.max(this.mMinWidth, Math.min(this.mMaxWidth, d.getIntrinsicWidth()));
            dh = Math.max(this.mMinHeight, Math.min(this.mMaxHeight, d.getIntrinsicHeight()));
            dh = Math.max(thumbHeight, dh);
        }
        this.setMeasuredDimension(RangeSeekBar.resolveSizeAndState((int)(dw += this.mPaddingLeft + this.mPaddingRight), (int)widthMeasureSpec, (int)0), RangeSeekBar.resolveSizeAndState((int)(dh += this.mPaddingTop + this.mPaddingBottom), (int)heightMeasureSpec, (int)0));
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mIsUserSeekable || !this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                MLog.info((Object)TAG, (String)"ACTION_DOWN", (Object[])new Object[0]);
                if (SephirothViewCompat.isInScrollingContainer((View)this)) {
                    MLog.warn((Object)TAG, (String)"isInScrollContainer", (Object[])new Object[0]);
                    this.mTouchDownX = event.getX();
                    break;
                }
                this.startDrag(event);
                break;
            }
            case 2: {
                if (this.mIsDragging) {
                    this.trackTouchEvent(event);
                    break;
                }
                float x = event.getX();
                if (!(Math.abs(x - this.mTouchDownX) > (float)this.mScaledTouchSlop)) break;
                this.startDrag(event);
                break;
            }
            case 1: {
                if (this.mIsDragging) {
                    this.trackTouchEvent(event);
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                } else {
                    this.onStartTrackingTouch();
                    this.trackTouchEvent(event);
                    this.onStopTrackingTouch();
                    this.performClick();
                }
                this.invalidate();
                break;
            }
            case 3: {
                if (this.mIsDragging) {
                    this.onStopTrackingTouch();
                    this.setPressed(false);
                }
                this.invalidate();
                break;
            }
        }
        return true;
    }

    private WhichThumb getNearestThumb(float x, float y) {
        this.mThumbStart.copyBounds(this.mTempRect1);
        this.mTempRect1.inset(this.mTempRect1.width() / 4, this.mTempRect1.height() / 4);
        this.mThumbEnd.copyBounds(this.mTempRect2);
        this.mTempRect2.inset(this.mTempRect2.width() / 4, this.mTempRect2.height() / 4);
        float diff1 = Math.abs(x - (float)this.mTempRect1.centerX());
        float diff2 = Math.abs(x - (float)this.mTempRect2.centerX());
        if (this.mTempRect1.contains((int)x, (int)y)) {
            return WhichThumb.Start;
        }
        if (this.mTempRect2.contains((int)x, (int)y)) {
            return WhichThumb.End;
        }
        return diff1 < diff2 ? WhichThumb.Start : WhichThumb.End;
    }

    private void startDrag(MotionEvent event) {
        MLog.info((Object)TAG, (String)"startDrag", (Object[])new Object[0]);
        if (null == this.mThumbStart || null == this.mThumbEnd) {
            MLog.error((Object)TAG, (String)"missing one of the thumbs!", (Object[])new Object[0]);
            return;
        }
        this.mWhichThumb = this.getNearestThumb(event.getX() - (float)(this.mPaddingLeft - this.mThumbOffset), event.getY());
        MLog.verbose((Object)TAG, (String)"mWhichThumb: %s", (Object[])new Object[]{this.mWhichThumb});
        this.setPressed(true);
        if (this.mWhichThumb != WhichThumb.None) {
            Drawable thumb;
            Drawable drawable2 = thumb = this.mWhichThumb == WhichThumb.Start ? this.mThumbStart : this.mThumbEnd;
            if (thumb != null) {
                float scale = this.mWhichThumb == WhichThumb.Start ? this.getScaleStart() : this.getScaleEnd();
                this.setThumbPos(this.getWidth(), thumb, scale, this.mWhichThumb, Integer.MIN_VALUE);
                this.invalidate(thumb.getBounds());
            }
        }
        this.onStartTrackingTouch();
        this.trackTouchEvent(event);
        this.attemptClaimDrag();
    }

    public void setPressed(boolean pressed) {
        MLog.debug((Object)TAG, (String)"setPressed(%b, %s)", (Object[])new Object[]{pressed, this.mWhichThumb});
        if (!pressed) {
            this.mWhichThumb = WhichThumb.None;
        }
        super.setPressed(pressed);
    }

    private void setHotspot(float x, float y) {
    }

    private void trackTouchEvent(MotionEvent event) {
        float scale;
        if (null == this.mThumbStart || null == this.mThumbEnd) {
            return;
        }
        float x = event.getX();
        float y = event.getY();
        int width = this.getWidth();
        if (this.mWhichThumb == WhichThumb.End) {
            x -= (float)this.getProgressOffset();
        }
        int thumbWidth = this.mThumbStart.getIntrinsicWidth();
        int availableWidth = width - this.mPaddingLeft - this.mPaddingRight - this.getProgressOffset() - thumbWidth + this.mThumbOffset * 2;
        x -= (float)thumbWidth / 2.0f;
        x += (float)this.mThumbOffset;
        float progress = 0.0f;
        if (x < (float)this.mPaddingLeft) {
            scale = 0.0f;
        } else if (x > (float)(width - this.mPaddingRight)) {
            scale = 1.0f;
        } else {
            scale = (x - (float)this.mPaddingLeft) / (float)availableWidth;
            progress = this.mTouchProgressOffset;
        }
        float max = this.getMax();
        progress += scale * max;
        this.setHotspot(x, y);
        if (this.mWhichThumb == WhichThumb.Start) {
            progress = MathUtils.constrain(progress, 0.0f, (float)this.getProgressStartMaxValue());
            this.setProgressInternal(Math.round(progress), this.getProgressEnd(), true, false);
        } else if (this.mWhichThumb == WhichThumb.End) {
            progress = MathUtils.constrain(progress, (float)this.getProgressEndMinValue(), (float)this.getMax());
            this.setProgressInternal(this.getProgressStart(), Math.round(progress), true, false);
        }
    }

    @Override
    synchronized boolean setProgressInternal(int startValue, int endValue, boolean fromUser, boolean animate) {
        if (this.mStepSize > 1) {
            int remainderEnd;
            int remainderStart = startValue % this.mStepSize;
            if (remainderStart > 0) {
                startValue = (double)((float)remainderStart / (float)this.mStepSize) > 0.5 ? (startValue += this.mStepSize - remainderStart) : (startValue -= remainderStart);
            }
            if ((remainderEnd = endValue % this.mStepSize) > 0) {
                endValue = (double)((float)remainderEnd / (float)this.mStepSize) > 0.5 ? (endValue += this.mStepSize - remainderEnd) : (endValue -= remainderEnd);
            }
        }
        if (this.mProgressStartMaxValue != -1 || this.mProgressEndMinValue != -1) {
            if (this.mProgressStartMaxValue != -1) {
                startValue = MathUtils.constrain(startValue, 0, this.mProgressStartMaxValue);
            }
            if (this.mProgressEndMinValue != -1) {
                endValue = MathUtils.constrain(endValue, this.mProgressEndMinValue, this.getMax());
            }
        } else if (this.mMinMaxStepSize != 0 && endValue - startValue < this.mMinMaxStepSize) {
            endValue = startValue + this.getMinMapStepSize();
        }
        return super.setProgressInternal(startValue, endValue, fromUser, animate);
    }

    private void attemptClaimDrag() {
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
        }
    }

    void onStartTrackingTouch() {
        this.mIsDragging = true;
        if (this.mOnRangeSeekBarChangeListener != null) {
            this.mOnRangeSeekBarChangeListener.onStartTrackingTouch(this);
        }
    }

    void onStopTrackingTouch() {
        this.mIsDragging = false;
        if (this.mOnRangeSeekBarChangeListener != null) {
            this.mOnRangeSeekBarChangeListener.onStopTrackingTouch(this);
        }
    }

    void onKeyChange() {
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.isEnabled()) {
            int increment = this.mKeyProgressIncrement;
            switch (keyCode) {
                case 21: 
                case 69: {
                    increment = -increment;
                }
                case 22: 
                case 70: 
                case 81: {
                    if (!this.setProgressInternal(this.getProgressStart() - increment, this.getProgressEnd() + increment, true, true)) break;
                    this.onKeyChange();
                    return true;
                }
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return RangeSeekBar.class.getName();
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        if (Build.VERSION.SDK_INT >= 24) {
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SET_PROGRESS);
        }
    }

    public boolean performAccessibilityAction(int action, Bundle arguments) {
        return super.performAccessibilityAction(action, arguments);
    }

    public static enum WhichThumb {
        Start,
        End,
        None;

    }

    public static interface OnRangeSeekBarChangeListener {
        public void onProgressChanged(RangeSeekBar var1, int var2, int var3, boolean var4);

        public void onStartTrackingTouch(RangeSeekBar var1);

        public void onStopTrackingTouch(RangeSeekBar var1);
    }
}

