/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.rangebar;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.InterpolatorRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.util.Pools;
import com.yy.appbase.R;
import com.yy.appbase.ui.widget.rangebar.DrawableUtils;
import com.yy.appbase.ui.widget.rangebar.MathUtils;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYView;
import java.util.ArrayList;

public class RangeProgressBar
extends YYView {
    private static final String TAG = "RangeProgressBar";
    private static final int TIMEOUT_SEND_ACCESSIBILITY_EVENT = 200;
    private static final DecelerateInterpolator PROGRESS_ANIM_INTERPOLATOR = new DecelerateInterpolator();
    private static final int PROGRESS_ANIM_DURATION = 80;
    protected int mMinMaxStepSize;
    protected int mProgressStartMaxValue;
    protected int mProgressEndMinValue;
    int mMinWidth;
    int mMaxWidth;
    int mMinHeight;
    int mMaxHeight;
    private int mProgressOffset;
    private int mEndProgress;
    private int mStartProgress;
    private int mMax;
    protected boolean mInitialProgressDone;
    private Drawable mProgressDrawable;
    private Drawable mCurrentDrawable;
    private ProgressTintInfo mProgressTintInfo;
    int mSampleWidth = 0;
    private boolean mNoInvalidate;
    private Interpolator mInterpolator;
    private RefreshProgressRunnable mRefreshProgressRunnable;
    private long mUiThreadId;
    private boolean mInDrawing;
    private boolean mAttached;
    private boolean mRefreshIsPosted;
    private float mVisualStartProgress;
    private float mVisualEndProgress;
    boolean mMirrorForRtl = false;
    private boolean mAggregatedIsVisible;
    private final ArrayList<RefreshData> mRefreshData = new ArrayList();
    private AccessibilityEventSender mAccessibilityEventSender;
    private Drawable mProgressDrawableIndicator;
    private Rect mProgressIndicatorBounds;
    private int mComputedWidth;
    protected int mPaddingBottom;
    protected int mPaddingTop;
    protected int mPaddingLeft;
    protected int mPaddingRight;

    public RangeProgressBar(Context context) {
        this(context, null);
    }

    public RangeProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.sephiroth_rangeProgressBarStyle);
    }

    public RangeProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mUiThreadId = Thread.currentThread().getId();
        this.initProgressBar();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RangeProgressBar, defStyleAttr, 0);
        this.mNoInvalidate = true;
        Drawable progressDrawable = a.getDrawable(R.styleable.RangeProgressBar_android_progressDrawable);
        if (progressDrawable != null) {
            if (RangeProgressBar.needsTileify(progressDrawable)) {
                this.setProgressDrawableTiled(progressDrawable);
            } else {
                this.setProgressDrawable(progressDrawable);
            }
        }
        this.mMinWidth = a.getDimensionPixelSize(R.styleable.RangeProgressBar_android_minWidth, this.mMinWidth);
        this.mMaxWidth = a.getDimensionPixelSize(R.styleable.RangeProgressBar_android_maxWidth, this.mMaxWidth);
        this.mMinHeight = a.getDimensionPixelSize(R.styleable.RangeProgressBar_android_minHeight, this.mMinHeight);
        this.mMaxHeight = a.getDimensionPixelSize(R.styleable.RangeProgressBar_android_maxHeight, this.mMaxHeight);
        this.mMinMaxStepSize = a.getInteger(R.styleable.RangeProgressBar_range_progress_startEnd_minDiff, 0);
        this.mProgressOffset = a.getDimensionPixelSize(R.styleable.RangeProgressBar_range_progress_offset, 0);
        this.mProgressEndMinValue = a.getInteger(R.styleable.RangeProgressBar_range_progress_endMinValue, -1);
        this.mProgressStartMaxValue = a.getInteger(R.styleable.RangeProgressBar_range_progress_startMaxValue, -1);
        int resID = a.getResourceId(R.styleable.RangeProgressBar_android_interpolator, 17432587);
        if (resID > 0) {
            this.setInterpolator(context, resID);
        }
        this.setMax(a.getInteger(R.styleable.RangeProgressBar_android_max, this.mMax));
        this.mNoInvalidate = false;
        if (a.hasValue(R.styleable.RangeProgressBar_android_progressTintMode)) {
            if (this.mProgressTintInfo == null) {
                this.mProgressTintInfo = new ProgressTintInfo();
            }
            this.mProgressTintInfo.mProgressTintMode = DrawableUtils.parseTintMode(a.getInt(R.styleable.RangeProgressBar_android_progressTintMode, -1), null);
            this.mProgressTintInfo.mHasProgressTintMode = true;
        }
        if (a.hasValue(R.styleable.RangeProgressBar_android_progressTint)) {
            if (this.mProgressTintInfo == null) {
                this.mProgressTintInfo = new ProgressTintInfo();
            }
            this.mProgressTintInfo.mProgressTintList = a.getColorStateList(R.styleable.RangeProgressBar_android_progressTint);
            this.mProgressTintInfo.mHasProgressTint = true;
        }
        if (a.hasValue(R.styleable.RangeProgressBar_android_progressBackgroundTintMode)) {
            if (this.mProgressTintInfo == null) {
                this.mProgressTintInfo = new ProgressTintInfo();
            }
            this.mProgressTintInfo.mProgressBackgroundTintMode = DrawableUtils.parseTintMode(a.getInt(R.styleable.RangeProgressBar_android_progressBackgroundTintMode, -1), null);
            this.mProgressTintInfo.mHasProgressBackgroundTintMode = true;
        }
        if (a.hasValue(R.styleable.RangeProgressBar_android_progressBackgroundTint)) {
            if (this.mProgressTintInfo == null) {
                this.mProgressTintInfo = new ProgressTintInfo();
            }
            this.mProgressTintInfo.mProgressBackgroundTintList = a.getColorStateList(R.styleable.RangeProgressBar_android_progressBackgroundTint);
            this.mProgressTintInfo.mHasProgressBackgroundTint = true;
        }
        int startProgress = a.getInteger(R.styleable.RangeProgressBar_range_progress_startValue, this.mStartProgress);
        int endProgress = a.getInteger(R.styleable.RangeProgressBar_range_progress_endValue, this.mEndProgress);
        a.recycle();
        this.applyProgressTints();
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
        this.setProgressStartEndBoundaries(this.mProgressStartMaxValue, this.mProgressEndMinValue);
        this.setInitialProgress(startProgress, endProgress);
        this.mInitialProgressDone = true;
    }

    public int getMinMapStepSize() {
        return this.mMinMaxStepSize;
    }

    protected void setInitialProgress(int startProgress, int endProgress) {
        this.setProgress(startProgress, endProgress);
    }

    private static boolean needsTileify(Drawable dr) {
        if (dr instanceof LayerDrawable) {
            LayerDrawable orig = (LayerDrawable)dr;
            int N = orig.getNumberOfLayers();
            for (int i = 0; i < N; ++i) {
                if (!RangeProgressBar.needsTileify(orig.getDrawable(i))) continue;
                MLog.debug((Object)TAG, (String)"needsTileify!", (Object[])new Object[0]);
                return true;
            }
            return false;
        }
        if (dr instanceof StateListDrawable) {
            return false;
        }
        return dr instanceof BitmapDrawable;
    }

    private Drawable tileify(Drawable drawable2, boolean clip) {
        MLog.debug((Object)TAG, (String)("tileify: " + drawable2 + ", clip: " + clip), (Object[])new Object[0]);
        if (drawable2 instanceof LayerDrawable) {
            LayerDrawable orig = (LayerDrawable)drawable2;
            int N = orig.getNumberOfLayers();
            Drawable[] outDrawables = new Drawable[N];
            for (int i = 0; i < N; ++i) {
                int id2 = orig.getId(i);
                outDrawables[i] = this.tileify(orig.getDrawable(i), id2 == 16908301 || id2 == 16908303);
            }
            LayerDrawable clone = new LayerDrawable(outDrawables);
            for (int i = 0; i < N; ++i) {
                clone.setId(i, orig.getId(i));
                if (Build.VERSION.SDK_INT < 23) continue;
                clone.setLayerGravity(i, orig.getLayerGravity(i));
                clone.setLayerWidth(i, orig.getLayerWidth(i));
                clone.setLayerHeight(i, orig.getLayerHeight(i));
                clone.setLayerInsetLeft(i, orig.getLayerInsetLeft(i));
                clone.setLayerInsetRight(i, orig.getLayerInsetRight(i));
                clone.setLayerInsetTop(i, orig.getLayerInsetTop(i));
                clone.setLayerInsetBottom(i, orig.getLayerInsetBottom(i));
                clone.setLayerInsetStart(i, orig.getLayerInsetStart(i));
                clone.setLayerInsetEnd(i, orig.getLayerInsetEnd(i));
            }
            return clone;
        }
        if (drawable2 instanceof StateListDrawable) {
            throw new RuntimeException("StateListDrawable not supported");
        }
        if (drawable2 instanceof BitmapDrawable) {
            Drawable.ConstantState cs = drawable2.getConstantState();
            assert (cs != null);
            BitmapDrawable clone = (BitmapDrawable)cs.newDrawable(this.getResources());
            clone.setTileModeXY(Shader.TileMode.REPEAT, Shader.TileMode.CLAMP);
            if (this.mSampleWidth <= 0) {
                this.mSampleWidth = clone.getIntrinsicWidth();
            }
            if (clip) {
                return new ClipDrawable((Drawable)clone, 0x800003, 1);
            }
            return clone;
        }
        return drawable2;
    }

    private void initProgressBar() {
        this.mMax = 100;
        this.mEndProgress = 100;
        this.mStartProgress = 0;
        this.mMinWidth = 24;
        this.mMaxWidth = 48;
        this.mMinHeight = 24;
        this.mMaxHeight = 48;
    }

    private void swapCurrentDrawable(Drawable newDrawable) {
        Drawable oldDrawable = this.mCurrentDrawable;
        this.mCurrentDrawable = newDrawable;
        if (oldDrawable != this.mCurrentDrawable) {
            if (oldDrawable != null) {
                oldDrawable.setVisible(false, false);
            }
            if (this.mCurrentDrawable != null) {
                this.mCurrentDrawable.setVisible(this.getWindowVisibility() == 0 && this.isShown(), false);
            }
        }
    }

    public Drawable getProgressDrawable() {
        return this.mProgressDrawable;
    }

    public void setProgressDrawable(Drawable d) {
        if (this.mProgressDrawable != d) {
            if (this.mProgressDrawable != null) {
                this.mProgressDrawable.setCallback(null);
                this.unscheduleDrawable(this.mProgressDrawable);
            }
            this.mProgressDrawable = d;
            if (d != null) {
                int drawableHeight;
                d.setCallback((Drawable.Callback)this);
                DrawableCompat.setLayoutDirection((Drawable)d, (int)this.getLayoutDirection());
                if (d.isStateful()) {
                    d.setState(this.getDrawableState());
                }
                if (this.mMaxHeight < (drawableHeight = d.getMinimumHeight())) {
                    this.mMaxHeight = drawableHeight;
                    this.requestLayout();
                }
                this.applyProgressTints();
            }
            this.swapCurrentDrawable(d);
            this.postInvalidate();
            this.updateDrawableBounds(this.getWidth(), this.getHeight());
            this.updateDrawableState();
            this.doRefreshProgress(16908301, this.mStartProgress, this.mEndProgress, false, false, false);
        }
    }

    private void applyProgressTints() {
        if (this.mProgressDrawable != null && this.mProgressTintInfo != null) {
            this.applyPrimaryProgressTint();
            this.applyProgressBackgroundTint();
        }
    }

    private void applyPrimaryProgressTint() {
        Drawable target;
        if ((this.mProgressTintInfo.mHasProgressTint || this.mProgressTintInfo.mHasProgressTintMode) && (target = this.getTintTarget(16908301, true)) != null) {
            if (this.mProgressTintInfo.mHasProgressTint) {
                DrawableCompat.setTintList((Drawable)target, (ColorStateList)this.mProgressTintInfo.mProgressTintList);
            }
            if (this.mProgressTintInfo.mHasProgressTintMode) {
                DrawableCompat.setTintMode((Drawable)target, (PorterDuff.Mode)this.mProgressTintInfo.mProgressTintMode);
            }
            if (target.isStateful()) {
                target.setState(this.getDrawableState());
            }
        }
    }

    private void applyProgressBackgroundTint() {
        Drawable target;
        if ((this.mProgressTintInfo.mHasProgressBackgroundTint || this.mProgressTintInfo.mHasProgressBackgroundTintMode) && (target = this.getTintTarget(0x1020000, false)) != null) {
            if (this.mProgressTintInfo.mHasProgressBackgroundTint) {
                DrawableCompat.setTintList((Drawable)target, (ColorStateList)this.mProgressTintInfo.mProgressBackgroundTintList);
            }
            if (this.mProgressTintInfo.mHasProgressBackgroundTintMode) {
                DrawableCompat.setTintMode((Drawable)target, (PorterDuff.Mode)this.mProgressTintInfo.mProgressBackgroundTintMode);
            }
            if (target.isStateful()) {
                target.setState(this.getDrawableState());
            }
        }
    }

    public void setProgressTintList(@Nullable ColorStateList tint) {
        if (this.mProgressTintInfo == null) {
            this.mProgressTintInfo = new ProgressTintInfo();
        }
        this.mProgressTintInfo.mProgressTintList = tint;
        this.mProgressTintInfo.mHasProgressTint = true;
        if (this.mProgressDrawable != null) {
            this.applyPrimaryProgressTint();
        }
    }

    @Nullable
    public ColorStateList getProgressTintList() {
        return this.mProgressTintInfo != null ? this.mProgressTintInfo.mProgressTintList : null;
    }

    public void setProgressTintMode(@Nullable PorterDuff.Mode tintMode) {
        if (this.mProgressTintInfo == null) {
            this.mProgressTintInfo = new ProgressTintInfo();
        }
        this.mProgressTintInfo.mProgressTintMode = tintMode;
        this.mProgressTintInfo.mHasProgressTintMode = true;
        if (this.mProgressDrawable != null) {
            this.applyPrimaryProgressTint();
        }
    }

    @Nullable
    public PorterDuff.Mode getProgressTintMode() {
        return this.mProgressTintInfo != null ? this.mProgressTintInfo.mProgressTintMode : null;
    }

    public void setProgressBackgroundTintList(@Nullable ColorStateList tint) {
        if (this.mProgressTintInfo == null) {
            this.mProgressTintInfo = new ProgressTintInfo();
        }
        this.mProgressTintInfo.mProgressBackgroundTintList = tint;
        this.mProgressTintInfo.mHasProgressBackgroundTint = true;
        if (this.mProgressDrawable != null) {
            this.applyProgressBackgroundTint();
        }
    }

    @Nullable
    public ColorStateList getProgressBackgroundTintList() {
        return this.mProgressTintInfo != null ? this.mProgressTintInfo.mProgressBackgroundTintList : null;
    }

    public void setProgressBackgroundTintMode(@Nullable PorterDuff.Mode tintMode) {
        if (this.mProgressTintInfo == null) {
            this.mProgressTintInfo = new ProgressTintInfo();
        }
        this.mProgressTintInfo.mProgressBackgroundTintMode = tintMode;
        this.mProgressTintInfo.mHasProgressBackgroundTintMode = true;
        if (this.mProgressDrawable != null) {
            this.applyProgressBackgroundTint();
        }
    }

    @Nullable
    public PorterDuff.Mode getProgressBackgroundTintMode() {
        return this.mProgressTintInfo != null ? this.mProgressTintInfo.mProgressBackgroundTintMode : null;
    }

    @Nullable
    private Drawable getTintTarget(int layerId, boolean shouldFallback) {
        Drawable layer = null;
        Drawable d = this.mProgressDrawable;
        if (d != null) {
            this.mProgressDrawable = d.mutate();
            if (d instanceof LayerDrawable) {
                layer = ((LayerDrawable)d).findDrawableByLayerId(layerId);
            }
            if (shouldFallback && layer == null) {
                layer = d;
            }
        }
        return layer;
    }

    public void setProgressDrawableTiled(Drawable d) {
        if (d != null) {
            d = this.tileify(d, false);
        }
        this.setProgressDrawable(d);
    }

    Drawable getCurrentDrawable() {
        return this.mCurrentDrawable;
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        return who == this.mProgressDrawable || super.verifyDrawable(who);
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.jumpToCurrentState();
        }
    }

    public void postInvalidate() {
        if (!this.mNoInvalidate) {
            super.postInvalidate();
        }
    }

    private synchronized void doRefreshProgress(int id2, int startValue, int endValue, boolean fromUser, boolean callBackToApp, boolean animate) {
        float scale2;
        MLog.info((Object)TAG, (String)"doRefreshProgress(%d, %d, %b, %b)", (Object[])new Object[]{startValue, endValue, fromUser, animate});
        float scale1 = this.mMax > 0 ? (float)startValue / (float)this.mMax : 0.0f;
        float f = scale2 = this.mMax > 0 ? (float)endValue / (float)this.mMax : 0.0f;
        if (animate) {
            MLog.verbose((Object)TAG, (String)"start: %g to %g", (Object[])new Object[]{Float.valueOf(this.mVisualStartProgress), Float.valueOf(scale1)});
            MLog.verbose((Object)TAG, (String)"end: %g to %g", (Object[])new Object[]{Float.valueOf(this.mVisualEndProgress), Float.valueOf(scale2)});
            ValueAnimator a1 = ValueAnimator.ofFloat((float[])new float[]{this.mVisualStartProgress, scale1});
            ValueAnimator a2 = ValueAnimator.ofFloat((float[])new float[]{this.mVisualEndProgress, scale2});
            a2.addUpdateListener(animation -> this.setVisualProgress(16908301, ((Float)a1.getAnimatedValue()).floatValue(), ((Float)a2.getAnimatedValue()).floatValue()));
            AnimatorSet set = new AnimatorSet();
            set.playTogether(new Animator[]{a1, a2});
            set.setDuration(80L);
            set.setInterpolator((TimeInterpolator)PROGRESS_ANIM_INTERPOLATOR);
            set.start();
        } else {
            this.setVisualProgress(id2, scale1, scale2);
        }
        if (callBackToApp) {
            this.onProgressRefresh(fromUser, startValue, endValue);
        }
    }

    public void onProgressRefresh(boolean fromUser, int startValue, int endValue) {
        MLog.debug((Object)TAG, (String)"onProgressRefresh(%d, %d)", (Object[])new Object[]{startValue, endValue});
    }

    private void setVisualProgress(int id2, float progress1, float progress2) {
        MLog.info((Object)TAG, (String)"setVisualProgress(%g, %g)", (Object[])new Object[]{Float.valueOf(progress1), Float.valueOf(progress2)});
        this.mVisualStartProgress = progress1;
        this.mVisualEndProgress = progress2;
        this.invalidate();
        this.onVisualProgressChanged(id2, progress1, progress2);
    }

    public void onVisualProgressChanged(int id2, float scale1, float scale2) {
        MLog.debug((Object)TAG, (String)"onVisualProgressChanged(%g, %g)", (Object[])new Object[]{Float.valueOf(scale1), Float.valueOf(scale2)});
    }

    private synchronized void refreshProgress(int id2, int startValue, int endValue, boolean fromUser, boolean animate) {
        if (this.mUiThreadId == Thread.currentThread().getId()) {
            this.doRefreshProgress(id2, startValue, endValue, fromUser, true, animate);
        } else {
            if (this.mRefreshProgressRunnable == null) {
                this.mRefreshProgressRunnable = new RefreshProgressRunnable();
            }
            RefreshData rd = RefreshData.obtain(id2, startValue, endValue, fromUser, animate);
            this.mRefreshData.add(rd);
            if (this.mAttached && !this.mRefreshIsPosted) {
                this.removeCallbacks(this.mRefreshProgressRunnable);
                this.post(this.mRefreshProgressRunnable);
                this.mRefreshIsPosted = true;
            }
        }
    }

    public synchronized void setProgress(int startValue, int endValue) {
        MLog.info((Object)TAG, (String)"setProgress(%d, %d)", (Object[])new Object[]{startValue, endValue});
        this.setProgressInternal(startValue, endValue, false, false);
    }

    public void setProgress(int startValue, int endValue, boolean animate) {
        this.setProgressInternal(startValue, endValue, false, animate);
    }

    synchronized boolean setProgressInternal(int startValue, int endValue, boolean fromUser, boolean animate) {
        MLog.info((Object)TAG, (String)"setProgressInternal(%d, %d)", (Object[])new Object[]{startValue, endValue});
        startValue = MathUtils.constrain(startValue, 0, MathUtils.constrain(endValue, 0, this.mMax));
        endValue = MathUtils.constrain(endValue, startValue, this.mMax);
        if (startValue == this.mStartProgress && endValue == this.mEndProgress) {
            return false;
        }
        this.mEndProgress = endValue;
        this.mStartProgress = startValue;
        this.refreshProgress(16908301, this.mStartProgress, this.mEndProgress, fromUser, animate);
        return true;
    }

    public void setProgressStartEndBoundaries(int startMax, int endMin) {
        MLog.info((Object)TAG, (String)"setProgressStartEndBoundaries(%d, %d)", (Object[])new Object[]{startMax, endMin});
        if (startMax > endMin) {
            throw new IllegalArgumentException("startMax cannot be greater than endMin");
        }
        if (startMax > this.mMax) {
            throw new IllegalArgumentException("startMax cannot be greater max value");
        }
        if (startMax != -1 || endMin != -1) {
            this.mMinMaxStepSize = 0;
        }
        this.mProgressStartMaxValue = startMax;
        this.mProgressEndMinValue = endMin;
    }

    public void setMinMaxStepSize(int value) {
        MLog.info((Object)TAG, (String)"setMinMaxStepSize(%d)", (Object[])new Object[]{value});
        if (value > this.mMax) {
            throw new IllegalArgumentException("value cannot be greater than max value");
        }
        if (value != 0) {
            this.mProgressEndMinValue = -1;
            this.mProgressStartMaxValue = -1;
        }
        this.mMinMaxStepSize = value;
    }

    public int getProgressStartMaxValue() {
        if (this.mProgressStartMaxValue != -1) {
            return this.mProgressStartMaxValue;
        }
        return this.getProgressEnd() - this.mMinMaxStepSize;
    }

    public int getProgressEndMinValue() {
        if (this.mProgressEndMinValue != -1) {
            return this.mProgressEndMinValue;
        }
        return this.getProgressStart() + this.mMinMaxStepSize;
    }

    public int getProgressEnd() {
        return this.mEndProgress;
    }

    public int getProgressStart() {
        return this.mStartProgress;
    }

    public synchronized int getMax() {
        return this.mMax;
    }

    public synchronized void setMax(int max) {
        MLog.info((Object)TAG, (String)"setMax(%d)", (Object[])new Object[]{max});
        if (max < 0) {
            max = 0;
        }
        if (max != this.mMax) {
            this.mMax = max;
            this.postInvalidate();
            if (this.mEndProgress > max) {
                this.mEndProgress = max;
            }
            this.refreshProgress(16908301, this.mStartProgress, this.mEndProgress, false, false);
        }
    }

    public final synchronized void incrementEndValueBy(int diff) {
        this.setProgress(this.mStartProgress, this.mEndProgress + diff);
    }

    public void setInterpolator(Context context, @InterpolatorRes int resID) {
        this.setInterpolator(AnimationUtils.loadInterpolator((Context)context, (int)resID));
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void onVisibilityAggregated(boolean isVisible) {
        super.onVisibilityAggregated(isVisible);
        if (isVisible != this.mAggregatedIsVisible) {
            this.mAggregatedIsVisible = isVisible;
            if (this.mCurrentDrawable != null) {
                this.mCurrentDrawable.setVisible(isVisible, false);
            }
        }
    }

    public void invalidateDrawable(@NonNull Drawable dr) {
        if (!this.mInDrawing) {
            if (this.verifyDrawable(dr)) {
                Rect dirty = dr.getBounds();
                int scrollX = this.getScrollX() + this.getPaddingLeft();
                int scrollY = this.getScrollY() + this.getPaddingTop();
                this.invalidate(dirty.left + scrollX, dirty.top + scrollY, dirty.right + scrollX, dirty.bottom + scrollY);
            } else {
                super.invalidateDrawable(dr);
            }
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.updateDrawableBounds(w, h);
    }

    private void updateDrawableBounds(int w, int h) {
        this.mPaddingLeft = this.getPaddingLeft();
        this.mPaddingRight = this.getPaddingRight();
        this.mPaddingTop = this.getPaddingTop();
        this.mPaddingBottom = this.getPaddingBottom();
        int right = w -= this.mPaddingRight + this.mPaddingLeft;
        int bottom = h -= this.mPaddingTop + this.mPaddingBottom;
        int top = 0;
        int left = 0;
        this.mProgressDrawableIndicator = null;
        this.mProgressIndicatorBounds = null;
        this.mComputedWidth = w;
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.setBounds(left, top, right, bottom);
            this.mProgressDrawableIndicator = ((LayerDrawable)this.mProgressDrawable).findDrawableByLayerId(16908301);
            this.mProgressIndicatorBounds = this.mProgressDrawableIndicator.getBounds();
        }
    }

    protected synchronized void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawTrack(canvas);
    }

    protected boolean isLayoutRtl() {
        return this.getLayoutDirection() == 1;
    }

    void drawTrack(Canvas canvas) {
        Drawable d = this.mProgressDrawable;
        if (d != null) {
            int saveCount = canvas.save();
            if (this.isLayoutRtl() && this.mMirrorForRtl) {
                canvas.translate((float)(this.getWidth() - this.mPaddingRight), (float)this.mPaddingTop);
                canvas.scale(-1.0f, 1.0f);
            } else {
                canvas.translate((float)this.mPaddingLeft, (float)this.mPaddingTop);
            }
            if (null != this.mProgressIndicatorBounds) {
                int w = this.mComputedWidth - this.mProgressOffset;
                int start = (int)(this.mVisualStartProgress * (float)w);
                int end = (int)(this.mVisualEndProgress * (float)w);
                this.mProgressDrawableIndicator.setBounds(start, this.mProgressIndicatorBounds.top, this.mProgressOffset + end, this.mProgressIndicatorBounds.bottom);
            }
            d.draw(canvas);
            canvas.restoreToCount(saveCount);
        }
    }

    public int getProgressOffset() {
        return this.mProgressOffset;
    }

    public void setProgressOffset(int value) {
        MLog.info((Object)TAG, (String)"setProgressOffset(%d)", (Object[])new Object[]{value});
        this.mProgressOffset = value;
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int dw = 0;
        int dh = 0;
        Drawable d = this.mCurrentDrawable;
        if (d != null) {
            dw = Math.max(this.mMinWidth, Math.min(this.mMaxWidth, d.getIntrinsicWidth()));
            dh = Math.max(this.mMinHeight, Math.min(this.mMaxHeight, d.getIntrinsicHeight()));
        }
        this.updateDrawableState();
        int measuredWidth = RangeProgressBar.resolveSizeAndState((int)(dw += this.getPaddingLeft() + this.getPaddingRight()), (int)widthMeasureSpec, (int)0);
        int measuredHeight = RangeProgressBar.resolveSizeAndState((int)(dh += this.getPaddingTop() + this.getPaddingBottom()), (int)heightMeasureSpec, (int)0);
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.updateDrawableState();
    }

    private void updateDrawableState() {
        int[] state = this.getDrawableState();
        boolean changed = false;
        Drawable progressDrawable = this.mProgressDrawable;
        if (progressDrawable != null && progressDrawable.isStateful()) {
            changed = progressDrawable.setState(state);
        }
        if (changed) {
            this.invalidate();
        }
    }

    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mProgressDrawable != null) {
            MLog.verbose((Object)TAG, (String)"setHotspot(%.2f, %.2f)", (Object[])new Object[]{Float.valueOf(x), Float.valueOf(y)});
            DrawableCompat.setHotspot((Drawable)this.mProgressDrawable, (float)x, (float)y);
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.startValue = this.mStartProgress;
        ss.endValue = this.mEndProgress;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setProgress(ss.startValue, ss.endValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        RangeProgressBar rangeProgressBar = this;
        synchronized (rangeProgressBar) {
            int count = this.mRefreshData.size();
            for (int i = 0; i < count; ++i) {
                RefreshData rd = this.mRefreshData.get(i);
                this.doRefreshProgress(rd.id, rd.startValue, rd.endValue, rd.fromUser, true, rd.animate);
                rd.recycle();
            }
            this.mRefreshData.clear();
        }
        this.mAttached = true;
    }

    protected void onDetachedFromWindow() {
        if (this.mRefreshProgressRunnable != null) {
            this.removeCallbacks(this.mRefreshProgressRunnable);
            this.mRefreshIsPosted = false;
        }
        if (this.mAccessibilityEventSender != null) {
            this.removeCallbacks(this.mAccessibilityEventSender);
        }
        super.onDetachedFromWindow();
        this.mAttached = false;
    }

    public CharSequence getAccessibilityClassName() {
        return RangeProgressBar.class.getName();
    }

    private static class ProgressTintInfo {
        ColorStateList mProgressTintList;
        PorterDuff.Mode mProgressTintMode;
        boolean mHasProgressTint;
        boolean mHasProgressTintMode;
        ColorStateList mProgressBackgroundTintList;
        PorterDuff.Mode mProgressBackgroundTintMode;
        boolean mHasProgressBackgroundTint;
        boolean mHasProgressBackgroundTintMode;

        private ProgressTintInfo() {
        }
    }

    private class AccessibilityEventSender
    implements Runnable {
        private AccessibilityEventSender() {
        }

        @Override
        public void run() {
            RangeProgressBar.this.sendAccessibilityEvent(4);
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        int startValue;
        int endValue;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.startValue = in.readInt();
            this.endValue = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.startValue);
            out.writeInt(this.endValue);
        }
    }

    private static class RefreshData {
        private static final int POOL_MAX = 24;
        private static final Pools.SynchronizedPool<RefreshData> sPool = new Pools.SynchronizedPool(24);
        public int id;
        public int startValue;
        public int endValue;
        public boolean fromUser;
        public boolean animate;

        private RefreshData() {
        }

        public static RefreshData obtain(int id2, int startValue, int endValue, boolean fromUser, boolean animate) {
            RefreshData rd = (RefreshData)sPool.acquire();
            if (rd == null) {
                rd = new RefreshData();
            }
            rd.id = id2;
            rd.startValue = startValue;
            rd.endValue = endValue;
            rd.fromUser = fromUser;
            rd.animate = animate;
            return rd;
        }

        public void recycle() {
            sPool.release((Object)this);
        }
    }

    private class RefreshProgressRunnable
    implements Runnable {
        private RefreshProgressRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RangeProgressBar rangeProgressBar = RangeProgressBar.this;
            synchronized (rangeProgressBar) {
                int count = RangeProgressBar.this.mRefreshData.size();
                for (int i = 0; i < count; ++i) {
                    RefreshData rd = (RefreshData)RangeProgressBar.this.mRefreshData.get(i);
                    RangeProgressBar.this.doRefreshProgress(rd.id, rd.startValue, rd.endValue, rd.fromUser, true, rd.animate);
                    rd.recycle();
                }
                RangeProgressBar.this.mRefreshData.clear();
                RangeProgressBar.this.mRefreshIsPosted = false;
            }
        }
    }
}

