/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.rangebar;

import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.graphics.drawable.DrawableWrapper;
import android.graphics.drawable.ScaleDrawable;
import android.os.Build;
import androidx.annotation.NonNull;
import com.yy.appbase.ui.widget.rangebar.ThemeUtils;
import java.util.Objects;

public class DrawableUtils {
    private static final String VECTOR_DRAWABLE_CLAZZ_NAME = "android.graphics.drawable.VectorDrawable";

    private DrawableUtils() {
    }

    public static PorterDuff.Mode parseTintMode(int value, PorterDuff.Mode defaultMode) {
        switch (value) {
            case 3: {
                return PorterDuff.Mode.SRC_OVER;
            }
            case 5: {
                return PorterDuff.Mode.SRC_IN;
            }
            case 9: {
                return PorterDuff.Mode.SRC_ATOP;
            }
            case 14: {
                return PorterDuff.Mode.MULTIPLY;
            }
            case 15: {
                return PorterDuff.Mode.SCREEN;
            }
            case 16: {
                return PorterDuff.Mode.ADD;
            }
        }
        return defaultMode;
    }

    static void fixDrawable(@NonNull Drawable drawable2) {
        if (Build.VERSION.SDK_INT == 21 && VECTOR_DRAWABLE_CLAZZ_NAME.equals(drawable2.getClass().getName())) {
            DrawableUtils.fixVectorDrawableTinting(drawable2);
        }
    }

    private static void fixVectorDrawableTinting(Drawable drawable2) {
        int[] originalState = drawable2.getState();
        if (originalState == null || originalState.length == 0) {
            drawable2.setState(ThemeUtils.CHECKED_STATE_SET);
        } else {
            drawable2.setState(ThemeUtils.EMPTY_STATE_SET);
        }
        drawable2.setState(originalState);
    }

    public static boolean canSafelyMutateDrawable(@NonNull Drawable drawable2) {
        if (drawable2 instanceof DrawableContainer) {
            Drawable.ConstantState state = drawable2.getConstantState();
            if (state instanceof DrawableContainer.DrawableContainerState) {
                DrawableContainer.DrawableContainerState containerState = (DrawableContainer.DrawableContainerState)state;
                for (Drawable child : containerState.getChildren()) {
                    if (DrawableUtils.canSafelyMutateDrawable(child)) continue;
                    return false;
                }
            }
        } else {
            if (drawable2 instanceof ScaleDrawable) {
                return DrawableUtils.canSafelyMutateDrawable(Objects.requireNonNull(((ScaleDrawable)drawable2).getDrawable()));
            }
            if (drawable2 instanceof DrawableWrapper) {
                return DrawableUtils.canSafelyMutateDrawable(Objects.requireNonNull(((DrawableWrapper)drawable2).getDrawable()));
            }
        }
        return true;
    }
}

