/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.indicator;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import com.yy.appbase.R;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.ResolutionUtils;
import java.util.ArrayList;
import java.util.List;

public class CircleIndicatorView
extends YYView {
    private static final int DEFAULT_COLOR = -2565928;
    private static final int DEFAULT_SELECT_COLOR = -16126;
    private static final int DEFAULT_COUNT = 4;
    private static final float DEFAULT_RADIUS = ResolutionUtils.dip2Px((float)3.0f);
    private static final float DEFAULT_DISTANCE = ResolutionUtils.dip2Px((float)3.0f);
    private float radius = DEFAULT_RADIUS;
    private float distance = DEFAULT_DISTANCE;
    private int defaultColor = -2565928;
    private int defaultSelectColor = -16126;
    private int count = 4;
    private int position;
    private List<Circle> indicatorList;
    private Paint mPaint;

    public CircleIndicatorView(Context context) {
        this(context, null);
    }

    public CircleIndicatorView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleIndicatorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.CircleIndicatorView);
        this.radius = attributes.getDimension(R.styleable.CircleIndicatorView_indicatorRadius, DEFAULT_RADIUS);
        this.distance = attributes.getDimension(R.styleable.CircleIndicatorView_indicatorDistance, DEFAULT_DISTANCE);
        this.defaultColor = attributes.getColor(R.styleable.CircleIndicatorView_indicatorColor, this.defaultColor);
        this.defaultSelectColor = attributes.getColor(R.styleable.CircleIndicatorView_indicatorSelectColor, this.defaultSelectColor);
        attributes.recycle();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.indicatorList = new ArrayList<Circle>();
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = (int)(this.radius * (float)this.count * 2.0f + this.distance * (float)(this.count - 1));
        int height = (int)this.radius * 2;
        this.setMeasuredDimension(width, height);
        this.indicatorList.clear();
        float x = 0.0f;
        for (int i = 0; i < this.count; ++i) {
            Circle circle = new Circle();
            x = i == 0 ? this.radius : (x += this.radius * 2.0f + this.distance);
            circle.x = x;
            circle.y = this.getMeasuredHeight() / 2;
            this.indicatorList.add(circle);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (int i = 0; i < this.indicatorList.size(); ++i) {
            Circle circle = this.indicatorList.get(i);
            float x = circle.x;
            float y = circle.y;
            if (this.position == i) {
                this.mPaint.setColor(this.defaultSelectColor);
            } else {
                this.mPaint.setColor(this.defaultColor);
            }
            canvas.drawCircle(x, y, this.radius, this.mPaint);
        }
    }

    public void setCount(int count) {
        this.count = count;
        this.invalidate();
    }

    public int getCount() {
        return this.count;
    }

    public void setPosition(int position) {
        this.position = position;
        this.requestLayout();
    }

    private static class Circle {
        private float x;
        private float y;

        private Circle() {
        }
    }
}

