/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.headframe;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.opensource.svgaplayer.hago.SVGADrawable;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.opensource.svgaplayer.hago.SVGAVideoEntity;
import com.yy.appbase.R;
import com.yy.appbase.ui.widget.headframe.StepSvgaImageView;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;

public class HeadFrameImageView
extends YYFrameLayout {
    private Context mContext;
    private CircleImageView mHeadImage;
    private StepSvgaImageView mFrame;
    private FrameLayout mFlContainer;
    private View mLeaveView;
    private boolean useParentSize = false;
    public static final int DEFAULT_BORDER_WIDTH = 0;
    public static final int DEFAULT_BORDER_COLOR = -1;
    public static final int DEFAULT_FRAME_WIDTH_WIDTH_HEIGHT = 220;
    public static final int DEFAULT_CIRCLEIMAGEVIEW_WIDTH_HEIGHT = 170;
    private float mScale = 0.0f;
    public int mBorderColor = -1;
    public int mBorderWidth = 0;
    public int mCircleImageViewWidthHegiht;
    public int mCircleImageViewFixWidthHeight;
    public boolean mIsMaxSize;
    private long mUid = 0L;
    private int mFrameGoneOrInvisible = 8;

    public HeadFrameImageView(Context context) {
        this(context, null);
    }

    public HeadFrameImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HeadFrameImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mContext = context;
        this.initAttrs(attrs, defStyle);
        this.initLayout();
        if (this.mScale == 0.0f) {
            this.resetImageLayoutParams();
        } else {
            this.resetImageLayoutParamsWithScale(this.mScale);
        }
    }

    public void initLayout() {
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_head_frame_imageview, (ViewGroup)this, true);
        this.mFrame = (StepSvgaImageView)this.findViewById(R.id.riv_frame);
        if (this.mFrame != null) {
            this.mFrame.setVisibility(this.mFrameGoneOrInvisible);
        }
        this.mFlContainer = (FrameLayout)this.findViewById(R.id.fl_container);
        this.mHeadImage = new CircleImageView(this.getContext());
        this.mHeadImage.setBorderColor(this.mBorderColor);
        this.mHeadImage.setBorderWidth(this.mBorderWidth);
        this.addViewFrameInside((View)this.mHeadImage);
    }

    public void initAttrs(AttributeSet attrs, int defStyle) {
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.HeadFrameImageView, defStyle, 0);
        this.mBorderWidth = a.getDimensionPixelSize(R.styleable.HeadFrameImageView_circleimageview_border_width, 0);
        this.mCircleImageViewWidthHegiht = a.getDimensionPixelSize(R.styleable.HeadFrameImageView_circleimageview_layout_width_height, 170);
        this.mCircleImageViewFixWidthHeight = a.getDimensionPixelSize(R.styleable.HeadFrameImageView_circleimageview_fix_width_height, -1);
        this.mBorderColor = a.getColor(R.styleable.HeadFrameImageView_circleimageview_border_color, -1);
        this.mIsMaxSize = a.getBoolean(R.styleable.HeadFrameImageView_is_max_size, false);
        this.useParentSize = a.getBoolean(R.styleable.HeadFrameImageView_use_parent_size, false);
        this.mScale = a.getFloat(R.styleable.HeadFrameImageView_scale, 0.0f);
        a.recycle();
    }

    public void setFrameWidthAndHeight(int widthAndHeight, int mBorderWidth) {
        this.mBorderWidth = mBorderWidth;
        this.mHeadImage.setBorderWidth(mBorderWidth);
        this.mCircleImageViewWidthHegiht = widthAndHeight;
        this.resetImageLayoutParams();
        this.invalidate();
    }

    public void setFrameWidthAndHeight(int widthAndHeight) {
        this.mCircleImageViewWidthHegiht = widthAndHeight;
        this.resetImageLayoutParams();
        this.invalidate();
    }

    public void resetImageLayoutParams() {
        if (this.mFrame.getVisibility() == 8) {
            ViewGroup.LayoutParams civLayoutParams = this.mFlContainer.getLayoutParams();
            if (this.mCircleImageViewFixWidthHeight > 0) {
                civLayoutParams.width = this.mCircleImageViewFixWidthHeight;
                civLayoutParams.height = this.mCircleImageViewFixWidthHeight;
            } else {
                civLayoutParams.width = this.mCircleImageViewWidthHegiht;
                civLayoutParams.height = this.mCircleImageViewWidthHegiht;
            }
            this.mFlContainer.setLayoutParams(civLayoutParams);
        } else {
            this.fillLayoutParams();
        }
    }

    public void resetImageLayoutParamsWithScale(float scale) {
        ViewGroup.LayoutParams frameLayoutParams = this.mFrame.getLayoutParams();
        frameLayoutParams.width = this.mCircleImageViewWidthHegiht;
        frameLayoutParams.height = this.mCircleImageViewWidthHegiht;
        this.mFrame.setLayoutParams(frameLayoutParams);
        this.mFrame.setVisibility(4);
        ViewGroup.LayoutParams civLayoutParams = this.mFlContainer.getLayoutParams();
        civLayoutParams.width = (int)((float)this.mCircleImageViewWidthHegiht * scale);
        civLayoutParams.height = (int)((float)this.mCircleImageViewWidthHegiht * scale);
        this.mFlContainer.setLayoutParams(civLayoutParams);
    }

    public void resetImageLayoutParams(float scale) {
        ViewGroup.LayoutParams frameLayoutParams = this.mFrame.getLayoutParams();
        frameLayoutParams.width = this.mCircleImageViewWidthHegiht;
        frameLayoutParams.height = this.mCircleImageViewWidthHegiht;
        this.mFrame.setLayoutParams(frameLayoutParams);
        ViewGroup.LayoutParams civLayoutParams = this.mFlContainer.getLayoutParams();
        civLayoutParams.width = (int)((float)this.mCircleImageViewWidthHegiht * scale);
        civLayoutParams.height = (int)((float)this.mCircleImageViewWidthHegiht * scale);
        this.mFlContainer.setLayoutParams(civLayoutParams);
    }

    private void fillLayoutParams() {
        if (!this.mIsMaxSize) {
            ViewGroup.LayoutParams civLayoutParams = this.mFlContainer.getLayoutParams();
            civLayoutParams.width = this.mCircleImageViewWidthHegiht;
            civLayoutParams.height = this.mCircleImageViewWidthHegiht;
            this.mFlContainer.setLayoutParams(civLayoutParams);
            ViewGroup.LayoutParams frameLayoutParams = this.mFrame.getLayoutParams();
            frameLayoutParams.width = this.mCircleImageViewWidthHegiht * 220 / 170;
            frameLayoutParams.height = this.mCircleImageViewWidthHegiht * 220 / 170;
            this.mFrame.setLayoutParams(frameLayoutParams);
        } else {
            ViewGroup.LayoutParams frameLayoutParams = this.mFrame.getLayoutParams();
            frameLayoutParams.width = this.mCircleImageViewWidthHegiht;
            frameLayoutParams.height = this.mCircleImageViewWidthHegiht;
            this.mFrame.setLayoutParams(frameLayoutParams);
            ViewGroup.LayoutParams civLayoutParams = this.mFlContainer.getLayoutParams();
            civLayoutParams.width = this.mCircleImageViewWidthHegiht * 170 / 220;
            civLayoutParams.height = this.mCircleImageViewWidthHegiht * 170 / 220;
            this.mFlContainer.setLayoutParams(civLayoutParams);
        }
    }

    public CircleImageView getCircleImageView() {
        return this.mHeadImage;
    }

    public boolean hasHeadFrameShow() {
        if (this.mFrame == null) {
            return false;
        }
        return this.mFrame.getVisibility() == 0;
    }

    public void setHeadFrame(String headFrameUrl) {
        this.setHeadFrame(headFrameUrl, null);
    }

    public StepSvgaImageView getFrameSvga() {
        return this.mFrame;
    }

    public void setHeadFrame(String headFrameUrl, final float scale) {
        if (RuntimeContext.sIsDebuggable) {
            FeatureLog.i((String)"FTHeadFrame", (String)"setHeadFrame:%s", (Object[])new Object[]{headFrameUrl});
        }
        if (!FP.empty((CharSequence)headFrameUrl) && YYImageUtils.canAppendResize((String)headFrameUrl)) {
            headFrameUrl = headFrameUrl + YYImageUtils.getThumbSmall();
        }
        final String finalHeadFrameUrl = headFrameUrl;
        Runnable command = new Runnable(){

            @Override
            public void run() {
                if (TextUtils.isEmpty((CharSequence)finalHeadFrameUrl)) {
                    HeadFrameImageView.this.mHeadImage.setBorderWidth(HeadFrameImageView.this.mBorderWidth);
                    HeadFrameImageView.this.mFrame.setImageDrawable(null);
                    HeadFrameImageView.this.resetImageLayoutParamsWithScale(scale);
                } else {
                    HeadFrameImageView.this.mFrame.setVisibility(0);
                    SvgaLoader.load((SVGAImageView)HeadFrameImageView.this.mFrame, (String)finalHeadFrameUrl, (ISvgaLoadCallback)new ISvgaLoadCallback(){

                        public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                            HeadFrameImageView.this.mFrame.setVisibility(0);
                            HeadFrameImageView.this.mHeadImage.setBorderWidth(0);
                            HeadFrameImageView.this.mFrame.setTag(finalHeadFrameUrl);
                            HeadFrameImageView.this.resetImageLayoutParams();
                            HeadFrameImageView.this.mFrame.startAnimation();
                            if (svgaVideoEntity != null) {
                                SVGADrawable svgaDrawable = new SVGADrawable(svgaVideoEntity);
                                HeadFrameImageView.this.mFrame.setSVGADrawable(svgaDrawable);
                            } else {
                                HeadFrameImageView.this.mFrame.setSVGADrawable(null);
                            }
                        }

                        public void onFailed(Exception e) {
                            MLog.error((Object)"HeadFrameImageView load svga failed:%s", (String)e.toString(), (Object[])new Object[0]);
                            HeadFrameImageView.this.mFrame.setVisibility(HeadFrameImageView.this.mFrameGoneOrInvisible);
                            HeadFrameImageView.this.mHeadImage.setBorderWidth(HeadFrameImageView.this.mBorderWidth);
                            HeadFrameImageView.this.resetImageLayoutParamsWithScale(scale);
                            HeadFrameImageView.this.mFrame.stopAnimation();
                        }
                    });
                }
            }
        };
        if (YYTaskExecutor.isMainThread()) {
            command.run();
        } else {
            YYTaskExecutor.postToMainThread((Runnable)command);
        }
    }

    public void setFrameGoneOrInvisible(int goneOrInvisible) {
        this.mFrameGoneOrInvisible = goneOrInvisible;
    }

    public void setHeadFrame(String headFrameUrl, final ImageLoader.ImageLoadListener listener2) {
        if (!FP.empty((CharSequence)headFrameUrl) && YYImageUtils.canAppendResize((String)headFrameUrl)) {
            headFrameUrl = headFrameUrl + YYImageUtils.getThumbSmall();
        }
        final String finalHeadFrameUrl = headFrameUrl;
        this.executeOnUi(() -> {
            if (TextUtils.isEmpty((CharSequence)finalHeadFrameUrl)) {
                this.mFrame.setVisibility(this.mFrameGoneOrInvisible);
                this.mHeadImage.setBorderWidth(this.mBorderWidth);
                this.resetImageLayoutParams();
                if (listener2 != null) {
                    listener2.onResourceReady(null, false, null);
                }
            } else {
                this.mFrame.setVisibility(0);
                SvgaLoader.load((SVGAImageView)this.mFrame, (String)finalHeadFrameUrl, (ISvgaLoadCallback)new ISvgaLoadCallback(){

                    public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                        HeadFrameImageView.this.mFrame.setVisibility(0);
                        HeadFrameImageView.this.mHeadImage.setBorderWidth(0);
                        HeadFrameImageView.this.resetImageLayoutParams();
                        if (listener2 != null) {
                            listener2.onResourceReady(null, false, null);
                        }
                        HeadFrameImageView.this.mFrame.startAnimation();
                        if (svgaVideoEntity != null) {
                            SVGADrawable svgaDrawable = new SVGADrawable(svgaVideoEntity);
                            HeadFrameImageView.this.mFrame.setSVGADrawable(svgaDrawable);
                        } else {
                            HeadFrameImageView.this.mFrame.setSVGADrawable(null);
                        }
                    }

                    public void onFailed(Exception e) {
                        MLog.error((Object)"HeadFrameImageView load svga failed:%s, url:%s", (String)e.toString(), (Object[])new Object[]{finalHeadFrameUrl});
                        HeadFrameImageView.this.mFrame.setVisibility(HeadFrameImageView.this.mFrameGoneOrInvisible);
                        HeadFrameImageView.this.mHeadImage.setBorderWidth(HeadFrameImageView.this.mBorderWidth);
                        HeadFrameImageView.this.resetImageLayoutParams();
                        if (listener2 != null) {
                            listener2.onLoadFailed(e);
                        }
                        HeadFrameImageView.this.mFrame.stopAnimation();
                    }
                });
            }
        });
    }

    public long getUid() {
        return this.mUid;
    }

    public void setUid(long uid) {
        this.mUid = uid;
    }

    public void addViewFrameInside(View view) {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        layoutParams.gravity = 17;
        this.mFlContainer.addView(view, (ViewGroup.LayoutParams)layoutParams);
    }

    public void setLeaveViewVisibility(boolean show2) {
        if (!show2 && this.mLeaveView == null) {
            return;
        }
        if (this.mLeaveView == null) {
            this.mLeaveView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_leave_view, null);
            this.addViewFrameInside(this.mLeaveView);
        }
        this.mLeaveView.setVisibility(show2 ? 0 : 8);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.useParentSize) {
            this.mCircleImageViewWidthHegiht = View.MeasureSpec.getSize((int)widthMeasureSpec);
            if (this.mScale == 0.0f) {
                this.resetImageLayoutParams();
            } else {
                this.resetImageLayoutParams(this.mScale);
            }
        }
    }

    public void setMaxSize(boolean isMaxSize) {
        this.mIsMaxSize = isMaxSize;
    }

    public void setUseParentSize(boolean useParentSize) {
        this.useParentSize = useParentSize;
    }

    public void setBorderColor(int resource) {
        if (resource <= 0) {
            return;
        }
        this.mBorderColor = resource;
        if (this.mHeadImage != null) {
            this.mHeadImage.setBorderColor(this.mBorderColor);
        }
    }

    private void executeOnUi(Runnable runnable) {
        if (YYTaskExecutor.isMainThread()) {
            runnable.run();
        } else {
            YYTaskExecutor.postToMainThread((Runnable)runnable);
        }
    }
}

