/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.gallery;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import java.util.ArrayList;
import java.util.List;

public abstract class AdAdapter<T>
extends BaseAdapter {
    protected List<T> mData = new ArrayList<T>();
    protected Context mContext;

    public AdAdapter(Context context) {
        this.mContext = context;
    }

    private void updateData(List<T> data2, boolean clear) {
        if (data2 == null || data2.size() == 0) {
            return;
        }
        if (clear) {
            this.mData.clear();
        }
        this.mData.addAll(data2);
        this.notifyDataSetChanged();
    }

    public void setData(List<T> data2) {
        this.updateData(data2, true);
    }

    public void addData(List<T> data2) {
        this.updateData(data2, false);
    }

    public List<T> getData() {
        return this.mData;
    }

    public int getCount() {
        return this.mData.size();
    }

    public T getItem(int position) {
        if (this.mData.size() == 0) {
            return null;
        }
        return this.mData.get(position % this.mData.size());
    }

    public long getItemId(int position) {
        return position;
    }

    public abstract View getView(int var1, View var2, ViewGroup var3);
}

