/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.edit;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import com.yy.base.memoryrecycle.views.YYEditText;

public class UdbEditText
extends YYEditText {
    View mBindCleanButton;
    int mBindResId = Integer.MIN_VALUE;

    public UdbEditText(Context context) {
        super(context);
    }

    public UdbEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public UdbEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        this.updateCleanButtonState();
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        if (this.mBindCleanButton != null) {
            this.mBindCleanButton.setVisibility(this.getText().toString().length() > 0 ? 0 : 4);
        }
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
    }

    public void bindCleanButton(View v) {
        if (v != null) {
            this.mBindCleanButton = v;
            this.mBindResId = Integer.MIN_VALUE;
            v.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    UdbEditText.this.setText("");
                    UdbEditText.this.requestFocus();
                }
            });
            this.updateCleanButtonState();
        }
    }

    public void bindCleanButton(int resId) {
        this.mBindResId = resId;
        this.mBindCleanButton = null;
        this.updateCleanButtonState();
    }

    private void updateCleanButtonState() {
        if (this.mBindCleanButton == null && this.mBindResId == Integer.MIN_VALUE) {
            return;
        }
        if (this.mBindCleanButton == null && this.mBindResId != Integer.MIN_VALUE) {
            this.mBindCleanButton = this.getRootView().findViewById(this.mBindResId);
            if (this.mBindCleanButton != null) {
                this.mBindCleanButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        UdbEditText.this.setText("");
                        UdbEditText.this.requestFocus();
                    }
                });
            } else {
                this.mBindResId = Integer.MIN_VALUE;
            }
        }
        if (this.mBindCleanButton != null) {
            this.mBindCleanButton.setVisibility(this.isFocused() && this.getText().toString().length() > 0 ? 0 : 4);
        }
    }
}

