/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.bubble;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Point;
import android.os.Build;
import android.util.Log;
import android.view.Display;
import android.view.View;

class Utils {
    private static final String TAG = "Utils";

    Utils() {
    }

    public static float bound(float min, float val, float max) {
        return Math.min(Math.max(val, min), max);
    }

    public static int getNavigationBarHeight(View view) {
        Activity activity = Utils.getActivity(view);
        if (activity != null) {
            Display display = activity.getWindowManager().getDefaultDisplay();
            Point size = new Point();
            display.getSize(size);
            int usableHeight = size.y;
            if (Build.VERSION.SDK_INT >= 17) {
                display.getRealSize(size);
            } else {
                try {
                    size.x = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
                    size.y = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
                }
                catch (Exception e) {
                    Log.w((String)TAG, (String)"getNavigationBarHeight: error", (Throwable)e);
                }
            }
            int realHeight = size.y;
            return realHeight > usableHeight ? realHeight - usableHeight : 0;
        }
        return 0;
    }

    private static Activity getActivity(View view) {
        Context context = view.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }
}

