/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.bubble;

import android.annotation.SuppressLint;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import android.widget.PopupWindow;
import com.yy.appbase.R;
import com.yy.appbase.ui.widget.bubble.BubbleStyle;
import com.yy.appbase.ui.widget.bubble.RelativePos;
import com.yy.appbase.ui.widget.bubble.Utils;
import com.yy.base.utils.ResolutionUtils;

@SuppressLint(value={"RtlHardcoded"})
public class BubblePopupWindow
extends PopupWindow {
    private static final String TAG = "BubblePopupWindow";
    private int mPadding = ResolutionUtils.dip2Px((float)2.0f);
    private int mArrowPosDelta = 0;
    private BubbleStyle mBubbleView;
    private long mDelayMillis = 0L;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private Runnable mDismissRunnable = new Runnable(){

        @Override
        public void run() {
            BubblePopupWindow.this.dismiss();
        }
    };

    public BubblePopupWindow(View contentView, BubbleStyle bubbleView) {
        super(contentView, -2, -2);
        if (bubbleView == null) {
            throw new NullPointerException("Bubble can not be null");
        }
        this.mBubbleView = bubbleView;
        this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.setCancelOnTouchOutside(true);
        this.setCancelOnTouch(true);
    }

    public void dismiss() {
        this.mHandler.removeCallbacks(this.mDismissRunnable);
        super.dismiss();
    }

    public void setCancelOnTouch(boolean cancel) {
        this.getContentView().setOnClickListener(cancel ? new View.OnClickListener(){

            public void onClick(View v) {
                BubblePopupWindow.this.dismiss();
            }
        } : null);
    }

    public void setCancelOnTouchOutside(boolean cancel) {
        this.setOutsideTouchable(cancel);
        this.setFocusable(cancel);
    }

    public void setCancelOnLater(long delayMillis) {
        this.mHandler.removeCallbacks(this.mDismissRunnable);
        this.mDelayMillis = delayMillis;
        if (delayMillis > 0L) {
            this.mHandler.postDelayed(this.mDismissRunnable, delayMillis);
        }
    }

    public void setPadding(int padding) {
        this.mPadding = padding;
    }

    public void setArrowPosDelta(int arrowPosDelta) {
        this.mArrowPosDelta = arrowPosDelta;
    }

    public void showArrowTo(View anchor, BubbleStyle.ArrowDirection direction) {
        this.showArrowTo(anchor, direction, 0);
    }

    public void showArrowTo(View anchor, BubbleStyle.ArrowDirection direction, int margin) {
        RelativePos relativePos;
        switch (direction) {
            case Up: {
                relativePos = new RelativePos(0, 2);
                break;
            }
            case Down: {
                relativePos = new RelativePos(0, 1);
                break;
            }
            case Left: {
                relativePos = new RelativePos(2, 0);
                break;
            }
            case Right: {
                relativePos = new RelativePos(1, 0);
                break;
            }
            default: {
                relativePos = new RelativePos(0, 0);
            }
        }
        this.showArrowTo(anchor, relativePos, margin, margin);
    }

    public void showArrowTo(View anchor, RelativePos relativePos, int marginH, int marginV) {
        this.dismiss();
        int screenWidth = Resources.getSystem().getDisplayMetrics().widthPixels;
        int screenHeight = Resources.getSystem().getDisplayMetrics().heightPixels;
        int navigationBarHeight = BubblePopupWindow.getNavigationBarHeightDelta(anchor);
        Rect anchorRect = BubblePopupWindow.getRectInWindow(anchor);
        this.getContentView().measure(View.MeasureSpec.makeMeasureSpec((int)(screenWidth - 2 * this.mPadding), (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)(screenHeight - 2 * this.mPadding), (int)Integer.MIN_VALUE));
        int contentWidth = this.getContentView().getMeasuredWidth();
        int contentHeight = this.getContentView().getMeasuredHeight();
        Log.d((String)TAG, (String)String.format("w:%d, h:%d", contentWidth, contentHeight));
        PopupProp outProp = new PopupProp();
        BubblePopupWindow.getPopupProp(screenWidth, screenHeight, navigationBarHeight, anchorRect, contentWidth, contentHeight, relativePos, marginH, marginV, this.mPadding, outProp);
        this.setWidth(-2);
        this.setHeight(-2);
        this.setAnimationStyle(outProp.animationStyle);
        if (contentWidth > outProp.maxWidth) {
            this.setWidth(outProp.maxWidth);
        }
        this.mBubbleView.setArrowDirection(outProp.direction);
        this.mBubbleView.setArrowPosPolicy(outProp.arrowPosPolicy);
        this.mBubbleView.setArrowTo(anchor);
        this.mBubbleView.setArrowPosDelta(this.mArrowPosDelta);
        this.showAtLocation(anchor, outProp.gravity, outProp.x, outProp.y);
        if (this.mDelayMillis > 0L) {
            this.setCancelOnLater(this.mDelayMillis);
        }
    }

    public void showArrowToWithMarginH(View anchor, RelativePos relativePos, int marginH, int marginV, boolean clearNavBarHeight) {
        this.dismiss();
        int screenWidth = Resources.getSystem().getDisplayMetrics().widthPixels;
        int screenHeight = Resources.getSystem().getDisplayMetrics().heightPixels;
        int navigationBarHeight = clearNavBarHeight ? 0 : BubblePopupWindow.getNavigationBarHeightDelta(anchor);
        Rect anchorRect = BubblePopupWindow.getRectInWindow(anchor);
        this.getContentView().measure(View.MeasureSpec.makeMeasureSpec((int)(screenWidth - 2 * this.mPadding), (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)(screenHeight - 2 * this.mPadding), (int)Integer.MIN_VALUE));
        int contentWidth = this.getContentView().getMeasuredWidth();
        int contentHeight = this.getContentView().getMeasuredHeight();
        Log.d((String)TAG, (String)String.format("w:%d, h:%d", contentWidth, contentHeight));
        PopupProp outProp = new PopupProp();
        BubblePopupWindow.getPopupProp(screenWidth, screenHeight, navigationBarHeight, anchorRect, contentWidth, contentHeight, relativePos, marginH, marginV, this.mPadding, outProp);
        this.setWidth(-2);
        this.setHeight(-2);
        this.setAnimationStyle(outProp.animationStyle);
        if (contentWidth > outProp.maxWidth) {
            this.setWidth(outProp.maxWidth);
        }
        this.mBubbleView.setArrowDirection(outProp.direction);
        this.mBubbleView.setArrowPosPolicy(outProp.arrowPosPolicy);
        this.mBubbleView.setArrowTo(anchor);
        this.mBubbleView.setArrowPosDelta(this.mArrowPosDelta);
        this.showAtLocation(anchor, outProp.gravity, marginH == 0 ? outProp.x : marginH, outProp.y);
        if (this.mDelayMillis > 0L) {
            this.setCancelOnLater(this.mDelayMillis);
        }
    }

    private static Rect getRectInWindow(View view) {
        int[] location = new int[2];
        view.getLocationInWindow(location);
        return new Rect(location[0], location[1], location[0] + view.getWidth(), location[1] + view.getHeight());
    }

    private static void getPopupProp(int screenWidth, int screenHeight, int navigationBarHeight, Rect anchorRect, int contentWidth, int contentHeight, RelativePos relativePos, int marginH, int marginV, int padding, PopupProp outProp) {
        outProp.direction = relativePos.getArrowDirection();
        outProp.animationStyle = BubblePopupWindow.getAnimationStyle(outProp.direction);
        outProp.gravity = 0;
        BubblePopupWindow.getPopupPropOfX(screenWidth, anchorRect, contentWidth, relativePos, marginH, padding, outProp);
        BubblePopupWindow.getPopupPropOfMaxWidth(screenWidth, anchorRect, relativePos, marginH, padding, outProp);
        BubblePopupWindow.getPopupPropOfY(screenHeight, navigationBarHeight, anchorRect, relativePos, marginV, outProp);
        block0 : switch (outProp.direction) {
            case Up: 
            case Down: {
                outProp.arrowPosPolicy = relativePos.getHorizPolicy();
                break;
            }
            case Left: 
            case Right: {
                switch (relativePos.getVerticalRelate()) {
                    case 0: {
                        outProp.arrowPosPolicy = BubbleStyle.ArrowPosPolicy.TargetCenter;
                        break block0;
                    }
                    case 3: {
                        outProp.arrowPosPolicy = BubbleStyle.ArrowPosPolicy.SelfBegin;
                        break block0;
                    }
                    case 4: {
                        outProp.arrowPosPolicy = BubbleStyle.ArrowPosPolicy.SelfEnd;
                        break block0;
                    }
                }
                outProp.arrowPosPolicy = BubbleStyle.ArrowPosPolicy.TargetCenter;
                break;
            }
            default: {
                outProp.arrowPosPolicy = BubbleStyle.ArrowPosPolicy.TargetCenter;
            }
        }
    }

    private static void getPopupPropOfX(int screenWidth, Rect anchorRect, int contentWidth, RelativePos relativePos, int marginH, int padding, PopupProp outProp) {
        switch (relativePos.getHorizontalRelate()) {
            case 3: {
                outProp.gravity |= 3;
                outProp.x = anchorRect.left + marginH;
                break;
            }
            case 2: {
                outProp.gravity |= 3;
                outProp.x = anchorRect.right + marginH;
                break;
            }
            case 1: {
                outProp.gravity |= 5;
                outProp.x = screenWidth - anchorRect.left + marginH;
                break;
            }
            case 4: {
                outProp.gravity |= 5;
                outProp.x = screenWidth - anchorRect.right + marginH;
                break;
            }
            case 0: {
                if (anchorRect.centerX() < contentWidth / 2 + padding) {
                    outProp.gravity |= 3;
                    outProp.x = padding;
                    break;
                }
                if (screenWidth - anchorRect.centerX() < contentWidth / 2 + padding) {
                    outProp.gravity |= 5;
                    outProp.x = padding;
                    break;
                }
                outProp.gravity = 0;
                outProp.x = anchorRect.centerX() - screenWidth / 2;
                break;
            }
        }
    }

    private static void getPopupPropOfMaxWidth(int screenWidth, Rect anchorRect, RelativePos relativePos, int marginH, int padding, PopupProp outProp) {
        switch (relativePos.getHorizontalRelate()) {
            case 3: {
                outProp.maxWidth = screenWidth - anchorRect.left - marginH - padding;
                break;
            }
            case 2: {
                outProp.maxWidth = screenWidth - anchorRect.right - marginH - padding;
                break;
            }
            case 1: {
                outProp.maxWidth = anchorRect.left - marginH - padding;
                break;
            }
            case 4: {
                outProp.maxWidth = anchorRect.right - marginH - padding;
                break;
            }
            case 0: {
                outProp.maxWidth = screenWidth - 2 * padding;
                break;
            }
        }
    }

    private static void getPopupPropOfY(int screenHeight, int navigationBarHeight, Rect anchorRect, RelativePos relativePos, int marginV, PopupProp outProp) {
        switch (relativePos.getVerticalRelate()) {
            case 3: {
                outProp.gravity |= 0x30;
                outProp.y = anchorRect.top + marginV;
                break;
            }
            case 2: {
                outProp.gravity |= 0x30;
                outProp.y = anchorRect.bottom + marginV;
                break;
            }
            case 4: {
                outProp.gravity |= 0x50;
                outProp.y = screenHeight + navigationBarHeight - anchorRect.bottom + marginV;
                break;
            }
            case 1: {
                outProp.gravity |= 0x50;
                outProp.y = screenHeight + navigationBarHeight - anchorRect.top + marginV;
                break;
            }
            case 0: {
                outProp.gravity |= 0x10;
                outProp.y = anchorRect.centerY() - navigationBarHeight / 2 - screenHeight / 2;
                break;
            }
        }
    }

    private static int getAnimationStyle(BubbleStyle.ArrowDirection direction) {
        switch (direction) {
            case Up: {
                return R.style.AnimationArrowUp;
            }
            case Down: {
                return R.style.AnimationArrowDown;
            }
            case Left: {
                return R.style.AnimationArrowLeft;
            }
            case Right: {
                return R.style.AnimationArrowRight;
            }
        }
        return R.style.AnimationArrowNone;
    }

    private static int getNavigationBarHeightDelta(View view) {
        if (Build.VERSION.SDK_INT >= 20) {
            return Utils.getNavigationBarHeight(view);
        }
        return 0;
    }

    private class PopupProp {
        BubbleStyle.ArrowDirection direction;
        BubbleStyle.ArrowPosPolicy arrowPosPolicy;
        int animationStyle;
        int maxWidth;
        int gravity;
        int x;
        int y;

        private PopupProp() {
        }
    }
}

