/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.bubble;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import com.yy.appbase.ui.widget.bubble.BubbleStyle;
import com.yy.appbase.ui.widget.bubble.Utils;

class BubbleDrawable
extends Drawable {
    private BubbleStyle.ArrowDirection mArrowDirection = BubbleStyle.ArrowDirection.None;
    private BubbleStyle.ArrowPosPolicy mArrowPosPolicy = BubbleStyle.ArrowPosPolicy.TargetCenter;
    private Shape mOriginalShape = new Shape();
    private Shape mBorderShape = new Shape();
    private Shape mFillShape = new Shape();
    private Paint mBorderPaint = new Paint(1);
    private Path mBorderPath = new Path();
    private Paint mFillPaint = new Paint(1);
    private Path mFillPath = new Path();
    private float mFillPadding = 0.0f;
    private int mFillColor = -872415232;
    private int mBorderColor = -1;
    private boolean isRoomTagUse = false;
    private PointF mArrowTo = new PointF(0.0f, 0.0f);
    private PointF mCustomArrow = new PointF(0.0f, 0.0f);
    private boolean useCustomPos = false;
    private RectF mOvalRect = new RectF();

    BubbleDrawable() {
    }

    void resetRect(int width, int height) {
        this.mOriginalShape.mRectF.set(0.0f, 0.0f, (float)width, (float)height);
    }

    void setFillColor(int fillColor) {
        this.mFillColor = fillColor;
    }

    void setBorderColor(int borderColor) {
        this.mBorderColor = borderColor;
    }

    void setBorderWidth(float borderWidth) {
        this.mOriginalShape.mBorderWidth = borderWidth;
    }

    void setFillPadding(float fillPadding) {
        this.mFillPadding = fillPadding;
    }

    void updateShapes() {
        this.updateBorderShape();
        this.updateFillShape();
    }

    private void updateBorderShape() {
        this.mBorderShape.set(this.mOriginalShape);
        this.mBorderShape.mRectF.set(this.mOriginalShape.mRectF.left + this.mOriginalShape.mBorderWidth / 2.0f + (this.mArrowDirection.isLeft() ? this.mOriginalShape.mArrowHeight : 0.0f), this.mOriginalShape.mRectF.top + this.mOriginalShape.mBorderWidth / 2.0f + (this.mArrowDirection.isUp() ? this.mOriginalShape.mArrowHeight : 0.0f), this.mOriginalShape.mRectF.right - this.mOriginalShape.mBorderWidth / 2.0f - (this.mArrowDirection.isRight() ? this.mOriginalShape.mArrowHeight : 0.0f), this.mOriginalShape.mRectF.bottom - this.mOriginalShape.mBorderWidth / 2.0f - (this.mArrowDirection.isDown() ? this.mOriginalShape.mArrowHeight : 0.0f));
        this.updateBorderArrowPeak(this.mArrowDirection, this.mArrowPosPolicy, this.useCustomPos ? this.mCustomArrow : this.mArrowTo, this.mBorderShape);
        this.updatePath(this.mBorderShape, this.mBorderPath);
    }

    private void updateFillShape() {
        this.mFillShape.set(this.mBorderShape);
        this.mFillShape.mBorderWidth = 0.0f;
        this.mFillShape.mRectF.set(this.mOriginalShape.mRectF.left + this.mOriginalShape.mBorderWidth + this.mFillPadding + (this.mArrowDirection.isLeft() ? this.mOriginalShape.mArrowHeight : 0.0f), this.mOriginalShape.mRectF.top + this.mOriginalShape.mBorderWidth + this.mFillPadding + (this.mArrowDirection.isUp() ? this.mOriginalShape.mArrowHeight : 0.0f), this.mOriginalShape.mRectF.right - this.mOriginalShape.mBorderWidth - this.mFillPadding - (this.mArrowDirection.isRight() ? this.mOriginalShape.mArrowHeight : 0.0f), this.mOriginalShape.mRectF.bottom - this.mOriginalShape.mBorderWidth - this.mFillPadding - (this.mArrowDirection.isDown() ? this.mOriginalShape.mArrowHeight : 0.0f));
        this.mFillShape.mTopLeftRadius = Math.max(0.0f, this.mOriginalShape.mTopLeftRadius - this.mOriginalShape.mBorderWidth / 2.0f - this.mFillPadding);
        this.mFillShape.mTopRightRadius = Math.max(0.0f, this.mOriginalShape.mTopRightRadius - this.mOriginalShape.mBorderWidth / 2.0f - this.mFillPadding);
        this.mFillShape.mBottomLeftRadius = Math.max(0.0f, this.mOriginalShape.mBottomLeftRadius - this.mOriginalShape.mBorderWidth / 2.0f - this.mFillPadding);
        this.mFillShape.mBottomRightRadius = Math.max(0.0f, this.mOriginalShape.mBottomRightRadius - this.mOriginalShape.mBorderWidth / 2.0f - this.mFillPadding);
        double w = (double)this.mOriginalShape.mArrowWidth - (double)(2.0f * (this.mOriginalShape.mBorderWidth / 2.0f + this.mFillPadding)) / Math.sin(Math.atan(this.mOriginalShape.mArrowHeight / (this.mOriginalShape.mArrowWidth / 2.0f)));
        double h = w * (double)this.mOriginalShape.mArrowHeight / (double)this.mOriginalShape.mArrowWidth;
        this.mFillShape.mArrowHeight = (float)(h + (double)(this.mOriginalShape.mBorderWidth / 2.0f) + (double)this.mFillPadding);
        this.mFillShape.mArrowWidth = this.mFillShape.mArrowHeight * this.mOriginalShape.mArrowWidth / this.mOriginalShape.mArrowHeight;
        BubbleDrawable.updateFillArrowPeak(this.mArrowDirection, this.mBorderShape, this.mFillShape);
        this.updatePath(this.mFillShape, this.mFillPath);
    }

    private static void updateFillArrowPeak(BubbleStyle.ArrowDirection direction, Shape borderShape, Shape outFillShape) {
        switch (direction) {
            case Left: {
                outFillShape.mArrowPeakX = outFillShape.mRectF.left - outFillShape.mArrowHeight;
                outFillShape.mArrowPeakY = borderShape.mArrowPeakY;
                break;
            }
            case Right: {
                outFillShape.mArrowPeakX = outFillShape.mRectF.right + outFillShape.mArrowHeight;
                outFillShape.mArrowPeakY = borderShape.mArrowPeakY;
                break;
            }
            case Up: {
                outFillShape.mArrowPeakX = borderShape.mArrowPeakX;
                outFillShape.mArrowPeakY = outFillShape.mRectF.top - outFillShape.mArrowHeight;
                break;
            }
            case Down: {
                outFillShape.mArrowPeakX = borderShape.mArrowPeakX;
                outFillShape.mArrowPeakY = outFillShape.mRectF.bottom + outFillShape.mArrowHeight;
                break;
            }
        }
    }

    private void updateBorderArrowPeak(BubbleStyle.ArrowDirection direction, BubbleStyle.ArrowPosPolicy policy, PointF arrowTo, Shape outShape) {
        switch (direction) {
            case Left: {
                outShape.mArrowPeakX = outShape.mRectF.left - outShape.mArrowHeight;
                outShape.mArrowPeakY = Utils.bound(outShape.mRectF.top + outShape.mTopLeftRadius + outShape.mArrowWidth / 2.0f + outShape.mBorderWidth / 2.0f, BubbleDrawable.getLeftRightArrowPeakY(policy, arrowTo, outShape), outShape.mRectF.bottom - outShape.mBottomLeftRadius - outShape.mArrowWidth / 2.0f - outShape.mBorderWidth / 2.0f);
                break;
            }
            case Up: {
                outShape.mArrowPeakX = Utils.bound(outShape.mRectF.left + outShape.mTopLeftRadius + outShape.mArrowWidth / 2.0f + outShape.mBorderWidth / 2.0f, BubbleDrawable.getUpDownArrowPeakX(policy, arrowTo, outShape), outShape.mRectF.right - outShape.mTopRightRadius - outShape.mArrowWidth / 2.0f - outShape.mBorderWidth / 2.0f);
                outShape.mArrowPeakY = outShape.mRectF.top - outShape.mArrowHeight;
                break;
            }
            case Right: {
                outShape.mArrowPeakX = outShape.mRectF.right + outShape.mArrowHeight;
                outShape.mArrowPeakY = Utils.bound(outShape.mRectF.top + outShape.mTopRightRadius + outShape.mArrowWidth / 2.0f + outShape.mBorderWidth / 2.0f, BubbleDrawable.getLeftRightArrowPeakY(policy, arrowTo, outShape), outShape.mRectF.bottom - outShape.mBottomRightRadius - outShape.mArrowWidth / 2.0f - outShape.mBorderWidth / 2.0f);
                break;
            }
            case Down: {
                outShape.mArrowPeakX = Utils.bound(outShape.mRectF.left + outShape.mBottomLeftRadius + outShape.mArrowWidth / 2.0f + outShape.mBorderWidth / 2.0f, BubbleDrawable.getUpDownArrowPeakX(policy, arrowTo, outShape), outShape.mRectF.right - outShape.mBottomRightRadius - outShape.mArrowWidth / 2.0f - outShape.mBorderWidth / 2.0f);
                outShape.mArrowPeakY = outShape.mRectF.bottom + outShape.mArrowHeight;
                break;
            }
        }
    }

    void setCornerRadius(float topLeft, float topRight, float bottomRight, float bottomLeft) {
        this.mOriginalShape.mTopLeftRadius = topLeft;
        this.mOriginalShape.mTopRightRadius = topRight;
        this.mOriginalShape.mBottomRightRadius = bottomRight;
        this.mOriginalShape.mBottomLeftRadius = bottomLeft;
    }

    void setArrowDirection(BubbleStyle.ArrowDirection arrowDirection) {
        this.mArrowDirection = arrowDirection;
    }

    void setArrowPosPolicy(BubbleStyle.ArrowPosPolicy arrowPosPolicy) {
        this.mArrowPosPolicy = arrowPosPolicy;
    }

    void setArrowHeight(float arrowHeight) {
        this.mOriginalShape.mArrowHeight = arrowHeight;
    }

    void setArrowWidth(float arrowWidth) {
        this.mOriginalShape.mArrowWidth = arrowWidth;
    }

    void setArrowTo(float x, float y) {
        this.mArrowTo.x = x;
        this.mArrowTo.y = y;
    }

    void setCustomArrowXY(float x, float y) {
        this.useCustomPos = true;
        this.mCustomArrow.x = x;
        this.mCustomArrow.y = y;
    }

    void setArrowPosDelta(float arrowDelta) {
        this.mOriginalShape.mArrowDelta = arrowDelta;
    }

    public void draw(@NonNull Canvas canvas) {
        this.mFillPaint.setStyle(Paint.Style.FILL);
        this.mFillPaint.setColor(this.mFillColor);
        canvas.drawPath(this.mFillPath, this.mFillPaint);
        if (this.mBorderShape.mBorderWidth > 0.0f) {
            this.mBorderPaint.setStyle(Paint.Style.STROKE);
            this.mBorderPaint.setStrokeCap(Paint.Cap.ROUND);
            this.mBorderPaint.setStrokeJoin(Paint.Join.ROUND);
            this.mBorderPaint.setStrokeWidth(this.mBorderShape.mBorderWidth);
            this.mBorderPaint.setColor(this.mBorderColor);
            canvas.drawPath(this.mBorderPath, this.mBorderPaint);
        }
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return 0;
    }

    private void updatePath(Shape shape, Path path) {
        path.reset();
        switch (this.mArrowDirection) {
            case Up: {
                this.buildWithUpArrow(shape, path);
                break;
            }
            case Down: {
                this.buildWithDownArrow(shape, path);
                break;
            }
            case Left: {
                this.buildWithLeftArrow(shape, path);
                break;
            }
            case Right: {
                this.buildWithRightArrow(shape, path);
                break;
            }
            default: {
                this.buildWithNoneArrow(shape, path);
            }
        }
    }

    private void buildWithNoneArrow(Shape shape, Path path) {
        RectF rect = shape.mRectF;
        path.moveTo(rect.left, rect.top + shape.mTopLeftRadius);
        this.compatPathArcTo(path, rect.left, rect.top, rect.left + 2.0f * shape.mTopLeftRadius, rect.top + 2.0f * shape.mTopLeftRadius, 180.0f, 90.0f);
        path.lineTo(rect.right - shape.mTopRightRadius, rect.top);
        this.buildTopRightCorner(shape, path);
        path.lineTo(rect.right, rect.bottom - shape.mBottomRightRadius);
        this.buildBottomRightCorner(shape, path);
        path.lineTo(rect.left + shape.mBottomLeftRadius, rect.bottom);
        this.buildBottomLeftCorner(shape, path);
        path.lineTo(rect.left, rect.top + shape.mTopLeftRadius);
    }

    private void buildWithLeftArrow(Shape shape, Path path) {
        RectF rect = shape.mRectF;
        path.moveTo(shape.mArrowPeakX, shape.mArrowPeakY);
        path.lineTo(rect.left, shape.mArrowPeakY - shape.mArrowWidth / 2.0f);
        path.lineTo(rect.left, rect.top + shape.mTopLeftRadius);
        this.buildTopLeftCorner(shape, path);
        path.lineTo(rect.right - shape.mTopRightRadius, rect.top);
        this.buildTopRightCorner(shape, path);
        path.lineTo(rect.right, rect.bottom - shape.mBottomRightRadius);
        this.buildBottomRightCorner(shape, path);
        path.lineTo(rect.left + shape.mBottomLeftRadius, rect.bottom);
        this.buildBottomLeftCorner(shape, path);
        path.lineTo(rect.left, shape.mArrowPeakY + shape.mArrowWidth / 2.0f);
        path.lineTo(shape.mArrowPeakX, shape.mArrowPeakY);
    }

    private void buildWithUpArrow(Shape shape, Path path) {
        RectF rect = shape.mRectF;
        path.moveTo(shape.mArrowPeakX, shape.mArrowPeakY);
        path.lineTo(shape.mArrowPeakX + shape.mArrowWidth / 2.0f, rect.top);
        path.lineTo(rect.right - shape.mTopRightRadius, rect.top);
        this.buildTopRightCorner(shape, path);
        path.lineTo(rect.right, rect.bottom - shape.mBottomRightRadius);
        this.buildBottomRightCorner(shape, path);
        path.lineTo(rect.left + shape.mBottomLeftRadius, rect.bottom);
        this.buildBottomLeftCorner(shape, path);
        path.lineTo(rect.left, rect.top + shape.mTopLeftRadius);
        this.buildTopLeftCorner(shape, path);
        path.lineTo(shape.mArrowPeakX - shape.mArrowWidth / 2.0f, rect.top);
        path.lineTo(shape.mArrowPeakX, shape.mArrowPeakY);
    }

    private void buildWithRightArrow(Shape shape, Path path) {
        RectF rect = shape.mRectF;
        path.moveTo(shape.mArrowPeakX, shape.mArrowPeakY);
        path.lineTo(rect.right, shape.mArrowPeakY + shape.mArrowWidth / 2.0f);
        path.lineTo(rect.right, rect.bottom - shape.mBottomRightRadius);
        this.buildBottomRightCorner(shape, path);
        path.lineTo(rect.left + shape.mBottomLeftRadius, rect.bottom);
        this.buildBottomLeftCorner(shape, path);
        path.lineTo(rect.left, rect.top + shape.mTopLeftRadius);
        this.buildTopLeftCorner(shape, path);
        path.lineTo(rect.right - shape.mTopRightRadius, rect.top);
        this.buildTopRightCorner(shape, path);
        path.lineTo(rect.right, shape.mArrowPeakY - shape.mArrowWidth / 2.0f);
        path.lineTo(shape.mArrowPeakX, shape.mArrowPeakY);
    }

    private void buildWithDownArrow(Shape shape, Path path) {
        RectF rect = shape.mRectF;
        if (this.isRoomTagUse()) {
            path.moveTo(shape.mArrowPeakX + shape.mArrowWidth / 2.0f, shape.mArrowPeakY);
        } else {
            path.moveTo(shape.mArrowPeakX, shape.mArrowPeakY);
        }
        path.lineTo(shape.mArrowPeakX - shape.mArrowWidth / 2.0f, rect.bottom);
        path.lineTo(rect.left + shape.mBottomLeftRadius, rect.bottom);
        this.buildBottomLeftCorner(shape, path);
        path.lineTo(rect.left, rect.top + shape.mTopLeftRadius);
        this.buildTopLeftCorner(shape, path);
        path.lineTo(rect.right - shape.mTopRightRadius, rect.top);
        this.buildTopRightCorner(shape, path);
        path.lineTo(rect.right, rect.bottom - shape.mBottomRightRadius);
        this.buildBottomRightCorner(shape, path);
        path.lineTo(shape.mArrowPeakX + shape.mArrowWidth / 2.0f, rect.bottom);
        if (this.isRoomTagUse()) {
            path.lineTo(shape.mArrowPeakX + shape.mArrowWidth / 2.0f, shape.mArrowPeakY);
        } else {
            path.lineTo(shape.mArrowPeakX, shape.mArrowPeakY);
        }
    }

    private static float getLeftRightArrowPeakY(BubbleStyle.ArrowPosPolicy policy, PointF arrowTo, Shape shape) {
        float y;
        switch (policy) {
            case TargetCenter: {
                y = shape.mRectF.centerY() + arrowTo.y;
                break;
            }
            case SelfCenter: {
                y = shape.mRectF.centerY();
                break;
            }
            case SelfBegin: {
                y = shape.mRectF.top;
                y += shape.mArrowDelta;
                break;
            }
            case SelfEnd: {
                y = shape.mRectF.bottom;
                y -= shape.mArrowDelta;
                break;
            }
            default: {
                y = 0.0f;
            }
        }
        return y;
    }

    private static float getUpDownArrowPeakX(BubbleStyle.ArrowPosPolicy policy, PointF arrowTo, Shape shape) {
        float x;
        switch (policy) {
            case TargetCenter: {
                x = shape.mRectF.centerX() + arrowTo.x;
                break;
            }
            case SelfCenter: {
                x = shape.mRectF.centerX();
                break;
            }
            case SelfBegin: {
                x = shape.mRectF.left;
                x += shape.mArrowDelta;
                break;
            }
            case SelfEnd: {
                x = shape.mRectF.right;
                x -= shape.mArrowDelta;
                break;
            }
            default: {
                x = 0.0f;
            }
        }
        return x;
    }

    private void buildTopLeftCorner(Shape shape, Path path) {
        this.compatPathArcTo(path, shape.mRectF.left, shape.mRectF.top, shape.mRectF.left + 2.0f * shape.mTopLeftRadius, shape.mRectF.top + 2.0f * shape.mTopLeftRadius, 180.0f, 90.0f);
    }

    private void buildTopRightCorner(Shape shape, Path path) {
        this.compatPathArcTo(path, shape.mRectF.right - 2.0f * shape.mTopRightRadius, shape.mRectF.top, shape.mRectF.right, shape.mRectF.top + 2.0f * shape.mTopRightRadius, 270.0f, 90.0f);
    }

    private void buildBottomRightCorner(Shape shape, Path path) {
        this.compatPathArcTo(path, shape.mRectF.right - 2.0f * shape.mBottomRightRadius, shape.mRectF.bottom - 2.0f * shape.mBottomRightRadius, shape.mRectF.right, shape.mRectF.bottom, 0.0f, 90.0f);
    }

    private void buildBottomLeftCorner(Shape shape, Path path) {
        this.compatPathArcTo(path, shape.mRectF.left, shape.mRectF.bottom - 2.0f * shape.mBottomLeftRadius, shape.mRectF.left + 2.0f * shape.mBottomLeftRadius, shape.mRectF.bottom, 90.0f, 90.0f);
    }

    private void compatPathArcTo(Path path, float left, float top, float right, float bottom, float startAngle, float sweepAngle) {
        this.mOvalRect.set(left, top, right, bottom);
        path.arcTo(this.mOvalRect, startAngle, sweepAngle);
    }

    public boolean isRoomTagUse() {
        return this.isRoomTagUse;
    }

    public void setRoomTagUse(boolean roomTagUse) {
        this.isRoomTagUse = roomTagUse;
    }

    private class Shape {
        RectF mRectF = new RectF();
        float mBorderWidth = 0.0f;
        float mArrowHeight = 0.0f;
        float mArrowWidth = 0.0f;
        float mArrowDelta = 0.0f;
        float mArrowPeakX = 0.0f;
        float mArrowPeakY = 0.0f;
        float mTopLeftRadius = 0.0f;
        float mTopRightRadius = 0.0f;
        float mBottomLeftRadius = 0.0f;
        float mBottomRightRadius = 0.0f;

        private Shape() {
        }

        void set(Shape shape) {
            this.mRectF.set(shape.mRectF);
            this.mBorderWidth = shape.mBorderWidth;
            this.mArrowHeight = shape.mArrowHeight;
            this.mArrowWidth = shape.mArrowWidth;
            this.mArrowDelta = shape.mArrowDelta;
            this.mArrowPeakX = shape.mArrowPeakX;
            this.mArrowPeakY = shape.mArrowPeakY;
            this.mTopLeftRadius = shape.mTopLeftRadius;
            this.mTopRightRadius = shape.mTopRightRadius;
            this.mBottomLeftRadius = shape.mBottomLeftRadius;
            this.mBottomRightRadius = shape.mBottomRightRadius;
        }
    }
}

