/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.bar;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.yy.appbase.R;
import com.yy.base.logger.MLog;

public class TitleBar
extends ConstraintLayout {
    protected View mLeftView;
    protected View mRightView;
    protected View mCenterView;
    protected View mBottomView;
    protected int mBg;
    private int mLeftLayout;
    private int mRightLayout;
    private int mCenterLayout;
    private int mBottomLayout;
    private Context mContext;
    private LayoutInflater mInflater;
    private static final String TAG = "TitleBar";

    public TitleBar(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public TitleBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        try {
            this.init(context, attrs, 0);
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (String)("zy TitleBar error == " + throwable), (Object[])new Object[0]);
        }
    }

    public TitleBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    private void init(Context context, AttributeSet attrs, int defStyle) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)context);
        this.mInflater.inflate(R.layout.layout_title_bar_base, (ViewGroup)this, true);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.title_bar_style, defStyle, 0);
        this.mBg = ta.getResourceId(R.styleable.title_bar_style_bg, -1);
        int left = ta.getResourceId(R.styleable.title_bar_style_left, -1);
        int right = ta.getResourceId(R.styleable.title_bar_style_right, -1);
        int center = ta.getResourceId(R.styleable.title_bar_style_center, -1);
        int bottom = ta.getResourceId(R.styleable.title_bar_style_bottom, -1);
        this.setLeftLayout(left);
        this.setRightLayout(right);
        this.setCenterLayout(center);
        this.setBottomLayout(bottom);
        this.setBg(this.mBg);
        ta.recycle();
    }

    public int getBg() {
        return this.mBg;
    }

    public void setBg(int bg) {
        this.mBg = bg;
        if (this.mBg > 0) {
            this.setBackgroundResource(this.mBg);
        }
    }

    public int getBottomLayout() {
        return this.mBottomLayout;
    }

    public void setBottomLayout(int bottomLayout) {
        this.mBottomLayout = bottomLayout;
        if (this.mBottomLayout > 0) {
            this.setBottomView(this.mInflater.inflate(this.mBottomLayout, null, false));
        }
    }

    public void setBottomView(View bottomView) {
        if (bottomView == null) {
            return;
        }
        if (this.mBottomView != null) {
            this.removeView(this.mBottomView);
        }
        this.mBottomView = bottomView;
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, 1);
        ((ViewGroup)this.findViewById(R.id.title_bottom_line)).addView(this.mBottomView, (ViewGroup.LayoutParams)params);
    }

    public int getLeftLayout() {
        return this.mLeftLayout;
    }

    public void setLeftLayout(int leftLayout) {
        this.mLeftLayout = leftLayout;
        if (this.mLeftLayout > 0) {
            this.setLeftView(this.mInflater.inflate(this.mLeftLayout, null));
        }
    }

    public View getLeftView() {
        return this.mLeftView;
    }

    public void setLeftView(View leftView) {
        if (leftView == null) {
            return;
        }
        if (this.mLeftView != null) {
            this.removeView(this.mLeftView);
        }
        this.mLeftView = leftView;
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -1);
        params.addRule(16);
        ((ViewGroup)this.findViewById(R.id.title_left)).addView(this.mLeftView, (ViewGroup.LayoutParams)params);
    }

    public int getRightLayout() {
        return this.mRightLayout;
    }

    public void setRightLayout(int rightLayout) {
        this.mRightLayout = rightLayout;
        if (this.mRightLayout > 0) {
            this.setRightView(this.mInflater.inflate(this.mRightLayout, (ViewGroup)this, false));
        }
    }

    public View getRightView() {
        return this.mRightView;
    }

    public void setRightView(View rightView) {
        int w = 0;
        int h = 0;
        ViewGroup.LayoutParams temp = rightView.getLayoutParams();
        if (temp != null) {
            w = temp.width;
            h = temp.height;
        }
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(w != 0 ? w : -2, h != 0 ? h : -1);
        params.addRule(15);
        this.setRightView(rightView, params);
    }

    public void setRightView(View rightView, RelativeLayout.LayoutParams params) {
        if (rightView == null) {
            return;
        }
        if (this.mRightView != null) {
            this.removeView(this.mRightView);
        }
        this.mRightView = rightView;
        ((ViewGroup)this.findViewById(R.id.title_right)).addView(this.mRightView, (ViewGroup.LayoutParams)params);
    }

    public int getCenterLayout() {
        return this.mCenterLayout;
    }

    public void setCenterLayout(int centerLayout) {
        this.mCenterLayout = centerLayout;
        if (this.mCenterLayout > 0) {
            this.setCenterView(this.mInflater.inflate(this.mCenterLayout, null));
        }
    }

    public void setCenterLayout(int centerLayout, int gravity) {
        this.mCenterLayout = centerLayout;
        if (this.mCenterLayout > 0) {
            this.setCenterView(this.mInflater.inflate(this.mCenterLayout, null), gravity);
        }
    }

    public void setCenterView(View centerView) {
        this.setCenterView(centerView, 16);
    }

    public void setCenterView(View centerView, RelativeLayout.LayoutParams params) {
        if (centerView == null) {
            return;
        }
        if (this.mCenterView != null) {
            this.removeView(this.mCenterView);
        }
        this.mCenterView = centerView;
        ((ViewGroup)this.findViewById(R.id.title_center)).addView(this.mCenterView, (ViewGroup.LayoutParams)params);
    }

    public void setCenterView(View centerView, int gravity) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -1);
        params.addRule(gravity);
        this.setCenterView(centerView, params);
    }

    public View getCenterView() {
        return this.mCenterView;
    }

    private ConstraintLayout.LayoutParams createDefaultLayoutParams() {
        ConstraintLayout.LayoutParams params = new ConstraintLayout.LayoutParams(-2, -2);
        params.topToTop = 0;
        params.bottomToBottom = 0;
        params.startToStart = 0;
        params.endToEnd = 0;
        return params;
    }
}

