/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.bar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.yy.appbase.R;
import com.yy.appbase.ui.widget.bar.TitleBar;
import com.yy.base.utils.FP;

public class SimpleTitleBar
extends TitleBar {
    private TextView mCenterTitle;
    private ImageView mCenterImage;
    private TextView mLeftTitle;
    private ImageView mLeftImage;

    public SimpleTitleBar(Context context) {
        this(context, null);
    }

    public SimpleTitleBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SimpleTitleBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.addChilds();
        this.setBg();
        this.initialize(context, attrs, defStyle);
    }

    private void initialize(Context context, AttributeSet attrs, int defStyle) {
        if (context != null && attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CommonTitleBar);
            int resId = a.getResourceId(R.styleable.CommonTitleBar_navIcon, R.drawable.icon_nav_back);
            String title = a.getString(R.styleable.CommonTitleBar_leftTitle);
            this.setLeftBtn(resId);
            if (!FP.empty((CharSequence)title)) {
                this.setLeftTitle(title);
            }
        }
    }

    private void addChilds() {
        this.setLeftLayout(R.layout.layout_simple_title_left1);
        this.setCenterLayout(R.layout.layout_simple_title_center1);
        this.setRightLayout(R.layout.layout_simple_title_right1);
        this.setBottomLayout(R.layout.layout_simple_title_bottom1);
        this.mLeftView.setVisibility(8);
        this.mRightView.setVisibility(8);
        this.mCenterView.setVisibility(8);
        this.mBottomView.setVisibility(8);
        this.mCenterTitle = (TextView)this.mCenterView.findViewById(R.id.simple_title_center_text);
        this.mCenterImage = (ImageView)this.mCenterView.findViewById(R.id.simple_title_center_image);
        this.mLeftTitle = (TextView)this.mLeftView.findViewById(R.id.simple_title_left_text);
        this.mLeftImage = (ImageView)this.mLeftView.findViewById(R.id.simple_title_left_image);
        this.mLeftImage.setBackgroundResource(R.drawable.select_1a000000_bg);
    }

    private void setBg() {
        if (this.mBg > 0) {
            this.setBackgroundColor(this.getResources().getColor(this.mBg));
        } else {
            this.setBackgroundColor(this.getResources().getColor(R.color.simple_title_bg_default_color));
        }
    }

    @Override
    public void setBg(int color2) {
        this.mBg = color2;
        this.setBg();
    }

    public void setBottomLineVisibility(boolean visibility) {
        if (visibility) {
            this.mBottomView.setVisibility(0);
        } else {
            this.mBottomView.setVisibility(8);
        }
    }

    public void setLeftBtn(int resId, View.OnClickListener listener2) {
        this.mLeftView.setVisibility(0);
        this.mLeftImage.setVisibility(0);
        this.mLeftImage.setImageResource(resId);
        this.mLeftView.setOnClickListener(listener2);
    }

    public void setLeftBtn(int resId, boolean isShow) {
        if (!isShow) {
            this.mLeftView.setVisibility(8);
        } else {
            this.mLeftView.setVisibility(0);
            this.mLeftImage.setVisibility(0);
            this.mLeftImage.setImageResource(resId);
        }
    }

    public void setLeftBtn(int resId) {
        this.mLeftView.setVisibility(0);
        this.mLeftImage.setVisibility(0);
        this.mLeftImage.setImageResource(resId);
    }

    public void setLeftTitle(String title) {
        this.mLeftView.setVisibility(0);
        this.mLeftTitle.setVisibility(0);
        this.mLeftTitle.setText((CharSequence)title);
    }

    public TextView getLeftTextView() {
        return this.mLeftTitle;
    }

    public void setWeMeetLeftTitle(String title) {
        this.mLeftView.setVisibility(0);
        this.mLeftTitle.setVisibility(0);
        this.mLeftTitle.setText((CharSequence)title);
        this.mLeftTitle.setTypeface(Typeface.defaultFromStyle((int)1));
    }

    public void setVoiceRoomListLeftTitle(String title) {
        this.mLeftView.setVisibility(0);
        this.mLeftTitle.setVisibility(0);
        this.mLeftTitle.setText((CharSequence)title);
        this.mLeftTitle.setTypeface(Typeface.defaultFromStyle((int)1));
    }

    public void setRightBtn(int resId, View.OnClickListener listener2) {
        if (!(this.mRightView instanceof ImageView)) {
            ((ViewGroup)this.findViewById(R.id.title_right)).removeAllViews();
            this.setRightLayout(R.layout.layout_simple_title_right1);
        }
        this.mRightView.setVisibility(0);
        ((ImageView)this.mRightView.findViewById(R.id.simple_title_right)).setImageResource(resId);
        this.mRightView.setOnClickListener(listener2);
    }

    public void setRightBtnColor(int color2) {
        if (!(this.mRightView instanceof TextView)) {
            ((ViewGroup)this.findViewById(R.id.title_right)).removeAllViews();
            this.setRightLayout(R.layout.layout_simple_title_right_txt1);
        }
        this.mRightView.setVisibility(0);
        ((TextView)this.mRightView.findViewById(R.id.simple_title_right_txt)).setTextColor(color2);
    }

    public void setRightBtnPadding(int padding) {
        if (!(this.mRightView instanceof TextView)) {
            ((ViewGroup)this.findViewById(R.id.title_right)).removeAllViews();
            this.setRightLayout(R.layout.layout_simple_title_right_txt1);
        }
        this.mRightView.setVisibility(0);
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)((TextView)this.mRightView.findViewById(R.id.simple_title_right_txt)).getLayoutParams();
        layoutParams.rightMargin = padding;
    }

    public void setRightBtnClickable(boolean clickable) {
        if (!(this.mRightView instanceof TextView)) {
            ((ViewGroup)this.findViewById(R.id.title_right)).removeAllViews();
            this.setRightLayout(R.layout.layout_simple_title_right_txt1);
        }
        this.mRightView.setVisibility(0);
        this.mRightView.setClickable(clickable);
    }

    public void setRightBtn(CharSequence str, View.OnClickListener l) {
        if (!(this.mRightView instanceof TextView)) {
            ((ViewGroup)this.findViewById(R.id.title_right)).removeAllViews();
            this.setRightLayout(R.layout.layout_simple_title_right_txt1);
        }
        this.mRightView.setVisibility(0);
        ((TextView)this.mRightView.findViewById(R.id.simple_title_right_txt)).setText(str);
        this.mRightView.setOnClickListener(l);
    }

    public void setRightBtn(CharSequence str) {
        if (!(this.mRightView instanceof TextView)) {
            ((ViewGroup)this.findViewById(R.id.title_right)).removeAllViews();
            this.setRightLayout(R.layout.layout_simple_title_right_txt1);
        }
        this.mRightView.setVisibility(0);
        ((TextView)this.mRightView.findViewById(R.id.simple_title_right_txt)).setText(str);
    }

    public void setRightBtn(int resId) {
        if (!(this.mRightView instanceof ImageView)) {
            ((ViewGroup)this.findViewById(R.id.title_right)).removeAllViews();
            this.setRightLayout(R.layout.layout_simple_title_right1);
        }
        this.mRightView.setVisibility(0);
        ((ImageView)this.mRightView.findViewById(R.id.simple_title_right)).setImageResource(resId);
    }

    public void setRightBtn(int[] resId, View.OnClickListener l) {
        if (!(this.mRightView instanceof LinearLayout)) {
            ((ViewGroup)this.findViewById(R.id.title_right)).removeAllViews();
            this.setRightView((View)new LinearLayout(this.getContext()));
        }
        LinearLayout parent = (LinearLayout)this.mRightView;
        parent.removeAllViews();
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        for (int i = 0; i < resId.length && i < 2; ++i) {
            ImageView barIcon = (ImageView)inflater.inflate(R.layout.layout_simple_title_bar_icon, (ViewGroup)parent, false);
            barIcon.setTag((Object)i);
            barIcon.setOnClickListener(l);
            barIcon.setImageResource(resId[i]);
            parent.addView((View)barIcon);
        }
        this.mRightView.setVisibility(0);
    }

    public void setTitlte(String title) {
        this.mCenterView.setVisibility(0);
        this.mCenterTitle.setVisibility(0);
        this.mCenterImage.setVisibility(8);
        this.mCenterTitle.setTextColor(this.getResources().getColor(R.color.common_title_color));
        this.mCenterTitle.setText((CharSequence)title);
    }

    public TextView setViewTitle(String title) {
        this.mCenterView.setVisibility(0);
        this.mCenterTitle.setVisibility(0);
        this.mCenterImage.setVisibility(8);
        this.mCenterTitle.setTextColor(this.getResources().getColor(R.color.common_title_color));
        this.mCenterTitle.setText((CharSequence)title);
        return this.mCenterTitle;
    }

    public void setTitlte(String title, int color2) {
        this.setTitlte(title, color2, 17);
    }

    public void setTitlte(String title, int color2, int textSize) {
        this.mCenterView.setVisibility(0);
        this.mCenterTitle.setVisibility(0);
        this.mCenterImage.setVisibility(8);
        this.mCenterTitle.setTextColor(color2);
        this.mCenterTitle.setText((CharSequence)title);
        this.mCenterTitle.setTextSize((float)textSize);
    }

    public void setTitleImage(int drwableId) {
        this.mCenterView.setVisibility(0);
        this.mCenterImage.setVisibility(0);
        this.mCenterTitle.setVisibility(8);
        this.mCenterImage.setImageResource(drwableId);
    }

    public TextView getCenterTitleTextView() {
        return this.mCenterTitle;
    }

    public void setNavOnClickListener(View.OnClickListener l) {
        this.mLeftView.setOnClickListener(l);
    }
}

