/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.bar;

import android.content.Context;
import android.graphics.Typeface;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.yy.appbase.R;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;

public class CommonTitleBar
extends YYFrameLayout {
    private YYImageView mLeftImageView;
    private YYTextView mTitle;
    private YYTextView mRightTextView;

    public CommonTitleBar(Context context) {
        super(context);
        this.init();
    }

    public CommonTitleBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CommonTitleBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        int titleTextSize = ResourceUtils.getDimen((int)R.dimen.commom_titlebar_textsize);
        int iconPadding = ResourceUtils.getDimen((int)R.dimen.commom_titlebar_iconpadding);
        int rightTextPadding = ResourceUtils.getDimen((int)R.dimen.commom_titlebar_righttextpadding);
        int rightTextSize = ResourceUtils.getDimen((int)R.dimen.commom_titlebar_righttextsize);
        this.mLeftImageView = new YYImageView(this.getContext());
        this.mTitle = new YYTextView(this.getContext());
        this.mRightTextView = new YYTextView(this.getContext());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -1);
        layoutParams.gravity = 8388627;
        this.mLeftImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams = new FrameLayout.LayoutParams(-2, -1);
        layoutParams.gravity = 17;
        this.mTitle.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams = new FrameLayout.LayoutParams(-2, -1);
        layoutParams.gravity = 8388629;
        this.mRightTextView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mTitle.setGravity(16);
        this.mLeftImageView.setScaleType(ImageView.ScaleType.CENTER);
        this.mRightTextView.setGravity(16);
        this.mTitle.setTextSize(0, (float)titleTextSize);
        this.mTitle.setTextColor(ResourceUtils.getColor((int)R.color.common_title));
        this.mRightTextView.setTextSize(0, (float)rightTextSize);
        this.mRightTextView.setTextColor(ResourceUtils.getColor((int)R.color.common_title_right));
        this.setViewPadding((View)this.mLeftImageView, iconPadding, 0, iconPadding, 0);
        this.setViewPadding((View)this.mRightTextView, rightTextPadding, 0, rightTextPadding, 0);
        this.addView((View)this.mLeftImageView);
        this.addView((View)this.mTitle);
        this.addView((View)this.mRightTextView);
    }

    private void setViewPadding(View view, int left, int top, int right, int bottom) {
        if (Build.VERSION.SDK_INT >= 17) {
            view.setPaddingRelative(left, top, right, bottom);
        } else {
            view.setPadding(left, top, right, bottom);
        }
    }

    public void setRightTextColor(int color2) {
        this.mRightTextView.setTextColor(color2);
    }

    public void setRightTextSize(float size) {
        this.mRightTextView.setTextSize(size);
    }

    public void setRightTextTypeface(Typeface typeface) {
        this.mRightTextView.setTypeface(typeface);
    }

    public void updateData(int leftDrawableId, String title, int rightDrawableId, String rightText) {
        this.updateData(leftDrawableId, title, rightDrawableId, rightText, 17);
    }

    public void updateData(int leftDrawableId, String title, int rightDrawableId, String rightText, final int titleGravity) {
        if (leftDrawableId > 0) {
            this.mLeftImageView.setImageDrawable(ResourceUtils.getDrawable((int)leftDrawableId));
            this.mLeftImageView.setVisibility(0);
        } else {
            this.mLeftImageView.setImageDrawable(null);
            this.mLeftImageView.setVisibility(8);
        }
        this.mTitle.setText((CharSequence)title);
        if (rightDrawableId > 0) {
            this.mRightTextView.setCompoundDrawablesRelativeWithIntrinsicBounds(ResourceUtils.getDrawable((int)rightDrawableId), null, null, null);
        } else {
            this.mRightTextView.setCompoundDrawables(null, null, null, null);
        }
        this.mRightTextView.setText((CharSequence)rightText);
        this.mRightTextView.setVisibility(rightDrawableId > 0 || StringUtils.isNotEmpty((String)rightText) ? 0 : 8);
        this.post(new Runnable(){

            @Override
            public void run() {
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)CommonTitleBar.this.mTitle.getLayoutParams();
                if ((titleGravity & 0x11) == 17) {
                    lp.gravity = titleGravity;
                    lp.leftMargin = 0;
                    lp.rightMargin = 0;
                } else if ((titleGravity & 0x800003) == 0x800003 || (titleGravity & 3) == 3) {
                    lp.gravity = titleGravity;
                    lp.leftMargin = CommonTitleBar.this.mLeftImageView.getVisibility() == 8 ? 0 : CommonTitleBar.this.mLeftImageView.getWidth();
                    lp.setMarginStart(lp.leftMargin);
                    lp.rightMargin = 0;
                    lp.setMarginEnd(0);
                } else if ((titleGravity & 0x800005) == 0x800005 || (titleGravity & 5) == 5) {
                    lp.gravity = titleGravity;
                    lp.leftMargin = 0;
                    lp.setMarginStart(0);
                    lp.rightMargin = CommonTitleBar.this.mRightTextView.getVisibility() == 8 ? 0 : CommonTitleBar.this.mRightTextView.getWidth();
                    lp.setMarginEnd(lp.rightMargin);
                }
                CommonTitleBar.this.mTitle.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
        });
    }

    public void setClickListeners(View.OnClickListener leftIconClick, View.OnClickListener titleClick, View.OnClickListener rightIconClick) {
        this.mLeftImageView.setOnClickListener(leftIconClick);
        this.mTitle.setOnClickListener(titleClick);
        this.mRightTextView.setOnClickListener(rightIconClick);
    }
}

