/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget.banner;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.cardview.widget.CardView;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.R;
import com.yy.appbase.ui.widget.ICanAutoPause;
import com.yy.appbase.ui.widget.banner.BannerActionAdapter;
import com.yy.appbase.ui.widget.banner.BannerScroller;
import com.yy.appbase.ui.widget.banner.BannerViewPager;
import com.yy.appbase.ui.widget.banner.WeakHandler;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.drawablerecycle.DrawableUtil;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class Banner
extends YYFrameLayout
implements ViewPager.OnPageChangeListener,
ICanAutoPause {
    public static final String TAG = "Base_Banner";
    private static final int CACHE_NUMBER = 2;
    private static final int SCROLLABLE_NUMBER = 1;
    private int mIndicatorMargin = 5;
    private int mIndicatorWidth;
    private int mIndicatorHeight;
    private int indicatorSize;
    private int bannerBackgroundImage;
    private int bannerStyle = 1;
    private int delayTime = 2000;
    private int scrollTime = 800;
    private boolean isAutoPlay = true;
    private boolean isScroll = true;
    private int mIndicatorSelectedResId = R.drawable.gray_radius;
    private int mIndicatorUnselectedResId = R.drawable.white_radius;
    protected int mLayoutResId = R.layout.layout_banner_channel;
    protected int mClickInterval = -1;
    private int borderRadius = -1;
    private int titleHeight;
    private int titleBackground;
    private int titleTextColor;
    private int titleTextSize;
    private int gravity = -1;
    private int mLastPosition = -1;
    private int mLastRealPosition = -1;
    private int mLastScrollPosition = -1;
    private int scaleType = 1;
    private List<RecycleImageView> indicatorImages = new ArrayList<RecycleImageView>(0);
    private Context context;
    private BannerViewPager viewPager;
    private TextView bannerTitle;
    private TextView numIndicatorInside;
    private TextView numIndicator;
    private LinearLayout indicator;
    private LinearLayout indicatorInside;
    private LinearLayout titleLayout;
    private RoundImageView defaultImage;
    private BannerActionAdapter mActionAdapter;
    private BannerPagerAdapter mPagerAdapter;
    private BannerScroller mScroller;
    private DisplayMetrics dm;
    private YYRelativeLayout mLayout;
    private long mLastClickTime = 0L;
    private List<View> mViewList = new ArrayList<View>(0);
    private List<ViewGroup> mContainerList = new ArrayList<ViewGroup>(0);
    private WeakHandler handler = new WeakHandler();
    private boolean isAutoPlayStart = false;
    private final Runnable mAutoPlayTask = new Runnable(){

        @Override
        public void run() {
            if (Banner.this.checkCanAutoPlay()) {
                int containerSize = Banner.this.mContainerList.size();
                if (containerSize <= 0) {
                    MLog.warn((Object)Banner.TAG, (String)"autoPlayTask fail, container size is less than zero", (Object[])new Object[0]);
                    return;
                }
                int curPos = Banner.this.getCurItem();
                int newPosition = (curPos + 1) % containerSize;
                MLog.debug((Object)Banner.TAG, (String)"autoPlay curPos: %d, newPos: %d", (Object[])new Object[]{curPos, newPosition});
                Banner.this.viewPager.setCurrentItem(newPosition);
                Banner.this.handler.postDelayed(Banner.this.mAutoPlayTask, Banner.this.delayTime);
            }
        }
    };
    private final View.OnTouchListener mContainerTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            Object pos = v.getTag();
            if (pos instanceof Integer) {
                int realPos = Banner.this.toRealPosition((Integer)pos);
                if (Banner.this.mActionAdapter != null) {
                    return Banner.this.mActionAdapter.onTouch(realPos, v, event);
                }
            }
            return false;
        }
    };
    private final View.OnClickListener mContainerClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            Object pos = v.getTag();
            if (pos instanceof Integer) {
                int realPos = Banner.this.toRealPosition((Integer)pos);
                if (Banner.this.mActionAdapter != null) {
                    long clickInterval = System.currentTimeMillis() - Banner.this.mLastClickTime;
                    if (clickInterval > (long)Banner.this.mClickInterval) {
                        Banner.this.mLastClickTime = System.currentTimeMillis();
                        Banner.this.mActionAdapter.onClick(realPos, v);
                    } else {
                        MLog.info((Object)Banner.TAG, (String)"onClick ignore, clickInterval: %d not match", (Object[])new Object[]{clickInterval});
                    }
                }
            }
        }
    };

    public Banner(Context context) {
        this(context, null);
    }

    public Banner(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Banner(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.context = context;
        this.dm = context.getResources().getDisplayMetrics();
        this.indicatorSize = this.dm.widthPixels / 80;
        this.initView(context, attrs);
    }

    protected void initView(Context context, AttributeSet attrs) {
        this.handleTypedArray(context, attrs);
        View view = LayoutInflater.from((Context)context).inflate(this.mLayoutResId, (ViewGroup)this, true);
        this.defaultImage = (RoundImageView)view.findViewById(R.id.bannerDefaultImage);
        this.viewPager = (BannerViewPager)view.findViewById(R.id.bannerViewPager);
        this.titleLayout = (LinearLayout)view.findViewById(R.id.bannerTitleLl);
        this.indicator = (LinearLayout)view.findViewById(R.id.circleIndicator);
        this.indicatorInside = (LinearLayout)view.findViewById(R.id.indicatorInside);
        this.bannerTitle = (TextView)view.findViewById(R.id.bannerTitleTv);
        this.numIndicator = (TextView)view.findViewById(R.id.numIndicator);
        this.mLayout = (YYRelativeLayout)view.findViewById(R.id.card_banner);
        this.numIndicatorInside = (TextView)view.findViewById(R.id.numIndicatorInside);
        this.defaultImage.setImageResource(this.bannerBackgroundImage);
        if (this.mLayout != null) {
            this.mLayout.setBackground((Drawable)DrawableUtil.getRoundDrawable((int)10));
        }
        this.initViewPagerScroll();
    }

    private void handleTypedArray(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.Banner);
        this.mIndicatorWidth = typedArray.getDimensionPixelSize(R.styleable.Banner_indicator_width, this.indicatorSize);
        this.mIndicatorHeight = typedArray.getDimensionPixelSize(R.styleable.Banner_indicator_height, this.indicatorSize);
        this.mIndicatorMargin = typedArray.getDimensionPixelSize(R.styleable.Banner_indicator_margin, 5);
        this.mIndicatorSelectedResId = typedArray.getResourceId(R.styleable.Banner_indicator_drawable_selected, R.drawable.gray_radius);
        this.mIndicatorUnselectedResId = typedArray.getResourceId(R.styleable.Banner_indicator_drawable_unselected, R.drawable.white_radius);
        this.scaleType = typedArray.getInt(R.styleable.Banner_image_scale_type, this.scaleType);
        this.delayTime = typedArray.getInt(R.styleable.Banner_delay_time, 2000);
        this.scrollTime = typedArray.getInt(R.styleable.Banner_scroll_time, 800);
        this.isAutoPlay = typedArray.getBoolean(R.styleable.Banner_is_auto_play, true);
        this.titleBackground = typedArray.getColor(R.styleable.Banner_title_background, -1);
        this.borderRadius = typedArray.getDimensionPixelSize(R.styleable.Banner_banner_border_radius, 5);
        this.titleHeight = typedArray.getDimensionPixelSize(R.styleable.Banner_title_height, -1);
        this.titleTextColor = typedArray.getColor(R.styleable.Banner_title_textcolor, -1);
        this.titleTextSize = typedArray.getDimensionPixelSize(R.styleable.Banner_title_textsize, -1);
        this.mLayoutResId = typedArray.getResourceId(R.styleable.Banner_banner_layout, this.mLayoutResId);
        this.bannerBackgroundImage = typedArray.getResourceId(R.styleable.Banner_banner_default_image, R.drawable.icon_default_photo);
        typedArray.recycle();
    }

    private void initViewPagerScroll() {
        try {
            Field mField = ViewPager.class.getDeclaredField("mScroller");
            mField.setAccessible(true);
            this.mScroller = new BannerScroller(this.viewPager.getContext());
            this.mScroller.setDuration(this.scrollTime);
            mField.set((Object)this.viewPager, (Object)this.mScroller);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public Banner isAutoPlay(boolean isAutoPlay) {
        this.isAutoPlay = isAutoPlay;
        return this;
    }

    public Banner setActionAdapter(BannerActionAdapter actionAdapter) {
        this.mActionAdapter = actionAdapter;
        if (this.mActionAdapter != null) {
            this.mActionAdapter.bindBanner(this);
        }
        return this;
    }

    public Banner setDelayTime(int delayTime) {
        this.delayTime = delayTime;
        return this;
    }

    public Banner setIndicatorGravity(int type2) {
        switch (type2) {
            case 5: {
                this.gravity = 19;
                break;
            }
            case 6: {
                this.gravity = 17;
                break;
            }
            case 7: {
                this.gravity = 21;
                break;
            }
        }
        return this;
    }

    public Banner setBannerAnimation(Class<? extends ViewPager.PageTransformer> transformer) {
        try {
            this.setPageTransformer(true, transformer.newInstance());
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"Please set the PageTransformer class", (Throwable)e, (Object[])new Object[0]);
        }
        return this;
    }

    public Banner setOffscreenPageLimit(int limit) {
        if (this.viewPager != null) {
            this.viewPager.setOffscreenPageLimit(limit);
        }
        return this;
    }

    public Banner setPageTransformer(boolean reverseDrawingOrder, ViewPager.PageTransformer transformer) {
        this.viewPager.setPageTransformer(reverseDrawingOrder, transformer);
        return this;
    }

    public Banner setBannerStyle(int bannerStyle) {
        this.bannerStyle = bannerStyle;
        return this;
    }

    public Banner setViewPagerIsScroll(boolean isScroll) {
        this.isScroll = isScroll;
        return this;
    }

    public Banner setIndicatorSelectedResId(@DrawableRes int indicatorSelectedResId) {
        this.mIndicatorSelectedResId = indicatorSelectedResId;
        return this;
    }

    public Banner setIndicatorUnselectedResId(@DrawableRes int indicatorUnselectedResId) {
        this.mIndicatorUnselectedResId = indicatorUnselectedResId;
        return this;
    }

    public long getClickInterval() {
        return this.mClickInterval;
    }

    public Banner setClickInterval(int clickInterval) {
        this.mClickInterval = clickInterval;
        return this;
    }

    public int getBorderRadius() {
        return this.borderRadius;
    }

    public Banner setBorderRadius(int borderRadius) {
        this.borderRadius = borderRadius;
        for (ViewGroup container : this.mContainerList) {
            if (!(container instanceof CardView)) continue;
            ((CardView)container).setRadius((float)this.borderRadius);
        }
        return this;
    }

    void prepare() {
        int count = this.getCount();
        this.updateStyleUI(count);
        this.updateItemUI(count);
        this.updateState(count);
        if (this.checkCanAutoPlay()) {
            this.startAutoPlay();
        }
    }

    private void updateState(int count) {
        this.mLastPosition = -1;
        this.mLastRealPosition = -1;
        this.mLastScrollPosition = -1;
        MLog.info((Object)TAG, (String)("updateState count: " + count), (Object[])new Object[0]);
        if (count <= 0) {
            this.defaultImage.setVisibility(0);
            this.viewPager.setScrollable(false);
        } else {
            int toPosition = 1;
            this.defaultImage.setVisibility(8);
            boolean scrollable = this.isScroll;
            if (count <= 1) {
                scrollable = false;
                this.mLastScrollPosition = 1;
            }
            this.viewPager.setScrollable(scrollable);
            this.viewPager.setCurrentItem(toPosition);
            if (this.bannerStyle == 1 || this.bannerStyle == 4 || this.bannerStyle == 5) {
                this.initIndicator(count);
            }
            this.onPageSelected(toPosition);
        }
    }

    private void setTitleStyleUI() {
        if (this.titleBackground != -1) {
            this.titleLayout.setBackgroundColor(this.titleBackground);
        }
        if (this.titleHeight != -1) {
            this.titleLayout.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, this.titleHeight));
        }
        if (this.titleTextColor != -1) {
            this.bannerTitle.setTextColor(this.titleTextColor);
        }
        if (this.titleTextSize != -1) {
            this.bannerTitle.setTextSize(0, (float)this.titleTextSize);
        }
    }

    private int getCount() {
        return this.mActionAdapter == null ? 0 : this.mActionAdapter.getCount();
    }

    private void updateStyleUI(int count) {
        int visibility = count > 1 ? 0 : 8;
        switch (this.bannerStyle) {
            case 1: {
                this.indicator.setVisibility(visibility);
                break;
            }
            case 2: {
                this.numIndicator.setVisibility(visibility);
                break;
            }
            case 3: {
                this.numIndicatorInside.setVisibility(visibility);
                this.setTitleStyleUI();
                break;
            }
            case 4: {
                this.indicator.setVisibility(visibility);
                this.setTitleStyleUI();
                break;
            }
            case 5: {
                this.indicatorInside.setVisibility(visibility);
                this.setTitleStyleUI();
                break;
            }
        }
        if (this.gravity != -1) {
            this.indicator.setGravity(this.gravity);
        }
    }

    private void clearItemView() {
        this.mViewList.clear();
        for (ViewGroup container : this.mContainerList) {
            if (container == null) continue;
            container.removeAllViews();
        }
    }

    private List<ViewGroup> getItemContainerList(int count, List<View> viewList) {
        if (FP.empty(viewList)) {
            this.mContainerList.clear();
            return this.mContainerList;
        }
        int originCount = this.mContainerList.size();
        MLog.debug((Object)TAG, (String)"getItemContainerList origin size: %d, new size: %d", (Object[])new Object[]{originCount, count});
        ArrayList<ViewGroup> newContainerList = new ArrayList<ViewGroup>(count);
        for (int i = 0; i < count; ++i) {
            int realPos;
            ViewGroup originContainer = null;
            if (i < this.mContainerList.size()) {
                originContainer = this.mContainerList.get(i);
            } else {
                CardView cardView = new CardView(this.context);
                if (this.borderRadius > 0) {
                    cardView.setRadius((float)this.borderRadius);
                }
                MLog.debug((Object)TAG, (String)("getItemContainer borderRadius: " + this.borderRadius), (Object[])new Object[0]);
                cardView.setCardElevation(0.0f);
                cardView.setCardBackgroundColor(ResourceUtils.getColor((int)R.color.transparent));
                cardView.setTag((Object)i);
                cardView.setOnTouchListener(this.mContainerTouchListener);
                cardView.setOnClickListener(this.mContainerClickListener);
                originContainer = cardView;
            }
            if (originContainer == null) continue;
            newContainerList.add(originContainer);
            if (i == 0 || i == count - 1 || (realPos = this.toRealPosition(i)) < 0 || realPos >= viewList.size()) continue;
            originContainer.addView(viewList.get(realPos));
        }
        return newContainerList;
    }

    private void setScaleType(View imageView) {
        if (imageView instanceof RecycleImageView) {
            RecycleImageView view = (RecycleImageView)imageView;
            switch (this.scaleType) {
                case 0: {
                    view.setScaleType(ImageView.ScaleType.CENTER);
                    break;
                }
                case 1: {
                    view.setScaleType(ImageView.ScaleType.CENTER_CROP);
                    break;
                }
                case 2: {
                    view.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                    break;
                }
                case 3: {
                    view.setScaleType(ImageView.ScaleType.FIT_CENTER);
                    break;
                }
                case 4: {
                    view.setScaleType(ImageView.ScaleType.FIT_END);
                    break;
                }
                case 5: {
                    view.setScaleType(ImageView.ScaleType.FIT_START);
                    break;
                }
                case 6: {
                    view.setScaleType(ImageView.ScaleType.FIT_XY);
                    break;
                }
                case 7: {
                    view.setScaleType(ImageView.ScaleType.MATRIX);
                    break;
                }
            }
        }
    }

    private void initIndicator(int count) {
        this.indicatorImages.clear();
        this.indicator.removeAllViews();
        this.indicatorInside.removeAllViews();
        for (int i = 0; i < count; ++i) {
            RecycleImageView imageView = new RecycleImageView(this.context);
            imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.mIndicatorWidth, this.mIndicatorHeight);
            params.leftMargin = this.mIndicatorMargin;
            params.rightMargin = this.mIndicatorMargin;
            params.height = -2;
            params.width = -2;
            if (i == 0) {
                imageView.setImageResource(this.mIndicatorSelectedResId);
            } else {
                imageView.setImageResource(this.mIndicatorUnselectedResId);
            }
            this.indicatorImages.add(imageView);
            if (this.bannerStyle == 1 || this.bannerStyle == 4) {
                this.indicator.addView((View)imageView, (ViewGroup.LayoutParams)params);
                continue;
            }
            if (this.bannerStyle != 5) continue;
            this.indicatorInside.addView((View)imageView, (ViewGroup.LayoutParams)params);
        }
    }

    private void updateItemUI(int count) {
        this.clearItemView();
        ArrayList<View> viewList = new ArrayList<View>(count);
        for (int i = 0; i < count; ++i) {
            View itemView = null;
            if (this.mActionAdapter != null) {
                itemView = (View)this.mActionAdapter.createItem(this.context, i);
            }
            if (itemView == null) continue;
            this.setScaleType(itemView);
            viewList.add(itemView);
            if (!(itemView.getParent() instanceof ViewGroup)) continue;
            ((ViewGroup)itemView.getParent()).removeView(itemView);
        }
        this.mViewList = viewList;
        this.mContainerList = this.getItemContainerList(count + 2, viewList);
        MLog.info((Object)TAG, (String)"updateItemUI container size: %d, view size: %d", (Object[])new Object[]{this.mContainerList.size(), this.mViewList.size()});
        if (this.mPagerAdapter == null) {
            this.mPagerAdapter = new BannerPagerAdapter();
            this.viewPager.addOnPageChangeListener(this);
            this.viewPager.setAdapter(this.mPagerAdapter);
            this.viewPager.setFocusable(true);
        } else {
            this.mPagerAdapter.notifyDataSetChanged();
        }
    }

    private boolean checkCanAutoPlay() {
        int count = this.getCount();
        int containerSize = this.mContainerList.size();
        return this.isAutoPlay && count > 1 && containerSize == count + 2;
    }

    public void onWindowRealVisible() {
        super.onWindowRealVisible();
        if (this.isAutoPlayStart) {
            MLog.debug((Object)TAG, (String)"onWindowRealVisible", (Object[])new Object[0]);
            this.restartAutoPlay();
        }
    }

    public void onWindowInvisible() {
        super.onWindowInvisible();
        MLog.debug((Object)TAG, (String)"onWindowInvisble", (Object[])new Object[0]);
        if (this.isAutoPlayStart) {
            this.pauseAutoPlay();
        }
    }

    private void pauseAutoPlay() {
        MLog.debug((Object)TAG, (String)"pauseAutoPlay", (Object[])new Object[0]);
        this.handler.removeCallbacks(this.mAutoPlayTask);
    }

    private void restartAutoPlay() {
        MLog.debug((Object)TAG, (String)"restartAutoPlay", (Object[])new Object[0]);
        this.handler.removeCallbacks(this.mAutoPlayTask);
        this.handler.postDelayed(this.mAutoPlayTask, this.delayTime);
    }

    public void startAutoPlay() {
        MLog.debug((Object)TAG, (String)"startAutoPlay", (Object[])new Object[0]);
        this.isAutoPlayStart = true;
        this.restartAutoPlay();
    }

    public void stopAutoPlay() {
        MLog.debug((Object)TAG, (String)"stopAutoPlay", (Object[])new Object[0]);
        this.isAutoPlayStart = false;
        this.pauseAutoPlay();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.checkCanAutoPlay()) {
            int action = ev.getAction();
            if (action == 1 || action == 3 || action == 4) {
                this.startAutoPlay();
            } else if (action == 0) {
                this.stopAutoPlay();
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    int toRealPosition(int position) {
        int count = this.getCount();
        if (count <= 0) {
            return 0;
        }
        return (position - 1 + count) % count;
    }

    private int getCurItem() {
        return this.mLastPosition;
    }

    private void checkItemContainer(int position) {
        if (position >= 0 && position < this.mContainerList.size()) {
            View view;
            ViewGroup viewGroup = this.mContainerList.get(position);
            int realPos = this.toRealPosition(position);
            if (realPos >= 0 && realPos < this.mViewList.size() && (view = this.mViewList.get(realPos)) != null && view.getParent() != viewGroup) {
                if (view.getParent() instanceof ViewGroup) {
                    ViewGroup lastViewGroup = (ViewGroup)view.getParent();
                    lastViewGroup.clearAnimation();
                    lastViewGroup.removeView(view);
                }
                viewGroup.addView(view);
            }
        }
    }

    public void onPageScrollStateChanged(int state) {
        switch (state) {
            case 0: {
                MLog.debug((Object)TAG, (String)("SCROLL_STATE_IDLE curPos: " + this.getCurItem()), (Object[])new Object[0]);
                if (this.getCurItem() == 0) {
                    this.viewPager.setCurrentItem(this.getCount(), false);
                    break;
                }
                if (this.getCurItem() != this.getCount() + 1) break;
                this.viewPager.setCurrentItem(1, false);
                break;
            }
            case 1: {
                MLog.debug((Object)TAG, (String)("SCROLL_STATE_DRAGGING curPos: " + this.getCurItem()), (Object[])new Object[0]);
                if (this.getCurItem() == this.getCount() + 1) {
                    this.viewPager.setCurrentItem(1, false);
                    break;
                }
                if (this.getCurItem() != 0) break;
                this.viewPager.setCurrentItem(this.getCount(), false);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mLastScrollPosition != position) {
            MLog.debug((Object)TAG, (String)("onPageScrolled position: " + position + ", lastScrollPosition: " + this.mLastScrollPosition), (Object[])new Object[0]);
            this.mLastScrollPosition = position;
            if (this.mLastPosition == position) {
                this.checkItemContainer(position + 1);
            } else {
                this.checkItemContainer(position);
            }
        }
    }

    public void onPageSelected(int position) {
        int lastPos = this.mLastPosition;
        int lastRealPos = this.mLastRealPosition;
        MLog.debug((Object)TAG, (String)"onPageSelected position: %d, lastPos: %d", (Object[])new Object[]{position, lastPos});
        if (lastPos == position) {
            return;
        }
        this.checkItemContainer(position);
        this.mLastPosition = position;
        int newRealPosition = this.toRealPosition(position);
        MLog.debug((Object)TAG, (String)"onPageSelected lastRealPos: %d, newRealPos: %d", (Object[])new Object[]{lastRealPos, newRealPosition});
        if (newRealPosition == lastRealPos) {
            return;
        }
        this.mLastRealPosition = newRealPosition;
        if (this.mActionAdapter != null) {
            try {
                if (lastRealPos >= 0 && lastRealPos < this.mViewList.size()) {
                    MLog.debug((Object)TAG, (String)("hideItem realPos: " + lastRealPos), (Object[])new Object[0]);
                    this.mActionAdapter.hideItem(lastRealPos, this.mViewList.get(lastRealPos));
                }
                if (newRealPosition >= 0 && newRealPosition < this.mViewList.size()) {
                    MLog.debug((Object)TAG, (String)("showItem realPos: " + newRealPosition), (Object[])new Object[0]);
                    this.mActionAdapter.showItem(newRealPosition, this.mViewList.get(newRealPosition));
                }
            }
            catch (Exception ex) {
                MLog.error((Object)TAG, (String)"onPageSelected error", (Throwable)ex, (Object[])new Object[0]);
            }
        }
        if (this.bannerStyle == 1 || this.bannerStyle == 4 || this.bannerStyle == 5) {
            if (lastRealPos >= 0 && lastRealPos < this.indicatorImages.size()) {
                this.indicatorImages.get(lastRealPos).setImageResource(this.mIndicatorUnselectedResId);
            }
            if (newRealPosition >= 0 && newRealPosition < this.indicatorImages.size()) {
                this.indicatorImages.get(newRealPosition).setImageResource(this.mIndicatorSelectedResId);
            }
        }
        switch (this.bannerStyle) {
            case 2: {
                this.numIndicator.setText((CharSequence)(newRealPosition + 1 + "/" + this.getCount()));
                break;
            }
            case 3: {
                this.numIndicatorInside.setText((CharSequence)(newRealPosition + 1 + "/" + this.getCount()));
                if (this.mActionAdapter == null) break;
                if (this.mActionAdapter.displayTitle(newRealPosition, this.bannerTitle)) {
                    this.titleLayout.setVisibility(0);
                    this.bannerTitle.setVisibility(0);
                    break;
                }
                this.titleLayout.setVisibility(8);
                this.bannerTitle.setVisibility(8);
                break;
            }
            case 4: 
            case 5: {
                if (this.mActionAdapter == null) break;
                if (this.mActionAdapter.displayTitle(newRealPosition, this.bannerTitle)) {
                    this.titleLayout.setVisibility(0);
                    this.bannerTitle.setVisibility(0);
                    break;
                }
                this.titleLayout.setVisibility(8);
                this.bannerTitle.setVisibility(8);
                break;
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.checkCanAutoPlay()) {
            this.startAutoPlay();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopAutoPlay();
    }

    @Override
    public void onAutoPause() {
        this.stopAutoPlay();
    }

    @Override
    public void onAutoResume() {
        if (this.checkCanAutoPlay()) {
            this.startAutoPlay();
        }
    }

    class BannerPagerAdapter
    extends PagerAdapter {
        BannerPagerAdapter() {
        }

        public int getCount() {
            return Banner.this.mContainerList.size();
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        public Object instantiateItem(ViewGroup container, int position) {
            MLog.debug((Object)Banner.TAG, (String)("instantiateItem position: " + position), (Object[])new Object[0]);
            View view = (View)Banner.this.mContainerList.get(position);
            if (view.getParent() instanceof ViewGroup) {
                ((ViewGroup)view.getParent()).removeView(view);
            }
            view.clearAnimation();
            container.addView(view, new ViewGroup.LayoutParams(-1, -1));
            return view;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            MLog.debug((Object)Banner.TAG, (String)("destroyItem position: " + position), (Object[])new Object[0]);
        }

        public int getItemPosition(@NonNull Object object) {
            return -2;
        }
    }
}

