/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.yy.appbase.R;
import com.yy.base.imageloader.view.RecycleImageView;

@Deprecated
public class RoundedImageView
extends RecycleImageView {
    private int mViewWidth;
    private int mViewHeight;
    private float topLeftRadius = 0.0f;
    private float topRightRadius = 0.0f;
    private float bottomLeftRadius = 0.0f;
    private float bottomRightRadius = 0.0f;
    private Path roundedPath = null;

    public RoundedImageView(Context context) {
        this(context, null, 0);
    }

    public RoundedImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundedImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        super.setScaleType(ImageView.ScaleType.CENTER_CROP);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.RoundedImageView);
        if (ta.hasValue(R.styleable.RoundedImageView_round_radius)) {
            float radius = ta.getDimensionPixelSize(R.styleable.RoundedImageView_round_radius, 0);
            if (radius >= 0.0f) {
                this.topLeftRadius = radius;
                this.topRightRadius = radius;
                this.bottomLeftRadius = radius;
                this.bottomRightRadius = radius;
            }
            return;
        }
        this.topLeftRadius = ta.getDimensionPixelSize(R.styleable.RoundedImageView_topLeftRadius, 0);
        this.topRightRadius = ta.getDimensionPixelSize(R.styleable.RoundedImageView_topRightRadius, 0);
        this.bottomLeftRadius = ta.getDimensionPixelSize(R.styleable.RoundedImageView_bottomLeftRadius, 0);
        this.bottomRightRadius = ta.getDimensionPixelSize(R.styleable.RoundedImageView_bottomRightRadius, 0);
        ta.recycle();
    }

    public void setRadius(float radius) {
        if (radius >= 0.0f) {
            this.topLeftRadius = radius;
            this.topRightRadius = radius;
            this.bottomLeftRadius = radius;
            this.bottomRightRadius = radius;
            this.invalidate();
        }
    }

    public void setRadius(float topLeftRadius, float topRightRadius, float bottomLeftRadius, float bottomRightRadius) {
        if (topLeftRadius >= 0.0f) {
            this.topLeftRadius = topLeftRadius;
        }
        if (topRightRadius >= 0.0f) {
            this.topRightRadius = topRightRadius;
        }
        if (bottomLeftRadius >= 0.0f) {
            this.bottomLeftRadius = bottomLeftRadius;
        }
        if (bottomRightRadius >= 0.0f) {
            this.bottomRightRadius = bottomRightRadius;
        }
        this.invalidate();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mViewWidth = this.getWidth();
        this.mViewHeight = this.getHeight();
        this.updateRoundedPath();
    }

    private void updateRoundedPath() {
        this.roundedPath = new Path();
        this.roundedPath.addRoundRect(new RectF(0.0f, 0.0f, (float)this.mViewWidth, (float)this.mViewHeight), new float[]{this.topLeftRadius, this.topLeftRadius, this.topRightRadius, this.topRightRadius, this.bottomLeftRadius, this.bottomLeftRadius, this.bottomRightRadius, this.bottomRightRadius}, Path.Direction.CW);
    }

    protected void onDraw(Canvas canvas) {
        if (null != this.roundedPath) {
            canvas.clipPath(this.roundedPath);
        }
        super.onDraw(canvas);
    }
}

